/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_BYTESWAP_H__
#define __SBP2_BYTESWAP_H__


#include <glib.h>


static inline void
sbp2_byteswap_data (gpointer data,
                    gint     length)
{
  guint32 *temp = data;

  for (length = (length >> 2); length--; )
    temp[length] = GUINT32_FROM_BE (temp[length]);
}


#if G_BYTE_ORDER == G_LITTLE_ENDIAN
#define sbp2_be32_to_cpu_data(b, l) sbp2_byteswap_data((b), (l))
#define sbp2_cpu_to_be32_data(b, l) sbp2_byteswap_data((b), (l))
#else /* G_BIG_ENDIAN */
#define sbp2_be32_to_cpu_data(b, l) G_STMT_START { (void)0; } G_STMT_END
#define sbp2_cpu_to_be32_data(b, l) G_STMT_START { (void)0; } G_STMT_END
#endif


#endif /* __SBP2_BYTESWAP_H__ */
