#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "qmrtg-utils.h"

#define NEEDLE          "rblsmtpd: "
#define NEEDLE_LEN      10

/* one blocked entity */
struct sender_s {
    char *name;
    unsigned int trials;
    
    struct sender_s *next;
};


/* is name in list? */
int in_list(char *name, struct sender_s *list);
/* add "name" to list, and return its position */
struct sender_s *add_member(char *name, struct sender_s *list);
/* increment name's occurrences number by one */
int increment_trials(char *name, struct sender_s *list);
/* get the number of list members */
unsigned int total_members(struct sender_s *list);
/* get the total number of occurrences */
unsigned int total_trials(struct sender_s *list);
/* return the position of the last member */
struct sender_s *last_member(struct sender_s *list);


int main() {
    char line[MAX_LOGLINE_LEN];
    struct sender_s *senders_list, *list_cursor;
    char *startptr, *endptr;
    char sender_ip[16];

    
    list_cursor = senders_list = NULL;
    
    while ( fgets(line, MAX_LOGLINE_LEN, stdin) != NULL ) {
        startptr = strstr(line, NEEDLE);
        if (startptr == NULL)  continue;
        startptr += NEEDLE_LEN;
        endptr = strchr(startptr, ' ');
        memcpy(sender_ip, startptr, endptr - startptr);
        sender_ip[endptr - startptr] = '\0';
        
        if (in_list(sender_ip, senders_list))
            increment_trials(sender_ip, senders_list);
        else {
            list_cursor = add_member(sender_ip, senders_list);
            if (senders_list == NULL) senders_list = list_cursor;
        }
    }
        
    printf("%u\n%u\n", total_members(senders_list), total_trials(senders_list));
    
    
    return 0;
}


int in_list(char *name, struct sender_s *list) {
    struct sender_s *tmpel = list;

    
    while (tmpel != NULL) {
        if (strcmp(name, tmpel->name) == 0) return 1;
        tmpel = tmpel->next;
    }
    
    
    return 0;
}


struct sender_s *add_member(char *name, struct sender_s *list) {
    struct sender_s *tmpel = list;
    
    
    tmpel = last_member(list);
    if (tmpel == NULL) {
        tmpel = (struct sender_s *)malloc(sizeof(struct sender_s));
    } else {
        tmpel->next = (struct sender_s *)malloc(sizeof(struct sender_s));
        tmpel = tmpel->next;
    }
    
    tmpel->name = (char *)malloc(strlen(name)+1);
    memcpy(tmpel->name, name, strlen(name)+1);
    tmpel->trials = 1;
    tmpel->next = NULL;
    
    
    return tmpel;
}


struct sender_s *last_member(struct sender_s *list) {
    struct sender_s *tmpel;
    
    
    if (list == NULL) return NULL;
    
    tmpel = list;
    while (tmpel->next != NULL)
        tmpel = tmpel->next;


    return tmpel;
}


int increment_trials(char *name, struct sender_s *list) {
    struct sender_s *tmpel = list;
    
    
    while (tmpel != NULL) {
        if (strcmp(name, tmpel->name) == 0) {
            tmpel->trials++;
            return tmpel->trials;
        }
        tmpel = tmpel->next;
    }
    
    
    return -1;
}


unsigned int total_members(struct sender_s *list) {
    struct sender_s *tmpel = list;
    unsigned int count = 0;
    

    while (tmpel != NULL) {
        count++;
        tmpel = tmpel->next;
    }

    
    return count;
}


unsigned int total_trials(struct sender_s *list) {
    struct sender_s *tmpel = list;
    unsigned int count = 0;
    

    while (tmpel != NULL) {
        count += tmpel->trials;
        tmpel = tmpel->next;
    }
    

    return count;
}
