//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontdescriptor?language=objc)
///
/// This is toll-free bridged with `NSFontDescriptor`.
#[doc(alias = "CTFontDescriptorRef")]
#[repr(C)]
pub struct CTFontDescriptor {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTFontDescriptor {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTFontDescriptor"> for CTFontDescriptor {}
);

unsafe impl ConcreteType for CTFontDescriptor {
    /// Returns the type identifier for Core Text font descriptor
    /// references.
    ///
    /// Returns: The identifier for the opaque type CTFontDescriptorRef.
    #[doc(alias = "CTFontDescriptorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTFontDescriptorGetTypeID() -> CFTypeID;
        }
        unsafe { CTFontDescriptorGetTypeID() }
    }
}

extern "C" {
    /// kCTFontURLAttribute
    ///
    /// The font URL.
    ///
    /// This is the key for accessing the font URL from the font descriptor. The value associated with this key is a CFURLRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonturlattribute?language=objc)
    pub static kCTFontURLAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontNameAttribute
    ///
    /// The PostScript name.
    ///
    /// This is the key for retrieving the PostScript name from the font descriptor. When matching, this is treated more generically: the system first tries to find fonts with this PostScript name. If none is found, the system tries to find fonts with this family name, and, finally, if still nothing, tries to find fonts with this display name. The value associated with this key is a CFStringRef. If unspecified, defaults to "Helvetica", if unavailable falls back to global font cascade list.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontnameattribute?language=objc)
    pub static kCTFontNameAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontDisplayNameAttribute
    ///
    /// The display name.
    ///
    /// This is the key for accessing the name used to display the font. Most commonly this is the full name. The value associated with this key is a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdisplaynameattribute?language=objc)
    pub static kCTFontDisplayNameAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontFamilyNameAttribute
    ///
    /// The family name.
    ///
    /// This is the key for accessing the family name from the font descriptor. The value associated with this key is a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfamilynameattribute?language=objc)
    pub static kCTFontFamilyNameAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontStyleNameAttribute
    ///
    /// The style name.
    ///
    /// This is the key for accessing the style name of the font. This name represents the designer's description of the font's style. The value associated with this key is a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontstylenameattribute?language=objc)
    pub static kCTFontStyleNameAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontTraitsAttribute
    ///
    /// The font traits dictionary.
    ///
    /// This is the key for accessing the dictionary of font traits for stylistic information. See CTFontTraits.h for the list of font traits. The value associated with this key is a CFDictionaryRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttraitsattribute?language=objc)
    pub static kCTFontTraitsAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAttribute
    ///
    /// The font variation dictionary.
    ///
    /// This key is used to obtain the font variation instance as a CFDictionaryRef. If specified in a font descriptor, fonts with the specified axes will be primary match candidates, if no such fonts exist, this attribute will be ignored.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationattribute?language=objc)
    pub static kCTFontVariationAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAxesAttribute
    ///
    /// An array of variation axis dictionaries or null if the font does not support variations. Each variation axis dictionary contains the five kCTFontVariationAxis-prefixed keys.
    /// Unlike the result of CTFontCopyVariationAxes(), kCTFontVariationAxisNameKey values for this attribute are not localized.
    /// Before macOS 13.0 and iOS 16.0 this attribute is not accurate and CTFontCopyVariationAxes() should be used instead.
    ///
    ///
    /// See also: CTFontCopyVariationAxes
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxesattribute?language=objc)
    pub static kCTFontVariationAxesAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontSizeAttribute
    ///
    /// The font point size.
    ///
    /// This key is used to obtain or specify the font point size. Creating a font with this unspecified will default to a point size of 12.0. The value for this key is represented as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontsizeattribute?language=objc)
    pub static kCTFontSizeAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontMatrixAttribute
    ///
    /// The font transformation matrix.
    ///
    /// This key is used to specify the font transformation matrix when creating a font. The default value is CGAffineTransformIdentity. The value for this key is a CFDataRef containing a CGAffineTransform, of which only the a, b, c, and d fields are used.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmatrixattribute?language=objc)
    pub static kCTFontMatrixAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontCascadeListAttribute
    ///
    /// The font cascade list.
    ///
    /// This key is used to specify or obtain the cascade list used for a font reference. The cascade list is a CFArrayRef containing CTFontDescriptorRefs. If unspecified, the global cascade list is used. This list is not consulted for private-use characters on OS X 10.10, iOS 8, or earlier.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontcascadelistattribute?language=objc)
    pub static kCTFontCascadeListAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontCharacterSetAttribute
    ///
    /// The font Unicode character coverage set.
    ///
    /// The value for this key is a CFCharacterSetRef. Creating a font with this attribute will restrict the font to a subset of its actual character set.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontcharactersetattribute?language=objc)
    pub static kCTFontCharacterSetAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontLanguagesAttribute
    ///
    /// The list of supported languages.
    ///
    /// The value for this key is a CFArrayRef of CFStringRef language identifiers conforming to UTS #35. It can be requested from any font. If present in a descriptor used for matching, only fonts supporting the specified languages will be returned.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontlanguagesattribute?language=objc)
    pub static kCTFontLanguagesAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontBaselineAdjustAttribute
    ///
    /// The baseline adjustment to apply to font metrics.
    ///
    /// The value for this key is a floating-point CFNumberRef. This is primarily used when defining font descriptors for a cascade list to keep the baseline of all fonts even.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontbaselineadjustattribute?language=objc)
    pub static kCTFontBaselineAdjustAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontMacintoshEncodingsAttribute
    ///
    /// The Macintosh encodings (legacy script codes).
    ///
    /// The value associated with this key is a CFNumberRef containing a bitfield of the script codes in
    /// <CoreText
    /// /SFNTTypes.h>; bit 0 corresponds to kFontRomanScript, and so on. This attribute is provided for legacy compatibility.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmacintoshencodingsattribute?language=objc)
    pub static kCTFontMacintoshEncodingsAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontFeaturesAttribute
    ///
    /// The array of font features.
    ///
    /// This key is used to specify or obtain the font features for a font reference. The value associated with this key is a CFArrayRef of font feature dictionaries as documented for CTFontCopyFeatures() in
    /// <CoreText
    /// /CTFont.h>.
    /// Unlike the result of CTFontCopyFeatures(), this attribute does not contain localized names.
    ///
    ///
    /// See also: CTFontCopyFeatures
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturesattribute?language=objc)
    pub static kCTFontFeaturesAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureSettingsAttribute
    ///
    /// The array of typographic feature settings.
    ///
    /// This key is used to specify an array of zero or more feature settings. Each setting dictionary indicates which setting should be applied. In the case of duplicate or conflicting settings the last setting in the list will take precedence. In the case of AAT settings, it is the caller's responsibility to handle exclusive and non-exclusive settings as necessary.
    /// An AAT setting dictionary contains a tuple of a kCTFontFeatureTypeIdentifierKey key-value pair and a kCTFontFeatureSelectorIdentifierKey key-value pair.
    /// An OpenType setting dictionary contains a tuple of a kCTFontOpenTypeFeatureTag key-value pair and a kCTFontOpenTypeFeatureValue key-value pair.
    ///
    /// Starting with OS X 10.10 and iOS 8.0, settings are also accepted (but not returned) in the following simplified forms:
    /// An OpenType setting can be either an array pair of tag string and value number, or a tag string on its own. For example:
    /// @
    /// [
    /// "
    /// c2sc", @1 ] or simply @"c2sc". An unspecified value enables the feature and a value of zero disables it.
    /// An AAT setting can be specified as an array pair of type and selector numbers. For example:
    /// @
    /// [
    /// @
    /// (kUpperCaseType),
    /// @
    /// (kUpperCaseSmallCapsSelector) ].
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturesettingsattribute?language=objc)
    pub static kCTFontFeatureSettingsAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontFixedAdvanceAttribute
    ///
    /// Specifies advance width.
    ///
    /// This key is used to specify a constant advance width, which affects the glyph metrics of any font instance created with this key; it overrides font values and the font transformation matrix, if any. The value associated with this key must be a CFNumberRef.
    ///
    /// Starting with macOS 10.14 and iOS 12.0, this only affects glyph advances that have non-zero width when this attribute is not present.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfixedadvanceattribute?language=objc)
    pub static kCTFontFixedAdvanceAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontOrientationAttribute
    ///
    /// The orientation attribute.
    ///
    /// This key is used to specify a particular orientation for the glyphs of the font. The value associated with this key is a int as a CFNumberRef. If you want to receive vertical metrics from a font for vertical rendering, specify kCTFontVerticalOrientation. If unspecified, the font will use its native orientation.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontorientationattribute?language=objc)
    pub static kCTFontOrientationAttribute: &'static CFString;
}

/// Specifies the intended rendering orientation of the font for obtaining glyph metrics.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontorientation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontOrientation(pub u32);
impl CTFontOrientation {
    #[doc(alias = "kCTFontOrientationDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "kCTFontOrientationHorizontal")]
    pub const Horizontal: Self = Self(1);
    #[doc(alias = "kCTFontOrientationVertical")]
    pub const Vertical: Self = Self(2);
    #[deprecated = "Deprecated"]
    pub const kCTFontDefaultOrientation: Self = Self(CTFontOrientation::Default.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontHorizontalOrientation: Self = Self(CTFontOrientation::Horizontal.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontVerticalOrientation: Self = Self(CTFontOrientation::Vertical.0);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontOrientation {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontOrientation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// kCTFontFormatAttribute
    ///
    /// Specifies the recognized format of the font.
    ///
    /// The attribute is used to specify or obtain the format of the font. The returned value is a CFNumber containing one of the constants defined below.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontformatattribute?language=objc)
    pub static kCTFontFormatAttribute: &'static CFString;
}

/// The font is not a recognized format
///
/// The font is an OpenType format containing PostScript data
///
/// The font is an OpenType format containing TrueType data
///
/// The font is a recognized TrueType format
///
/// The font is a recognized PostScript format
///
/// The font is a bitmap only format
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontformat?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontFormat(pub u32);
impl CTFontFormat {
    #[doc(alias = "kCTFontFormatUnrecognized")]
    pub const Unrecognized: Self = Self(0);
    #[doc(alias = "kCTFontFormatOpenTypePostScript")]
    pub const OpenTypePostScript: Self = Self(1);
    #[doc(alias = "kCTFontFormatOpenTypeTrueType")]
    pub const OpenTypeTrueType: Self = Self(2);
    #[doc(alias = "kCTFontFormatTrueType")]
    pub const TrueType: Self = Self(3);
    #[doc(alias = "kCTFontFormatPostScript")]
    pub const PostScript: Self = Self(4);
    #[doc(alias = "kCTFontFormatBitmap")]
    pub const Bitmap: Self = Self(5);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontFormat {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontFormat {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// kCTFontRegistrationScopeAttribute
    ///
    /// Specifies the font descriptor's registration scope.
    ///
    /// The attribute is used to specify or obtain the font registration scope. The value returned is a CFNumberRef containing one of the CTFontManagerScope enumerated values. A value of NULL can be returned for font descriptors that are not registered.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontregistrationscopeattribute?language=objc)
    pub static kCTFontRegistrationScopeAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontPriorityAttribute
    ///
    /// The font descriptors priority when resolving duplicates and sorting match results.
    ///
    /// This key is used to obtain or specify the font priority. The value returned is a CFNumberRef containing an integer value as defined below. The higher the value, the higher the priority of the font. Only registered fonts will have a priority. Unregistered font descriptors will return NULL.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontpriorityattribute?language=objc)
    pub static kCTFontPriorityAttribute: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontprioritysystem?language=objc)
pub const kCTFontPrioritySystem: c_uint = 10000;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontprioritynetwork?language=objc)
pub const kCTFontPriorityNetwork: c_uint = 20000;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontprioritycomputer?language=objc)
pub const kCTFontPriorityComputer: c_uint = 30000;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontpriorityuser?language=objc)
pub const kCTFontPriorityUser: c_uint = 40000;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontprioritydynamic?language=objc)
pub const kCTFontPriorityDynamic: c_uint = 50000;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontpriorityprocess?language=objc)
pub const kCTFontPriorityProcess: c_uint = 60000;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontpriority?language=objc)
pub type CTFontPriority = u32;

extern "C" {
    /// kCTFontEnabledAttribute
    ///
    /// The font enabled state.
    ///
    /// The value associated with this key is a CFBoolean. Unregistered font descriptors will return NULL, which is equivalent to false.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontenabledattribute?language=objc)
    pub static kCTFontEnabledAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontDownloadableAttribute
    ///
    /// The font downloadable state.
    ///
    /// The value associated with this key is a CFBoolean. If it is true, CoreText attempts to download a font if necessary when matching a descriptor.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdownloadableattribute?language=objc)
    pub static kCTFontDownloadableAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontDownloadedAttribute
    ///
    /// The download state.
    ///
    /// The value associated with this key is a CFBoolean. If it is true, corresponding FontAsset has been downloaded. (but still it may be necessary to call appropriate API in order to use the font in the FontAsset.)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdownloadedattribute?language=objc)
    pub static kCTFontDownloadedAttribute: &'static CFString;
}

extern "C" {
    /// kCTFontOpticalSizeAttribute
    ///
    /// The point size at which this font is intended to be used.
    ///
    /// The value is a CFNumber used to activate size-specific (not linearly scaled) metrics. Starting with macOS 10.14 and iOS 12.0, the CFString "auto" can be used instead to request an optical size matching the point size. Starting with macOS 10.15 and iOS 13.0, the CFString "none" can be used instead to explicitly disable automatic optical sizing enabled by the font.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontopticalsizeattribute?language=objc)
    pub static kCTFontOpticalSizeAttribute: &'static CFString;
}

impl CTFontDescriptor {
    /// Creates a new font descriptor with the provided PostScript name and size.
    ///
    ///
    /// Parameter `name`: The PostScript name to be used for the font descriptor as a CFStringRef. Any font name beginning with a "." is reserved for the system and should not be used here.
    ///
    ///
    /// Parameter `size`: The point size. If 0.0, the kCTFontSizeAttribute will be omitted from the font descriptor.
    ///
    ///
    /// Returns: This function creates a new font descriptor reference with the given PostScript name and point size.
    ///
    ///
    /// If you are trying to create a system UI font descriptor (with name beginning with a "."), you should create a font with CTFontCreateUIFontForLanguage() or appropriate AppKit/UIKit APIs instead, then use CTFontCopyFontDescriptor() to get its font descriptor.
    #[doc(alias = "CTFontDescriptorCreateWithNameAndSize")]
    #[inline]
    pub unsafe fn with_name_and_size(
        name: &CFString,
        size: CGFloat,
    ) -> CFRetained<CTFontDescriptor> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateWithNameAndSize(
                name: &CFString,
                size: CGFloat,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe { CTFontDescriptorCreateWithNameAndSize(name, size) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates a new font descriptor reference from a dictionary of attributes.
    ///
    ///
    /// Parameter `attributes`: A CFDictionaryRef of arbitrary attributes.
    ///
    ///
    /// Returns: This function creates a new font descriptor with the attributes specified. This dictionary can contain arbitrary attributes that will be preserved, however unrecognized attributes will be ignored on font creation and and may not be preserved over the round trip (descriptor -> font -> descriptor).
    ///
    /// # Safety
    ///
    /// `attributes` generics must be of the correct type.
    #[doc(alias = "CTFontDescriptorCreateWithAttributes")]
    #[inline]
    pub unsafe fn with_attributes(attributes: &CFDictionary) -> CFRetained<CTFontDescriptor> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateWithAttributes(
                attributes: &CFDictionary,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe { CTFontDescriptorCreateWithAttributes(attributes) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates a copy of the original font descriptor with new attributes.
    ///
    ///
    /// Parameter `original`: The original font descriptor reference.
    ///
    ///
    /// Parameter `attributes`: A CFDictionaryRef of arbitrary attributes.
    ///
    ///
    /// Returns: This function creates a new copy of the original font descriptor with attributes augmented by those specified. If there are conflicts between attributes, the new attributes will replace existing ones, except for kCTFontVariationAttribute and kCTFontFeatureSettingsAttribute which will be merged.
    /// Starting with macOS 10.12 and iOS 10.0, setting the value of kCTFontFeatureSettingsAttribute to kCFNull will clear the feature settings of the original font descriptor. Setting the value of any individual feature settings pair in the kCTFontFeatureSettingsAttribute value array to kCFNull will clear that feature setting alone. For example, an element like
    /// @
    /// { (id)kCTFontFeatureTypeIdentifierKey:
    /// @
    /// (kLigaturesType), (id)kCTFontFeatureSelectorIdentifierKey: (id)kCFNull } means clear the kLigatureType feature set in the original font descriptor. An element like
    /// @
    /// [
    /// "
    /// liga", (id)kCFNull ] will have the same effect.
    ///
    ///
    /// See also: kCTFontFeatureSettingsAttribute
    ///
    /// # Safety
    ///
    /// `attributes` generics must be of the correct type.
    #[doc(alias = "CTFontDescriptorCreateCopyWithAttributes")]
    #[inline]
    pub unsafe fn copy_with_attributes(
        &self,
        attributes: &CFDictionary,
    ) -> CFRetained<CTFontDescriptor> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateCopyWithAttributes(
                original: &CTFontDescriptor,
                attributes: &CFDictionary,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe { CTFontDescriptorCreateCopyWithAttributes(self, attributes) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a new font descriptor in the specified family based on the traits of the original descriptor.
    ///
    ///
    /// Parameter `original`: The original font descriptor reference.
    ///
    ///
    /// Parameter `family`: The name of the desired family.
    ///
    ///
    /// Returns: Returns a new font reference with the original traits in the given family, or NULL if none found in the system.
    #[doc(alias = "CTFontDescriptorCreateCopyWithFamily")]
    #[inline]
    pub unsafe fn copy_with_family(
        &self,
        family: &CFString,
    ) -> Option<CFRetained<CTFontDescriptor>> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateCopyWithFamily(
                original: &CTFontDescriptor,
                family: &CFString,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe { CTFontDescriptorCreateCopyWithFamily(self, family) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a new font descriptor based on the original descriptor having the specified symbolic traits.
    ///
    ///
    /// Parameter `original`: The original font descriptor reference.
    ///
    ///
    /// Parameter `symTraitValue`: The value of the symbolic traits. This bitfield is used to indicate the desired value for the traits specified by the symTraitMask parameter. Used in conjunction, they can allow for trait removal as well as addition.
    ///
    ///
    /// Parameter `symTraitMask`: The mask bits of the symbolic traits. This bitfield is used to indicate the traits that should be changed.
    ///
    ///
    /// Returns: Returns a new font descriptor reference in the same family with the given symbolic traits, or NULL if none found in the system.
    #[doc(alias = "CTFontDescriptorCreateCopyWithSymbolicTraits")]
    #[cfg(feature = "CTFontTraits")]
    #[inline]
    pub unsafe fn copy_with_symbolic_traits(
        &self,
        sym_trait_value: CTFontSymbolicTraits,
        sym_trait_mask: CTFontSymbolicTraits,
    ) -> Option<CFRetained<CTFontDescriptor>> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateCopyWithSymbolicTraits(
                original: &CTFontDescriptor,
                sym_trait_value: CTFontSymbolicTraits,
                sym_trait_mask: CTFontSymbolicTraits,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe {
            CTFontDescriptorCreateCopyWithSymbolicTraits(self, sym_trait_value, sym_trait_mask)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a copy of the original font descriptor with a new variation instance.
    ///
    ///
    /// Parameter `original`: The original font descriptor reference.
    ///
    ///
    /// Parameter `variationIdentifier`: The variation axis identifier. This is the four character code of the variation axis as a CFNumberRef.
    ///
    ///
    /// Parameter `variationValue`: The value corresponding with the variation instance.
    ///
    ///
    /// Returns: This function returns a copy of the original font descriptor with a new variation instance. This is a convenience method for easily creating new variation font instances.
    #[doc(alias = "CTFontDescriptorCreateCopyWithVariation")]
    #[inline]
    pub unsafe fn copy_with_variation(
        &self,
        variation_identifier: &CFNumber,
        variation_value: CGFloat,
    ) -> CFRetained<CTFontDescriptor> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateCopyWithVariation(
                original: &CTFontDescriptor,
                variation_identifier: &CFNumber,
                variation_value: CGFloat,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe {
            CTFontDescriptorCreateCopyWithVariation(self, variation_identifier, variation_value)
        };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Copies a font descriptor with new feature setting.
    ///
    ///
    /// This is a convenience method to more easily toggle the state of individual features.
    ///
    ///
    /// Parameter `original`: The original font descriptor reference.
    ///
    ///
    /// Parameter `featureTypeIdentifier`: The feature type identifier.
    ///
    ///
    /// Parameter `featureSelectorIdentifier`: The feature selector identifier.
    ///
    ///
    /// Returns: A copy of the original font descriptor modified with the given feature settings.
    ///
    ///
    /// See also: CTFontDescriptorCreateCopyWithAttributes
    ///
    /// See also: kCTFontFeatureSettingsAttribute
    #[doc(alias = "CTFontDescriptorCreateCopyWithFeature")]
    #[inline]
    pub unsafe fn copy_with_feature(
        &self,
        feature_type_identifier: &CFNumber,
        feature_selector_identifier: &CFNumber,
    ) -> CFRetained<CTFontDescriptor> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateCopyWithFeature(
                original: &CTFontDescriptor,
                feature_type_identifier: &CFNumber,
                feature_selector_identifier: &CFNumber,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe {
            CTFontDescriptorCreateCopyWithFeature(
                self,
                feature_type_identifier,
                feature_selector_identifier,
            )
        };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns an array of font normalized font descriptors matching the provided descriptor.
    ///
    ///
    /// Parameter `descriptor`: The font descriptor reference.
    ///
    ///
    /// Parameter `mandatoryAttributes`: A set of attribute keys which are required to be identically matched in any returned font descriptors. Optional.
    ///
    ///
    /// Returns: This function returns a retained array of normalized font descriptors matching the attributes present in descriptor. If descriptor itself is normalized then the array will contain only one item, the original descriptor.
    ///
    /// # Safety
    ///
    /// `mandatory_attributes` generic must be of the correct type.
    #[doc(alias = "CTFontDescriptorCreateMatchingFontDescriptors")]
    #[inline]
    pub unsafe fn matching_font_descriptors(
        &self,
        mandatory_attributes: Option<&CFSet>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateMatchingFontDescriptors(
                descriptor: &CTFontDescriptor,
                mandatory_attributes: Option<&CFSet>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret =
            unsafe { CTFontDescriptorCreateMatchingFontDescriptors(self, mandatory_attributes) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns an the single preferred matching font descriptor based on the original descriptor and system precedence.
    ///
    ///
    /// Parameter `descriptor`: The font descriptor reference.
    ///
    ///
    /// Parameter `mandatoryAttributes`: A set of attribute keys which are required to be identically matched in any returned font descriptors. Optional.
    ///
    ///
    /// Returns: This function returns a retained normalized font descriptor matching the attributes present in descriptor. The original descriptor may be returned in normalized form.
    ///
    /// # Safety
    ///
    /// `mandatory_attributes` generic must be of the correct type.
    #[doc(alias = "CTFontDescriptorCreateMatchingFontDescriptor")]
    #[inline]
    pub unsafe fn matching_font_descriptor(
        &self,
        mandatory_attributes: Option<&CFSet>,
    ) -> Option<CFRetained<CTFontDescriptor>> {
        extern "C-unwind" {
            fn CTFontDescriptorCreateMatchingFontDescriptor(
                descriptor: &CTFontDescriptor,
                mandatory_attributes: Option<&CFSet>,
            ) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret =
            unsafe { CTFontDescriptorCreateMatchingFontDescriptor(self, mandatory_attributes) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

/// Progress state
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontdescriptormatchingstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontDescriptorMatchingState(pub u32);
impl CTFontDescriptorMatchingState {
    #[doc(alias = "kCTFontDescriptorMatchingDidBegin")]
    pub const DidBegin: Self = Self(0);
    #[doc(alias = "kCTFontDescriptorMatchingDidFinish")]
    pub const DidFinish: Self = Self(1);
    #[doc(alias = "kCTFontDescriptorMatchingWillBeginQuerying")]
    pub const WillBeginQuerying: Self = Self(2);
    #[doc(alias = "kCTFontDescriptorMatchingStalled")]
    pub const Stalled: Self = Self(3);
    #[doc(alias = "kCTFontDescriptorMatchingWillBeginDownloading")]
    pub const WillBeginDownloading: Self = Self(4);
    #[doc(alias = "kCTFontDescriptorMatchingDownloading")]
    pub const Downloading: Self = Self(5);
    #[doc(alias = "kCTFontDescriptorMatchingDidFinishDownloading")]
    pub const DidFinishDownloading: Self = Self(6);
    #[doc(alias = "kCTFontDescriptorMatchingDidMatch")]
    pub const DidMatch: Self = Self(7);
    #[doc(alias = "kCTFontDescriptorMatchingDidFailWithError")]
    pub const DidFailWithError: Self = Self(8);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontDescriptorMatchingState {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontDescriptorMatchingState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingsourcedescriptor?language=objc)
    pub static kCTFontDescriptorMatchingSourceDescriptor: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingdescriptors?language=objc)
    pub static kCTFontDescriptorMatchingDescriptors: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingresult?language=objc)
    pub static kCTFontDescriptorMatchingResult: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingpercentage?language=objc)
    pub static kCTFontDescriptorMatchingPercentage: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingcurrentassetsize?language=objc)
    pub static kCTFontDescriptorMatchingCurrentAssetSize: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingtotaldownloadedsize?language=objc)
    pub static kCTFontDescriptorMatchingTotalDownloadedSize: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingtotalassetsize?language=objc)
    pub static kCTFontDescriptorMatchingTotalAssetSize: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptormatchingerror?language=objc)
    pub static kCTFontDescriptorMatchingError: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontdescriptorprogresshandler?language=objc)
#[cfg(feature = "block2")]
pub type CTFontDescriptorProgressHandler =
    *mut block2::DynBlock<dyn Fn(CTFontDescriptorMatchingState, NonNull<CFDictionary>) -> bool>;

impl CTFontDescriptor {
    /// # Safety
    ///
    /// - `descriptors` generic must be of the correct type.
    /// - `mandatory_attributes` generic must be of the correct type.
    /// - `progress_block` must be a valid pointer.
    #[doc(alias = "CTFontDescriptorMatchFontDescriptorsWithProgressHandler")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn match_font_descriptors_with_progress_handler(
        descriptors: &CFArray,
        mandatory_attributes: Option<&CFSet>,
        progress_block: CTFontDescriptorProgressHandler,
    ) -> bool {
        extern "C-unwind" {
            fn CTFontDescriptorMatchFontDescriptorsWithProgressHandler(
                descriptors: &CFArray,
                mandatory_attributes: Option<&CFSet>,
                progress_block: CTFontDescriptorProgressHandler,
            ) -> bool;
        }
        unsafe {
            CTFontDescriptorMatchFontDescriptorsWithProgressHandler(
                descriptors,
                mandatory_attributes,
                progress_block,
            )
        }
    }

    /// Returns the attributes dictionary of the font descriptor.
    ///
    ///
    /// Parameter `descriptor`: The font descriptor reference.
    ///
    ///
    /// Returns: A retained reference to the font descriptor attributes dictionary. This dictionary will contain the minimum number of attributes to fully specify this particular font descriptor.
    #[doc(alias = "CTFontDescriptorCopyAttributes")]
    #[inline]
    pub unsafe fn attributes(&self) -> CFRetained<CFDictionary> {
        extern "C-unwind" {
            fn CTFontDescriptorCopyAttributes(
                descriptor: &CTFontDescriptor,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CTFontDescriptorCopyAttributes(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the value associated with an arbitrary attribute.
    ///
    ///
    /// Parameter `descriptor`: The font descriptor.
    ///
    ///
    /// Parameter `attribute`: The requested attribute.
    ///
    ///
    /// Returns: A retained reference to the requested attribute, or NULL if the requested attribute is not present. Refer to the attribute definitions for documentation as to how each attribute is packaged as a CFType.
    #[doc(alias = "CTFontDescriptorCopyAttribute")]
    #[inline]
    pub unsafe fn attribute(&self, attribute: &CFString) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CTFontDescriptorCopyAttribute(
                descriptor: &CTFontDescriptor,
                attribute: &CFString,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CTFontDescriptorCopyAttribute(self, attribute) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// function    CTFontDescriptorCopyLocalizedAttribute
    ///
    /// Returns a localized value for the requested attribute if available.
    ///
    ///
    /// This function returns a localized attribute based on the global language list. If localization is not possible for the attribute the behavior matches CTFontDescriptorCopyAttribute(). Generally, localization of attributes is only applicable to name attributes of a normalized font descriptor.
    ///
    ///
    /// Parameter `descriptor`: The font descriptor reference.
    ///
    ///
    /// Parameter `attribute`: The requested font attribute.
    ///
    ///
    /// Parameter `language`: If non-NULL, this will be receive a retained reference to the matched language. The language identifier will conform to UTS #35.
    /// If CoreText can supply its own localized string where the font cannot, this value will be NULL.
    ///
    ///
    /// Returns: A retained reference to the requested attribute, or NULL if the requested attribute is not present. Refer to the attribute definitions for documentation as to how each attribute is packaged as a CFType.
    ///
    /// # Safety
    ///
    /// `language` must be a valid pointer or null.
    #[doc(alias = "CTFontDescriptorCopyLocalizedAttribute")]
    #[inline]
    pub unsafe fn localized_attribute(
        &self,
        attribute: &CFString,
        language: *mut *const CFString,
    ) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CTFontDescriptorCopyLocalizedAttribute(
                descriptor: &CTFontDescriptor,
                attribute: &CFString,
                language: *mut *const CFString,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CTFontDescriptorCopyLocalizedAttribute(self, attribute, language) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[deprecated = "renamed to `CTFontDescriptor::with_name_and_size`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateWithNameAndSize(
    name: &CFString,
    size: CGFloat,
) -> CFRetained<CTFontDescriptor> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateWithNameAndSize(
            name: &CFString,
            size: CGFloat,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe { CTFontDescriptorCreateWithNameAndSize(name, size) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontDescriptor::with_attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateWithAttributes(
    attributes: &CFDictionary,
) -> CFRetained<CTFontDescriptor> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateWithAttributes(
            attributes: &CFDictionary,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe { CTFontDescriptorCreateWithAttributes(attributes) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontDescriptor::copy_with_attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateCopyWithAttributes(
    original: &CTFontDescriptor,
    attributes: &CFDictionary,
) -> CFRetained<CTFontDescriptor> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateCopyWithAttributes(
            original: &CTFontDescriptor,
            attributes: &CFDictionary,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe { CTFontDescriptorCreateCopyWithAttributes(original, attributes) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontDescriptor::copy_with_family`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateCopyWithFamily(
    original: &CTFontDescriptor,
    family: &CFString,
) -> Option<CFRetained<CTFontDescriptor>> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateCopyWithFamily(
            original: &CTFontDescriptor,
            family: &CFString,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe { CTFontDescriptorCreateCopyWithFamily(original, family) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CTFontTraits")]
#[deprecated = "renamed to `CTFontDescriptor::copy_with_symbolic_traits`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateCopyWithSymbolicTraits(
    original: &CTFontDescriptor,
    sym_trait_value: CTFontSymbolicTraits,
    sym_trait_mask: CTFontSymbolicTraits,
) -> Option<CFRetained<CTFontDescriptor>> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateCopyWithSymbolicTraits(
            original: &CTFontDescriptor,
            sym_trait_value: CTFontSymbolicTraits,
            sym_trait_mask: CTFontSymbolicTraits,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe {
        CTFontDescriptorCreateCopyWithSymbolicTraits(original, sym_trait_value, sym_trait_mask)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFontDescriptor::copy_with_variation`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateCopyWithVariation(
    original: &CTFontDescriptor,
    variation_identifier: &CFNumber,
    variation_value: CGFloat,
) -> CFRetained<CTFontDescriptor> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateCopyWithVariation(
            original: &CTFontDescriptor,
            variation_identifier: &CFNumber,
            variation_value: CGFloat,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe {
        CTFontDescriptorCreateCopyWithVariation(original, variation_identifier, variation_value)
    };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontDescriptor::copy_with_feature`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateCopyWithFeature(
    original: &CTFontDescriptor,
    feature_type_identifier: &CFNumber,
    feature_selector_identifier: &CFNumber,
) -> CFRetained<CTFontDescriptor> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateCopyWithFeature(
            original: &CTFontDescriptor,
            feature_type_identifier: &CFNumber,
            feature_selector_identifier: &CFNumber,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe {
        CTFontDescriptorCreateCopyWithFeature(
            original,
            feature_type_identifier,
            feature_selector_identifier,
        )
    };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontDescriptor::matching_font_descriptors`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateMatchingFontDescriptors(
    descriptor: &CTFontDescriptor,
    mandatory_attributes: Option<&CFSet>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateMatchingFontDescriptors(
            descriptor: &CTFontDescriptor,
            mandatory_attributes: Option<&CFSet>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret =
        unsafe { CTFontDescriptorCreateMatchingFontDescriptors(descriptor, mandatory_attributes) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFontDescriptor::matching_font_descriptor`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCreateMatchingFontDescriptor(
    descriptor: &CTFontDescriptor,
    mandatory_attributes: Option<&CFSet>,
) -> Option<CFRetained<CTFontDescriptor>> {
    extern "C-unwind" {
        fn CTFontDescriptorCreateMatchingFontDescriptor(
            descriptor: &CTFontDescriptor,
            mandatory_attributes: Option<&CFSet>,
        ) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret =
        unsafe { CTFontDescriptorCreateMatchingFontDescriptor(descriptor, mandatory_attributes) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "block2")]
    #[deprecated = "renamed to `CTFontDescriptor::match_font_descriptors_with_progress_handler`"]
    pub fn CTFontDescriptorMatchFontDescriptorsWithProgressHandler(
        descriptors: &CFArray,
        mandatory_attributes: Option<&CFSet>,
        progress_block: CTFontDescriptorProgressHandler,
    ) -> bool;
}

#[deprecated = "renamed to `CTFontDescriptor::attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCopyAttributes(
    descriptor: &CTFontDescriptor,
) -> CFRetained<CFDictionary> {
    extern "C-unwind" {
        fn CTFontDescriptorCopyAttributes(
            descriptor: &CTFontDescriptor,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CTFontDescriptorCopyAttributes(descriptor) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFontDescriptor::attribute`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCopyAttribute(
    descriptor: &CTFontDescriptor,
    attribute: &CFString,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CTFontDescriptorCopyAttribute(
            descriptor: &CTFontDescriptor,
            attribute: &CFString,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CTFontDescriptorCopyAttribute(descriptor, attribute) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFontDescriptor::localized_attribute`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontDescriptorCopyLocalizedAttribute(
    descriptor: &CTFontDescriptor,
    attribute: &CFString,
    language: *mut *const CFString,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CTFontDescriptorCopyLocalizedAttribute(
            descriptor: &CTFontDescriptor,
            attribute: &CFString,
            language: *mut *const CFString,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CTFontDescriptorCopyLocalizedAttribute(descriptor, attribute, language) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
