use libc::{timespec, FILE};
/* automatically generated by rust-bindgen 0.69.4 */

pub const BLOSC2_VERSION_MAJOR: u32 = 2;
pub const BLOSC2_VERSION_MINOR: u32 = 15;
pub const BLOSC2_VERSION_RELEASE: u32 = 1;
pub const BLOSC2_VERSION_STRING: &[u8; 7] = b"2.15.1\0";
pub const BLOSC2_VERSION_DATE: &[u8; 22] = b"$Date:: 2024-07-30 #$\0";
pub const BLOSC2_MAX_DIM: u32 = 8;
pub const BLOSC_BLOSCLZ_COMPNAME: &[u8; 8] = b"blosclz\0";
pub const BLOSC_LZ4_COMPNAME: &[u8; 4] = b"lz4\0";
pub const BLOSC_LZ4HC_COMPNAME: &[u8; 6] = b"lz4hc\0";
pub const BLOSC_ZLIB_COMPNAME: &[u8; 5] = b"zlib\0";
pub const BLOSC_ZSTD_COMPNAME: &[u8; 5] = b"zstd\0";
pub const BLOSC_BLOSCLZ_LIBNAME: &[u8; 8] = b"BloscLZ\0";
pub const BLOSC_LZ4_LIBNAME: &[u8; 4] = b"LZ4\0";
pub const BLOSC_ZLIB_LIBNAME: &[u8; 5] = b"Zlib\0";
pub const BLOSC_ZSTD_LIBNAME: &[u8; 5] = b"Zstd\0";
pub const BLOSC2_MAX_METALAYERS: u32 = 16;
pub const BLOSC2_METALAYER_NAME_MAXLEN: u32 = 31;
pub const BLOSC2_MAX_VLMETALAYERS: u32 = 8192;
pub const BLOSC2_VLMETALAYERS_NAME_MAXLEN: u32 = 31;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_stdio_file {
    pub file: *mut FILE,
}
#[test]
fn bindgen_test_layout_blosc2_stdio_file() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_stdio_file> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_stdio_file>(),
        8usize,
        concat!("Size of: ", stringify!(blosc2_stdio_file))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_stdio_file>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_stdio_file))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).file) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_file),
            "::",
            stringify!(file)
        )
    );
}
extern "C" {
    pub fn blosc2_stdio_open(
        urlpath: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        params: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn blosc2_stdio_close(stream: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_stdio_size(stream: *mut ::std::os::raw::c_void) -> i64;
}
extern "C" {
    pub fn blosc2_stdio_write(
        ptr: *const ::std::os::raw::c_void,
        size: i64,
        nitems: i64,
        position: i64,
        stream: *mut ::std::os::raw::c_void,
    ) -> i64;
}
extern "C" {
    pub fn blosc2_stdio_read(
        ptr: *mut *mut ::std::os::raw::c_void,
        size: i64,
        nitems: i64,
        position: i64,
        stream: *mut ::std::os::raw::c_void,
    ) -> i64;
}
extern "C" {
    pub fn blosc2_stdio_truncate(
        stream: *mut ::std::os::raw::c_void,
        size: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_stdio_destroy(params: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
#[doc = " @brief Parameters for memory-mapped I/O. You can use the blosc2_schunk_open*_udio functions to memory-map existing\n schunk files from disk. To create a new schunk which is backed up by a memory-mapped file on disk, set the io member\n of the #blosc2_storage struct (see test_mmap for examples). Please note that memory-mapped I/O is only available for\n cframes and not sframes."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_stdio_mmap {
    pub mode: *const ::std::os::raw::c_char,
    pub initial_mapping_size: i64,
    pub needs_free: bool,
    pub addr: *mut ::std::os::raw::c_char,
    pub urlpath: *mut ::std::os::raw::c_char,
    pub file_size: i64,
    pub mapping_size: i64,
    pub is_memory_only: bool,
    pub file: *mut FILE,
    pub fd: ::std::os::raw::c_int,
    pub access_flags: i64,
    pub map_flags: i64,
}
#[test]
fn bindgen_test_layout_blosc2_stdio_mmap() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_stdio_mmap> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_stdio_mmap>(),
        96usize,
        concat!("Size of: ", stringify!(blosc2_stdio_mmap))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_stdio_mmap>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_stdio_mmap))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).initial_mapping_size) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(initial_mapping_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).needs_free) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(needs_free)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).addr) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).urlpath) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(urlpath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).file_size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(file_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mapping_size) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(mapping_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_memory_only) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(is_memory_only)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).file) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).access_flags) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(access_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).map_flags) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_stdio_mmap),
            "::",
            stringify!(map_flags)
        )
    );
}
extern "C" {
    #[doc = " @brief Default struct for memory-mapped I/O for user initialization."]
    pub static BLOSC2_STDIO_MMAP_DEFAULTS: blosc2_stdio_mmap;
}
extern "C" {
    pub fn blosc2_stdio_mmap_open(
        urlpath: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        params: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn blosc2_stdio_mmap_close(stream: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_stdio_mmap_size(stream: *mut ::std::os::raw::c_void) -> i64;
}
extern "C" {
    pub fn blosc2_stdio_mmap_write(
        ptr: *const ::std::os::raw::c_void,
        size: i64,
        nitems: i64,
        position: i64,
        stream: *mut ::std::os::raw::c_void,
    ) -> i64;
}
extern "C" {
    pub fn blosc2_stdio_mmap_read(
        ptr: *mut *mut ::std::os::raw::c_void,
        size: i64,
        nitems: i64,
        position: i64,
        stream: *mut ::std::os::raw::c_void,
    ) -> i64;
}
extern "C" {
    pub fn blosc2_stdio_mmap_truncate(
        stream: *mut ::std::os::raw::c_void,
        size: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_stdio_mmap_destroy(params: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
pub const BLOSC1_VERSION_FORMAT_PRE1: _bindgen_ty_4 = 1;
pub const BLOSC1_VERSION_FORMAT: _bindgen_ty_4 = 2;
pub const BLOSC2_VERSION_FORMAT_ALPHA: _bindgen_ty_4 = 3;
pub const BLOSC2_VERSION_FORMAT_BETA1: _bindgen_ty_4 = 4;
pub const BLOSC2_VERSION_FORMAT_STABLE: _bindgen_ty_4 = 5;
pub const BLOSC2_VERSION_FORMAT: _bindgen_ty_4 = 5;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub const BLOSC2_VERSION_FRAME_FORMAT_BETA2: _bindgen_ty_5 = 1;
pub const BLOSC2_VERSION_FRAME_FORMAT_RC1: _bindgen_ty_5 = 2;
pub const BLOSC2_VERSION_FRAME_FORMAT: _bindgen_ty_5 = 2;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_instr {
    pub cratio: f32,
    pub cspeed: f32,
    pub filter_speed: f32,
    pub flags: [u8; 4usize],
}
#[test]
fn bindgen_test_layout_blosc2_instr() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_instr> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_instr>(),
        16usize,
        concat!("Size of: ", stringify!(blosc2_instr))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_instr>(),
        4usize,
        concat!("Alignment of ", stringify!(blosc2_instr))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cratio) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_instr),
            "::",
            stringify!(cratio)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cspeed) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_instr),
            "::",
            stringify!(cspeed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filter_speed) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_instr),
            "::",
            stringify!(filter_speed)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_instr),
            "::",
            stringify!(flags)
        )
    );
}
pub const BLOSC_MIN_HEADER_LENGTH: _bindgen_ty_6 = 16;
pub const BLOSC_EXTENDED_HEADER_LENGTH: _bindgen_ty_6 = 32;
pub const BLOSC2_MAX_OVERHEAD: _bindgen_ty_6 = 32;
pub const BLOSC2_MAX_BUFFERSIZE: _bindgen_ty_6 = 2147483615;
pub const BLOSC_MAX_TYPESIZE: _bindgen_ty_6 = 255;
pub const BLOSC_MIN_BUFFERSIZE: _bindgen_ty_6 = 32;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
pub const BLOSC2_DEFINED_TUNER_START: _bindgen_ty_7 = 0;
pub const BLOSC2_DEFINED_TUNER_STOP: _bindgen_ty_7 = 31;
pub const BLOSC2_GLOBAL_REGISTERED_TUNER_START: _bindgen_ty_7 = 32;
pub const BLOSC2_GLOBAL_REGISTERED_TUNER_STOP: _bindgen_ty_7 = 159;
pub const BLOSC2_GLOBAL_REGISTERED_TUNERS: _bindgen_ty_7 = 0;
pub const BLOSC2_USER_REGISTERED_TUNER_START: _bindgen_ty_7 = 160;
pub const BLOSC2_USER_REGISTERED_TUNER_STOP: _bindgen_ty_7 = 255;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
pub const BLOSC_STUNE: _bindgen_ty_8 = 0;
pub const BLOSC_LAST_TUNER: _bindgen_ty_8 = 1;
pub const BLOSC_LAST_REGISTERED_TUNE: _bindgen_ty_8 = 31;
#[doc = " @brief Codes for the different tuners shipped with Blosc"]
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
pub const BLOSC2_DEFINED_FILTERS_START: _bindgen_ty_9 = 0;
pub const BLOSC2_DEFINED_FILTERS_STOP: _bindgen_ty_9 = 31;
pub const BLOSC2_GLOBAL_REGISTERED_FILTERS_START: _bindgen_ty_9 = 32;
pub const BLOSC2_GLOBAL_REGISTERED_FILTERS_STOP: _bindgen_ty_9 = 159;
pub const BLOSC2_GLOBAL_REGISTERED_FILTERS: _bindgen_ty_9 = 5;
pub const BLOSC2_USER_REGISTERED_FILTERS_START: _bindgen_ty_9 = 160;
pub const BLOSC2_USER_REGISTERED_FILTERS_STOP: _bindgen_ty_9 = 255;
pub const BLOSC2_MAX_FILTERS: _bindgen_ty_9 = 6;
pub const BLOSC2_MAX_UDFILTERS: _bindgen_ty_9 = 16;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
pub const BLOSC_NOSHUFFLE: _bindgen_ty_10 = 0;
pub const BLOSC_NOFILTER: _bindgen_ty_10 = 0;
pub const BLOSC_SHUFFLE: _bindgen_ty_10 = 1;
pub const BLOSC_BITSHUFFLE: _bindgen_ty_10 = 2;
pub const BLOSC_DELTA: _bindgen_ty_10 = 3;
pub const BLOSC_TRUNC_PREC: _bindgen_ty_10 = 4;
pub const BLOSC_LAST_FILTER: _bindgen_ty_10 = 5;
pub const BLOSC_LAST_REGISTERED_FILTER: _bindgen_ty_10 = 36;
#[doc = " @brief Codes for filters.\n\n @sa #blosc1_compress"]
pub type _bindgen_ty_10 = ::std::os::raw::c_uint;
#[doc = "!< byte-wise shuffle"]
pub const BLOSC_DOSHUFFLE: _bindgen_ty_11 = 1;
#[doc = "!< plain copy"]
pub const BLOSC_MEMCPYED: _bindgen_ty_11 = 2;
#[doc = "!< bit-wise shuffle"]
pub const BLOSC_DOBITSHUFFLE: _bindgen_ty_11 = 4;
#[doc = "!< delta coding"]
pub const BLOSC_DODELTA: _bindgen_ty_11 = 8;
#[doc = " @brief Codes for internal flags (see blosc1_cbuffer_metainfo)"]
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
#[doc = "!< use dictionaries with codec"]
pub const BLOSC2_USEDICT: _bindgen_ty_12 = 1;
#[doc = "!< data is in big-endian ordering"]
pub const BLOSC2_BIGENDIAN: _bindgen_ty_12 = 2;
#[doc = "!< codec is instrumented (mainly for development)"]
pub const BLOSC2_INSTR_CODEC: _bindgen_ty_12 = 128;
#[doc = " @brief Codes for new internal flags in Blosc2"]
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
#[doc = "!< maximum size for compression dicts"]
pub const BLOSC2_MAXDICTSIZE: _bindgen_ty_13 = 131072;
#[doc = "!< maximum size for blocks"]
pub const BLOSC2_MAXBLOCKSIZE: _bindgen_ty_13 = 536866816;
#[doc = " @brief Values for different Blosc2 capabilities"]
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
pub const BLOSC2_DEFINED_CODECS_START: _bindgen_ty_14 = 0;
pub const BLOSC2_DEFINED_CODECS_STOP: _bindgen_ty_14 = 31;
pub const BLOSC2_GLOBAL_REGISTERED_CODECS_START: _bindgen_ty_14 = 32;
pub const BLOSC2_GLOBAL_REGISTERED_CODECS_STOP: _bindgen_ty_14 = 159;
pub const BLOSC2_GLOBAL_REGISTERED_CODECS: _bindgen_ty_14 = 5;
pub const BLOSC2_USER_REGISTERED_CODECS_START: _bindgen_ty_14 = 160;
pub const BLOSC2_USER_REGISTERED_CODECS_STOP: _bindgen_ty_14 = 255;
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
pub const BLOSC_BLOSCLZ: _bindgen_ty_15 = 0;
pub const BLOSC_LZ4: _bindgen_ty_15 = 1;
pub const BLOSC_LZ4HC: _bindgen_ty_15 = 2;
pub const BLOSC_ZLIB: _bindgen_ty_15 = 4;
pub const BLOSC_ZSTD: _bindgen_ty_15 = 5;
pub const BLOSC_LAST_CODEC: _bindgen_ty_15 = 6;
pub const BLOSC_LAST_REGISTERED_CODEC: _bindgen_ty_15 = 36;
#[doc = " @brief Codes for the different compressors shipped with Blosc"]
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
pub const BLOSC_BLOSCLZ_LIB: _bindgen_ty_16 = 0;
pub const BLOSC_LZ4_LIB: _bindgen_ty_16 = 1;
pub const BLOSC_ZLIB_LIB: _bindgen_ty_16 = 3;
pub const BLOSC_ZSTD_LIB: _bindgen_ty_16 = 4;
pub const BLOSC_UDCODEC_LIB: _bindgen_ty_16 = 6;
#[doc = "!< compressor library in super-chunk header"]
pub const BLOSC_SCHUNK_LIB: _bindgen_ty_16 = 7;
#[doc = " @brief Codes for compression libraries shipped with Blosc (code must be < 8)"]
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
pub const BLOSC_BLOSCLZ_FORMAT: _bindgen_ty_17 = 0;
pub const BLOSC_LZ4_FORMAT: _bindgen_ty_17 = 1;
pub const BLOSC_LZ4HC_FORMAT: _bindgen_ty_17 = 1;
pub const BLOSC_ZLIB_FORMAT: _bindgen_ty_17 = 3;
pub const BLOSC_ZSTD_FORMAT: _bindgen_ty_17 = 4;
pub const BLOSC_UDCODEC_FORMAT: _bindgen_ty_17 = 6;
#[doc = " @brief The codes for compressor formats shipped with Blosc"]
pub type _bindgen_ty_17 = ::std::os::raw::c_uint;
pub const BLOSC_BLOSCLZ_VERSION_FORMAT: _bindgen_ty_18 = 1;
pub const BLOSC_LZ4_VERSION_FORMAT: _bindgen_ty_18 = 1;
pub const BLOSC_LZ4HC_VERSION_FORMAT: _bindgen_ty_18 = 1;
pub const BLOSC_ZLIB_VERSION_FORMAT: _bindgen_ty_18 = 1;
pub const BLOSC_ZSTD_VERSION_FORMAT: _bindgen_ty_18 = 1;
pub const BLOSC_UDCODEC_VERSION_FORMAT: _bindgen_ty_18 = 1;
#[doc = " @brief The version formats for compressors shipped with Blosc.\n All versions here starts at 1"]
pub type _bindgen_ty_18 = ::std::os::raw::c_uint;
pub const BLOSC_ALWAYS_SPLIT: _bindgen_ty_19 = 1;
pub const BLOSC_NEVER_SPLIT: _bindgen_ty_19 = 2;
pub const BLOSC_AUTO_SPLIT: _bindgen_ty_19 = 3;
pub const BLOSC_FORWARD_COMPAT_SPLIT: _bindgen_ty_19 = 4;
pub type _bindgen_ty_19 = ::std::os::raw::c_uint;
#[doc = "!< the version for the chunk format"]
pub const BLOSC2_CHUNK_VERSION: _bindgen_ty_20 = 0;
#[doc = "!< the version for the format of internal codec"]
pub const BLOSC2_CHUNK_VERSIONLZ: _bindgen_ty_20 = 1;
#[doc = "!< flags and codec info"]
pub const BLOSC2_CHUNK_FLAGS: _bindgen_ty_20 = 2;
#[doc = "!< (uint8) the number of bytes of the atomic type"]
pub const BLOSC2_CHUNK_TYPESIZE: _bindgen_ty_20 = 3;
#[doc = "!< (int32) uncompressed size of the buffer (this header is not included)"]
pub const BLOSC2_CHUNK_NBYTES: _bindgen_ty_20 = 4;
#[doc = "!< (int32) size of internal blocks"]
pub const BLOSC2_CHUNK_BLOCKSIZE: _bindgen_ty_20 = 8;
#[doc = "!< (int32) compressed size of the buffer (including this header)"]
pub const BLOSC2_CHUNK_CBYTES: _bindgen_ty_20 = 12;
#[doc = "!< the codecs for the filter pipeline (1 byte per code)"]
pub const BLOSC2_CHUNK_FILTER_CODES: _bindgen_ty_20 = 16;
#[doc = "!< meta info for the filter pipeline (1 byte per code)"]
pub const BLOSC2_CHUNK_FILTER_META: _bindgen_ty_20 = 24;
#[doc = "!< flags specific for Blosc2 functionality"]
pub const BLOSC2_CHUNK_BLOSC2_FLAGS: _bindgen_ty_20 = 31;
#[doc = " @brief Offsets for fields in Blosc2 chunk header."]
pub type _bindgen_ty_20 = ::std::os::raw::c_uint;
#[doc = "!< no special value"]
pub const BLOSC2_NO_SPECIAL: _bindgen_ty_21 = 0;
#[doc = "!< zero special value"]
pub const BLOSC2_SPECIAL_ZERO: _bindgen_ty_21 = 1;
#[doc = "!< NaN special value"]
pub const BLOSC2_SPECIAL_NAN: _bindgen_ty_21 = 2;
#[doc = "!< generic special value"]
pub const BLOSC2_SPECIAL_VALUE: _bindgen_ty_21 = 3;
#[doc = "!< non initialized values"]
pub const BLOSC2_SPECIAL_UNINIT: _bindgen_ty_21 = 4;
#[doc = "!< last valid ID for special value (update this adequately)"]
pub const BLOSC2_SPECIAL_LASTID: _bindgen_ty_21 = 4;
#[doc = "!< special value mask (prev IDs cannot be larger than this)"]
pub const BLOSC2_SPECIAL_MASK: _bindgen_ty_21 = 7;
#[doc = " @brief Run lengths for special values for chunks/frames"]
pub type _bindgen_ty_21 = ::std::os::raw::c_uint;
pub const BLOSC2_ERROR_SUCCESS: _bindgen_ty_22 = 0;
pub const BLOSC2_ERROR_FAILURE: _bindgen_ty_22 = -1;
pub const BLOSC2_ERROR_STREAM: _bindgen_ty_22 = -2;
pub const BLOSC2_ERROR_DATA: _bindgen_ty_22 = -3;
pub const BLOSC2_ERROR_MEMORY_ALLOC: _bindgen_ty_22 = -4;
#[doc = "!< Not enough space to read"]
pub const BLOSC2_ERROR_READ_BUFFER: _bindgen_ty_22 = -5;
#[doc = "!< Not enough space to write"]
pub const BLOSC2_ERROR_WRITE_BUFFER: _bindgen_ty_22 = -6;
#[doc = "!< Codec not supported"]
pub const BLOSC2_ERROR_CODEC_SUPPORT: _bindgen_ty_22 = -7;
#[doc = "!< Invalid parameter supplied to codec"]
pub const BLOSC2_ERROR_CODEC_PARAM: _bindgen_ty_22 = -8;
#[doc = "!< Codec dictionary error"]
pub const BLOSC2_ERROR_CODEC_DICT: _bindgen_ty_22 = -9;
#[doc = "!< Version not supported"]
pub const BLOSC2_ERROR_VERSION_SUPPORT: _bindgen_ty_22 = -10;
#[doc = "!< Invalid value in header"]
pub const BLOSC2_ERROR_INVALID_HEADER: _bindgen_ty_22 = -11;
#[doc = "!< Invalid parameter supplied to function"]
pub const BLOSC2_ERROR_INVALID_PARAM: _bindgen_ty_22 = -12;
#[doc = "!< File read failure"]
pub const BLOSC2_ERROR_FILE_READ: _bindgen_ty_22 = -13;
#[doc = "!< File write failure"]
pub const BLOSC2_ERROR_FILE_WRITE: _bindgen_ty_22 = -14;
#[doc = "!< File open failure"]
pub const BLOSC2_ERROR_FILE_OPEN: _bindgen_ty_22 = -15;
#[doc = "!< Not found"]
pub const BLOSC2_ERROR_NOT_FOUND: _bindgen_ty_22 = -16;
#[doc = "!< Bad run length encoding"]
pub const BLOSC2_ERROR_RUN_LENGTH: _bindgen_ty_22 = -17;
#[doc = "!< Filter pipeline error"]
pub const BLOSC2_ERROR_FILTER_PIPELINE: _bindgen_ty_22 = -18;
#[doc = "!< Chunk insert failure"]
pub const BLOSC2_ERROR_CHUNK_INSERT: _bindgen_ty_22 = -19;
#[doc = "!< Chunk append failure"]
pub const BLOSC2_ERROR_CHUNK_APPEND: _bindgen_ty_22 = -20;
#[doc = "!< Chunk update failure"]
pub const BLOSC2_ERROR_CHUNK_UPDATE: _bindgen_ty_22 = -21;
#[doc = "!< Sizes larger than 2gb not supported"]
pub const BLOSC2_ERROR_2GB_LIMIT: _bindgen_ty_22 = -22;
#[doc = "!< Super-chunk copy failure"]
pub const BLOSC2_ERROR_SCHUNK_COPY: _bindgen_ty_22 = -23;
#[doc = "!< Wrong type for frame"]
pub const BLOSC2_ERROR_FRAME_TYPE: _bindgen_ty_22 = -24;
#[doc = "!< File truncate failure"]
pub const BLOSC2_ERROR_FILE_TRUNCATE: _bindgen_ty_22 = -25;
#[doc = "!< Thread or thread context creation failure"]
pub const BLOSC2_ERROR_THREAD_CREATE: _bindgen_ty_22 = -26;
#[doc = "!< Postfilter failure"]
pub const BLOSC2_ERROR_POSTFILTER: _bindgen_ty_22 = -27;
#[doc = "!< Special frame failure"]
pub const BLOSC2_ERROR_FRAME_SPECIAL: _bindgen_ty_22 = -28;
#[doc = "!< Special super-chunk failure"]
pub const BLOSC2_ERROR_SCHUNK_SPECIAL: _bindgen_ty_22 = -29;
#[doc = "!< IO plugin error"]
pub const BLOSC2_ERROR_PLUGIN_IO: _bindgen_ty_22 = -30;
#[doc = "!< Remove file failure"]
pub const BLOSC2_ERROR_FILE_REMOVE: _bindgen_ty_22 = -31;
#[doc = "!< Pointer is null"]
pub const BLOSC2_ERROR_NULL_POINTER: _bindgen_ty_22 = -32;
#[doc = "!< Invalid index"]
pub const BLOSC2_ERROR_INVALID_INDEX: _bindgen_ty_22 = -33;
#[doc = "!< Metalayer has not been found"]
pub const BLOSC2_ERROR_METALAYER_NOT_FOUND: _bindgen_ty_22 = -34;
#[doc = "!< Max buffer size exceeded"]
pub const BLOSC2_ERROR_MAX_BUFSIZE_EXCEEDED: _bindgen_ty_22 = -35;
#[doc = "!< Tuner failure"]
pub const BLOSC2_ERROR_TUNER: _bindgen_ty_22 = -36;
#[doc = " @brief Error codes\n Each time an error code is added here, its corresponding message error should be added in\n print_error()"]
pub type _bindgen_ty_22 = ::std::os::raw::c_int;
extern "C" {
    #[doc = " @brief Initialize the Blosc library environment.\n\n You must call this previous to any other Blosc call, unless you want\n Blosc to be used simultaneously in a multi-threaded environment, in\n which case you can use the #blosc2_compress_ctx #blosc2_decompress_ctx pair.\n\n @sa #blosc2_destroy"]
    pub fn blosc2_init();
}
extern "C" {
    #[doc = " @brief Destroy the Blosc library environment.\n\n You must call this after to you are done with all the Blosc calls,\n unless you have not used blosc2_init() before.\n\n @sa #blosc2_init"]
    pub fn blosc2_destroy();
}
extern "C" {
    #[doc = " @brief Compress a block of data in the @p src buffer and returns the size of\n compressed block.\n\n @remark Compression is memory safe and guaranteed not to write @p dest\n more than what is specified in @p destsize.\n There is not a minimum for @p src buffer size @p nbytes.\n Equivalent to #blosc2_compress.\n\n @warning The @p src buffer and the @p dest buffer can not overlap.\n\n @param clevel The desired compression level and must be a number\n between 0 (no compression) and 9 (maximum compression).\n @param doshuffle Specifies whether the shuffle compression preconditioner\n should be applied or not. #BLOSC_NOFILTER means not applying filters,\n #BLOSC_SHUFFLE means applying shuffle at a byte level and\n #BLOSC_BITSHUFFLE at a bit level (slower but *may* achieve better\n compression).\n @param typesize Is the number of bytes for the atomic type in binary\n @p src buffer.  This is mainly useful for the shuffle preconditioner.\n For implementation reasons, only a 1 < typesize < 256 will allow the\n shuffle filter to work.  When typesize is not in this range, shuffle\n will be silently disabled.\n @param nbytes The number of bytes to compress in the @p src buffer.\n @param src The buffer containing the data to compress.\n @param dest The buffer where the compressed data will be put,\n must have at least the size of @p destsize.\n @param destsize The size of the dest buffer. Blosc\n guarantees that if you set @p destsize to, at least,\n (@p nbytes + #BLOSC2_MAX_OVERHEAD), the compression will always succeed.\n\n @return The number of bytes compressed.\n If @p src buffer cannot be compressed into @p destsize, the return\n value is zero and you should discard the contents of the @p dest\n buffer. A negative return value means that an internal error happened. This\n should never happen. If you see this, please report it back\n together with the buffer data causing this and compression settings.\n\n\n @par Environment variables\n @parblock\n\n This function honors different environment variables to control\n internal parameters without the need of doing that programmatically.\n Here are the ones supported:\n\n * **BLOSC_CLEVEL=(INTEGER)**: This will overwrite the @p clevel parameter\n before the compression process starts.\n\n * **BLOSC_SHUFFLE=[NOSHUFFLE | SHUFFLE | BITSHUFFLE]**: This will\n overwrite the @p doshuffle parameter before the compression process\n starts.\n\n * **BLOSC_DELTA=(1|0)**: This will call #blosc2_set_delta() before the\n compression process starts.\n\n * **BLOSC_TYPESIZE=(INTEGER)**: This will overwrite the @p typesize\n parameter before the compression process starts.\n\n * **BLOSC_COMPRESSOR=[BLOSCLZ | LZ4 | LZ4HC | ZLIB | ZSTD]**:\n This will call #blosc1_set_compressor before the compression process starts.\n\n * **BLOSC_NTHREADS=(INTEGER)**: This will call\n #blosc2_set_nthreads before the compression process starts.\n\n * **BLOSC_SPLITMODE=(ALWAYS | NEVER | AUTO | FORWARD_COMPAT)**:\n This will call #blosc1_set_splitmode() before the compression process starts.\n\n * **BLOSC_BLOCKSIZE=(INTEGER)**: This will call\n #blosc1_set_blocksize before the compression process starts.\n *NOTE:* The *blocksize* is a critical parameter with\n important restrictions in the allowed values, so use this with care.\n\n * **BLOSC_NOLOCK=(ANY VALUE)**: This will call #blosc2_compress_ctx under\n the hood, with the *compressor*, *blocksize* and\n *numinternalthreads* parameters set to the same as the last calls to\n #blosc1_set_compressor, #blosc1_set_blocksize and\n #blosc2_set_nthreads. *BLOSC_CLEVEL*, *BLOSC_SHUFFLE*, *BLOSC_DELTA* and\n *BLOSC_TYPESIZE* environment vars will also be honored.\n\n @endparblock\n\n @sa #blosc1_decompress"]
    pub fn blosc1_compress(
        clevel: ::std::os::raw::c_int,
        doshuffle: ::std::os::raw::c_int,
        typesize: usize,
        nbytes: usize,
        src: *const ::std::os::raw::c_void,
        dest: *mut ::std::os::raw::c_void,
        destsize: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Decompress a block of compressed data in @p src, put the result in\n @p dest and returns the size of the decompressed block.\n\n @warning The @p src buffer and the @p dest buffer can not overlap.\n\n @remark Decompression is memory safe and guaranteed not to write the @p dest\n buffer more than what is specified in @p destsize.\n Similar to #blosc2_decompress.\n\n @remark In case you want to keep under control the number of bytes read from\n source, you can call #blosc1_cbuffer_sizes first to check whether the\n @p nbytes (i.e. the number of bytes to be read from @p src buffer by this\n function) in the compressed buffer is ok with you.\n\n @param src The buffer to be decompressed.\n @param dest The buffer where the decompressed data will be put.\n @param destsize The size of the @p dest buffer.\n\n @return The number of bytes decompressed.\n If an error occurs, e.g. the compressed data is corrupted or the\n output buffer is not large enough, then a negative value\n will be returned instead.\n\n @par Environment variables\n @parblock\n This function honors different environment variables to control\n internal parameters without the need of doing that programmatically.\n Here are the ones supported:\n\n * **BLOSC_NTHREADS=(INTEGER)**: This will call\n #blosc2_set_nthreads before the proper decompression\n process starts.\n\n * **BLOSC_NOLOCK=(ANY VALUE)**: This will call #blosc2_decompress_ctx\n under the hood, with the *numinternalthreads* parameter set to the\n same value as the last call to #blosc2_set_nthreads.\n\n @endparblock\n\n @sa #blosc1_compress"]
    pub fn blosc1_decompress(
        src: *const ::std::os::raw::c_void,
        dest: *mut ::std::os::raw::c_void,
        destsize: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get @p nitems (of @p typesize size) in @p src buffer starting in @p start.\n The items are returned in @p dest buffer, which has to have enough\n space for storing all items.\n\n @remark The function #blosc2_getitem is a more complete and secure version.\n\n @param src The compressed buffer from data will be decompressed.\n @param start The position of the first item (of @p typesize size) from where data\n will be retrieved.\n @param nitems The number of items (of @p typesize size) that will be retrieved.\n @param dest The buffer where the decompressed data retrieved will be put.\n\n @return The number of bytes copied to @p dest or a negative value if\n some error happens."]
    pub fn blosc1_getitem(
        src: *const ::std::os::raw::c_void,
        start: ::std::os::raw::c_int,
        nitems: ::std::os::raw::c_int,
        dest: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get @p nitems (of @p typesize size) in @p src buffer starting in @p start.\n The items are returned in @p dest buffer. The dest buffer should have enough space\n for storing all items. This function is a more secure version of #blosc1_getitem.\n\n @param src The compressed buffer holding the data to be retrieved.\n @param srcsize Size of the compressed buffer.\n @param start The position of the first item (of @p typesize size) from where data\n will be retrieved.\n @param nitems The number of items (of @p typesize size) that will be retrieved.\n @param dest The buffer where the retrieved data will be stored decompressed.\n @param destsize Size of the buffer where retrieved data will be stored.\n\n @return The number of bytes copied to @p dest or a negative value if\n some error happens."]
    pub fn blosc2_getitem(
        src: *const ::std::os::raw::c_void,
        srcsize: i32,
        start: ::std::os::raw::c_int,
        nitems: ::std::os::raw::c_int,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
#[doc = "Pointer to a callback function that executes `dojob(jobdata + i*jobdata_elsize)` for `i = 0 to numjobs-1`,\npossibly in parallel threads (but not returning until all `dojob` calls have returned).   This allows the\ncaller to provide a custom threading backend as an alternative to the default Blosc-managed threads.\n`callback_data` is passed through from `blosc2_set_threads_callback`."]
pub type blosc_threads_callback = ::std::option::Option<
    unsafe extern "C" fn(
        callback_data: *mut ::std::os::raw::c_void,
        dojob: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        numjobs: ::std::os::raw::c_int,
        jobdata_elsize: usize,
        jobdata: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    #[doc = " @brief Set the threading backend for parallel compression/decompression to use @p callback to execute work\n instead of using the Blosc-managed threads.  The @p callback_data argument is passed through to the callback.\n\n @param callback: the callback to use. Passing `NULL` uses the default Blosc threading backend.\n @param callback_data: the callback data.\n\n @warning This function is *not* thread-safe and should be called\n before any other Blosc function: it affects all Blosc contexts.\n @sa https://github.com/Blosc/c-blosc2/pull/81"]
    pub fn blosc2_set_threads_callback(
        callback: blosc_threads_callback,
        callback_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " @brief Returns the current number of threads that are used for\n compression/decompression."]
    pub fn blosc2_get_nthreads() -> i16;
}
extern "C" {
    #[doc = " @brief Initialize a pool of threads for compression/decompression. If\n @p nthreads is 1, then the serial version is chosen and a possible\n previous existing pool is ended. If this is not called, @p nthreads\n is set to 1 internally.\n\n @param nthreads The number of threads to use.\n\n @return The previous number of threads."]
    pub fn blosc2_set_nthreads(nthreads: i16) -> i16;
}
extern "C" {
    #[doc = " @brief Get the current compressor that is used for compression.\n\n @return The string identifying the compressor being used."]
    pub fn blosc1_get_compressor() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Select the compressor to be used. The supported ones are \"blosclz\",\n \"lz4\", \"lz4hc\", \"zlib\" and \"ztsd\". If this function is not\n called, then \"blosclz\" will be used.\n\n @param compname The name identifier of the compressor to be set.\n\n @return The code for the compressor (>=0). In case the compressor\n is not recognized, or there is not support for it in this build,\n it returns a -1."]
    pub fn blosc1_set_compressor(compname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Select the delta coding filter to be used.\n\n @param dodelta A value >0 will activate the delta filter.\n If 0, it will be de-activated\n\n This call should always succeed."]
    pub fn blosc2_set_delta(dodelta: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " @brief Get the compressor name associated with the compressor code.\n\n @param compcode The code identifying the compressor\n @param compname The pointer to a string where the compressor name will be put.\n\n @return The compressor code. If the compressor code is not recognized,\n or there is not support for it in this build, -1 is returned."]
    pub fn blosc2_compcode_to_compname(
        compcode: ::std::os::raw::c_int,
        compname: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get the compressor code associated with the compressor name.\n\n @param compname The string containing the compressor name.\n\n @return The compressor code. If the compressor name is not recognized,\n or there is not support for it in this build, -1 is returned instead."]
    pub fn blosc2_compname_to_compcode(
        compname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get a list of compressors supported in the current build.\n\n @return The comma separated string with the list of compressor names\n supported.\n\n This function does not leak, so you should not free() the returned\n list.\n\n This function should always succeed."]
    pub fn blosc2_list_compressors() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Get the version of Blosc in string format.\n\n @return The string with the current Blosc version.\n Useful for dynamic libraries."]
    pub fn blosc2_get_version_string() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " @brief Get info from compression libraries included in the current build.\n\n @param compname The compressor name that you want info from.\n @param complib The pointer to a string where the\n compression library name, if available, will be put.\n @param version The pointer to a string where the\n compression library version, if available, will be put.\n\n @warning You are in charge of the @p complib and @p version strings,\n you should free() them so as to avoid leaks.\n\n @return The code for the compression library (>=0). If it is not supported,\n this function returns -1."]
    pub fn blosc2_get_complib_info(
        compname: *const ::std::os::raw::c_char,
        complib: *mut *mut ::std::os::raw::c_char,
        version: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Free possible memory temporaries and thread resources. Use this\n when you are not going to use Blosc for a long while.\n\n @return A 0 if succeeds, in case of problems releasing the resources,\n it returns a negative number."]
    pub fn blosc2_free_resources() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get information about a compressed buffer, namely the number of\n uncompressed bytes (@p nbytes) and compressed (@p cbytes). It also\n returns the @p blocksize (which is used internally for doing the\n compression by blocks).\n\n @remark Equivalent to function #blosc2_cbuffer_sizes.\n\n @param cbuffer The buffer of compressed data.\n @param nbytes The pointer where the number of uncompressed bytes will be put.\n @param cbytes The pointer where the number of compressed bytes will be put.\n @param blocksize The pointer where the block size will be put.\n\n You only need to pass the first BLOSC_MIN_HEADER_LENGTH bytes of a\n compressed buffer for this call to work.\n\n This function should always succeed."]
    pub fn blosc1_cbuffer_sizes(
        cbuffer: *const ::std::os::raw::c_void,
        nbytes: *mut usize,
        cbytes: *mut usize,
        blocksize: *mut usize,
    );
}
extern "C" {
    #[doc = " @brief Get information about a compressed buffer, namely the number of\n uncompressed bytes (@p nbytes) and compressed (@p cbytes). It also\n returns the @p blocksize (which is used internally for doing the\n compression by blocks).\n\n @param cbuffer The buffer of compressed data.\n @param nbytes The pointer where the number of uncompressed bytes will be put.\n @param cbytes The pointer where the number of compressed bytes will be put.\n @param blocksize The pointer where the block size will be put.\n\n @note: if any of the nbytes, cbytes or blocksize is NULL, it will not be returned.\n\n You only need to pass the first BLOSC_MIN_HEADER_LENGTH bytes of a\n compressed buffer for this call to work.\n\n @return On failure, returns negative value."]
    pub fn blosc2_cbuffer_sizes(
        cbuffer: *const ::std::os::raw::c_void,
        nbytes: *mut i32,
        cbytes: *mut i32,
        blocksize: *mut i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Checks that the compressed buffer starting at @p cbuffer of length @p cbytes\n may contain valid blosc compressed data, and that it is safe to call\n blosc1_decompress/blosc1_getitem.\n On success, returns 0 and sets @p nbytes to the size of the uncompressed data.\n This does not guarantee that the decompression function won't return an error,\n but does guarantee that it is safe to attempt decompression.\n\n @param cbuffer The buffer of compressed data.\n @param cbytes The number of compressed bytes.\n @param nbytes The pointer where the number of uncompressed bytes will be put.\n\n @return On failure, returns negative value."]
    pub fn blosc1_cbuffer_validate(
        cbuffer: *const ::std::os::raw::c_void,
        cbytes: usize,
        nbytes: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get information about a compressed buffer, namely the type size\n (@p typesize), as well as some internal @p flags.\n\n @param cbuffer The buffer of compressed data.\n @param typesize The pointer where the type size will be put.\n @param flags The pointer of the integer where the additional info is encoded.\n The @p flags is a set of bits, where the currently used ones are:\n   * bit 0: whether the shuffle filter has been applied or not\n   * bit 1: whether the internal buffer is a pure memcpy or not\n   * bit 2: whether the bitshuffle filter has been applied or not\n   * bit 3: whether the delta coding filter has been applied or not\n\n You can use the @p BLOSC_DOSHUFFLE, @p BLOSC_DOBITSHUFFLE, @p BLOSC_DODELTA\n and @p BLOSC_MEMCPYED symbols for extracting the interesting bits\n (e.g. @p flags & @p BLOSC_DOSHUFFLE says whether the buffer is byte-shuffled\n or not).\n\n This function should always succeed."]
    pub fn blosc1_cbuffer_metainfo(
        cbuffer: *const ::std::os::raw::c_void,
        typesize: *mut usize,
        flags: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @brief Get information about a compressed buffer, namely the internal\n Blosc format version (@p version) and the format for the internal\n Lempel-Ziv compressor used (@p versionlz).\n\n @param cbuffer The buffer of compressed data.\n @param version The pointer where the Blosc format version will be put.\n @param versionlz The pointer where the Lempel-Ziv version will be put.\n\n This function should always succeed."]
    pub fn blosc2_cbuffer_versions(
        cbuffer: *const ::std::os::raw::c_void,
        version: *mut ::std::os::raw::c_int,
        versionlz: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @brief Get the compressor library/format used in a compressed buffer.\n\n @param cbuffer The buffer of compressed data.\n\n @return The string identifying the compressor library/format used.\n\n This function should always succeed."]
    pub fn blosc2_cbuffer_complib(
        cbuffer: *const ::std::os::raw::c_void,
    ) -> *const ::std::os::raw::c_char;
}
pub const BLOSC2_IO_FILESYSTEM: _bindgen_ty_23 = 0;
pub const BLOSC2_IO_FILESYSTEM_MMAP: _bindgen_ty_23 = 1;
pub const BLOSC_IO_LAST_BLOSC_DEFINED: _bindgen_ty_23 = 2;
pub const BLOSC_IO_LAST_REGISTERED: _bindgen_ty_23 = 32;
#[doc = "Structures and functions related with user-defined input/output."]
pub type _bindgen_ty_23 = ::std::os::raw::c_uint;
pub const BLOSC2_IO_BLOSC_DEFINED: _bindgen_ty_24 = 32;
pub const BLOSC2_IO_REGISTERED: _bindgen_ty_24 = 160;
pub const BLOSC2_IO_USER_DEFINED: _bindgen_ty_24 = 256;
pub type _bindgen_ty_24 = ::std::os::raw::c_uint;
pub type blosc2_open_cb = ::std::option::Option<
    unsafe extern "C" fn(
        urlpath: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        params: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type blosc2_close_cb = ::std::option::Option<
    unsafe extern "C" fn(stream: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
pub type blosc2_size_cb =
    ::std::option::Option<unsafe extern "C" fn(stream: *mut ::std::os::raw::c_void) -> i64>;
pub type blosc2_write_cb = ::std::option::Option<
    unsafe extern "C" fn(
        ptr: *const ::std::os::raw::c_void,
        size: i64,
        nitems: i64,
        position: i64,
        stream: *mut ::std::os::raw::c_void,
    ) -> i64,
>;
pub type blosc2_read_cb = ::std::option::Option<
    unsafe extern "C" fn(
        ptr: *mut *mut ::std::os::raw::c_void,
        size: i64,
        nitems: i64,
        position: i64,
        stream: *mut ::std::os::raw::c_void,
    ) -> i64,
>;
pub type blosc2_truncate_cb = ::std::option::Option<
    unsafe extern "C" fn(stream: *mut ::std::os::raw::c_void, size: i64) -> ::std::os::raw::c_int,
>;
pub type blosc2_destroy_cb = ::std::option::Option<
    unsafe extern "C" fn(params: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_io_cb {
    pub id: u8,
    pub name: *mut ::std::os::raw::c_char,
    pub is_allocation_necessary: bool,
    pub open: blosc2_open_cb,
    pub close: blosc2_close_cb,
    pub size: blosc2_size_cb,
    pub write: blosc2_write_cb,
    pub read: blosc2_read_cb,
    pub truncate: blosc2_truncate_cb,
    pub destroy: blosc2_destroy_cb,
}
#[test]
fn bindgen_test_layout_blosc2_io_cb() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_io_cb> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_io_cb>(),
        80usize,
        concat!("Size of: ", stringify!(blosc2_io_cb))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_io_cb>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_io_cb))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_allocation_necessary) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(is_allocation_necessary)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).open) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(open)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).close) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(write)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).truncate) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(truncate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).destroy) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io_cb),
            "::",
            stringify!(destroy)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_io {
    pub id: u8,
    pub name: *const ::std::os::raw::c_char,
    pub params: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_blosc2_io() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_io> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_io>(),
        24usize,
        concat!("Size of: ", stringify!(blosc2_io))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_io>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_io))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_io),
            "::",
            stringify!(params)
        )
    );
}
extern "C" {
    pub static BLOSC2_IO_DEFAULTS: blosc2_io;
}
extern "C" {
    #[doc = " @brief Register a user-defined input/output callbacks in Blosc.\n\n @param io The callbacks API to register.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_register_io_cb(io: *const blosc2_io_cb) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get a user-defined input/output callback in Blosc.\n\n @param id The id of the callback to get.\n\n @return A pointer containing the desired callback if success. Else a NULL pointer is returned."]
    pub fn blosc2_get_io_cb(id: u8) -> *mut blosc2_io_cb;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_context_s {
    _unused: [u8; 0],
}
#[doc = "Structures and functions related with contexts."]
pub type blosc2_context = blosc2_context_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_tuner {
    pub init: ::std::option::Option<
        unsafe extern "C" fn(
            config: *mut ::std::os::raw::c_void,
            cctx: *mut blosc2_context,
            dctx: *mut blosc2_context,
        ) -> ::std::os::raw::c_int,
    >,
    pub next_blocksize: ::std::option::Option<
        unsafe extern "C" fn(context: *mut blosc2_context) -> ::std::os::raw::c_int,
    >,
    pub next_cparams: ::std::option::Option<
        unsafe extern "C" fn(context: *mut blosc2_context) -> ::std::os::raw::c_int,
    >,
    pub update: ::std::option::Option<
        unsafe extern "C" fn(context: *mut blosc2_context, ctime: f64) -> ::std::os::raw::c_int,
    >,
    pub free: ::std::option::Option<
        unsafe extern "C" fn(context: *mut blosc2_context) -> ::std::os::raw::c_int,
    >,
    pub id: ::std::os::raw::c_int,
    pub name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_blosc2_tuner() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_tuner> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_tuner>(),
        56usize,
        concat!("Size of: ", stringify!(blosc2_tuner))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_tuner>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_tuner))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_blocksize) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(next_blocksize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_cparams) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(next_cparams)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).update) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(update)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(free)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_tuner),
            "::",
            stringify!(name)
        )
    );
}
extern "C" {
    #[doc = " @brief Register locally a user-defined tuner in Blosc.\n\n @param tuner The tuner to register.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_register_tuner(tuner: *mut blosc2_tuner) -> ::std::os::raw::c_int;
}
#[doc = " @brief The parameters for a prefilter function.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_prefilter_params {
    pub user_data: *mut ::std::os::raw::c_void,
    pub input: *const u8,
    pub output: *mut u8,
    pub output_size: i32,
    pub output_typesize: i32,
    pub output_offset: i32,
    pub nchunk: i64,
    pub nblock: i32,
    pub tid: i32,
    pub ttmp: *mut u8,
    pub ttmp_nbytes: usize,
    pub ctx: *mut blosc2_context,
}
#[test]
fn bindgen_test_layout_blosc2_prefilter_params() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_prefilter_params> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_prefilter_params>(),
        80usize,
        concat!("Size of: ", stringify!(blosc2_prefilter_params))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_prefilter_params>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_prefilter_params))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user_data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(user_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).input) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(output)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output_size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(output_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output_typesize) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(output_typesize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output_offset) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(output_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nchunk) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(nchunk)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nblock) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(nblock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tid) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ttmp) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(ttmp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ttmp_nbytes) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(ttmp_nbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ctx) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_prefilter_params),
            "::",
            stringify!(ctx)
        )
    );
}
#[doc = " @brief The parameters for a postfilter function.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_postfilter_params {
    pub user_data: *mut ::std::os::raw::c_void,
    pub input: *const u8,
    pub output: *mut u8,
    pub size: i32,
    pub typesize: i32,
    pub offset: i32,
    pub nchunk: i64,
    pub nblock: i32,
    pub tid: i32,
    pub ttmp: *mut u8,
    pub ttmp_nbytes: usize,
    pub ctx: *mut blosc2_context,
}
#[test]
fn bindgen_test_layout_blosc2_postfilter_params() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_postfilter_params> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_postfilter_params>(),
        80usize,
        concat!("Size of: ", stringify!(blosc2_postfilter_params))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_postfilter_params>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_postfilter_params))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user_data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(user_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).input) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(input)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).output) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(output)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).typesize) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(typesize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nchunk) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(nchunk)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nblock) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(nblock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tid) as usize - ptr as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(tid)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ttmp) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(ttmp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ttmp_nbytes) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(ttmp_nbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ctx) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_postfilter_params),
            "::",
            stringify!(ctx)
        )
    );
}
#[doc = " @brief The type of the prefilter function.\n\n If the function call is successful, the return value should be 0; else, a negative value."]
pub type blosc2_prefilter_fn = ::std::option::Option<
    unsafe extern "C" fn(params: *mut blosc2_prefilter_params) -> ::std::os::raw::c_int,
>;
#[doc = " @brief The type of the postfilter function.\n\n If the function call is successful, the return value should be 0; else, a negative value."]
pub type blosc2_postfilter_fn = ::std::option::Option<
    unsafe extern "C" fn(params: *mut blosc2_postfilter_params) -> ::std::os::raw::c_int,
>;
#[doc = " @brief The parameters for creating a context for compression purposes.\n\n In parenthesis it is shown the default value used internally when a 0\n (zero) in the fields of the struct is passed to a function."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_cparams {
    pub compcode: u8,
    pub compcode_meta: u8,
    pub clevel: u8,
    pub use_dict: ::std::os::raw::c_int,
    pub typesize: i32,
    pub nthreads: i16,
    pub blocksize: i32,
    pub splitmode: i32,
    pub schunk: *mut ::std::os::raw::c_void,
    pub filters: [u8; 6usize],
    pub filters_meta: [u8; 6usize],
    pub prefilter: blosc2_prefilter_fn,
    pub preparams: *mut blosc2_prefilter_params,
    pub tuner_params: *mut ::std::os::raw::c_void,
    pub tuner_id: ::std::os::raw::c_int,
    pub instr_codec: bool,
    pub codec_params: *mut ::std::os::raw::c_void,
    pub filter_params: [*mut ::std::os::raw::c_void; 6usize],
}
#[test]
fn bindgen_test_layout_blosc2_cparams() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_cparams> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_cparams>(),
        136usize,
        concat!("Size of: ", stringify!(blosc2_cparams))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_cparams>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_cparams))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compcode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(compcode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compcode_meta) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(compcode_meta)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clevel) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(clevel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).use_dict) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(use_dict)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).typesize) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(typesize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nthreads) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(nthreads)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blocksize) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(blocksize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).splitmode) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(splitmode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).schunk) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(schunk)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filters) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(filters)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filters_meta) as usize - ptr as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(filters_meta)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prefilter) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(prefilter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).preparams) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(preparams)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tuner_params) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(tuner_params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tuner_id) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(tuner_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).instr_codec) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(instr_codec)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).codec_params) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(codec_params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filter_params) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_cparams),
            "::",
            stringify!(filter_params)
        )
    );
}
#[doc = "@brief The parameters for creating a context for decompression purposes.\n\nIn parenthesis it is shown the default value used internally when a 0\n(zero) in the fields of the struct is passed to a function."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_dparams {
    pub nthreads: i16,
    pub schunk: *mut ::std::os::raw::c_void,
    pub postfilter: blosc2_postfilter_fn,
    pub postparams: *mut blosc2_postfilter_params,
}
#[test]
fn bindgen_test_layout_blosc2_dparams() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_dparams> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_dparams>(),
        32usize,
        concat!("Size of: ", stringify!(blosc2_dparams))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_dparams>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_dparams))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nthreads) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_dparams),
            "::",
            stringify!(nthreads)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).schunk) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_dparams),
            "::",
            stringify!(schunk)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).postfilter) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_dparams),
            "::",
            stringify!(postfilter)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).postparams) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_dparams),
            "::",
            stringify!(postparams)
        )
    );
}
extern "C" {
    #[doc = " @brief Create a context for @a *_ctx() compression functions.\n\n @param cparams The blosc2_cparams struct with the compression parameters.\n\n @return A pointer to the new context. NULL is returned if this fails.\n\n @note This supports the same environment variables than #blosc2_compress\n for overriding the programmatic compression values.\n\n @sa #blosc2_compress"]
    pub fn blosc2_create_cctx(cparams: blosc2_cparams) -> *mut blosc2_context;
}
extern "C" {
    #[doc = " @brief Create a context for *_ctx() decompression functions.\n\n @param dparams The blosc2_dparams struct with the decompression parameters.\n\n @return A pointer to the new context. NULL is returned if this fails.\n\n @note This supports the same environment variables than #blosc2_decompress\n for overriding the programmatic decompression values.\n\n @sa #blosc2_decompress\n"]
    pub fn blosc2_create_dctx(dparams: blosc2_dparams) -> *mut blosc2_context;
}
extern "C" {
    #[doc = " @brief Free the resources associated with a context.\n\n @param context The context to free.\n\n This function should always succeed and is valid for contexts meant for\n both compression and decompression."]
    pub fn blosc2_free_ctx(context: *mut blosc2_context);
}
extern "C" {
    #[doc = " @brief Create a @p cparams associated to a context.\n\n @param ctx The context from where to extract the compression parameters.\n @param cparams The pointer where the compression params will be stored.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_ctx_get_cparams(
        ctx: *mut blosc2_context,
        cparams: *mut blosc2_cparams,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Create a @p dparams associated to a context.\n\n @param ctx The context from where to extract the decompression parameters.\n @param dparams The pointer where the decompression params will be stored.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_ctx_get_dparams(
        ctx: *mut blosc2_context,
        dparams: *mut blosc2_dparams,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Set a maskout so as to avoid decompressing specified blocks.\n\n @param ctx The decompression context to update.\n\n @param maskout The boolean mask for the blocks where decompression\n is to be avoided.\n\n @remark The maskout is valid for contexts *only* meant for decompressing\n a chunk via #blosc2_decompress_ctx.  Once a call to #blosc2_decompress_ctx\n is done, this mask is reset so that next call to #blosc2_decompress_ctx\n will decompress the whole chunk.\n\n @param nblocks The number of blocks in maskout above.\n\n @return If success, a 0 is returned.  An error is signaled with a negative int.\n"]
    pub fn blosc2_set_maskout(
        ctx: *mut blosc2_context,
        maskout: *mut bool,
        nblocks: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_compress(
        clevel: ::std::os::raw::c_int,
        doshuffle: ::std::os::raw::c_int,
        typesize: i32,
        src: *const ::std::os::raw::c_void,
        srcsize: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Decompress a block of compressed data in @p src, put the result in\n @p dest and returns the size of the decompressed block.\n\n @warning The @p src buffer and the @p dest buffer can not overlap.\n\n @remark Decompression is memory safe and guaranteed not to write the @p dest\n buffer more than what is specified in @p destsize.\n\n @remark In case you want to keep under control the number of bytes read from\n source, you can call #blosc1_cbuffer_sizes first to check whether the\n @p nbytes (i.e. the number of bytes to be read from @p src buffer by this\n function) in the compressed buffer is ok with you.\n\n @param src The buffer to be decompressed.\n @param srcsize The size of the buffer to be decompressed.\n @param dest The buffer where the decompressed data will be put.\n @param destsize The size of the @p dest buffer.\n\n @return The number of bytes decompressed.\n If an error occurs, e.g. the compressed data is corrupted or the\n output buffer is not large enough, then a negative value\n will be returned instead."]
    pub fn blosc2_decompress(
        src: *const ::std::os::raw::c_void,
        srcsize: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Context interface to Blosc compression. This does not require a call\n to #blosc2_init and can be called from multithreaded applications\n without the global lock being used, so allowing Blosc be executed\n simultaneously in those scenarios.\n\n @param context A blosc2_context struct with the different compression params.\n @param src The buffer containing the data to be compressed.\n @param srcsize The number of bytes to be compressed from the @p src buffer.\n @param dest The buffer where the compressed data will be put.\n @param destsize The size in bytes of the @p dest buffer.\n\n @return The number of bytes compressed.\n If @p src buffer cannot be compressed into @p destsize, the return\n value is zero and you should discard the contents of the @p dest\n buffer.  A negative return value means that an internal error happened.\n It could happen that context is not meant for compression (which is stated in stderr).\n Otherwise, please report it back together with the buffer data causing this\n and compression settings."]
    pub fn blosc2_compress_ctx(
        context: *mut blosc2_context,
        src: *const ::std::os::raw::c_void,
        srcsize: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Context interface to Blosc decompression. This does not require a\n call to #blosc2_init and can be called from multithreaded\n applications without the global lock being used, so allowing Blosc\n be executed simultaneously in those scenarios.\n\n @param context The blosc2_context struct with the different compression params.\n @param src The buffer of compressed data.\n @param srcsize The length of buffer of compressed data.\n @param dest The buffer where the decompressed data will be put.\n @param destsize The size in bytes of the @p dest buffer.\n\n @warning The @p src buffer and the @p dest buffer can not overlap.\n\n @remark Decompression is memory safe and guaranteed not to write the @p dest\n buffer more than what is specified in @p destsize.\n\n @remark In case you want to keep under control the number of bytes read from\n source, you can call #blosc1_cbuffer_sizes first to check the @p nbytes\n (i.e. the number of bytes to be read from @p src buffer by this function)\n in the compressed buffer.\n\n @remark If #blosc2_set_maskout is called prior to this function, its\n @p block_maskout parameter will be honored for just *one single* shot;\n i.e. the maskout in context will be automatically reset to NULL, so\n mask won't be used next time (unless #blosc2_set_maskout is called again).\n\n @return The number of bytes decompressed (i.e. the maskout blocks are not\n counted). If an error occurs, e.g. the compressed data is corrupted,\n @p destsize is not large enough or context is not meant for decompression,\n then a negative value will be returned instead."]
    pub fn blosc2_decompress_ctx(
        context: *mut blosc2_context,
        src: *const ::std::os::raw::c_void,
        srcsize: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Create a chunk made of zeros.\n\n @param cparams The compression parameters.\n @param nbytes The size (in bytes) of the chunk.\n @param dest The buffer where the data chunk will be put.\n @param destsize The size (in bytes) of the @p dest buffer;\n must be BLOSC_EXTENDED_HEADER_LENGTH at least.\n\n @return The number of bytes compressed (BLOSC_EXTENDED_HEADER_LENGTH).\n If negative, there has been an error and @p dest is unusable."]
    pub fn blosc2_chunk_zeros(
        cparams: blosc2_cparams,
        nbytes: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Create a chunk made of nans.\n\n @param cparams The compression parameters;\n only 4 bytes (float) and 8 bytes (double) are supported.\n @param nbytes The size (in bytes) of the chunk.\n @param dest The buffer where the data chunk will be put.\n @param destsize The size (in bytes) of the @p dest buffer;\n must be BLOSC_EXTENDED_HEADER_LENGTH at least.\n\n @note Whether the NaNs are floats or doubles will be given by the typesize.\n\n @return The number of bytes compressed (BLOSC_EXTENDED_HEADER_LENGTH).\n If negative, there has been an error and @p dest is unusable."]
    pub fn blosc2_chunk_nans(
        cparams: blosc2_cparams,
        nbytes: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Create a chunk made of repeated values.\n\n @param cparams The compression parameters.\n @param nbytes The size (in bytes) of the chunk.\n @param dest The buffer where the data chunk will be put.\n @param destsize The size (in bytes) of the @p dest buffer.\n @param repeatval A pointer to the repeated value (little endian).\n The size of the value is given by @p cparams.typesize param.\n\n @return The number of bytes compressed (BLOSC_EXTENDED_HEADER_LENGTH + typesize).\n If negative, there has been an error and @p dest is unusable."]
    pub fn blosc2_chunk_repeatval(
        cparams: blosc2_cparams,
        nbytes: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
        repeatval: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Create a chunk made of uninitialized values.\n\n @param cparams The compression parameters.\n @param nbytes The size (in bytes) of the chunk.\n @param dest The buffer where the data chunk will be put.\n @param destsize The size (in bytes) of the @p dest buffer;\n must be BLOSC_EXTENDED_HEADER_LENGTH at least.\n\n @return The number of bytes compressed (BLOSC_EXTENDED_HEADER_LENGTH).\n If negative, there has been an error and @p dest is unusable."]
    pub fn blosc2_chunk_uninit(
        cparams: blosc2_cparams,
        nbytes: i32,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Context interface counterpart for #blosc1_getitem.\n\n @param context Context pointer.\n @param src The compressed buffer from data will be decompressed.\n @param srcsize Compressed buffer length.\n @param start The position of the first item (of @p typesize size) from where data\n will be retrieved.\n @param nitems The number of items (of @p typesize size) that will be retrieved.\n @param dest The buffer where the decompressed data retrieved will be put.\n @param destsize Output buffer length.\n\n @return The number of bytes copied to @p dest or a negative value if\n some error happens."]
    pub fn blosc2_getitem_ctx(
        context: *mut blosc2_context,
        src: *const ::std::os::raw::c_void,
        srcsize: i32,
        start: ::std::os::raw::c_int,
        nitems: ::std::os::raw::c_int,
        dest: *mut ::std::os::raw::c_void,
        destsize: i32,
    ) -> ::std::os::raw::c_int;
}
#[doc = " @brief This struct is meant for holding storage parameters for a\n for a blosc2 container, allowing to specify, for example, how to interpret\n the contents included in the schunk."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_storage {
    pub contiguous: bool,
    pub urlpath: *mut ::std::os::raw::c_char,
    pub cparams: *mut blosc2_cparams,
    pub dparams: *mut blosc2_dparams,
    pub io: *mut blosc2_io,
}
#[test]
fn bindgen_test_layout_blosc2_storage() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_storage> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_storage>(),
        40usize,
        concat!("Size of: ", stringify!(blosc2_storage))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_storage>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_storage))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).contiguous) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_storage),
            "::",
            stringify!(contiguous)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).urlpath) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_storage),
            "::",
            stringify!(urlpath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cparams) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_storage),
            "::",
            stringify!(cparams)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dparams) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_storage),
            "::",
            stringify!(dparams)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).io) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_storage),
            "::",
            stringify!(io)
        )
    );
}
extern "C" {
    #[doc = " @brief Default struct for #blosc2_storage meant for user initialization."]
    pub static BLOSC2_STORAGE_DEFAULTS: blosc2_storage;
}
extern "C" {
    #[doc = " @brief Get default struct for compression params meant for user initialization."]
    pub fn blosc2_get_blosc2_cparams_defaults() -> blosc2_cparams;
}
extern "C" {
    #[doc = " @brief Get default struct for decompression params meant for user initialization."]
    pub fn blosc2_get_blosc2_dparams_defaults() -> blosc2_dparams;
}
extern "C" {
    #[doc = " @brief Get default struct for #blosc2_storage meant for user initialization."]
    pub fn blosc2_get_blosc2_storage_defaults() -> blosc2_storage;
}
extern "C" {
    #[doc = " @brief Get default struct for #blosc2_io meant for user initialization."]
    pub fn blosc2_get_blosc2_io_defaults() -> blosc2_io;
}
extern "C" {
    #[doc = " @brief Get default struct for #blosc2_stdio_mmap meant for user initialization."]
    pub fn blosc2_get_blosc2_stdio_mmap_defaults() -> blosc2_stdio_mmap;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_frame_s {
    _unused: [u8; 0],
}
pub type blosc2_frame = blosc2_frame_s;
#[doc = " @brief This struct is meant to store metadata information inside\n a #blosc2_schunk, allowing to specify, for example, how to interpret\n the contents included in the schunk."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_metalayer {
    #[doc = "!< The metalayer identifier for Blosc client (e.g. Blosc2 NDim)."]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = "!< The serialized (msgpack preferably) content of the metalayer."]
    pub content: *mut u8,
    #[doc = "!< The length in bytes of the content."]
    pub content_len: i32,
}
#[test]
fn bindgen_test_layout_blosc2_metalayer() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_metalayer> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_metalayer>(),
        24usize,
        concat!("Size of: ", stringify!(blosc2_metalayer))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_metalayer>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_metalayer))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_metalayer),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).content) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_metalayer),
            "::",
            stringify!(content)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).content_len) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_metalayer),
            "::",
            stringify!(content_len)
        )
    );
}
#[doc = " @brief This struct is the standard container for Blosc 2 compressed data.\n\n This is essentially a container for Blosc 1 chunks of compressed data,\n and it allows to overcome the 32-bit limitation in Blosc 1. Optionally,\n a #blosc2_frame can be attached so as to store the compressed chunks contiguously."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_schunk {
    pub version: u8,
    pub compcode: u8,
    pub compcode_meta: u8,
    pub clevel: u8,
    pub splitmode: u8,
    pub typesize: i32,
    pub blocksize: i32,
    pub chunksize: i32,
    pub filters: [u8; 6usize],
    pub filters_meta: [u8; 6usize],
    pub nchunks: i64,
    pub current_nchunk: i64,
    pub nbytes: i64,
    pub cbytes: i64,
    pub data: *mut *mut u8,
    pub data_len: usize,
    pub storage: *mut blosc2_storage,
    pub frame: *mut blosc2_frame,
    pub cctx: *mut blosc2_context,
    pub dctx: *mut blosc2_context,
    pub metalayers: [*mut blosc2_metalayer; 16usize],
    pub nmetalayers: u16,
    pub vlmetalayers: [*mut blosc2_metalayer; 8192usize],
    pub nvlmetalayers: i16,
    pub tuner_params: *mut ::std::os::raw::c_void,
    pub tuner_id: ::std::os::raw::c_int,
    pub ndim: i8,
    pub blockshape: *mut i64,
}
#[test]
fn bindgen_test_layout_blosc2_schunk() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_schunk> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_schunk>(),
        65816usize,
        concat!("Size of: ", stringify!(blosc2_schunk))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_schunk>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_schunk))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compcode) as usize - ptr as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(compcode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compcode_meta) as usize - ptr as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(compcode_meta)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clevel) as usize - ptr as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(clevel)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).splitmode) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(splitmode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).typesize) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(typesize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blocksize) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(blocksize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).chunksize) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(chunksize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filters) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(filters)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).filters_meta) as usize - ptr as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(filters_meta)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nchunks) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(nchunks)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).current_nchunk) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(current_nchunk)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nbytes) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(nbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cbytes) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(cbytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_len) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(data_len)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).storage) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(storage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).frame) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(frame)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cctx) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(cctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dctx) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(dctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).metalayers) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(metalayers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nmetalayers) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(nmetalayers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vlmetalayers) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(vlmetalayers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nvlmetalayers) as usize - ptr as usize },
        65784usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(nvlmetalayers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tuner_params) as usize - ptr as usize },
        65792usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(tuner_params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tuner_id) as usize - ptr as usize },
        65800usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(tuner_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ndim) as usize - ptr as usize },
        65804usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(ndim)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).blockshape) as usize - ptr as usize },
        65808usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_schunk),
            "::",
            stringify!(blockshape)
        )
    );
}
extern "C" {
    #[doc = " @brief Create a new super-chunk.\n\n @param storage The storage properties.\n\n @remark In case that storage.urlpath is not NULL, the data is stored\n on-disk.  If the data file(s) exist, they are *overwritten*.\n\n @return The new super-chunk."]
    pub fn blosc2_schunk_new(storage: *mut blosc2_storage) -> *mut blosc2_schunk;
}
extern "C" {
    #[doc = " Create a copy of a super-chunk.\n\n @param schunk The super-chunk to be copied.\n @param storage The storage properties.\n\n @return The new super-chunk."]
    pub fn blosc2_schunk_copy(
        schunk: *mut blosc2_schunk,
        storage: *mut blosc2_storage,
    ) -> *mut blosc2_schunk;
}
extern "C" {
    #[doc = " @brief Create a super-chunk out of a contiguous frame buffer.\n\n @param cframe The buffer of the in-memory frame.\n @param copy Whether the super-chunk should make a copy of\n the @p cframe data or not.  The copy will be made to an internal\n sparse frame.\n\n @remark If copy is false, the @p cframe buffer passed will be owned\n by the super-chunk and will be automatically freed when\n blosc2_schunk_free() is called.  If the user frees it after the\n opening, bad things will happen.  Don't do that (or set @p copy).\n\n @param len The length of the buffer (in bytes).\n\n @return The new super-chunk."]
    pub fn blosc2_schunk_from_buffer(cframe: *mut u8, len: i64, copy: bool) -> *mut blosc2_schunk;
}
extern "C" {
    #[doc = " @brief Set the private `avoid_cframe_free` field in a frame.\n\n @param schunk The super-chunk referencing the frame.\n @param avoid_cframe_free The value to set in the blosc2_frame_s structure.\n\n @warning If you set it to `true` you will be responsible of freeing it."]
    pub fn blosc2_schunk_avoid_cframe_free(schunk: *mut blosc2_schunk, avoid_cframe_free: bool);
}
extern "C" {
    #[doc = " @brief Open an existing super-chunk that is on-disk (frame). No in-memory copy is made.\n\n @param urlpath The file name.\n\n @return The new super-chunk.  NULL if not found or not in frame format."]
    pub fn blosc2_schunk_open(urlpath: *const ::std::os::raw::c_char) -> *mut blosc2_schunk;
}
extern "C" {
    #[doc = " @brief Open an existing super-chunk that is on-disk (frame). No in-memory copy is made.\n\n @param urlpath The file name.\n\n @param offset The frame offset.\n\n @return The new super-chunk.  NULL if not found or not in frame format."]
    pub fn blosc2_schunk_open_offset(
        urlpath: *const ::std::os::raw::c_char,
        offset: i64,
    ) -> *mut blosc2_schunk;
}
extern "C" {
    #[doc = " @brief Open an existing super-chunk (no copy is made) using a user-defined I/O interface.\n\n @param urlpath The file name.\n\n @param udio The user-defined I/O interface.\n\n @return The new super-chunk."]
    pub fn blosc2_schunk_open_udio(
        urlpath: *const ::std::os::raw::c_char,
        udio: *const blosc2_io,
    ) -> *mut blosc2_schunk;
}
extern "C" {
    #[doc = " @brief Open an existing super-chunk (no copy is made) using a user-defined I/O interface.\n\n @param urlpath The file name.\n\n @param offset The frame offset.\n\n @param udio The user-defined I/O interface.\n\n @return The new super-chunk."]
    pub fn blosc2_schunk_open_offset_udio(
        urlpath: *const ::std::os::raw::c_char,
        offset: i64,
        udio: *const blosc2_io,
    ) -> *mut blosc2_schunk;
}
extern "C" {
    pub fn blosc2_schunk_to_buffer(
        schunk: *mut blosc2_schunk,
        cframe: *mut *mut u8,
        needs_free: *mut bool,
    ) -> i64;
}
extern "C" {
    pub fn blosc2_schunk_to_file(
        schunk: *mut blosc2_schunk,
        urlpath: *const ::std::os::raw::c_char,
    ) -> i64;
}
extern "C" {
    pub fn blosc2_schunk_append_file(
        schunk: *mut blosc2_schunk,
        urlpath: *const ::std::os::raw::c_char,
    ) -> i64;
}
extern "C" {
    #[doc = " @brief Release resources from a super-chunk.\n\n @param schunk The super-chunk to be freed.\n\n @remark All the memory resources attached to the super-chunk are freed.\n If the super-chunk is on-disk, the data continues there for a later\n re-opening.\n\n @return 0 if success."]
    pub fn blosc2_schunk_free(schunk: *mut blosc2_schunk) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Append an existing @p chunk to a super-chunk.\n\n @param schunk The super-chunk where the chunk will be appended.\n @param chunk The @p chunk to append.  An internal copy is made, so @p chunk can be reused or\n freed if desired.\n @param copy Whether the chunk should be copied internally or can be used as-is.\n\n @return The number of chunks in super-chunk. If some problem is\n detected, this number will be negative."]
    pub fn blosc2_schunk_append_chunk(
        schunk: *mut blosc2_schunk,
        chunk: *mut u8,
        copy: bool,
    ) -> i64;
}
extern "C" {
    #[doc = " @brief Update a chunk at a specific position in a super-chunk.\n\n @param schunk The super-chunk where the chunk will be updated.\n @param nchunk The position where the chunk will be updated.\n @param chunk The new @p chunk. If an internal copy is made, the @p chunk can be reused or\n freed if desired.\n @param copy Whether the chunk should be copied internally or can be used as-is.\n\n @return The number of chunks in super-chunk. If some problem is\n detected, this number will be negative."]
    pub fn blosc2_schunk_update_chunk(
        schunk: *mut blosc2_schunk,
        nchunk: i64,
        chunk: *mut u8,
        copy: bool,
    ) -> i64;
}
extern "C" {
    #[doc = " @brief Insert a chunk at a specific position in a super-chunk.\n\n @param schunk The super-chunk where the chunk will be appended.\n @param nchunk The position where the chunk will be inserted.\n @param chunk The @p chunk to insert. If an internal copy is made, the @p chunk can be reused or\n freed if desired.\n @param copy Whether the chunk should be copied internally or can be used as-is.\n\n @return The number of chunks in super-chunk. If some problem is\n detected, this number will be negative."]
    pub fn blosc2_schunk_insert_chunk(
        schunk: *mut blosc2_schunk,
        nchunk: i64,
        chunk: *mut u8,
        copy: bool,
    ) -> i64;
}
extern "C" {
    #[doc = " @brief Delete a chunk at a specific position in a super-chunk.\n\n @param schunk The super-chunk where the chunk will be deleted.\n @param nchunk The position where the chunk will be deleted.\n\n @return The number of chunks in super-chunk. If some problem is\n detected, this number will be negative."]
    pub fn blosc2_schunk_delete_chunk(schunk: *mut blosc2_schunk, nchunk: i64) -> i64;
}
extern "C" {
    #[doc = " @brief Append a @p src data buffer to a super-chunk.\n\n @param schunk The super-chunk where data will be appended.\n @param src The buffer of data to compress.\n @param nbytes The size of the @p src buffer.\n\n @return The number of chunks in super-chunk. If some problem is\n detected, this number will be negative."]
    pub fn blosc2_schunk_append_buffer(
        schunk: *mut blosc2_schunk,
        src: *const ::std::os::raw::c_void,
        nbytes: i32,
    ) -> i64;
}
extern "C" {
    #[doc = " @brief Decompress and return the @p nchunk chunk of a super-chunk.\n\n If the chunk is uncompressed successfully, it is put in the @p *dest\n pointer.\n\n @param schunk The super-chunk from where the chunk will be decompressed.\n @param nchunk The chunk to be decompressed (0 indexed).\n @param dest The buffer where the decompressed data will be put.\n @param nbytes The size of the area pointed by @p *dest.\n\n @warning You must make sure that you have enough space to store the\n uncompressed data.\n\n @return The size of the decompressed chunk or 0 if it is non-initialized. If some problem is\n detected, a negative code is returned instead."]
    pub fn blosc2_schunk_decompress_chunk(
        schunk: *mut blosc2_schunk,
        nchunk: i64,
        dest: *mut ::std::os::raw::c_void,
        nbytes: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Return a compressed chunk that is part of a super-chunk in the @p chunk parameter.\n\n @param schunk The super-chunk from where to extract a chunk.\n @param nchunk The chunk to be extracted (0 indexed).\n @param chunk The pointer to the chunk of compressed data.\n @param needs_free The pointer to a boolean indicating if it is the user's\n responsibility to free the chunk returned or not.\n\n @warning If the super-chunk is backed by a frame that is disk-based, a buffer is allocated for the\n (compressed) chunk, and hence a free is needed.\n You can check whether the chunk requires a free with the @p needs_free parameter.\n If the chunk does not need a free, it means that a pointer to the location in the super-chunk\n (or the backing in-memory frame) is returned in the @p chunk parameter.\n\n @return The size of the (compressed) chunk or 0 if it is non-initialized. If some problem is\n detected, a negative code is returned instead."]
    pub fn blosc2_schunk_get_chunk(
        schunk: *mut blosc2_schunk,
        nchunk: i64,
        chunk: *mut *mut u8,
        needs_free: *mut bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Return a (lazy) compressed chunk that is part of a super-chunk in the @p chunk parameter.\n\n @param schunk The super-chunk from where to extract a chunk.\n @param nchunk The chunk to be extracted (0 indexed).\n @param chunk The pointer to the (lazy) chunk of compressed data.\n @param needs_free The pointer to a boolean indicating if it is the user's\n responsibility to free the chunk returned or not.\n\n @note For disk-based frames, a lazy chunk is always returned.\n\n @warning Currently, a lazy chunk can only be used by #blosc2_decompress_ctx and #blosc2_getitem_ctx.\n\n @warning If the super-chunk is backed by a frame that is disk-based, a buffer is allocated for the\n (compressed) chunk, and hence a free is needed.\n You can check whether requires a free with the @p needs_free parameter.\n If the chunk does not need a free, it means that a pointer to the location in the super-chunk\n (or the backing in-memory frame) is returned in the @p chunk parameter.  In this case the returned\n chunk is not lazy.\n\n @return The size of the (compressed) chunk or 0 if it is non-initialized. If some problem is\n detected, a negative code is returned instead.  Note that a lazy chunk is somewhat larger than\n a regular chunk because of the trailer section (for details see `README_CHUNK_FORMAT.rst`)."]
    pub fn blosc2_schunk_get_lazychunk(
        schunk: *mut blosc2_schunk,
        nchunk: i64,
        chunk: *mut *mut u8,
        needs_free: *mut bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Fill buffer with a schunk slice.\n\n @param schunk The super-chunk from where to extract a slice.\n @param start Index (0-based) where the slice begins.\n @param stop The first index (0-based) that is not in the selected slice.\n @param buffer The buffer where the data will be stored.\n\n @warning You must make sure that you have enough space in buffer to store the\n uncompressed data.\n\n @return An error code."]
    pub fn blosc2_schunk_get_slice_buffer(
        schunk: *mut blosc2_schunk,
        start: i64,
        stop: i64,
        buffer: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Update a schunk slice from buffer.\n\n @param schunk The super-chunk where to set the slice.\n @param start Index (0-based) where the slice begins.\n @param stop The first index (0-based) that is not in the selected slice.\n @param buffer The buffer containing the data to set.\n\n\n @return An error code."]
    pub fn blosc2_schunk_set_slice_buffer(
        schunk: *mut blosc2_schunk,
        start: i64,
        stop: i64,
        buffer: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Return the @p cparams associated to a super-chunk.\n\n @param schunk The super-chunk from where to extract the compression parameters.\n @param cparams The pointer where the compression params will be returned.\n\n @warning A new struct is allocated, and the user should free it after use.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_schunk_get_cparams(
        schunk: *mut blosc2_schunk,
        cparams: *mut *mut blosc2_cparams,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Return the @p dparams struct associated to a super-chunk.\n\n @param schunk The super-chunk from where to extract the decompression parameters.\n @param dparams The pointer where the decompression params will be returned.\n\n @warning A new struct is allocated, and the user should free it after use.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_schunk_get_dparams(
        schunk: *mut blosc2_schunk,
        dparams: *mut *mut blosc2_dparams,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Reorder the chunk offsets of an existing super-chunk.\n\n @param schunk The super-chunk whose chunk offsets are to be reordered.\n @param offsets_order The new order of the chunk offsets.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_schunk_reorder_offsets(
        schunk: *mut blosc2_schunk,
        offsets_order: *mut i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get the length (in bytes) of the internal frame of the super-chunk.\n\n @param schunk The super-chunk.\n\n @return The length (in bytes) of the internal frame.\n If there is not an internal frame, an estimate of the length is provided."]
    pub fn blosc2_schunk_frame_len(schunk: *mut blosc2_schunk) -> i64;
}
extern "C" {
    #[doc = " @brief Quickly fill an empty frame with special values (zeros, NaNs, uninit).\n\n @param schunk The super-chunk to be filled.  This must be empty initially.\n @param nitems The number of items to fill.\n @param special_value The special value to use for filling.  The only values\n supported for now are BLOSC2_SPECIAL_ZERO, BLOSC2_SPECIAL_NAN and BLOSC2_SPECIAL_UNINIT.\n @param chunksize The chunksize for the chunks that are to be added to the super-chunk.\n\n @return The total number of chunks that have been added to the super-chunk.\n If there is an error, a negative value is returned."]
    pub fn blosc2_schunk_fill_special(
        schunk: *mut blosc2_schunk,
        nitems: i64,
        special_value: ::std::os::raw::c_int,
        chunksize: i32,
    ) -> i64;
}
extern "C" {
    #[doc = " @brief Add content into a new metalayer.\n\n @param schunk The super-chunk to which the metalayer should be added.\n @param name The name of the metalayer.\n @param content The content of the metalayer.\n @param content_len The length of the content.\n\n @return If successful, the index of the new metalayer. Else, return a negative value."]
    pub fn blosc2_meta_add(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
        content: *mut u8,
        content_len: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Update the content of an existing metalayer.\n\n @param schunk The frame containing the metalayer.\n @param name The name of the metalayer to be updated.\n @param content The new content of the metalayer.\n @param content_len The length of the content.\n\n @note Contrarily to #blosc2_meta_add the updates to metalayers\n are automatically serialized into a possible attached frame.\n\n @return If successful, the index of the metalayer. Else, return a negative value."]
    pub fn blosc2_meta_update(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
        content: *mut u8,
        content_len: i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Find whether the schunk has a variable-length metalayer or not.\n\n @param schunk The super-chunk from which the variable-length metalayer will be checked.\n @param name The name of the variable-length metalayer to be checked.\n\n @return If successful, return the index of the variable-length metalayer. Else, return a negative value."]
    pub fn blosc2_vlmeta_exists(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Add content into a new variable-length metalayer.\n\n @param schunk The super-chunk to which the variable-length metalayer should be added.\n @param name The name of the variable-length metalayer.\n @param content The content to be added.\n @param content_len The length of the content.\n @param cparams The parameters for compressing the variable-length metalayer content. If NULL,\n the `BLOSC2_CPARAMS_DEFAULTS` will be used.\n\n @return If successful, the index of the new variable-length metalayer. Else, return a negative value."]
    pub fn blosc2_vlmeta_add(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
        content: *mut u8,
        content_len: i32,
        cparams: *mut blosc2_cparams,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Update the content of an existing variable-length metalayer.\n\n @param schunk The super-chunk containing the variable-length metalayer.\n @param name The name of the variable-length metalayer to be updated.\n @param content The new content of the variable-length metalayer.\n @param content_len The length of the content.\n @param cparams The parameters for compressing the variable-length metalayer content. If NULL,\n the `BLOSC2_CPARAMS_DEFAULTS` will be used.\n\n @return If successful, the index of the variable-length metalayer. Else, return a negative value."]
    pub fn blosc2_vlmeta_update(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
        content: *mut u8,
        content_len: i32,
        cparams: *mut blosc2_cparams,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get the content out of a variable-length metalayer.\n\n @param schunk The super-chunk containing the variable-length metalayer.\n @param name The name of the variable-length metalayer.\n @param content The pointer where the content will be put.\n @param content_len The pointer where the length of the content will be put.\n\n @warning The @p **content receives a malloc'ed copy of the content.\n The user is responsible of freeing it.\n\n @return If successful, the index of the new variable-length metalayer. Else, return a negative value."]
    pub fn blosc2_vlmeta_get(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
        content: *mut *mut u8,
        content_len: *mut i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Delete the variable-length metalayer from the super-chunk.\n\n @param schunk The super-chunk containing the variable-length metalayer.\n @param name The name of the variable-length metalayer.\n\n @return If successful, the number of the variable-length metalayers in the super-chunk. Else, return a negative value."]
    pub fn blosc2_vlmeta_delete(
        schunk: *mut blosc2_schunk,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Get a list of all the variable-length metalayer names.\n\n @param schunk The super-chunk containing the variable-length metalayers.\n @param names The pointer to a char** to store the name pointers. This should\n be of size *schunk->nvlmetalayers * sizeof(char*).\n\n @return The number of the variable-length metalayers in the super-chunk.\n This cannot fail unless the user does not pass a @p names which is large enough to\n keep pointers to all names, in which case funny things (seg faults and such) will happen."]
    pub fn blosc2_vlmeta_get_names(
        schunk: *mut blosc2_schunk,
        names: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
pub type blosc_timestamp_t = timespec;
extern "C" {
    pub fn blosc_set_timestamp(timestamp: *mut blosc_timestamp_t);
}
extern "C" {
    pub fn blosc_elapsed_nsecs(start_time: blosc_timestamp_t, end_time: blosc_timestamp_t) -> f64;
}
extern "C" {
    pub fn blosc_elapsed_secs(start_time: blosc_timestamp_t, end_time: blosc_timestamp_t) -> f64;
}
extern "C" {
    #[doc = " @brief Get the internal blocksize to be used during compression. 0 means\n that an automatic blocksize is computed internally.\n\n @return The size in bytes of the internal block size."]
    pub fn blosc1_get_blocksize() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Force the use of a specific blocksize. If 0, an automatic\n blocksize will be used (the default).\n\n @warning The blocksize is a critical parameter with important\n restrictions in the allowed values, so use this with care."]
    pub fn blosc1_set_blocksize(blocksize: usize);
}
extern "C" {
    #[doc = " @brief Set the split mode.\n\n @param splitmode It can take the next values:\n  BLOSC_FORWARD_COMPAT_SPLIT\n  BLOSC_AUTO_SPLIT\n  BLOSC_NEVER_SPLIT\n  BLOSC_ALWAYS_SPLIT\n\n BLOSC_FORWARD_COMPAT offers reasonably forward compatibility,\n BLOSC_AUTO_SPLIT is for nearly optimal results (based on heuristics),\n BLOSC_NEVER_SPLIT and BLOSC_ALWAYS_SPLIT are for the user experimenting\n  when trying to get best compression ratios and/or speed.\n\n If not called, the default mode is BLOSC_FORWARD_COMPAT_SPLIT.\n\n This function should always succeed."]
    pub fn blosc1_set_splitmode(splitmode: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " @brief Get the offsets of a frame in a super-chunk.\n\n @param schunk The super-chunk containing the frame.\n\n @return If successful, return a pointer to a buffer of the decompressed offsets.\n The number of offsets is equal to schunk->nchunks; the user is\n responsible to free this buffer. Else, return a NULL value."]
    pub fn blosc2_frame_get_offsets(schunk: *mut blosc2_schunk) -> *mut i64;
}
#[doc = "Structures and functions related with compression codecs."]
pub type blosc2_codec_encoder_cb = ::std::option::Option<
    unsafe extern "C" fn(
        input: *const u8,
        input_len: i32,
        output: *mut u8,
        output_len: i32,
        meta: u8,
        cparams: *mut blosc2_cparams,
        chunk: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type blosc2_codec_decoder_cb = ::std::option::Option<
    unsafe extern "C" fn(
        input: *const u8,
        input_len: i32,
        output: *mut u8,
        output_len: i32,
        meta: u8,
        dparams: *mut blosc2_dparams,
        chunk: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_codec {
    pub compcode: u8,
    pub compname: *mut ::std::os::raw::c_char,
    pub complib: u8,
    pub version: u8,
    pub encoder: blosc2_codec_encoder_cb,
    pub decoder: blosc2_codec_decoder_cb,
}
#[test]
fn bindgen_test_layout_blosc2_codec() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_codec> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_codec>(),
        40usize,
        concat!("Size of: ", stringify!(blosc2_codec))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_codec>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_codec))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compcode) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_codec),
            "::",
            stringify!(compcode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compname) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_codec),
            "::",
            stringify!(compname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).complib) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_codec),
            "::",
            stringify!(complib)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_codec),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).encoder) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_codec),
            "::",
            stringify!(encoder)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).decoder) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_codec),
            "::",
            stringify!(decoder)
        )
    );
}
extern "C" {
    #[doc = " @brief Register locally a user-defined codec in Blosc.\n\n @param codec The codec to register.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_register_codec(codec: *mut blosc2_codec) -> ::std::os::raw::c_int;
}
#[doc = "Structures and functions related with filters plugins."]
pub type blosc2_filter_forward_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const u8,
        arg2: *mut u8,
        arg3: i32,
        arg4: u8,
        arg5: *mut blosc2_cparams,
        arg6: u8,
    ) -> ::std::os::raw::c_int,
>;
pub type blosc2_filter_backward_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const u8,
        arg2: *mut u8,
        arg3: i32,
        arg4: u8,
        arg5: *mut blosc2_dparams,
        arg6: u8,
    ) -> ::std::os::raw::c_int,
>;
#[doc = " @brief The parameters for a user-defined filter."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct blosc2_filter {
    pub id: u8,
    pub name: *mut ::std::os::raw::c_char,
    pub version: u8,
    pub forward: blosc2_filter_forward_cb,
    pub backward: blosc2_filter_backward_cb,
}
#[test]
fn bindgen_test_layout_blosc2_filter() {
    const UNINIT: ::std::mem::MaybeUninit<blosc2_filter> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blosc2_filter>(),
        40usize,
        concat!("Size of: ", stringify!(blosc2_filter))
    );
    assert_eq!(
        ::std::mem::align_of::<blosc2_filter>(),
        8usize,
        concat!("Alignment of ", stringify!(blosc2_filter))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).id) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_filter),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_filter),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_filter),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).forward) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_filter),
            "::",
            stringify!(forward)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).backward) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(blosc2_filter),
            "::",
            stringify!(backward)
        )
    );
}
extern "C" {
    #[doc = " @brief Register locally a user-defined filter in Blosc.\n\n @param filter The filter to register.\n\n @return 0 if succeeds. Else a negative code is returned."]
    pub fn blosc2_register_filter(filter: *mut blosc2_filter) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_remove_dir(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_remove_urlpath(path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_rename_urlpath(
        old_urlpath: *mut ::std::os::raw::c_char,
        new_path: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn blosc2_unidim_to_multidim(ndim: u8, shape: *mut i64, i: i64, index: *mut i64);
}
extern "C" {
    pub fn blosc2_multidim_to_unidim(index: *const i64, ndim: i8, strides: *const i64, i: *mut i64);
}
extern "C" {
    pub fn blosc2_get_slice_nchunks(
        schunk: *mut blosc2_schunk,
        start: *mut i64,
        stop: *mut i64,
        chunks_idx: *mut *mut i64,
    ) -> ::std::os::raw::c_int;
}
