/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import com.apple.cocoa.foundation.NSPoint;
import com.apple.cocoa.foundation.NSRect;
import com.apple.cocoa.foundation.NSRuntime;
import com.apple.cocoa.foundation.NSSize;
import java.awt.Rectangle;

public class NSMutableRect
extends NSRect {
    private int _backingRect = 0;
    private boolean _freeRect = true;

    public NSMutableRect() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public NSMutableRect(float f, float f2, float f3, float f4) {
        this._backingRect = this.privateCreateBackingRect();
        this.setX(f);
        this.setY(f2);
        this.setWidth(f3);
        this.setHeight(f4);
    }

    public NSMutableRect(NSPoint nSPoint, NSSize nSSize) {
        this(nSPoint.x(), nSPoint.y(), nSSize.width(), nSSize.height());
    }

    public NSMutableRect(NSPoint nSPoint, NSPoint nSPoint2) {
        this(nSPoint.x() < nSPoint2.x() ? nSPoint.x() : nSPoint2.x(), nSPoint.y() < nSPoint2.y() ? nSPoint.y() : nSPoint2.y(), nSPoint.x() < nSPoint2.x() ? nSPoint2.x() - nSPoint.x() : nSPoint.x() - nSPoint2.x(), nSPoint.y() < nSPoint2.y() ? nSPoint2.y() - nSPoint.y() : nSPoint.y() - nSPoint2.y());
    }

    public NSMutableRect(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public NSMutableRect(NSRect nSRect) {
        this(nSRect.x(), nSRect.y(), nSRect.width(), nSRect.height());
    }

    private NSMutableRect(int n) {
        this._backingRect = n;
        this._freeRect = false;
    }

    protected void finalize() {
        if (this._freeRect && this._backingRect != 0) {
            this.privateDestroyBackingRect(this._backingRect);
        }
    }

    public float x() {
        return this.privateX(this._backingRect);
    }

    public float y() {
        return this.privateY(this._backingRect);
    }

    public float width() {
        return this.privateWidth(this._backingRect);
    }

    public float height() {
        return this.privateHeight(this._backingRect);
    }

    public void setX(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN x");
        }
        this.privateSetX(this._backingRect, f);
    }

    public void setY(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN y");
        }
        this.privateSetY(this._backingRect, f);
    }

    public void setWidth(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN width");
        }
        if (0.0f <= f) {
            this.privateSetWidth(this._backingRect, 0.0f == f ? 0.0f : f);
            return;
        }
        throw new IllegalArgumentException("cannot set negative width (" + f + ")");
    }

    public void setHeight(float f) {
        if (f != f) {
            throw new IllegalArgumentException("cannot set NaN height");
        }
        if (0.0f <= f) {
            this.privateSetHeight(this._backingRect, 0.0f == f ? 0.0f : f);
            return;
        }
        throw new IllegalArgumentException("cannot set negative height (" + f + ")");
    }

    public void setOrigin(NSPoint nSPoint) {
        this.setX(nSPoint.x());
        this.setY(nSPoint.y());
    }

    public void setSize(NSSize nSSize) {
        this.setWidth(nSSize.width());
        this.setHeight(nSSize.height());
    }

    public void insetRect(float f, float f2) {
        this.setX(this.x() + f);
        this.setY(this.y() + f2);
        this.setWidth(this.width() - f - f);
        this.setHeight(this.height() - f2 - f2);
    }

    public void offsetRect(float f, float f2) {
        this.setX(this.x() + f);
        this.setY(this.y() + f2);
    }

    public void makeIntegral() {
        float f = this.width();
        float f2 = this.height();
        if (0.0 < (double)f && 0.0 < (double)f2) {
            float f3 = this.x();
            float f4 = this.y();
            float f5 = (float)Math.floor(f3);
            float f6 = (float)Math.floor(f4);
            this.setX(f5);
            this.setY(f6);
            this.setWidth((float)Math.ceil(f3 + f) - f5);
            this.setHeight((float)Math.ceil(f4 + f2) - f6);
            return;
        }
        this.setX(0.0f);
        this.setY(0.0f);
        this.setWidth(0.0f);
        this.setHeight(0.0f);
    }

    public void unionRect(NSRect nSRect) {
        float f = nSRect.width();
        float f2 = nSRect.height();
        float f3 = this.width();
        float f4 = this.height();
        if (f <= 0.0f || f2 <= 0.0f) {
            if (f3 <= 0.0f || f4 <= 0.0f) {
                this.setX(0.0f);
                this.setY(0.0f);
                this.setWidth(0.0f);
                this.setHeight(0.0f);
            }
        } else if (f3 <= 0.0f || f4 <= 0.0f) {
            this.setX(nSRect.x());
            this.setY(nSRect.y());
            this.setWidth(f);
            this.setHeight(f2);
        } else {
            float f5 = nSRect.x();
            float f6 = nSRect.y();
            float f7 = this.x();
            float f8 = this.y();
            float f9 = f7 <= f5 ? f7 : f5;
            float f10 = f8 <= f6 ? f8 : f6;
            float f11 = (f7 + f3 >= f5 + f ? f7 + f3 : f5 + f) - f9;
            float f12 = (f8 + f4 >= f6 + f2 ? f8 + f4 : f6 + f2) - f10;
            this.setX(f9);
            this.setY(f10);
            this.setWidth(f11);
            this.setHeight(f12);
        }
    }

    public void intersectRect(NSRect nSRect) {
        float f = this.width();
        float f2 = this.height();
        float f3 = nSRect.width();
        float f4 = nSRect.height();
        if (f <= 0.0f || f2 <= 0.0f || f3 <= 0.0f || f4 <= 0.0f) {
            this.setX(0.0f);
            this.setY(0.0f);
            this.setWidth(0.0f);
            this.setHeight(0.0f);
        } else {
            float f5;
            float f6;
            float f7 = this.x();
            float f8 = f7 >= (f6 = nSRect.x()) ? f7 : f6;
            float f9 = f5 = f7 <= f6 ? (f7 += f) : (f6 += f3);
            if (f5 <= f8) {
                this.setX(0.0f);
                this.setY(0.0f);
                this.setWidth(0.0f);
                this.setHeight(0.0f);
            } else {
                float f10 = f8;
                float f11 = f5 - f8;
                f7 = this.y();
                f8 = f7 >= (f6 = nSRect.y()) ? f7 : f6;
                float f12 = f5 = f7 <= f6 ? (f7 += f2) : (f6 += f4);
                if (f5 <= f8) {
                    this.setX(0.0f);
                    this.setY(0.0f);
                    this.setWidth(0.0f);
                    this.setHeight(0.0f);
                } else {
                    float f13 = f8;
                    float f14 = f5 - f8;
                    this.setX(f10);
                    this.setY(f13);
                    this.setWidth(f11);
                    this.setHeight(f14);
                }
            }
        }
    }

    public Object clone() {
        return new NSMutableRect(this);
    }

    private native int privateCreateBackingRect();

    private native void privateDestroyBackingRect(int var1);

    private native float privateX(int var1);

    private native float privateY(int var1);

    private native float privateWidth(int var1);

    private native float privateHeight(int var1);

    private native void privateSetX(int var1, float var2);

    private native void privateSetY(int var1, float var2);

    private native void privateSetWidth(int var1, float var2);

    private native void privateSetHeight(int var1, float var2);

    static {
        NSRuntime.loadLibrary("ObjCJava");
        NSRuntime.loadLibrary("FoundationJava");
    }
}

