/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class CTabFolderLayout
extends Layout {
    CTabFolderLayout() {
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int minHeight;
        CTabFolder folder = (CTabFolder)composite;
        CTabItem[] items = folder.items;
        CTabFolderRenderer renderer = folder.renderer;
        int tabW = 0;
        int selectedIndex = folder.selectedIndex;
        if (selectedIndex == -1) {
            selectedIndex = 0;
        }
        GC gc = new GC(folder);
        for (int i = 0; i < items.length; ++i) {
            if (folder.single) {
                tabW = Math.max(tabW, renderer.computeSize((int)i, (int)2, (GC)gc, (int)-1, (int)-1).x);
                continue;
            }
            int state = 0;
            if (i == selectedIndex) {
                state |= 2;
            }
            tabW += renderer.computeSize((int)i, (int)state, (GC)gc, (int)-1, (int)-1).x;
        }
        int width = 0;
        int wrapHeight = 0;
        boolean leftControl = false;
        boolean rightControl = false;
        if (wHint == -1) {
            for (int i = 0; i < folder.controls.length; ++i) {
                Control control = folder.controls[i];
                if (control.isDisposed() || !control.getVisible()) continue;
                if ((folder.controlAlignments[i] & 0x4000) != 0) {
                    leftControl = true;
                } else {
                    rightControl = true;
                }
                width += control.computeSize((int)-1, (int)-1).x;
            }
        } else {
            Point size = new Point(wHint, hHint);
            boolean[][] positions = new boolean[1][];
            Rectangle[] rects = folder.computeControlBounds(size, positions);
            int minY = Integer.MAX_VALUE;
            int maxY = 0;
            for (int i = 0; i < rects.length; ++i) {
                if (positions[0][i]) {
                    minY = Math.min(minY, rects[i].y);
                    maxY = Math.max(maxY, rects[i].y + rects[i].height);
                    wrapHeight = maxY - minY;
                    continue;
                }
                if ((folder.controlAlignments[i] & 0x4000) != 0) {
                    leftControl = true;
                } else {
                    rightControl = true;
                }
                width += rects[i].width;
            }
        }
        if (leftControl) {
            width += 6;
        }
        if (rightControl) {
            width += 6;
        }
        tabW += width;
        gc.dispose();
        int controlW = 0;
        int controlH = 0;
        for (int i = 0; i < items.length; ++i) {
            Control control = items[i].control;
            if (control == null || control.isDisposed()) continue;
            Point size = control.computeSize(wHint, hHint, flushCache);
            controlW = Math.max(controlW, size.x);
            controlH = Math.max(controlH, size.y);
        }
        int minWidth = Math.max(tabW, controlW + folder.marginWidth);
        int n = minHeight = folder.minimized ? 0 : controlH + wrapHeight;
        if (minWidth == 0) {
            minWidth = 64;
        }
        if (minHeight == 0) {
            minHeight = 64;
        }
        if (wHint != -1) {
            minWidth = wHint;
        }
        if (hHint != -1) {
            minHeight = hHint;
        }
        return new Point(minWidth, minHeight);
    }

    @Override
    protected boolean flushCache(Control control) {
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Control control;
        CTabFolder folder = (CTabFolder)composite;
        if (folder.selectedIndex != -1 && (control = folder.items[folder.selectedIndex].control) != null && !control.isDisposed()) {
            control.setBounds(folder.getClientArea());
        }
    }
}

