// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package resourcesettings provides access to the Resource Settings API.
//
// For product documentation, see: https://cloud.google.com/resource-manager/docs/resource-settings/overview
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/resourcesettings/v1"
//	...
//	ctx := context.Background()
//	resourcesettingsService, err := resourcesettings.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	resourcesettingsService, err := resourcesettings.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	resourcesettingsService, err := resourcesettings.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package resourcesettings // import "google.golang.org/api/resourcesettings/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "resourcesettings:v1"
const apiName = "resourcesettings"
const apiVersion = "v1"
const basePath = "https://resourcesettings.googleapis.com/"
const mtlsBasePath = "https://resourcesettings.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Folders = NewFoldersService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Settings = NewFoldersSettingsService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Settings *FoldersSettingsService
}

func NewFoldersSettingsService(s *Service) *FoldersSettingsService {
	rs := &FoldersSettingsService{s: s}
	return rs
}

type FoldersSettingsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Settings = NewOrganizationsSettingsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Settings *OrganizationsSettingsService
}

func NewOrganizationsSettingsService(s *Service) *OrganizationsSettingsService {
	rs := &OrganizationsSettingsService{s: s}
	return rs
}

type OrganizationsSettingsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Settings = NewProjectsSettingsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Settings *ProjectsSettingsService
}

func NewProjectsSettingsService(s *Service) *ProjectsSettingsService {
	rs := &ProjectsSettingsService{s: s}
	return rs
}

type ProjectsSettingsService struct {
	s *Service
}

// GoogleCloudResourcesettingsV1ListSettingsResponse: The response from
// ListSettings.
type GoogleCloudResourcesettingsV1ListSettingsResponse struct {
	// NextPageToken: Unused. A page token used to retrieve the next page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Settings: A list of settings that are available at the specified
	// Cloud resource.
	Settings []*GoogleCloudResourcesettingsV1Setting `json:"settings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1ListSettingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1ListSettingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudResourcesettingsV1Setting: The schema for settings.
type GoogleCloudResourcesettingsV1Setting struct {
	// EffectiveValue: Output only. The effective value of the setting at
	// the given parent resource, evaluated based on the resource hierarchy
	// The effective value evaluates to one of the following options, in
	// this order. If an option is not valid or doesn't exist, then the next
	// option is used: 1. The local setting value on the given resource:
	// Setting.local_value 2. If one of the given resource's ancestors in
	// the resource hierarchy have a local setting value, the local value at
	// the nearest such ancestor. 3. The setting's default value:
	// SettingMetadata.default_value 4. An empty value, defined as a `Value`
	// with all fields unset. The data type of Value must always be
	// consistent with the data type defined in Setting.metadata.
	EffectiveValue *GoogleCloudResourcesettingsV1Value `json:"effectiveValue,omitempty"`

	// Etag: A fingerprint used for optimistic concurrency. See
	// UpdateSetting for more details.
	Etag string `json:"etag,omitempty"`

	// LocalValue: The configured value of the setting at the given parent
	// resource, ignoring the resource hierarchy. The data type of Value
	// must always be consistent with the data type defined in
	// Setting.metadata.
	LocalValue *GoogleCloudResourcesettingsV1Value `json:"localValue,omitempty"`

	// Metadata: Output only. Metadata about a setting which is not editable
	// by the end user.
	Metadata *GoogleCloudResourcesettingsV1SettingMetadata `json:"metadata,omitempty"`

	// Name: The resource name of the setting. Must be in one of the
	// following forms: *
	// `projects/{project_number}/settings/{setting_name}` *
	// `folders/{folder_id}/settings/{setting_name}` *
	// `organizations/{organization_id}/settings/{setting_name}` For
	// example, "/projects/123/settings/gcp-enableMyFeature"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EffectiveValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EffectiveValue") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1Setting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1Setting
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudResourcesettingsV1SettingMetadata: Metadata about a
// setting which is not editable by the end user.
type GoogleCloudResourcesettingsV1SettingMetadata struct {
	// DataType: The data type for this setting.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Unspecified data type.
	//   "BOOLEAN" - A boolean setting.
	//   "STRING" - A string setting.
	//   "STRING_SET" - A string set setting.
	//   "ENUM_VALUE" - A Enum setting
	//   "DURATION_VALUE" - A Duration setting
	//   "STRING_MAP" - A string->string map setting
	DataType string `json:"dataType,omitempty"`

	// DefaultValue: The value provided by Setting.effective_value if no
	// setting value is explicitly set. Note: not all settings have a
	// default value.
	DefaultValue *GoogleCloudResourcesettingsV1Value `json:"defaultValue,omitempty"`

	// Description: A detailed description of what this setting does.
	Description string `json:"description,omitempty"`

	// DisplayName: The human readable name for this setting.
	DisplayName string `json:"displayName,omitempty"`

	// ReadOnly: A flag indicating that values of this setting cannot be
	// modified. See documentation for the specific setting for updates and
	// reasons.
	ReadOnly bool `json:"readOnly,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1SettingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1SettingMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudResourcesettingsV1Value: The data in a setting value.
type GoogleCloudResourcesettingsV1Value struct {
	// BooleanValue: Defines this value as being a boolean value.
	BooleanValue bool `json:"booleanValue,omitempty"`

	// DurationValue: Defines this value as being a Duration.
	DurationValue string `json:"durationValue,omitempty"`

	// EnumValue: Defines this value as being a Enum.
	EnumValue *GoogleCloudResourcesettingsV1ValueEnumValue `json:"enumValue,omitempty"`

	// StringMapValue: Defines this value as being a StringMap.
	StringMapValue *GoogleCloudResourcesettingsV1ValueStringMap `json:"stringMapValue,omitempty"`

	// StringSetValue: Defines this value as being a StringSet.
	StringSetValue *GoogleCloudResourcesettingsV1ValueStringSet `json:"stringSetValue,omitempty"`

	// StringValue: Defines this value as being a string value.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BooleanValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1Value) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1Value
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudResourcesettingsV1ValueEnumValue: A enum value that can
// hold any enum type setting values. Each enum type is represented by a
// number, this representation is stored in the definitions.
type GoogleCloudResourcesettingsV1ValueEnumValue struct {
	// Value: The value of this enum
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1ValueEnumValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1ValueEnumValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudResourcesettingsV1ValueStringMap: A string->string map
// value that can hold a map of string keys to string values. The
// maximum length of each string is 200 characters and there can be a
// maximum of 50 key-value pairs in the map.
type GoogleCloudResourcesettingsV1ValueStringMap struct {
	// Mappings: The key-value pairs in the map
	Mappings map[string]string `json:"mappings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Mappings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mappings") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1ValueStringMap) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1ValueStringMap
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudResourcesettingsV1ValueStringSet: A string set value that
// can hold a set of strings. The maximum length of each string is 200
// characters and there can be a maximum of 50 strings in the string
// set.
type GoogleCloudResourcesettingsV1ValueStringSet struct {
	// Values: The strings in the set
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudResourcesettingsV1ValueStringSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudResourcesettingsV1ValueStringSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "resourcesettings.folders.settings.get":

type FoldersSettingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a specified setting. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the setting does not exist.
//
//   - name: The name of the setting to get. See Setting for naming
//     requirements.
func (r *FoldersSettingsService) Get(name string) *FoldersSettingsGetCall {
	c := &FoldersSettingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The SettingView for this
// request.
//
// Possible values:
//
//	"SETTING_VIEW_UNSPECIFIED" - The default / unset value. The API
//
// will default to the SETTING_VIEW_BASIC view.
//
//	"SETTING_VIEW_BASIC" - Include Setting.metadata, but nothing else.
//
// This is the default value (for both ListSettings and GetSetting).
//
//	"SETTING_VIEW_EFFECTIVE_VALUE" - Include Setting.effective_value,
//
// but nothing else.
//
//	"SETTING_VIEW_LOCAL_VALUE" - Include Setting.local_value, but
//
// nothing else.
func (c *FoldersSettingsGetCall) View(view string) *FoldersSettingsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSettingsGetCall) Fields(s ...googleapi.Field) *FoldersSettingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSettingsGetCall) IfNoneMatch(entityTag string) *FoldersSettingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSettingsGetCall) Context(ctx context.Context) *FoldersSettingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSettingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSettingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.folders.settings.get" call.
// Exactly one of *GoogleCloudResourcesettingsV1Setting or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudResourcesettingsV1Setting.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSettingsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1Setting, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1Setting{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a specified setting. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the setting does not exist.",
	//   "flatPath": "v1/folders/{foldersId}/settings/{settingsId}",
	//   "httpMethod": "GET",
	//   "id": "resourcesettings.folders.settings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the setting to get. See Setting for naming requirements.",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/settings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The SettingView for this request.",
	//       "enum": [
	//         "SETTING_VIEW_UNSPECIFIED",
	//         "SETTING_VIEW_BASIC",
	//         "SETTING_VIEW_EFFECTIVE_VALUE",
	//         "SETTING_VIEW_LOCAL_VALUE"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value. The API will default to the SETTING_VIEW_BASIC view.",
	//         "Include Setting.metadata, but nothing else. This is the default value (for both ListSettings and GetSetting).",
	//         "Include Setting.effective_value, but nothing else.",
	//         "Include Setting.local_value, but nothing else."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "resourcesettings.folders.settings.list":

type FoldersSettingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the settings that are available on the Cloud resource
// `parent`.
//
//   - parent: The project, folder, or organization that is the parent
//     resource for this setting. Must be in one of the following forms: *
//     `projects/{project_number}` * `projects/{project_id}` *
//     `folders/{folder_id}` * `organizations/{organization_id}`.
func (r *FoldersSettingsService) List(parent string) *FoldersSettingsListCall {
	c := &FoldersSettingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Unused. The size of
// the page to be returned.
func (c *FoldersSettingsListCall) PageSize(pageSize int64) *FoldersSettingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Unused. A page
// token used to retrieve the next page.
func (c *FoldersSettingsListCall) PageToken(pageToken string) *FoldersSettingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The SettingView for this
// request.
//
// Possible values:
//
//	"SETTING_VIEW_UNSPECIFIED" - The default / unset value. The API
//
// will default to the SETTING_VIEW_BASIC view.
//
//	"SETTING_VIEW_BASIC" - Include Setting.metadata, but nothing else.
//
// This is the default value (for both ListSettings and GetSetting).
//
//	"SETTING_VIEW_EFFECTIVE_VALUE" - Include Setting.effective_value,
//
// but nothing else.
//
//	"SETTING_VIEW_LOCAL_VALUE" - Include Setting.local_value, but
//
// nothing else.
func (c *FoldersSettingsListCall) View(view string) *FoldersSettingsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSettingsListCall) Fields(s ...googleapi.Field) *FoldersSettingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FoldersSettingsListCall) IfNoneMatch(entityTag string) *FoldersSettingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSettingsListCall) Context(ctx context.Context) *FoldersSettingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSettingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSettingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.folders.settings.list" call.
// Exactly one of *GoogleCloudResourcesettingsV1ListSettingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudResourcesettingsV1ListSettingsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSettingsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1ListSettingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1ListSettingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the settings that are available on the Cloud resource `parent`.",
	//   "flatPath": "v1/folders/{foldersId}/settings",
	//   "httpMethod": "GET",
	//   "id": "resourcesettings.folders.settings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Unused. The size of the page to be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Unused. A page token used to retrieve the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The project, folder, or organization that is the parent resource for this setting. Must be in one of the following forms: * `projects/{project_number}` * `projects/{project_id}` * `folders/{folder_id}` * `organizations/{organization_id}`",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The SettingView for this request.",
	//       "enum": [
	//         "SETTING_VIEW_UNSPECIFIED",
	//         "SETTING_VIEW_BASIC",
	//         "SETTING_VIEW_EFFECTIVE_VALUE",
	//         "SETTING_VIEW_LOCAL_VALUE"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value. The API will default to the SETTING_VIEW_BASIC view.",
	//         "Include Setting.metadata, but nothing else. This is the default value (for both ListSettings and GetSetting).",
	//         "Include Setting.effective_value, but nothing else.",
	//         "Include Setting.local_value, but nothing else."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/settings",
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1ListSettingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSettingsListCall) Pages(ctx context.Context, f func(*GoogleCloudResourcesettingsV1ListSettingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "resourcesettings.folders.settings.patch":

type FoldersSettingsPatchCall struct {
	s                                    *Service
	name                                 string
	googlecloudresourcesettingsv1setting *GoogleCloudResourcesettingsV1Setting
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Patch: Updates a specified setting. Returns a `google.rpc.Status`
// with `google.rpc.Code.NOT_FOUND` if the setting does not exist.
// Returns a `google.rpc.Status` with
// `google.rpc.Code.FAILED_PRECONDITION` if the setting is flagged as
// read only. Returns a `google.rpc.Status` with
// `google.rpc.Code.ABORTED` if the etag supplied in the request does
// not match the persisted etag of the setting value. On success, the
// response will contain only `name`, `local_value` and `etag`. The
// `metadata` and `effective_value` cannot be updated through this API.
// Note: the supplied setting will perform a full overwrite of the
// `local_value` field.
//
//   - name: The resource name of the setting. Must be in one of the
//     following forms: *
//     `projects/{project_number}/settings/{setting_name}` *
//     `folders/{folder_id}/settings/{setting_name}` *
//     `organizations/{organization_id}/settings/{setting_name}` For
//     example, "/projects/123/settings/gcp-enableMyFeature".
func (r *FoldersSettingsService) Patch(name string, googlecloudresourcesettingsv1setting *GoogleCloudResourcesettingsV1Setting) *FoldersSettingsPatchCall {
	c := &FoldersSettingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudresourcesettingsv1setting = googlecloudresourcesettingsv1setting
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FoldersSettingsPatchCall) Fields(s ...googleapi.Field) *FoldersSettingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FoldersSettingsPatchCall) Context(ctx context.Context) *FoldersSettingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FoldersSettingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSettingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudresourcesettingsv1setting)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.folders.settings.patch" call.
// Exactly one of *GoogleCloudResourcesettingsV1Setting or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudResourcesettingsV1Setting.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSettingsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1Setting, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1Setting{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a specified setting. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the setting does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if the setting is flagged as read only. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the setting value. On success, the response will contain only `name`, `local_value` and `etag`. The `metadata` and `effective_value` cannot be updated through this API. Note: the supplied setting will perform a full overwrite of the `local_value` field.",
	//   "flatPath": "v1/folders/{foldersId}/settings/{settingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "resourcesettings.folders.settings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the setting. Must be in one of the following forms: * `projects/{project_number}/settings/{setting_name}` * `folders/{folder_id}/settings/{setting_name}` * `organizations/{organization_id}/settings/{setting_name}` For example, \"/projects/123/settings/gcp-enableMyFeature\"",
	//       "location": "path",
	//       "pattern": "^folders/[^/]+/settings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "resourcesettings.organizations.settings.get":

type OrganizationsSettingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a specified setting. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the setting does not exist.
//
//   - name: The name of the setting to get. See Setting for naming
//     requirements.
func (r *OrganizationsSettingsService) Get(name string) *OrganizationsSettingsGetCall {
	c := &OrganizationsSettingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The SettingView for this
// request.
//
// Possible values:
//
//	"SETTING_VIEW_UNSPECIFIED" - The default / unset value. The API
//
// will default to the SETTING_VIEW_BASIC view.
//
//	"SETTING_VIEW_BASIC" - Include Setting.metadata, but nothing else.
//
// This is the default value (for both ListSettings and GetSetting).
//
//	"SETTING_VIEW_EFFECTIVE_VALUE" - Include Setting.effective_value,
//
// but nothing else.
//
//	"SETTING_VIEW_LOCAL_VALUE" - Include Setting.local_value, but
//
// nothing else.
func (c *OrganizationsSettingsGetCall) View(view string) *OrganizationsSettingsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsSettingsGetCall) Fields(s ...googleapi.Field) *OrganizationsSettingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsSettingsGetCall) IfNoneMatch(entityTag string) *OrganizationsSettingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsSettingsGetCall) Context(ctx context.Context) *OrganizationsSettingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsSettingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsSettingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.organizations.settings.get" call.
// Exactly one of *GoogleCloudResourcesettingsV1Setting or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudResourcesettingsV1Setting.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsSettingsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1Setting, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1Setting{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a specified setting. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the setting does not exist.",
	//   "flatPath": "v1/organizations/{organizationsId}/settings/{settingsId}",
	//   "httpMethod": "GET",
	//   "id": "resourcesettings.organizations.settings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the setting to get. See Setting for naming requirements.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/settings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The SettingView for this request.",
	//       "enum": [
	//         "SETTING_VIEW_UNSPECIFIED",
	//         "SETTING_VIEW_BASIC",
	//         "SETTING_VIEW_EFFECTIVE_VALUE",
	//         "SETTING_VIEW_LOCAL_VALUE"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value. The API will default to the SETTING_VIEW_BASIC view.",
	//         "Include Setting.metadata, but nothing else. This is the default value (for both ListSettings and GetSetting).",
	//         "Include Setting.effective_value, but nothing else.",
	//         "Include Setting.local_value, but nothing else."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "resourcesettings.organizations.settings.list":

type OrganizationsSettingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the settings that are available on the Cloud resource
// `parent`.
//
//   - parent: The project, folder, or organization that is the parent
//     resource for this setting. Must be in one of the following forms: *
//     `projects/{project_number}` * `projects/{project_id}` *
//     `folders/{folder_id}` * `organizations/{organization_id}`.
func (r *OrganizationsSettingsService) List(parent string) *OrganizationsSettingsListCall {
	c := &OrganizationsSettingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Unused. The size of
// the page to be returned.
func (c *OrganizationsSettingsListCall) PageSize(pageSize int64) *OrganizationsSettingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Unused. A page
// token used to retrieve the next page.
func (c *OrganizationsSettingsListCall) PageToken(pageToken string) *OrganizationsSettingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The SettingView for this
// request.
//
// Possible values:
//
//	"SETTING_VIEW_UNSPECIFIED" - The default / unset value. The API
//
// will default to the SETTING_VIEW_BASIC view.
//
//	"SETTING_VIEW_BASIC" - Include Setting.metadata, but nothing else.
//
// This is the default value (for both ListSettings and GetSetting).
//
//	"SETTING_VIEW_EFFECTIVE_VALUE" - Include Setting.effective_value,
//
// but nothing else.
//
//	"SETTING_VIEW_LOCAL_VALUE" - Include Setting.local_value, but
//
// nothing else.
func (c *OrganizationsSettingsListCall) View(view string) *OrganizationsSettingsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsSettingsListCall) Fields(s ...googleapi.Field) *OrganizationsSettingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsSettingsListCall) IfNoneMatch(entityTag string) *OrganizationsSettingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsSettingsListCall) Context(ctx context.Context) *OrganizationsSettingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsSettingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsSettingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.organizations.settings.list" call.
// Exactly one of *GoogleCloudResourcesettingsV1ListSettingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudResourcesettingsV1ListSettingsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsSettingsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1ListSettingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1ListSettingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the settings that are available on the Cloud resource `parent`.",
	//   "flatPath": "v1/organizations/{organizationsId}/settings",
	//   "httpMethod": "GET",
	//   "id": "resourcesettings.organizations.settings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Unused. The size of the page to be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Unused. A page token used to retrieve the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The project, folder, or organization that is the parent resource for this setting. Must be in one of the following forms: * `projects/{project_number}` * `projects/{project_id}` * `folders/{folder_id}` * `organizations/{organization_id}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The SettingView for this request.",
	//       "enum": [
	//         "SETTING_VIEW_UNSPECIFIED",
	//         "SETTING_VIEW_BASIC",
	//         "SETTING_VIEW_EFFECTIVE_VALUE",
	//         "SETTING_VIEW_LOCAL_VALUE"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value. The API will default to the SETTING_VIEW_BASIC view.",
	//         "Include Setting.metadata, but nothing else. This is the default value (for both ListSettings and GetSetting).",
	//         "Include Setting.effective_value, but nothing else.",
	//         "Include Setting.local_value, but nothing else."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/settings",
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1ListSettingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsSettingsListCall) Pages(ctx context.Context, f func(*GoogleCloudResourcesettingsV1ListSettingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "resourcesettings.organizations.settings.patch":

type OrganizationsSettingsPatchCall struct {
	s                                    *Service
	name                                 string
	googlecloudresourcesettingsv1setting *GoogleCloudResourcesettingsV1Setting
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Patch: Updates a specified setting. Returns a `google.rpc.Status`
// with `google.rpc.Code.NOT_FOUND` if the setting does not exist.
// Returns a `google.rpc.Status` with
// `google.rpc.Code.FAILED_PRECONDITION` if the setting is flagged as
// read only. Returns a `google.rpc.Status` with
// `google.rpc.Code.ABORTED` if the etag supplied in the request does
// not match the persisted etag of the setting value. On success, the
// response will contain only `name`, `local_value` and `etag`. The
// `metadata` and `effective_value` cannot be updated through this API.
// Note: the supplied setting will perform a full overwrite of the
// `local_value` field.
//
//   - name: The resource name of the setting. Must be in one of the
//     following forms: *
//     `projects/{project_number}/settings/{setting_name}` *
//     `folders/{folder_id}/settings/{setting_name}` *
//     `organizations/{organization_id}/settings/{setting_name}` For
//     example, "/projects/123/settings/gcp-enableMyFeature".
func (r *OrganizationsSettingsService) Patch(name string, googlecloudresourcesettingsv1setting *GoogleCloudResourcesettingsV1Setting) *OrganizationsSettingsPatchCall {
	c := &OrganizationsSettingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudresourcesettingsv1setting = googlecloudresourcesettingsv1setting
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsSettingsPatchCall) Fields(s ...googleapi.Field) *OrganizationsSettingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsSettingsPatchCall) Context(ctx context.Context) *OrganizationsSettingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsSettingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsSettingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudresourcesettingsv1setting)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.organizations.settings.patch" call.
// Exactly one of *GoogleCloudResourcesettingsV1Setting or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudResourcesettingsV1Setting.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsSettingsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1Setting, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1Setting{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a specified setting. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the setting does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if the setting is flagged as read only. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the setting value. On success, the response will contain only `name`, `local_value` and `etag`. The `metadata` and `effective_value` cannot be updated through this API. Note: the supplied setting will perform a full overwrite of the `local_value` field.",
	//   "flatPath": "v1/organizations/{organizationsId}/settings/{settingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "resourcesettings.organizations.settings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the setting. Must be in one of the following forms: * `projects/{project_number}/settings/{setting_name}` * `folders/{folder_id}/settings/{setting_name}` * `organizations/{organization_id}/settings/{setting_name}` For example, \"/projects/123/settings/gcp-enableMyFeature\"",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/settings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "resourcesettings.projects.settings.get":

type ProjectsSettingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns a specified setting. Returns a `google.rpc.Status` with
// `google.rpc.Code.NOT_FOUND` if the setting does not exist.
//
//   - name: The name of the setting to get. See Setting for naming
//     requirements.
func (r *ProjectsSettingsService) Get(name string) *ProjectsSettingsGetCall {
	c := &ProjectsSettingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The SettingView for this
// request.
//
// Possible values:
//
//	"SETTING_VIEW_UNSPECIFIED" - The default / unset value. The API
//
// will default to the SETTING_VIEW_BASIC view.
//
//	"SETTING_VIEW_BASIC" - Include Setting.metadata, but nothing else.
//
// This is the default value (for both ListSettings and GetSetting).
//
//	"SETTING_VIEW_EFFECTIVE_VALUE" - Include Setting.effective_value,
//
// but nothing else.
//
//	"SETTING_VIEW_LOCAL_VALUE" - Include Setting.local_value, but
//
// nothing else.
func (c *ProjectsSettingsGetCall) View(view string) *ProjectsSettingsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsSettingsGetCall) Fields(s ...googleapi.Field) *ProjectsSettingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsSettingsGetCall) IfNoneMatch(entityTag string) *ProjectsSettingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsSettingsGetCall) Context(ctx context.Context) *ProjectsSettingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsSettingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSettingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.projects.settings.get" call.
// Exactly one of *GoogleCloudResourcesettingsV1Setting or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudResourcesettingsV1Setting.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsSettingsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1Setting, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1Setting{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a specified setting. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the setting does not exist.",
	//   "flatPath": "v1/projects/{projectsId}/settings/{settingsId}",
	//   "httpMethod": "GET",
	//   "id": "resourcesettings.projects.settings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the setting to get. See Setting for naming requirements.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/settings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The SettingView for this request.",
	//       "enum": [
	//         "SETTING_VIEW_UNSPECIFIED",
	//         "SETTING_VIEW_BASIC",
	//         "SETTING_VIEW_EFFECTIVE_VALUE",
	//         "SETTING_VIEW_LOCAL_VALUE"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value. The API will default to the SETTING_VIEW_BASIC view.",
	//         "Include Setting.metadata, but nothing else. This is the default value (for both ListSettings and GetSetting).",
	//         "Include Setting.effective_value, but nothing else.",
	//         "Include Setting.local_value, but nothing else."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "resourcesettings.projects.settings.list":

type ProjectsSettingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the settings that are available on the Cloud resource
// `parent`.
//
//   - parent: The project, folder, or organization that is the parent
//     resource for this setting. Must be in one of the following forms: *
//     `projects/{project_number}` * `projects/{project_id}` *
//     `folders/{folder_id}` * `organizations/{organization_id}`.
func (r *ProjectsSettingsService) List(parent string) *ProjectsSettingsListCall {
	c := &ProjectsSettingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Unused. The size of
// the page to be returned.
func (c *ProjectsSettingsListCall) PageSize(pageSize int64) *ProjectsSettingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Unused. A page
// token used to retrieve the next page.
func (c *ProjectsSettingsListCall) PageToken(pageToken string) *ProjectsSettingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The SettingView for this
// request.
//
// Possible values:
//
//	"SETTING_VIEW_UNSPECIFIED" - The default / unset value. The API
//
// will default to the SETTING_VIEW_BASIC view.
//
//	"SETTING_VIEW_BASIC" - Include Setting.metadata, but nothing else.
//
// This is the default value (for both ListSettings and GetSetting).
//
//	"SETTING_VIEW_EFFECTIVE_VALUE" - Include Setting.effective_value,
//
// but nothing else.
//
//	"SETTING_VIEW_LOCAL_VALUE" - Include Setting.local_value, but
//
// nothing else.
func (c *ProjectsSettingsListCall) View(view string) *ProjectsSettingsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsSettingsListCall) Fields(s ...googleapi.Field) *ProjectsSettingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsSettingsListCall) IfNoneMatch(entityTag string) *ProjectsSettingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsSettingsListCall) Context(ctx context.Context) *ProjectsSettingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsSettingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSettingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.projects.settings.list" call.
// Exactly one of *GoogleCloudResourcesettingsV1ListSettingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudResourcesettingsV1ListSettingsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsSettingsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1ListSettingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1ListSettingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the settings that are available on the Cloud resource `parent`.",
	//   "flatPath": "v1/projects/{projectsId}/settings",
	//   "httpMethod": "GET",
	//   "id": "resourcesettings.projects.settings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Unused. The size of the page to be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Unused. A page token used to retrieve the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The project, folder, or organization that is the parent resource for this setting. Must be in one of the following forms: * `projects/{project_number}` * `projects/{project_id}` * `folders/{folder_id}` * `organizations/{organization_id}`",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The SettingView for this request.",
	//       "enum": [
	//         "SETTING_VIEW_UNSPECIFIED",
	//         "SETTING_VIEW_BASIC",
	//         "SETTING_VIEW_EFFECTIVE_VALUE",
	//         "SETTING_VIEW_LOCAL_VALUE"
	//       ],
	//       "enumDescriptions": [
	//         "The default / unset value. The API will default to the SETTING_VIEW_BASIC view.",
	//         "Include Setting.metadata, but nothing else. This is the default value (for both ListSettings and GetSetting).",
	//         "Include Setting.effective_value, but nothing else.",
	//         "Include Setting.local_value, but nothing else."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/settings",
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1ListSettingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsSettingsListCall) Pages(ctx context.Context, f func(*GoogleCloudResourcesettingsV1ListSettingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "resourcesettings.projects.settings.patch":

type ProjectsSettingsPatchCall struct {
	s                                    *Service
	name                                 string
	googlecloudresourcesettingsv1setting *GoogleCloudResourcesettingsV1Setting
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// Patch: Updates a specified setting. Returns a `google.rpc.Status`
// with `google.rpc.Code.NOT_FOUND` if the setting does not exist.
// Returns a `google.rpc.Status` with
// `google.rpc.Code.FAILED_PRECONDITION` if the setting is flagged as
// read only. Returns a `google.rpc.Status` with
// `google.rpc.Code.ABORTED` if the etag supplied in the request does
// not match the persisted etag of the setting value. On success, the
// response will contain only `name`, `local_value` and `etag`. The
// `metadata` and `effective_value` cannot be updated through this API.
// Note: the supplied setting will perform a full overwrite of the
// `local_value` field.
//
//   - name: The resource name of the setting. Must be in one of the
//     following forms: *
//     `projects/{project_number}/settings/{setting_name}` *
//     `folders/{folder_id}/settings/{setting_name}` *
//     `organizations/{organization_id}/settings/{setting_name}` For
//     example, "/projects/123/settings/gcp-enableMyFeature".
func (r *ProjectsSettingsService) Patch(name string, googlecloudresourcesettingsv1setting *GoogleCloudResourcesettingsV1Setting) *ProjectsSettingsPatchCall {
	c := &ProjectsSettingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudresourcesettingsv1setting = googlecloudresourcesettingsv1setting
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsSettingsPatchCall) Fields(s ...googleapi.Field) *ProjectsSettingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsSettingsPatchCall) Context(ctx context.Context) *ProjectsSettingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsSettingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsSettingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudresourcesettingsv1setting)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "resourcesettings.projects.settings.patch" call.
// Exactly one of *GoogleCloudResourcesettingsV1Setting or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudResourcesettingsV1Setting.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsSettingsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudResourcesettingsV1Setting, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudResourcesettingsV1Setting{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a specified setting. Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the setting does not exist. Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if the setting is flagged as read only. Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag supplied in the request does not match the persisted etag of the setting value. On success, the response will contain only `name`, `local_value` and `etag`. The `metadata` and `effective_value` cannot be updated through this API. Note: the supplied setting will perform a full overwrite of the `local_value` field.",
	//   "flatPath": "v1/projects/{projectsId}/settings/{settingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "resourcesettings.projects.settings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the setting. Must be in one of the following forms: * `projects/{project_number}/settings/{setting_name}` * `folders/{folder_id}/settings/{setting_name}` * `organizations/{organization_id}/settings/{setting_name}` For example, \"/projects/123/settings/gcp-enableMyFeature\"",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/settings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudResourcesettingsV1Setting"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
