// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package ecs_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ecs"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleECS_CreateCluster() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.CreateClusterInput{
		ClusterName: aws.String("String"),
	}
	resp, err := svc.CreateCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_CreateService() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.CreateServiceInput{
		DesiredCount:   aws.Int64(1),         // Required
		ServiceName:    aws.String("String"), // Required
		TaskDefinition: aws.String("String"), // Required
		ClientToken:    aws.String("String"),
		Cluster:        aws.String("String"),
		DeploymentConfiguration: &ecs.DeploymentConfiguration{
			MaximumPercent:        aws.Int64(1),
			MinimumHealthyPercent: aws.Int64(1),
		},
		LoadBalancers: []*ecs.LoadBalancer{
			{ // Required
				ContainerName:    aws.String("String"),
				ContainerPort:    aws.Int64(1),
				LoadBalancerName: aws.String("String"),
				TargetGroupArn:   aws.String("String"),
			},
			// More values...
		},
		PlacementConstraints: []*ecs.PlacementConstraint{
			{ // Required
				Expression: aws.String("String"),
				Type:       aws.String("PlacementConstraintType"),
			},
			// More values...
		},
		PlacementStrategy: []*ecs.PlacementStrategy{
			{ // Required
				Field: aws.String("String"),
				Type:  aws.String("PlacementStrategyType"),
			},
			// More values...
		},
		Role: aws.String("String"),
	}
	resp, err := svc.CreateService(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DeleteAttributes() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DeleteAttributesInput{
		Attributes: []*ecs.Attribute{ // Required
			{ // Required
				Name:       aws.String("String"), // Required
				TargetId:   aws.String("String"),
				TargetType: aws.String("TargetType"),
				Value:      aws.String("String"),
			},
			// More values...
		},
		Cluster: aws.String("String"),
	}
	resp, err := svc.DeleteAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DeleteCluster() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DeleteClusterInput{
		Cluster: aws.String("String"), // Required
	}
	resp, err := svc.DeleteCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DeleteService() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DeleteServiceInput{
		Service: aws.String("String"), // Required
		Cluster: aws.String("String"),
	}
	resp, err := svc.DeleteService(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DeregisterContainerInstance() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DeregisterContainerInstanceInput{
		ContainerInstance: aws.String("String"), // Required
		Cluster:           aws.String("String"),
		Force:             aws.Bool(true),
	}
	resp, err := svc.DeregisterContainerInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DeregisterTaskDefinition() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DeregisterTaskDefinitionInput{
		TaskDefinition: aws.String("String"), // Required
	}
	resp, err := svc.DeregisterTaskDefinition(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DescribeClusters() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DescribeClustersInput{
		Clusters: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeClusters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DescribeContainerInstances() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DescribeContainerInstancesInput{
		ContainerInstances: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Cluster: aws.String("String"),
	}
	resp, err := svc.DescribeContainerInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DescribeServices() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DescribeServicesInput{
		Services: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Cluster: aws.String("String"),
	}
	resp, err := svc.DescribeServices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DescribeTaskDefinition() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DescribeTaskDefinitionInput{
		TaskDefinition: aws.String("String"), // Required
	}
	resp, err := svc.DescribeTaskDefinition(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DescribeTasks() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DescribeTasksInput{
		Tasks: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Cluster: aws.String("String"),
	}
	resp, err := svc.DescribeTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_DiscoverPollEndpoint() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.DiscoverPollEndpointInput{
		Cluster:           aws.String("String"),
		ContainerInstance: aws.String("String"),
	}
	resp, err := svc.DiscoverPollEndpoint(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListAttributes() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListAttributesInput{
		TargetType:     aws.String("TargetType"), // Required
		AttributeName:  aws.String("String"),
		AttributeValue: aws.String("String"),
		Cluster:        aws.String("String"),
		MaxResults:     aws.Int64(1),
		NextToken:      aws.String("String"),
	}
	resp, err := svc.ListAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListClusters() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListClustersInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.ListClusters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListContainerInstances() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListContainerInstancesInput{
		Cluster:    aws.String("String"),
		Filter:     aws.String("String"),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		Status:     aws.String("ContainerInstanceStatus"),
	}
	resp, err := svc.ListContainerInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListServices() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListServicesInput{
		Cluster:    aws.String("String"),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.ListServices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListTaskDefinitionFamilies() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListTaskDefinitionFamiliesInput{
		FamilyPrefix: aws.String("String"),
		MaxResults:   aws.Int64(1),
		NextToken:    aws.String("String"),
		Status:       aws.String("TaskDefinitionFamilyStatus"),
	}
	resp, err := svc.ListTaskDefinitionFamilies(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListTaskDefinitions() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListTaskDefinitionsInput{
		FamilyPrefix: aws.String("String"),
		MaxResults:   aws.Int64(1),
		NextToken:    aws.String("String"),
		Sort:         aws.String("SortOrder"),
		Status:       aws.String("TaskDefinitionStatus"),
	}
	resp, err := svc.ListTaskDefinitions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_ListTasks() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.ListTasksInput{
		Cluster:           aws.String("String"),
		ContainerInstance: aws.String("String"),
		DesiredStatus:     aws.String("DesiredStatus"),
		Family:            aws.String("String"),
		MaxResults:        aws.Int64(1),
		NextToken:         aws.String("String"),
		ServiceName:       aws.String("String"),
		StartedBy:         aws.String("String"),
	}
	resp, err := svc.ListTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_PutAttributes() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.PutAttributesInput{
		Attributes: []*ecs.Attribute{ // Required
			{ // Required
				Name:       aws.String("String"), // Required
				TargetId:   aws.String("String"),
				TargetType: aws.String("TargetType"),
				Value:      aws.String("String"),
			},
			// More values...
		},
		Cluster: aws.String("String"),
	}
	resp, err := svc.PutAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_RegisterContainerInstance() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.RegisterContainerInstanceInput{
		Attributes: []*ecs.Attribute{
			{ // Required
				Name:       aws.String("String"), // Required
				TargetId:   aws.String("String"),
				TargetType: aws.String("TargetType"),
				Value:      aws.String("String"),
			},
			// More values...
		},
		Cluster:                           aws.String("String"),
		ContainerInstanceArn:              aws.String("String"),
		InstanceIdentityDocument:          aws.String("String"),
		InstanceIdentityDocumentSignature: aws.String("String"),
		TotalResources: []*ecs.Resource{
			{ // Required
				DoubleValue:  aws.Float64(1.0),
				IntegerValue: aws.Int64(1),
				LongValue:    aws.Int64(1),
				Name:         aws.String("String"),
				StringSetValue: []*string{
					aws.String("String"), // Required
					// More values...
				},
				Type: aws.String("String"),
			},
			// More values...
		},
		VersionInfo: &ecs.VersionInfo{
			AgentHash:     aws.String("String"),
			AgentVersion:  aws.String("String"),
			DockerVersion: aws.String("String"),
		},
	}
	resp, err := svc.RegisterContainerInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_RegisterTaskDefinition() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.RegisterTaskDefinitionInput{
		ContainerDefinitions: []*ecs.ContainerDefinition{ // Required
			{ // Required
				Command: []*string{
					aws.String("String"), // Required
					// More values...
				},
				Cpu:               aws.Int64(1),
				DisableNetworking: aws.Bool(true),
				DnsSearchDomains: []*string{
					aws.String("String"), // Required
					// More values...
				},
				DnsServers: []*string{
					aws.String("String"), // Required
					// More values...
				},
				DockerLabels: map[string]*string{
					"Key": aws.String("String"), // Required
					// More values...
				},
				DockerSecurityOptions: []*string{
					aws.String("String"), // Required
					// More values...
				},
				EntryPoint: []*string{
					aws.String("String"), // Required
					// More values...
				},
				Environment: []*ecs.KeyValuePair{
					{ // Required
						Name:  aws.String("String"),
						Value: aws.String("String"),
					},
					// More values...
				},
				Essential: aws.Bool(true),
				ExtraHosts: []*ecs.HostEntry{
					{ // Required
						Hostname:  aws.String("String"), // Required
						IpAddress: aws.String("String"), // Required
					},
					// More values...
				},
				Hostname: aws.String("String"),
				Image:    aws.String("String"),
				Links: []*string{
					aws.String("String"), // Required
					// More values...
				},
				LogConfiguration: &ecs.LogConfiguration{
					LogDriver: aws.String("LogDriver"), // Required
					Options: map[string]*string{
						"Key": aws.String("String"), // Required
						// More values...
					},
				},
				Memory:            aws.Int64(1),
				MemoryReservation: aws.Int64(1),
				MountPoints: []*ecs.MountPoint{
					{ // Required
						ContainerPath: aws.String("String"),
						ReadOnly:      aws.Bool(true),
						SourceVolume:  aws.String("String"),
					},
					// More values...
				},
				Name: aws.String("String"),
				PortMappings: []*ecs.PortMapping{
					{ // Required
						ContainerPort: aws.Int64(1),
						HostPort:      aws.Int64(1),
						Protocol:      aws.String("TransportProtocol"),
					},
					// More values...
				},
				Privileged:             aws.Bool(true),
				ReadonlyRootFilesystem: aws.Bool(true),
				Ulimits: []*ecs.Ulimit{
					{ // Required
						HardLimit: aws.Int64(1),             // Required
						Name:      aws.String("UlimitName"), // Required
						SoftLimit: aws.Int64(1),             // Required
					},
					// More values...
				},
				User: aws.String("String"),
				VolumesFrom: []*ecs.VolumeFrom{
					{ // Required
						ReadOnly:        aws.Bool(true),
						SourceContainer: aws.String("String"),
					},
					// More values...
				},
				WorkingDirectory: aws.String("String"),
			},
			// More values...
		},
		Family:      aws.String("String"), // Required
		NetworkMode: aws.String("NetworkMode"),
		PlacementConstraints: []*ecs.TaskDefinitionPlacementConstraint{
			{ // Required
				Expression: aws.String("String"),
				Type:       aws.String("TaskDefinitionPlacementConstraintType"),
			},
			// More values...
		},
		TaskRoleArn: aws.String("String"),
		Volumes: []*ecs.Volume{
			{ // Required
				Host: &ecs.HostVolumeProperties{
					SourcePath: aws.String("String"),
				},
				Name: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.RegisterTaskDefinition(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_RunTask() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.RunTaskInput{
		TaskDefinition: aws.String("String"), // Required
		Cluster:        aws.String("String"),
		Count:          aws.Int64(1),
		Group:          aws.String("String"),
		Overrides: &ecs.TaskOverride{
			ContainerOverrides: []*ecs.ContainerOverride{
				{ // Required
					Command: []*string{
						aws.String("String"), // Required
						// More values...
					},
					Environment: []*ecs.KeyValuePair{
						{ // Required
							Name:  aws.String("String"),
							Value: aws.String("String"),
						},
						// More values...
					},
					Name: aws.String("String"),
				},
				// More values...
			},
			TaskRoleArn: aws.String("String"),
		},
		PlacementConstraints: []*ecs.PlacementConstraint{
			{ // Required
				Expression: aws.String("String"),
				Type:       aws.String("PlacementConstraintType"),
			},
			// More values...
		},
		PlacementStrategy: []*ecs.PlacementStrategy{
			{ // Required
				Field: aws.String("String"),
				Type:  aws.String("PlacementStrategyType"),
			},
			// More values...
		},
		StartedBy: aws.String("String"),
	}
	resp, err := svc.RunTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_StartTask() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.StartTaskInput{
		ContainerInstances: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		TaskDefinition: aws.String("String"), // Required
		Cluster:        aws.String("String"),
		Group:          aws.String("String"),
		Overrides: &ecs.TaskOverride{
			ContainerOverrides: []*ecs.ContainerOverride{
				{ // Required
					Command: []*string{
						aws.String("String"), // Required
						// More values...
					},
					Environment: []*ecs.KeyValuePair{
						{ // Required
							Name:  aws.String("String"),
							Value: aws.String("String"),
						},
						// More values...
					},
					Name: aws.String("String"),
				},
				// More values...
			},
			TaskRoleArn: aws.String("String"),
		},
		StartedBy: aws.String("String"),
	}
	resp, err := svc.StartTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_StopTask() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.StopTaskInput{
		Task:    aws.String("String"), // Required
		Cluster: aws.String("String"),
		Reason:  aws.String("String"),
	}
	resp, err := svc.StopTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_SubmitContainerStateChange() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.SubmitContainerStateChangeInput{
		Cluster:       aws.String("String"),
		ContainerName: aws.String("String"),
		ExitCode:      aws.Int64(1),
		NetworkBindings: []*ecs.NetworkBinding{
			{ // Required
				BindIP:        aws.String("String"),
				ContainerPort: aws.Int64(1),
				HostPort:      aws.Int64(1),
				Protocol:      aws.String("TransportProtocol"),
			},
			// More values...
		},
		Reason: aws.String("String"),
		Status: aws.String("String"),
		Task:   aws.String("String"),
	}
	resp, err := svc.SubmitContainerStateChange(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_SubmitTaskStateChange() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.SubmitTaskStateChangeInput{
		Cluster: aws.String("String"),
		Reason:  aws.String("String"),
		Status:  aws.String("String"),
		Task:    aws.String("String"),
	}
	resp, err := svc.SubmitTaskStateChange(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_UpdateContainerAgent() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.UpdateContainerAgentInput{
		ContainerInstance: aws.String("String"), // Required
		Cluster:           aws.String("String"),
	}
	resp, err := svc.UpdateContainerAgent(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_UpdateContainerInstancesState() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.UpdateContainerInstancesStateInput{
		ContainerInstances: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Status:  aws.String("ContainerInstanceStatus"), // Required
		Cluster: aws.String("String"),
	}
	resp, err := svc.UpdateContainerInstancesState(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleECS_UpdateService() {
	sess := session.Must(session.NewSession())

	svc := ecs.New(sess)

	params := &ecs.UpdateServiceInput{
		Service: aws.String("String"), // Required
		Cluster: aws.String("String"),
		DeploymentConfiguration: &ecs.DeploymentConfiguration{
			MaximumPercent:        aws.Int64(1),
			MinimumHealthyPercent: aws.Int64(1),
		},
		DesiredCount:   aws.Int64(1),
		TaskDefinition: aws.String("String"),
	}
	resp, err := svc.UpdateService(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
