(contributors)=

# Contributors

Numerous organizations, companies, and individuals have contributed time,
money, and code to build PDAL up into a highly capable software package.
Without these contributions, PDAL would not progress as quickly, and its
quality wouldn't be as high. The development team is proud of the software, and
it collectively represents years of experiences doing point cloud data
management. We hope you'll find it useful too.

This page is to recognize these contributors and their contributions. Thanks.

## Engineering Contributors

```{image} https://hobu.co/theme/images/hobulogo.png
:target: http://hobu.co
```

[Hobu] is the primary company behind the design, testing, development, and
distribution of PDAL. Two Hobu team members primarily interact with PDAL.
[Howard Butler] founded the project, and he provides project leadership and
software development.  [Andrew Bell] has contributed design, refactoring, and
new feature development of PDAL over the past couple of years.

[Michael Gerlek] helped bootstrap PDAL by providing its first design, basic
primitive objects, and first stage implementations.

```{image} ./GCS_SmallLogo.png
:target: https://grovercsllc.com/
:width: 300px
```

[Bradley Chambers] from [Grover Consulting Services] has contributed numerous
features and capabilities to the PDAL project, including {ref}`Poisson sampling
<filters.sample>` and classification filters such as
{ref}`the SMRF filter<filters.smrf>`.  He is also a prolific {ref}`tutorial` writer.

## Funding Contributors

```{image} ../development/rsgis_logo.png
:target: https://www.erdc.usace.army.mil/Locations/CRREL/
```

The US Army Corps of Engineers Remote Sensing / GIS Center of Expertise at
[CRREL] sponsors development of PDAL for its use in point cloud data
management systems. [CRREL]'s [GRiD] project manages LiDAR and point cloud
data for a multitude of U.S. Army Corps missions. Find out more about GRiD in
this [LiDAR Magazine article].

```{image} ../development/nsf1.png
:target: https://www.nsf.gov
```

```{image} ../development/uoh.png
:target: http://www.uh.edu
```

[NSF](http://www.nsf.gov), in collaboration with [Dr. Craig Glennie](https://www.cive.uh.edu/faculty/glennie) at the [University of Houston](https://www.uh.edu) supports PDAL with funding support to develop and enhance
statistical methods, transformation operations, tutorial and example
development, and [PCL](https://pointclouds.org) integration.

[andrew bell]: https://github.com/abellgithub
[bradley chambers]: https://github.com/chambbj
[crrel]: http://www.erdc.usace.army.mil/Locations/CRREL.aspx
[grid]: http://lidar.io/about.html
[grover consulting services]: https://grovercsllc.com/
[hobu]: https://hobu.co
[howard butler]: https://github.com/hobu
[lidar magazine article]: http://www.lidarmag.com/content/view/11343/198/
[michael gerlek]: http://github.com/mpgerlek
