/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar;

import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.UnaryExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.util.StringPair;
import java.io.Serializable;
import org.relaxng.datatype.Datatype;

public class ExpressionPool
implements Serializable {
    private final ClosedHash expTable;
    static /* synthetic */ Class class$com$sun$msv$grammar$ChoiceExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$SequenceExp;

    public final Expression createAttribute(NameClass nameClass) {
        return this.unify(new AttributeExp(nameClass, Expression.anyString));
    }

    public final Expression createAttribute(NameClass nameClass, Expression expression) {
        if (expression == Expression.nullSet) {
            return expression;
        }
        return this.unify(new AttributeExp(nameClass, expression));
    }

    public final Expression createEpsilon() {
        return Expression.epsilon;
    }

    public final Expression createNullSet() {
        return Expression.nullSet;
    }

    public final Expression createAnyString() {
        return Expression.anyString;
    }

    public final Expression createChoice(Expression expression, Expression expression2) {
        Expression expression3;
        if (expression == Expression.nullSet) {
            return expression2;
        }
        if (expression2 == Expression.nullSet) {
            return expression;
        }
        if (expression == Expression.epsilon && expression2.isEpsilonReducible()) {
            return expression2;
        }
        if (expression2 == Expression.epsilon && expression.isEpsilonReducible()) {
            return expression;
        }
        if (expression2 instanceof ChoiceExp) {
            ChoiceExp choiceExp = (ChoiceExp)expression2;
            return this.createChoice(this.createChoice(expression, choiceExp.exp1), choiceExp.exp2);
        }
        Expression expression4 = expression;
        while (true) {
            if (expression4 == expression2) {
                return expression;
            }
            if (!(expression4 instanceof ChoiceExp)) break;
            expression3 = (ChoiceExp)expression4;
            if (expression3.exp2 == expression2) {
                return expression;
            }
            expression4 = expression3.exp1;
        }
        expression3 = this.expTable.get(Expression.hashCode(expression, expression2, 2), expression, expression2, class$com$sun$msv$grammar$ChoiceExp == null ? (class$com$sun$msv$grammar$ChoiceExp = ExpressionPool.class$("com.sun.msv.grammar.ChoiceExp")) : class$com$sun$msv$grammar$ChoiceExp);
        if (expression3 == null) {
            return this.unify(new ChoiceExp(expression, expression2));
        }
        return expression3;
    }

    public final Expression createOneOrMore(Expression expression) {
        if (expression == Expression.epsilon || expression == Expression.anyString || expression == Expression.nullSet || expression instanceof OneOrMoreExp) {
            return expression;
        }
        return this.unify(new OneOrMoreExp(expression));
    }

    public final Expression createZeroOrMore(Expression expression) {
        return this.createOptional(this.createOneOrMore(expression));
    }

    public final Expression createOptional(Expression expression) {
        return this.createChoice(expression, Expression.epsilon);
    }

    public final Expression createData(XSDatatype xSDatatype) {
        return this.createData(xSDatatype, new StringPair("", xSDatatype.displayName()));
    }

    public final Expression createData(Datatype datatype, StringPair stringPair) {
        return this.createData(datatype, stringPair, Expression.nullSet);
    }

    public final Expression createData(Datatype datatype, StringPair stringPair, Expression expression) {
        return this.unify(new DataExp(datatype, stringPair, expression));
    }

    public final Expression createValue(Datatype datatype, StringPair stringPair, Object object) {
        return this.unify(new ValueExp(datatype, stringPair, object));
    }

    public final Expression createList(Expression expression) {
        return this.unify(new ListExp(expression));
    }

    public final Expression createMixed(Expression expression) {
        if (expression == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression == Expression.epsilon) {
            return Expression.anyString;
        }
        return this.unify(new MixedExp(expression));
    }

    public final Expression createSequence(Expression expression, Expression expression2) {
        if (expression == Expression.nullSet || expression2 == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression == Expression.epsilon) {
            return expression2;
        }
        if (expression2 == Expression.epsilon) {
            return expression;
        }
        if (expression2 instanceof SequenceExp) {
            SequenceExp sequenceExp = (SequenceExp)expression2;
            return this.createSequence(this.createSequence(expression, sequenceExp.exp1), sequenceExp.exp2);
        }
        Expression expression3 = this.expTable.get(Expression.hashCode(expression, expression2, 5), expression, expression2, class$com$sun$msv$grammar$SequenceExp == null ? (class$com$sun$msv$grammar$SequenceExp = ExpressionPool.class$("com.sun.msv.grammar.SequenceExp")) : class$com$sun$msv$grammar$SequenceExp);
        if (expression3 == null) {
            return this.unify(new SequenceExp(expression, expression2));
        }
        return expression3;
    }

    public final Expression createConcur(Expression expression, Expression expression2) {
        if (expression == Expression.nullSet || expression2 == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression == Expression.epsilon) {
            if (expression2.isEpsilonReducible()) {
                return Expression.epsilon;
            }
            return Expression.nullSet;
        }
        if (expression2 == Expression.epsilon) {
            if (expression.isEpsilonReducible()) {
                return Expression.epsilon;
            }
            return Expression.nullSet;
        }
        if (expression2 instanceof ConcurExp) {
            ConcurExp concurExp = (ConcurExp)expression2;
            return this.createConcur(this.createConcur(expression, concurExp.exp1), concurExp.exp2);
        }
        return this.unify(new ConcurExp(expression, expression2));
    }

    public final Expression createInterleave(Expression expression, Expression expression2) {
        if (expression == Expression.epsilon) {
            return expression2;
        }
        if (expression2 == Expression.epsilon) {
            return expression;
        }
        if (expression == Expression.nullSet || expression2 == Expression.nullSet) {
            return Expression.nullSet;
        }
        if (expression2 instanceof InterleaveExp) {
            InterleaveExp interleaveExp = (InterleaveExp)expression2;
            return this.createInterleave(this.createInterleave(expression, interleaveExp.exp1), interleaveExp.exp2);
        }
        return this.unify(new InterleaveExp(expression, expression2));
    }

    public ExpressionPool(ExpressionPool expressionPool) {
        this.expTable = new ClosedHash(expressionPool.expTable);
    }

    public ExpressionPool() {
        this.expTable = new ClosedHash();
    }

    protected final Expression unify(Expression expression) {
        Expression expression2 = this.expTable.get(expression);
        if (expression2 == null) {
            ClosedHash closedHash = this.expTable;
            synchronized (closedHash) {
                expression2 = this.expTable.get(expression);
                if (expression2 == null) {
                    this.expTable.put(expression);
                    Expression expression3 = expression;
                    return expression3;
                }
            }
        }
        return expression2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class ClosedHash
    implements Serializable {
        private Expression[] table = new Expression[191];
        private int count;
        private int threshold = 57;
        private static final float loadFactor = 0.3f;
        private static final int initialCapacity = 191;
        private final ClosedHash parent;

        public ClosedHash() {
            this(null);
        }

        public ClosedHash(ClosedHash closedHash) {
            this.parent = closedHash;
        }

        public Expression get(int n, Expression expression, Expression expression2, Class clazz) {
            Object object;
            if (this.parent != null && (object = this.parent.get(n, expression, expression2, clazz)) != null) {
                return object;
            }
            object = this.table;
            int n2 = (n & Integer.MAX_VALUE) % ((Expression[])object).length;
            Expression expression3;
            while ((expression3 = object[n2]) != null) {
                if (expression3.hashCode() == n && expression3.getClass() == clazz) {
                    BinaryExp binaryExp = (BinaryExp)expression3;
                    if (binaryExp.exp1 == expression && binaryExp.exp2 == expression2) {
                        return binaryExp;
                    }
                }
                n2 = (n2 + 1) % ((Expression[])object).length;
            }
            return null;
        }

        public Expression get(int n, Expression expression, Class clazz) {
            Object object;
            if (this.parent != null && (object = this.parent.get(n, expression, clazz)) != null) {
                return object;
            }
            object = this.table;
            int n2 = (n & Integer.MAX_VALUE) % ((Expression[])object).length;
            Expression expression2;
            while ((expression2 = object[n2]) != null) {
                if (expression2.hashCode() == n && expression2.getClass() == clazz) {
                    UnaryExp unaryExp = (UnaryExp)expression2;
                    if (unaryExp.exp == expression) {
                        return unaryExp;
                    }
                }
                n2 = (n2 + 1) % ((Expression[])object).length;
            }
            return null;
        }

        public Expression get(Expression expression) {
            Object object;
            if (this.parent != null && (object = this.parent.get(expression)) != null) {
                return object;
            }
            object = this.table;
            int n = (expression.hashCode() & Integer.MAX_VALUE) % ((Expression[])object).length;
            Expression expression2;
            while ((expression2 = object[n]) != null) {
                if (expression2.equals(expression)) {
                    return expression2;
                }
                n = (n + 1) % ((Expression[])object).length;
            }
            return null;
        }

        private void rehash() {
            int n = this.table.length;
            Expression[] expressionArray = this.table;
            int n2 = n * 2 + 1;
            Expression[] expressionArray2 = new Expression[n2];
            int n3 = n;
            while (n3-- > 0) {
                if (expressionArray[n3] == null) continue;
                int n4 = (expressionArray[n3].hashCode() & Integer.MAX_VALUE) % expressionArray2.length;
                while (expressionArray2[n4] != null) {
                    n4 = (n4 + 1) % expressionArray2.length;
                }
                expressionArray2[n4] = expressionArray[n3];
            }
            this.threshold = (int)((float)n2 * 0.3f);
            this.table = expressionArray2;
        }

        public void put(Expression expression) {
            if (this.count >= this.threshold) {
                this.rehash();
            }
            Expression[] expressionArray = this.table;
            int n = (expression.hashCode() & Integer.MAX_VALUE) % expressionArray.length;
            while (expressionArray[n] != null) {
                n = (n + 1) % expressionArray.length;
            }
            expressionArray[n] = expression;
            ++this.count;
        }
    }
}

