/* -*-c-*-
 THIS FILE WAS AUTOGENERATED BY template/prelude.c.tmpl. DO NOT EDIT.

 sources: ./ast, ./dir, ./gc, ./numeric, ./io, ./marshal, ./mjit, ./mjit_c, ./pack, ./trace_point, ./warning, ./array, ./kernel, ./ractor, ./symbol, ./timev, ./thread_sync, ./nilclass, ./prelude, ./gem_prelude, ./yjit
*/
#include "internal.h"
#include "internal/warnings.h"
#include "iseq.h"
#include "ruby/ruby.h"
#include "vm_core.h"

COMPILER_WARNING_PUSH
#if __has_warning("-Wstring-concatenation")
COMPILER_WARNING_IGNORED(-Wstring-concatenation)
#endif

static const char prelude_name0[] = "<internal:ast>";
static const struct {
    char L0[477]; /* 1..95 */
    char L95[493]; /* 96..149 */
    char L149[504]; /* 150..193 */
    char L193[490]; /* 194..267 */
    char L267[163]; /* 268..277 */
} prelude_code0 = {
#line 1 "ast.rb"
""/* for ast.c */
""
""/* AbstractSyntaxTree provides methods to parse Ruby code into */
""/* abstract syntax trees. The nodes in the tree */
""/* are instances of RubyVM::AbstractSyntaxTree::Node. */
""/*  */
""/* This module is MRI specific as it exposes implementation details */
""/* of the MRI abstract syntax tree. */
""/*  */
""/* This module is experimental and its API is not stable, therefore it might */
""/* change without notice. As examples, the order of children nodes is not */
""/* guaranteed, the number of children nodes might change, there is no way to */
""/* access children nodes by name, etc. */
""/*  */
""/* If you are looking for a stable API or an API working under multiple Ruby */
""/* implementations, consider using the _parser_ gem or Ripper. If you would */
""/* like to make RubyVM::AbstractSyntaxTree stable, please join the discussion */
""/* at https://bugs.ruby-lang.org/issues/14844. */
""/*  */
"module RubyVM::AbstractSyntaxTree\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse(string, keep_script_lines: false, error_tolerant: false, keep_tokens: false) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*  Parses the given _string_ into an abstract syntax tree, */
"\n"/*  returning the root node of that tree. */
"\n"/*  */
"\n"/*    RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-1:9> */
"\n"/*  */
"\n"/*  If <tt>keep_script_lines: true</tt> option is provided, the text of the parsed */
"\n"/*  source is associated with nodes and is available via Node#script_lines. */
"\n"/*  */
"\n"/*  If <tt>keep_tokens: true</tt> option is provided, Node#tokens are populated. */
"\n"/*  */
"\n"/*  SyntaxError is raised if the given _string_ is invalid syntax. To overwrite this */
"\n"/*  behavior, <tt>error_tolerant: true</tt> can be provided. In this case, the parser */
"\n"/*  will produce a tree where expressions with syntax errors would be represented by */
"\n"/*  Node with <tt>type=:ERROR</tt>. */
"\n"/*  */
"\n"/*     root = RubyVM::AbstractSyntaxTree.parse("x = 1; p(x; y=2") */
"\n"/*     # <internal:ast>:33:in `parse': syntax error, unexpected ';', expecting ')' (SyntaxError) */
"\n"/*     # x = 1; p(x; y=2 */
"\n"/*     #           ^ */
"\n"/*  */
"\n"/*     root = RubyVM::AbstractSyntaxTree.parse("x = 1; p(x; y=2", error_tolerant: true) */
"\n"/*     # (SCOPE@1:0-1:15 */
"\n"/*     #  tbl: [:x, :y] */
"\n"/*     #  args: nil */
"\n"/*     #  body: (BLOCK@1:0-1:15 (LASGN@1:0-1:5 :x (LIT@1:4-1:5 1)) (ERROR@1:7-1:11) (LASGN@1:12-1:15 :y (LIT@1:14-1:15 2)))) */
"\n"/*     root.children.last.children */
"\n"/*     # [(LASGN@1:0-1:5 :x (LIT@1:4-1:5 1)), */
"\n"/*     #  (ERROR@1:7-1:11), */
"\n"/*     #  (LASGN@1:12-1:15 :y (LIT@1:14-1:15 2))] */
"\n"/*  */
"\n"/*  Note that parsing continues even after the errored expresion. */
"\n"/*  */
"  def self.parse string, keep_script_lines: false, error_tolerant: false, keep_tokens: false\n"
"    Primitive.ast_s_parse string, keep_script_lines, error_tolerant, keep_tokens\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file(pathname, keep_script_lines: false, error_tolerant: false, keep_tokens: false) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Reads the file from _pathname_, then parses it like ::parse, */
"\n"/*   returning the root node of the abstract syntax tree. */
"\n"/*  */
"\n"/*   SyntaxError is raised if _pathname_'s contents are not */
"\n"/*   valid Ruby syntax. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file("my-app/app.rb") */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-31:3> */
"\n"/*  */
"\n"/*   See ::parse for explanation of keyword argument meaning and usage. */
"  def self.parse_file pathname, keep_script_lines: false, error_tolerant: false, keep_tokens: false\n"
"    Primitive.ast_s_parse_file pathname, keep_script_lines, error_tolerant, keep_tokens\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc, keep_script_lines: false, error_tolerant: false, keep_tokens: false)   -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method, keep_script_lines: false, error_tolerant: false, keep_tokens: false) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Returns AST nodes of the given _proc_ or _method_. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc {1 + 2}) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:35-1:42> */
"\n"/*  */
"\n"/*     def hello */
"\n"/*       puts "hello, world" */
"\n"/*     end */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method(:hello)) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-3:3> */
"\n"/*  */
"\n"/*   See ::parse for explanation of keyword argument meaning and usage. */
,
#line 96 "ast.rb"
"  def self.of body, keep_script_lines: false, error_tolerant: false, keep_tokens: false\n"
"    Primitive.ast_s_of body, keep_script_lines, error_tolerant, keep_tokens\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.node_id_for_backtrace_location(backtrace_location)   -> integer */
"\n"/*  */
"\n"/*   Returns the node id for the given backtrace location. */
"\n"/*  */
"\n"/*     begin */
"\n"/*       raise */
"\n"/*     rescue =>  e */
"\n"/*       loc = e.backtrace_locations.first */
"\n"/*       RubyVM::AbstractSyntaxTree.node_id_for_backtrace_location(loc) */
"\n"/*     end # => 0 */
"  def self.node_id_for_backtrace_location backtrace_location\n"
"    Primitive.node_id_for_backtrace_location backtrace_location\n"
"  end\n"
"\n"
"\n"/* RubyVM::AbstractSyntaxTree::Node instances are created by parse methods in */
"\n"/* RubyVM::AbstractSyntaxTree. */
"\n"/*  */
"\n"/* This class is MRI specific. */
"\n"/*  */
"  class Node\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.type -> symbol */
"\n"/*  */
"\n"/*  Returns the type of this node as a symbol. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    root.type # => :SCOPE */
"\n"/*    lasgn = root.children[2] */
"\n"/*    lasgn.type # => :LASGN */
"\n"/*    call = lasgn.children[1] */
"\n"/*    call.type # => :OPCALL */
"    def type\n"
"      Primitive.ast_node_type\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text began. */
"    def first_lineno\n"
"      Primitive.ast_node_first_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text began. */
"    def first_column\n"
,
#line 150 "ast.rb"
"      Primitive.ast_node_first_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text ended. */
"    def last_lineno\n"
"      Primitive.ast_node_last_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text ended. */
"    def last_column\n"
"      Primitive.ast_node_last_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.tokens -> array */
"\n"/*  */
"\n"/*  Returns tokens corresponding to the location of the node. */
"\n"/*  Returns +nil+ if +keep_tokens+ is not enabled when #parse method is called. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse("x = 1 + 2", keep_tokens: true) */
"\n"/*    root.tokens # => [[0, :tIDENTIFIER, "x", [1, 0, 1, 1]], [1, :tSP, " ", [1, 1, 1, 2]], ...] */
"\n"/*    root.tokens.map{_1[2]}.join # => "x = 1 + 2" */
"\n"/*  */
"\n"/*  Token is an array of: */
"\n"/*  */
"\n"/*  - id */
"\n"/*  - token type */
"\n"/*  - source code text */
"\n"/*  - location [ first_lineno, first_column, last_lineno, last_column ] */
"    def tokens\n"
"      return nil unless all_tokens\n"
"\n"
"      all_tokens.each_with_object([]) do |token, a|\n"
"        loc = token.last\n"
"        if ([first_lineno, first_column] <=> [loc[0], loc[1]]) <= 0 &&\n"
"           ([last_lineno, last_column]   <=> [loc[2], loc[3]]) >= 0\n"
"           a << token\n"
"        end\n"
,
#line 194 "ast.rb"
"      end\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.all_tokens -> array */
"\n"/*  */
"\n"/*  Returns all tokens for the input script regardless the receiver node. */
"\n"/*  Returns +nil+ if +keep_tokens+ is not enabled when #parse method is called. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse("x = 1 + 2", keep_tokens: true) */
"\n"/*    root.all_tokens # => [[0, :tIDENTIFIER, "x", [1, 0, 1, 1]], [1, :tSP, " ", [1, 1, 1, 2]], ...] */
"\n"/*    root.children[-1].all_tokens # => [[0, :tIDENTIFIER, "x", [1, 0, 1, 1]], [1, :tSP, " ", [1, 1, 1, 2]], ...] */
"    def all_tokens\n"
"      Primitive.ast_node_all_tokens\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.children -> array */
"\n"/*  */
"\n"/*  Returns AST nodes under this one.  Each kind of node */
"\n"/*  has different children, depending on what kind of node it is. */
"\n"/*  */
"\n"/*  The returned array may contain other nodes or <code>nil</code>. */
"    def children\n"
"      Primitive.ast_node_children\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.inspect -> string */
"\n"/*  */
"\n"/*  Returns debugging information about this node as a string. */
"    def inspect\n"
"      Primitive.ast_node_inspect\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.node_id -> integer */
"\n"/*  */
"\n"/*  Returns an internal node_id number. */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def node_id\n"
"      Primitive.ast_node_node_id\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.script_lines -> array */
"\n"/*  */
"\n"/*  Returns the original source code as an array of lines. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def script_lines\n"
"      Primitive.ast_node_script_lines\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.source -> string */
"\n"/*  */
"\n"/*  Returns the code fragment that corresponds to this AST. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"\n"/*  */
"\n"/*  Also note that this API may return an incomplete code fragment */
"\n"/*  that does not parse; for example, a here document following */
"\n"/*  an expression may be dropped. */
"    def source\n"
"      lines = script_lines\n"
"      if lines\n"
"        lines = lines[first_lineno - 1 .. last_lineno - 1]\n"
,
#line 268 "ast.rb"
"        lines[-1] = lines[-1][0...last_column]\n"
"        lines[0] = lines[0][first_column..-1]\n"
"        lines.join\n"
"      else\n"
"        nil\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 311 "miniprelude.c"
};

static const char prelude_name1[] = "<internal:dir>";
static const struct {
    char L0[508]; /* 1..191 */
    char L191[350]; /* 192..315 */
} prelude_code1 = {
#line 1 "dir.rb"
""/* Objects of class Dir are directory streams representing */
""/* directories in the underlying file system. They provide a variety */
""/* of ways to list directories and their contents. See also File. */
""/*  */
""/* The directory used in these examples contains the two regular files */
""/* (<code>config.h</code> and <code>main.rb</code>), the parent */
""/* directory (<code>..</code>), and the directory itself */
""/* (<code>.</code>). */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \Class \Dir: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Enumerable}[rdoc-ref:Enumerable@What-27s+Here], */
""/*   which provides dozens of additional methods. */
""/*  */
""/* Here, class \Dir provides methods that are useful for: */
""/*  */
""/* - {Reading}[rdoc-ref:Dir@Reading] */
""/* - {Setting}[rdoc-ref:Dir@Setting] */
""/* - {Querying}[rdoc-ref:Dir@Querying] */
""/* - {Iterating}[rdoc-ref:Dir@Iterating] */
""/* - {Other}[rdoc-ref:Dir@Other] */
""/*  */
""/* === Reading */
""/*  */
""/* - #close: Closes the directory stream for +self+. */
""/* - #pos=: Sets the position in the directory stream for +self+. */
""/* - #read: Reads and returns the next entry in the directory stream for +self+. */
""/* - #rewind: Sets the position in the directory stream for +self+ to the first entry. */
""/* - #seek: Sets the position in the directory stream for +self+ */
""/*   the entry at the given offset. */
""/*  */
""/* === Setting */
""/*  */
""/* - ::chdir: Changes the working directory of the current process */
""/*   to the given directory. */
""/* - ::chroot: Changes the file-system root for the current process */
""/*   to the given directory. */
""/*  */
""/* === Querying */
""/*  */
""/* - ::[]: Same as ::glob without the ability to pass flags. */
""/* - ::children: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::empty?: Returns whether the given path is an empty directory. */
""/* - ::entries: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - ::exist?: Returns whether the given path is a directory. */
""/* - ::getwd (aliased as #pwd): Returns the path to the current working directory. */
""/* - ::glob: Returns an array of file paths matching the given pattern and flags. */
""/* - ::home: Returns the home directory path for a given user or the current user. */
""/* - #children: Returns an array of names of the children */
""/*   (both files and directories) of +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - #fileno: Returns the integer file descriptor for +self+. */
""/* - #path (aliased as #to_path): Returns the path used to create +self+. */
""/* - #tell (aliased as #pos): Returns the integer position */
""/*   in the directory stream for +self+. */
""/*  */
""/* === Iterating */
""/*  */
""/* - ::each_child: Calls the given block with each entry in the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::foreach: Calls the given block with each entry in the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each: Calls the given block with each entry in +self+, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each_child: Calls the given block with each entry in +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/*  */
""/* === Other */
""/*  */
""/* - ::mkdir: Creates a directory at the given path, with optional permissions. */
""/* - ::new: Returns a new \Dir for the given path, with optional encoding. */
""/* - ::open: Same as ::new, but if a block is given, yields the \Dir to the block, */
""/*   closing it upon block exit. */
""/* - ::unlink (aliased as ::delete and ::rmdir): Removes the given directory. */
""/* - #inspect: Returns a string description of +self+. */
"class Dir\n"
"\n"/* call-seq: */
"\n"/*    Dir.open( string ) -> aDir */
"\n"/*    Dir.open( string, encoding: enc ) -> aDir */
"\n"/*    Dir.open( string ) {| aDir | block } -> anObject */
"\n"/*    Dir.open( string, encoding: enc ) {| aDir | block } -> anObject */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"\n"/*  */
"\n"/* With no block, <code>open</code> is a synonym for Dir::new. If a */
"\n"/* block is present, it is passed <i>aDir</i> as a parameter. The */
"\n"/* directory is closed at the end of the block, and Dir::open returns */
"\n"/* the value of the block. */
"  def self.open(name, encoding: nil, &block)\n"
"    dir = Primitive.dir_s_open(name, encoding)\n"
"    if block\n"
"      begin\n"
"        yield dir\n"
"      ensure\n"
"        Primitive.dir_s_close(dir)\n"
"      end\n"
"    else\n"
"      dir\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir.new( string ) -> aDir */
"\n"/*    Dir.new( string, encoding: enc ) -> aDir */
"\n"/*  */
"\n"/* Returns a new directory object for the named directory. */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"  def initialize(name, encoding: nil)\n"
"    Primitive.dir_initialize(name, encoding)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir[ string [, string ...] [, base: path] [, sort: true] ] -> array */
"\n"/*  */
"\n"/* Equivalent to calling */
"\n"/* <code>Dir.glob([</code><i>string,...</i><code>], 0)</code>. */
"  def self.[](*args, base: nil, sort: true)\n"
"    Primitive.dir_s_aref(args, base, sort)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] )                       -> array */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] ) { |filename| block }  -> nil */
"\n"/*  */
"\n"/* Expands +pattern+, which is a pattern string or an Array of pattern */
"\n"/* strings, and returns an array containing the matching filenames. */
"\n"/* If a block is given, calls the block once for each matching filename, */
"\n"/* passing the filename as a parameter to the block. */
"\n"/*  */
"\n"/* The optional +base+ keyword argument specifies the base directory for */
"\n"/* interpreting relative pathnames instead of the current working directory. */
"\n"/* As the results are not prefixed with the base directory name in this */
"\n"/* case, you will need to prepend the base directory name if you want real */
"\n"/* paths. */
"\n"/*  */
"\n"/* The results which matched single wildcard or character set are sorted in */
"\n"/* binary ascending order, unless +false+ is given as the optional +sort+ */
"\n"/* keyword argument.  The order of an Array of pattern strings and braces */
"\n"/* are preserved. */
"\n"/*  */
"\n"/* Note that the pattern is not a regexp, it's closer to a shell glob. */
"\n"/* See File::fnmatch for the meaning of the +flags+ parameter. */
"\n"/* Case sensitivity depends on your system (+File::FNM_CASEFOLD+ is ignored). */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/mx</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::     Matches all files */
"\n"/*   <code>c*</code>::    Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::    Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c\*</code>:: Match all files that have <code>c</code> in them */
"\n"/*                        (including at the beginning or end). */
"\n"/*  */
"\n"/*   Note, this will not match Unix-like hidden files (dotfiles).  In order */
"\n"/*   to include those in the match results, you must use the */
"\n"/*   File::FNM_DOTMATCH flag or something like <code>"{*,.*}"</code>. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively if followed by <code>/</code>.  If */
"\n"/*   this path segment contains any other characters, it is the same as the */
"\n"/*   usual <code>*</code>. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>{p,q}</code>:: */
"\n"/*   Matches either literal <code>p</code> or literal <code>q</code>. */
"\n"/*   Equivalent to pattern alternation in regexp. */
"\n"/*  */
"\n"/*   Matching literals may be more than one character in length.  More than */
"\n"/*   two literals may be specified. */
"\n"/*  */
"\n"/* <code>\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/*   Note that this means you cannot use backslash on windows as part of a */
,
#line 192 "dir.rb"
"\n"/*   glob, i.e.  <code>Dir["c:\\foo*"]</code> will not work, use */
"\n"/*   <code>Dir["c:/foo*"]</code> instead. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    Dir["config.?"]                     #=> ["config.h"] */
"\n"/*    Dir.glob("config.?")                #=> ["config.h"] */
"\n"/*    Dir.glob("*.[a-z][a-z]")            #=> ["main.rb"] */
"\n"/*    Dir.glob("*.[^r]*")                 #=> ["config.h"] */
"\n"/*    Dir.glob("*.{rb,h}")                #=> ["main.rb", "config.h"] */
"\n"/*    Dir.glob("*")                       #=> ["config.h", "main.rb"] */
"\n"/*    Dir.glob("*", File::FNM_DOTMATCH)   #=> [".", "config.h", "main.rb"] */
"\n"/*    Dir.glob(["*.rb", "*.h"])           #=> ["main.rb", "config.h"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb")                 #=> ["main.rb", */
"\n"/*                                        #    "lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb", base: "lib")    #=> ["song.rb", */
"\n"/*                                        #    "song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib")                  #=> ["lib"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\**\/\*.rb")          #=> ["lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\*.rb")             #=> ["lib/song.rb"] */
"  def self.glob(pattern, _flags = 0, flags: _flags, base: nil, sort: true)\n"
"    Primitive.dir_s_glob(pattern, flags, base, sort)\n"
"  end\n"
"end\n"
"\n"
"class << File\n"
"\n"/* call-seq: */
"\n"/*    File.fnmatch( pattern, path, [flags] ) -> (true or false) */
"\n"/*    File.fnmatch?( pattern, path, [flags] ) -> (true or false) */
"\n"/*  */
"\n"/* Returns true if +path+ matches against +pattern+.  The pattern is not a */
"\n"/* regular expression; instead it follows rules similar to shell filename */
"\n"/* globbing.  It may contain the following metacharacters: */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/x</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::    Matches all regular files */
"\n"/*   <code>c*</code>::   Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::   Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c*</code>:: Matches all files that have <code>c</code> in them */
"\n"/*                       (including at the beginning or end). */
"\n"/*  */
"\n"/*   To match hidden files (that start with a <code>.</code>) set the */
"\n"/*   File::FNM_DOTMATCH flag. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively or files expansively. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/* <code>{a,b}</code>:: */
"\n"/*   Matches pattern a and pattern b if File::FNM_EXTGLOB flag is enabled. */
"\n"/*   Behaves like a Regexp union (<code>(?:a|b)</code>). */
"\n"/*  */
"\n"/* +flags+ is a bitwise OR of the <code>FNM_XXX</code> constants. The same */
"\n"/* glob pattern and flags are used by Dir::glob. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    File.fnmatch('cat',       'cat')        #=> true  # match entire string */
"\n"/*    File.fnmatch('cat',       'category')   #=> false # only match partial string */
"\n"/*  */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats')                    #=> false # { } isn't supported by default */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats', File::FNM_EXTGLOB) #=> true  # { } is supported on FNM_EXTGLOB */
"\n"/*  */
"\n"/*    File.fnmatch('c?t',     'cat')          #=> true  # '?' match only 1 character */
"\n"/*    File.fnmatch('c??t',    'cat')          #=> false # ditto */
"\n"/*    File.fnmatch('c*',      'cats')         #=> true  # '*' match 0 or more characters */
"\n"/*    File.fnmatch('c*t',     'c/a/b/t')      #=> true  # ditto */
"\n"/*    File.fnmatch('ca[a-z]', 'cat')          #=> true  # inclusive bracket expression */
"\n"/*    File.fnmatch('ca[^t]',  'cat')          #=> false # exclusive bracket expression ('^' or '!') */
"\n"/*  */
"\n"/*    File.fnmatch('cat', 'CAT')                     #=> false # case sensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_CASEFOLD) #=> true  # case insensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_SYSCASE)  #=> true or false # depends on the system default */
"\n"/*  */
"\n"/*    File.fnmatch('?',   '/', File::FNM_PATHNAME)  #=> false # wildcard doesn't match '/' on FNM_PATHNAME */
"\n"/*    File.fnmatch('*',   '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*    File.fnmatch('[/]', '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*  */
"\n"/*    File.fnmatch('\?',   '?')                       #=> true  # escaped wildcard becomes ordinary */
"\n"/*    File.fnmatch('\a',   'a')                       #=> true  # escaped ordinary remains ordinary */
"\n"/*    File.fnmatch('\a',   '\a', File::FNM_NOESCAPE)  #=> true  # FNM_NOESCAPE makes '\' ordinary */
"\n"/*    File.fnmatch('[\?]', '?')                       #=> true  # can escape inside bracket expression */
"\n"/*  */
"\n"/*    File.fnmatch('*',   '.profile')                      #=> false # wildcard doesn't match leading */
"\n"/*    File.fnmatch('*',   '.profile', File::FNM_DOTMATCH)  #=> true  # period by default. */
"\n"/*    File.fnmatch('.*',  '.profile')                      #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/\*.rb', 'main.rb')                  #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', './main.rb')                #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', 'lib/song.rb')              #=> true */
"\n"/*    File.fnmatch('**.rb', 'main.rb')                    #=> true */
"\n"/*    File.fnmatch('**.rb', './main.rb')                  #=> false */
"\n"/*    File.fnmatch('**.rb', 'lib/song.rb')                #=> true */
"\n"/*    File.fnmatch('*',     'dave/.profile')              #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/foo', 'a/b/c/foo', File::FNM_PATHNAME)     #=> true */
"\n"/*    File.fnmatch('**\/foo', '/a/b/c/foo', File::FNM_PATHNAME)    #=> true */
"\n"/*    File.fnmatch('**\/foo', 'c:/a/b/c/foo', File::FNM_PATHNAME)  #=> true */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME)    #=> false */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME | File::FNM_DOTMATCH) #=> true */
"  def fnmatch(pattern, path, flags = 0)\n"
"  end\n"
"  alias fnmatch? fnmatch\n"
"end if false\n"
#line 636 "miniprelude.c"
};

static const char prelude_name2[] = "<internal:gc>";
static const struct {
    char L0[492]; /* 1..70 */
    char L70[495]; /* 71..230 */
    char L230[507]; /* 231..272 */
    char L272[455]; /* 273..297 */
} prelude_code2 = {
#line 1 "gc.rb"
""/* for gc.c */
""
""/*  The GC module provides an interface to Ruby's mark and */
""/*  sweep garbage collection mechanism. */
""/*  */
""/*  Some of the underlying methods are also available via the ObjectSpace */
""/*  module. */
""/*  */
""/*  You may obtain information about the operation of the \GC through */
""/*  GC::Profiler. */
"module GC\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.start                     -> nil */
"\n"/*     ObjectSpace.garbage_collect  -> nil */
"\n"/*     include GC; garbage_collect  -> nil */
"\n"/*     GC.start(full_mark: true, immediate_sweep: true)           -> nil */
"\n"/*     ObjectSpace.garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*     include GC; garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*  */
"\n"/*  Initiates garbage collection, even if manually disabled. */
"\n"/*  */
"\n"/*  This method is defined with keyword arguments that default to true: */
"\n"/*  */
"\n"/*     def GC.start(full_mark: true, immediate_sweep: true); end */
"\n"/*  */
"\n"/*  Use full_mark: false to perform a minor \GC. */
"\n"/*  Use immediate_sweep: false to defer sweeping (use lazy sweep). */
"\n"/*  */
"\n"/*  Note: These keyword arguments are implementation and version dependent. They */
"\n"/*  are not guaranteed to be future-compatible, and may be ignored if the */
"\n"/*  underlying implementation does not support them. */
"  def self.start full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.enable    -> true or false */
"\n"/*  */
"\n"/*  Enables garbage collection, returning +true+ if garbage */
"\n"/*  collection was previously disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.enable    #=> true */
"\n"/*     GC.enable    #=> false */
"\n"/*  */
"  def self.enable\n"
"    Primitive.gc_enable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.disable    -> true or false */
"\n"/*  */
"\n"/*  Disables garbage collection, returning +true+ if garbage */
"\n"/*  collection was already disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.disable   #=> true */
"  def self.disable\n"
"    Primitive.gc_disable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress	    -> integer, true or false */
"\n"/*  */
"\n"/*  Returns current status of \GC stress mode. */
,
#line 71 "gc.rb"
"  def self.stress\n"
"    Primitive.gc_stress_get\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress = flag          -> flag */
"\n"/*  */
"\n"/*  Updates the \GC stress mode. */
"\n"/*  */
"\n"/*  When stress mode is enabled, the \GC is invoked at every \GC opportunity: */
"\n"/*  all memory and object allocations. */
"\n"/*  */
"\n"/*  Enabling stress mode will degrade performance, it is only for debugging. */
"\n"/*  */
"\n"/*  flag can be true, false, or an integer bit-ORed following flags. */
"\n"/*    0x01:: no major GC */
"\n"/*    0x02:: no immediate sweep */
"\n"/*    0x04:: full mark after malloc/calloc/realloc */
"  def self.stress=(flag)\n"
"    Primitive.gc_stress_set_m flag\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.count -> Integer */
"\n"/*  */
"\n"/*  The number of times \GC occurred. */
"\n"/*  */
"\n"/*  It returns the number of times \GC occurred since the process started. */
"  def self.count\n"
"    Primitive.gc_count\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.stat -> Hash */
"\n"/*     GC.stat(hash) -> Hash */
"\n"/*     GC.stat(:key) -> Numeric */
"\n"/*  */
"\n"/*  Returns a Hash containing information about the \GC. */
"\n"/*  */
"\n"/*  The contents of the hash are implementation specific and may change in */
"\n"/*  the future without notice. */
"\n"/*  */
"\n"/*  The hash includes information about internal statistics about \GC such as: */
"\n"/*  */
"\n"/*  [count] */
"\n"/*    The total number of garbage collections ran since application start */
"\n"/*    (count includes both minor and major garbage collections) */
"\n"/*  [time] */
"\n"/*    The total time spent in garbage collections (in milliseconds) */
"\n"/*  [heap_allocated_pages] */
"\n"/*    The total number of `:heap_eden_pages` + `:heap_tomb_pages` */
"\n"/*  [heap_sorted_length] */
"\n"/*    The number of pages that can fit into the buffer that holds references to */
"\n"/*    all pages */
"\n"/*  [heap_allocatable_pages] */
"\n"/*    The total number of pages the application could allocate without additional \GC */
"\n"/*  [heap_available_slots] */
"\n"/*    The total number of slots in all `:heap_allocated_pages` */
"\n"/*  [heap_live_slots] */
"\n"/*    The total number of slots which contain live objects */
"\n"/*  [heap_free_slots] */
"\n"/*    The total number of slots which do not contain live objects */
"\n"/*  [heap_final_slots] */
"\n"/*    The total number of slots with pending finalizers to be run */
"\n"/*  [heap_marked_slots] */
"\n"/*    The total number of objects marked in the last \GC */
"\n"/*  [heap_eden_pages] */
"\n"/*    The total number of pages which contain at least one live slot */
"\n"/*  [heap_tomb_pages] */
"\n"/*    The total number of pages which do not contain any live slots */
"\n"/*  [total_allocated_pages] */
"\n"/*    The cumulative number of pages allocated since application start */
"\n"/*  [total_freed_pages] */
"\n"/*    The cumulative number of pages freed since application start */
"\n"/*  [total_allocated_objects] */
"\n"/*    The cumulative number of objects allocated since application start */
"\n"/*  [total_freed_objects] */
"\n"/*    The cumulative number of objects freed since application start */
"\n"/*  [malloc_increase_bytes] */
"\n"/*    Amount of memory allocated on the heap for objects. Decreased by any \GC */
"\n"/*  [malloc_increase_bytes_limit] */
"\n"/*    When `:malloc_increase_bytes` crosses this limit, \GC is triggered */
"\n"/*  [minor_gc_count] */
"\n"/*    The total number of minor garbage collections run since process start */
"\n"/*  [major_gc_count] */
"\n"/*    The total number of major garbage collections run since process start */
"\n"/*  [compact_count] */
"\n"/*    The total number of compactions run since process start */
"\n"/*  [read_barrier_faults] */
"\n"/*    The total number of times the read barrier was triggered during */
"\n"/*    compaction */
"\n"/*  [total_moved_objects] */
"\n"/*    The total number of objects compaction has moved */
"\n"/*  [remembered_wb_unprotected_objects] */
"\n"/*    The total number of objects without write barriers */
"\n"/*  [remembered_wb_unprotected_objects_limit] */
"\n"/*    When `:remembered_wb_unprotected_objects` crosses this limit, */
"\n"/*    major \GC is triggered */
"\n"/*  [old_objects] */
"\n"/*    Number of live, old objects which have survived at least 3 garbage collections */
"\n"/*  [old_objects_limit] */
"\n"/*    When `:old_objects` crosses this limit, major \GC is triggered */
"\n"/*  [oldmalloc_increase_bytes] */
"\n"/*    Amount of memory allocated on the heap for objects. Decreased by major \GC */
"\n"/*  [oldmalloc_increase_bytes_limit] */
"\n"/*    When `:old_malloc_increase_bytes` crosses this limit, major \GC is triggered */
"\n"/*  */
"\n"/*  If the optional argument, hash, is given, */
"\n"/*  it is overwritten and returned. */
"\n"/*  This is intended to avoid probe effect. */
"\n"/*  */
"\n"/*  This method is only expected to work on CRuby. */
"  def self.stat hash_or_key = nil\n"
"    Primitive.gc_stat hash_or_key\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.stat_heap -> Hash */
"\n"/*    GC.stat_heap(nil, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name) -> Hash */
"\n"/*    GC.stat_heap(heap_name, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name, :key) -> Numeric */
"\n"/*  */
"\n"/* Returns information for memory pools in the \GC. */
"\n"/*  */
"\n"/* If the first optional argument, +heap_name+, is passed in and not +nil+, it */
"\n"/* returns a +Hash+ containing information about the particular memory pool. */
"\n"/* Otherwise, it will return a +Hash+ with memory pool names as keys and */
"\n"/* a +Hash+ containing information about the memory pool as values. */
"\n"/*  */
"\n"/* If the second optional argument, +hash_or_key+, is given as +Hash+, it will */
"\n"/* be overwritten and returned. This is intended to avoid the probe effect. */
"\n"/*  */
"\n"/* If both optional arguments are passed in and the second optional argument is */
"\n"/* a symbol, it will return a +Numeric+ of the value for the particular memory */
"\n"/* pool. */
"\n"/*  */
"\n"/* On CRuby, +heap_name+ is of the type +Integer+ but may be of type +String+ */
"\n"/* on other implementations. */
"\n"/*  */
"\n"/* The contents of the hash are implementation specific and may change in */
"\n"/* the future without notice. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, it is overwritten and returned. */
"\n"/*  */
"\n"/* This method is only expected to work on CRuby. */
"  def self.stat_heap heap_name = nil, hash_or_key = nil\n"
"    Primitive.gc_stat_heap heap_name, hash_or_key\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*     GC.latest_gc_info -> hash */
"\n"/*     GC.latest_gc_info(hash) -> hash */
"\n"/*     GC.latest_gc_info(:major_by) -> :malloc */
"\n"/*  */
"\n"/* Returns information about the most recent garbage collection. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, */
"\n"/* it is overwritten and returned. */
"\n"/* This is intended to avoid probe effect. */
,
#line 231 "gc.rb"
"  def self.latest_gc_info hash_or_key = nil\n"
"    Primitive.gc_latest_gc_info hash_or_key\n"
"  end\n"
"\n"
"  if respond_to?(:compact)\n"
"\n"/* call-seq: */
"\n"/*    GC.verify_compaction_references(toward: nil, double_heap: false) -> hash */
"\n"/*  */
"\n"/* Verify compaction reference consistency. */
"\n"/*  */
"\n"/* This method is implementation specific.  During compaction, objects that */
"\n"/* were moved are replaced with T_MOVED objects.  No object should have a */
"\n"/* reference to a T_MOVED object after compaction. */
"\n"/*  */
"\n"/* This function expands the heap to ensure room to move all objects, */
"\n"/* compacts the heap to make sure everything moves, updates all references, */
"\n"/* then performs a full \GC.  If any object contains a reference to a T_MOVED */
"\n"/* object, that object should be pushed on the mark stack, and will */
"\n"/* make a SEGV. */
"    def self.verify_compaction_references(toward: nil, double_heap: false, expand_heap: false)\n"
"      Primitive.gc_verify_compaction_references(double_heap, expand_heap, toward == :empty)\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time = true/false */
"\n"/*  */
"\n"/* Enable to measure \GC time. */
"\n"/* You can get the result with <tt>GC.stat(:time)</tt>. */
"\n"/* Note that \GC time measurement can cause some performance overhead. */
"  def self.measure_total_time=(flag)\n"
"    Primitive.cstmt! %{\n"
"      rb_objspace.flags.measure_gc = RTEST(flag) ? TRUE : FALSE;\n"
"      return flag;\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time -> true/false */
"\n"/*  */
"\n"/* Return measure_total_time flag (default: +true+). */
"\n"/* Note that measurement can affect the application performance. */
,
#line 273 "gc.rb"
"  def self.measure_total_time\n"
"    Primitive.cexpr! %{\n"
"      RBOOL(rb_objspace.flags.measure_gc)\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.total_time -> int */
"\n"/*  */
"\n"/* Return measured \GC total time in nano seconds. */
"  def self.total_time\n"
"    Primitive.cexpr! %{\n"
"      ULL2NUM(rb_objspace.profile.total_time_ns)\n"
"    }\n"
"  end\n"
"end\n"
"\n"
"module ObjectSpace\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  module_function :garbage_collect\n"
"end\n"
#line 949 "miniprelude.c"
};

static const char prelude_name3[] = "<internal:numeric>";
static const struct {
    char L0[477]; /* 1..105 */
    char L105[490]; /* 106..191 */
    char L191[508]; /* 192..287 */
    char L287[504]; /* 288..368 */
    char L368[385]; /* 369..406 */
} prelude_code3 = {
#line 1 "numeric.rb"
"class Numeric\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.real?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is a real number (i.e. not Complex). */
"\n"/*  */
"  def real?\n"
"    true\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    num.real  ->  self */
"\n"/*  */
"\n"/* Returns self. */
"\n"/*  */
"  def real\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.integer?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is an Integer. */
"\n"/*  */
"\n"/*      1.0.integer?   #=> false */
"\n"/*      1.integer?     #=> true */
"\n"/*  */
"  def integer?\n"
"    false\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.finite?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is a finite number, otherwise returns +false+. */
"\n"/*  */
"  def finite?\n"
"    true\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.infinite?  ->  -1, 1, or nil */
"\n"/*  */
"\n"/*  Returns +nil+, -1, or 1 depending on whether the value is */
"\n"/*  finite, <code>-Infinity</code>, or <code>+Infinity</code>. */
"\n"/*  */
"  def infinite?\n"
"    nil\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    num.imag       ->  0 */
"\n"/*    num.imaginary  ->  0 */
"\n"/*  */
"\n"/* Returns zero. */
"\n"/*  */
"  def imaginary\n"
"    0\n"
"  end\n"
"\n"
"  alias imag imaginary\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    num.conj       ->  self */
"\n"/*    num.conjugate  ->  self */
"\n"/*  */
"\n"/* Returns self. */
"\n"/*  */
"  def conjugate\n"
"    self\n"
"  end\n"
"\n"
"  alias conj conjugate\n"
"end\n"
"\n"
"class Integer\n"
"\n"/* call-seq: */
"\n"/*    -int  ->  integer */
"\n"/*  */
"\n"/* Returns +int+, negated. */
"  def -@\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_uminus(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   ~int  ->  integer */
"\n"/*  */
"\n"/* One's complement: returns a number where each bit is flipped. */
"\n"/*  */
"\n"/* Inverts the bits in an Integer. As integers are conceptually of */
"\n"/* infinite length, the result acts as if it had an infinite number of */
"\n"/* one bits to the left. In hex representations, this is displayed */
"\n"/* as two periods to the left of the digits. */
"\n"/*  */
"\n"/*   sprintf("%X", ~0x1122334455)    #=> "..FEEDDCCBBAA" */
"  def ~\n"
"    Primitive.attr! 'inline'\n"
,
#line 106 "numeric.rb"
"    Primitive.cexpr! 'rb_int_comp(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.abs        ->  integer */
"\n"/*    int.magnitude  ->  integer */
"\n"/*  */
"\n"/* Returns the absolute value of +int+. */
"\n"/*  */
"\n"/*    (-12345).abs   #=> 12345 */
"\n"/*    -12345.abs     #=> 12345 */
"\n"/*    12345.abs      #=> 12345 */
"\n"/*  */
"\n"/* Integer#magnitude is an alias for Integer#abs. */
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.bit_length  ->  integer */
"\n"/*  */
"\n"/* Returns the number of bits of the value of +int+. */
"\n"/*  */
"\n"/* "Number of bits" means the bit position of the highest bit */
"\n"/* which is different from the sign bit */
"\n"/* (where the least significant bit has bit position 1). */
"\n"/* If there is no such bit (zero or minus one), zero is returned. */
"\n"/*  */
"\n"/* I.e. this method returns <i>ceil(log2(int < 0 ? -int : int+1))</i>. */
"\n"/*  */
"\n"/*    (-2**1000-1).bit_length   #=> 1001 */
"\n"/*    (-2**1000).bit_length     #=> 1000 */
"\n"/*    (-2**1000+1).bit_length   #=> 1000 */
"\n"/*    (-2**12-1).bit_length     #=> 13 */
"\n"/*    (-2**12).bit_length       #=> 12 */
"\n"/*    (-2**12+1).bit_length     #=> 12 */
"\n"/*    -0x101.bit_length         #=> 9 */
"\n"/*    -0x100.bit_length         #=> 8 */
"\n"/*    -0xff.bit_length          #=> 8 */
"\n"/*    -2.bit_length             #=> 1 */
"\n"/*    -1.bit_length             #=> 0 */
"\n"/*    0.bit_length              #=> 0 */
"\n"/*    1.bit_length              #=> 1 */
"\n"/*    0xff.bit_length           #=> 8 */
"\n"/*    0x100.bit_length          #=> 9 */
"\n"/*    (2**12-1).bit_length      #=> 12 */
"\n"/*    (2**12).bit_length        #=> 13 */
"\n"/*    (2**12+1).bit_length      #=> 13 */
"\n"/*    (2**1000-1).bit_length    #=> 1000 */
"\n"/*    (2**1000).bit_length      #=> 1001 */
"\n"/*    (2**1000+1).bit_length    #=> 1001 */
"\n"/*  */
"\n"/* This method can be used to detect overflow in Array#pack as follows: */
"\n"/*  */
"\n"/*    if n.bit_length < 32 */
"\n"/*      [n].pack("l") # no overflow */
"\n"/*    else */
"\n"/*      raise "overflow" */
"\n"/*    end */
"  def bit_length\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_bit_length(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.even?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an even number. */
"  def even?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_even_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.integer?  ->  true */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, this always returns +true+. */
"  def integer?\n"
"    true\n"
"  end\n"
"\n"
"  alias magnitude abs\n"
"=begin\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
,
#line 192 "numeric.rb"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"=end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.odd?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an odd number. */
"  def odd?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_odd_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.ord  ->  self */
"\n"/*  */
"\n"/*  Returns the +int+ itself. */
"\n"/*  */
"\n"/*     97.ord   #=> 97 */
"\n"/*  */
"\n"/*  This method is intended for compatibility to character literals */
"\n"/*  in Ruby 1.9. */
"\n"/*  */
"\n"/*  For example, <code>?a.ord</code> returns 97 both in 1.8 and 1.9. */
"  def ord\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  Document-method: Integer#size */
"\n"/*  call-seq: */
"\n"/*     int.size  ->  int */
"\n"/*  */
"\n"/*  Returns the number of bytes in the machine representation of +int+ */
"\n"/*  (machine dependent). */
"\n"/*  */
"\n"/*     1.size               #=> 8 */
"\n"/*     -1.size              #=> 8 */
"\n"/*     2147483647.size      #=> 8 */
"\n"/*     (256**10 - 1).size   #=> 10 */
"\n"/*     (256**20 - 1).size   #=> 20 */
"\n"/*     (256**40 - 1).size   #=> 40 */
"\n"/*  */
"  def size\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_size(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_i    ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"\n"/*  */
"\n"/*  #to_int is an alias for #to_i. */
"  def to_i\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_int  ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"  def to_int\n"
"    self\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.zero? -> true or false */
"\n"/*  */
"\n"/* Returns +true+ if +int+ has a zero value. */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_zero_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    ceildiv(other) -> integer */
"\n"/*  */
"\n"/*  Returns the result of division +self+ by +other+. The result is rounded up to the nearest integer. */
"\n"/*  */
"\n"/*    3.ceildiv(3) # => 1 */
"\n"/*    4.ceildiv(3) # => 2 */
"\n"/*  */
"\n"/*    4.ceildiv(-3) # => -1 */
"\n"/*    -4.ceildiv(3) # => -1 */
"\n"/*    -4.ceildiv(-3) # => 2 */
"\n"/*  */
"\n"/*    3.ceildiv(1.2) # => 3 */
"  def ceildiv(other)\n"
"    -div(-other)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    int.numerator  ->  self */
"\n"/*  */
,
#line 288 "numeric.rb"
"\n"/* Returns self. */
"\n"/*  */
"  def numerator\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    int.denominator  ->  1 */
"\n"/*  */
"\n"/* Returns 1. */
"\n"/*  */
"  def denominator\n"
"    1\n"
"  end\n"
"end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    Integer.try_convert(object) -> object, integer, or nil */
"\n"/*  */
"\n"/*  If +object+ is an \Integer object, returns +object+. */
"\n"/*    Integer.try_convert(1) # => 1 */
"\n"/*  */
"\n"/*  Otherwise if +object+ responds to <tt>:to_int</tt>, */
"\n"/*  calls <tt>object.to_int</tt> and returns the result. */
"\n"/*    Integer.try_convert(1.25) # => 1 */
"\n"/*  */
"\n"/*  Returns +nil+ if +object+ does not respond to <tt>:to_int</tt> */
"\n"/*    Integer.try_convert([]) # => nil */
"\n"/*  */
"\n"/*  Raises an exception unless <tt>object.to_int</tt> returns an \Integer object. */
"\n"/*  */
"def Integer.try_convert(num)\n"
"=begin\n"
"  Primitive.attr! 'inline'\n"
"  Primitive.cexpr! 'rb_check_integer_type(num)'\n"
"=end\n"
"end if false\n"
"\n"
"class Float\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    float.to_f  ->  self */
"\n"/*  */
"\n"/* Since +float+ is already a Float, returns +self+. */
"\n"/*  */
"  def to_f\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.abs        ->  float */
"\n"/*     float.magnitude  ->  float */
"\n"/*  */
"\n"/*  Returns the absolute value of +float+. */
"\n"/*  */
"\n"/*     (-34.56).abs   #=> 34.56 */
"\n"/*     -34.56.abs     #=> 34.56 */
"\n"/*     34.56.abs      #=> 34.56 */
"\n"/*  */
"\n"/*  Float#magnitude is an alias for Float#abs. */
"\n"/*  */
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    -float  ->  float */
"\n"/*  */
"\n"/* Returns +float+, negated. */
"\n"/*  */
"  def -@\n"
"    Primitive.attr! 'inline'\n"
,
#line 369 "numeric.rb"
"    Primitive.cexpr! 'rb_float_uminus(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.zero?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is 0.0. */
"\n"/*  */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(FLOAT_ZERO_P(self))'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.positive?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is greater than 0. */
"\n"/*  */
"  def positive?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) > 0.0)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.negative?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is less than 0. */
"\n"/*  */
"  def negative?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) < 0.0)'\n"
"  end\n"
"\n"
"end\n"
#line 1374 "miniprelude.c"
};

static const char prelude_name4[] = "<internal:io>";
static const struct {
    char L0[336]; /* 1..124 */
} prelude_code4 = {
#line 1 "io.rb"
"class IO\n"
"\n"/* other IO methods are defined in io.c */
"\n"
"\n"/* call-seq: */
"\n"/*    ios.read_nonblock(maxlen [, options])              -> string */
"\n"/*    ios.read_nonblock(maxlen, outbuf [, options])      -> outbuf */
"\n"/*  */
"\n"/* Reads at most <i>maxlen</i> bytes from <em>ios</em> using */
"\n"/* the read(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* If the optional <i>outbuf</i> argument is present, */
"\n"/* it must reference a String, which will receive the data. */
"\n"/* The <i>outbuf</i> will contain only the received data after the method call */
"\n"/* even if it is not empty at the beginning. */
"\n"/*  */
"\n"/* read_nonblock just calls the read(2) system call. */
"\n"/* It causes all errors the read(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The caller should care such errors. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitReadable. */
"\n"/* So IO::WaitReadable can be used to rescue the exceptions for retrying */
"\n"/* read_nonblock. */
"\n"/*  */
"\n"/* read_nonblock causes EOFError on EOF. */
"\n"/*  */
"\n"/* On some platforms, such as Windows, non-blocking mode is not supported */
"\n"/* on IO objects other than sockets. In such cases, Errno::EBADF will */
"\n"/* be raised. */
"\n"/*  */
"\n"/* If the read byte buffer is not empty, */
"\n"/* read_nonblock reads from the buffer like readpartial. */
"\n"/* In this case, the read(2) system call is not called. */
"\n"/*  */
"\n"/* When read_nonblock raises an exception kind of IO::WaitReadable, */
"\n"/* read_nonblock should not be called */
"\n"/* until io is readable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   # emulates blocking read (readpartial). */
"\n"/*   begin */
"\n"/*     result = io.read_nonblock(maxlen) */
"\n"/*   rescue IO::WaitReadable */
"\n"/*     IO.select([io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Although IO#read_nonblock doesn't raise IO::WaitWritable. */
"\n"/* OpenSSL::Buffering#read_nonblock can raise IO::WaitWritable. */
"\n"/* If IO and SSL should be used polymorphically, */
"\n"/* IO::WaitWritable should be rescued too. */
"\n"/* See the document of OpenSSL::Buffering#read_nonblock for sample code. */
"\n"/*  */
"\n"/* Note that this method is identical to readpartial */
"\n"/* except the non-blocking flag is set. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that read_nonblock should not raise an IO::WaitReadable exception, but */
"\n"/* return the symbol +:wait_readable+ instead. At EOF, it will return nil */
"\n"/* instead of raising EOFError. */
"  def read_nonblock(len, buf = nil, exception: true)\n"
"    Primitive.io_read_nonblock(len, buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.write_nonblock(string)   -> integer */
"\n"/*    ios.write_nonblock(string [, options])   -> integer */
"\n"/*  */
"\n"/* Writes the given string to <em>ios</em> using */
"\n"/* the write(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* It returns the number of bytes written. */
"\n"/*  */
"\n"/* write_nonblock just calls the write(2) system call. */
"\n"/* It causes all errors the write(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The result may also be smaller than string.length (partial write). */
"\n"/* The caller should care such errors and partial write. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitWritable. */
"\n"/* So IO::WaitWritable can be used to rescue the exceptions for retrying write_nonblock. */
"\n"/*  */
"\n"/*   # Creates a pipe. */
"\n"/*   r, w = IO.pipe */
"\n"/*  */
"\n"/*   # write_nonblock writes only 65536 bytes and return 65536. */
"\n"/*   # (The pipe size is 65536 bytes on this environment.) */
"\n"/*   s = "a" * 100000 */
"\n"/*   p w.write_nonblock(s)     #=> 65536 */
"\n"/*  */
"\n"/*   # write_nonblock cannot write a byte and raise EWOULDBLOCK (EAGAIN). */
"\n"/*   p w.write_nonblock("b")   # Resource temporarily unavailable (Errno::EAGAIN) */
"\n"/*  */
"\n"/* If the write buffer is not empty, it is flushed at first. */
"\n"/*  */
"\n"/* When write_nonblock raises an exception kind of IO::WaitWritable, */
"\n"/* write_nonblock should not be called */
"\n"/* until io is writable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   begin */
"\n"/*     result = io.write_nonblock(string) */
"\n"/*   rescue IO::WaitWritable, Errno::EINTR */
"\n"/*     IO.select(nil, [io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Note that this doesn't guarantee to write all data in string. */
"\n"/* The length written is reported as result and it should be checked later. */
"\n"/*  */
"\n"/* On some platforms such as Windows, write_nonblock is not supported */
"\n"/* according to the kind of the IO object. */
"\n"/* In such cases, write_nonblock raises <code>Errno::EBADF</code>. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that write_nonblock should not raise an IO::WaitWritable exception, but */
"\n"/* return the symbol +:wait_writable+ instead. */
"  def write_nonblock(buf, exception: true)\n"
"    Primitive.io_write_nonblock(buf, exception)\n"
"  end\n"
"end\n"
#line 1505 "miniprelude.c"
};

static const char prelude_name5[] = "<internal:marshal>";
static const struct {
    char L0[202]; /* 1..41 */
} prelude_code5 = {
#line 1 "marshal.rb"
"module Marshal\n"
"\n"/* call-seq: */
"\n"/*    load(source, proc = nil, freeze: false) -> obj */
"\n"/*    restore(source, proc = nil, freeze: false) -> obj */
"\n"/*  */
"\n"/* Returns the result of converting the serialized data in source into a */
"\n"/* Ruby object (possibly with associated subordinate objects). source */
"\n"/* may be either an instance of IO or an object that responds to */
"\n"/* to_str. If proc is specified, each object will be passed to the proc, as the object */
"\n"/* is being deserialized. */
"\n"/*  */
"\n"/* Never pass untrusted data (including user supplied input) to this method. */
"\n"/* Please see the overview for further details. */
"\n"/*  */
"\n"/* If the <tt>freeze: true</tt> argument is passed, deserialized object would */
"\n"/* be deeply frozen. Note that it may lead to more efficient memory usage due to */
"\n"/* frozen strings deduplication: */
"\n"/*  */
"\n"/*    serialized = Marshal.dump(['value1', 'value2', 'value1', 'value2']) */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [false, false, false, false] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1023900, 1023920, 1023940, 1023960] -- 4 different objects */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized, freeze: true) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [true, true, true, true] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1039360, 1039380, 1039360, 1039380] -- only 2 different objects, object_ids repeating */
"\n"/*  */
"  def self.load(source, proc = nil, freeze: false)\n"
"    Primitive.marshal_load(source, proc, freeze)\n"
"  end\n"
"\n"
"  class << self\n"
"    alias restore load\n"
"  end\n"
"end\n"
#line 1553 "miniprelude.c"
};

static const char prelude_name6[] = "<internal:mjit>";
static const struct {
    char L0[497]; /* 1..31 */
    char L31[97]; /* 32..38 */
} prelude_code6 = {
#line 1 "mjit.rb"
"module RubyVM::MJIT\n"
"\n"/* Return true if MJIT is enabled. */
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(mjit_enabled)'\n"
"  end\n"
"\n"
"\n"/* Stop generating JITed code. */
"  def self.pause(wait: true)\n"
"    Primitive.cexpr! 'mjit_pause(RTEST(wait))'\n"
"  end\n"
"\n"
"\n"/* Start generating JITed code again after pause. */
"  def self.resume\n"
"    Primitive.cexpr! 'mjit_resume()'\n"
"  end\n"
"end\n"
"\n"
"if RubyVM::MJIT.enabled?\n"
"  begin\n"
"    require 'fiddle'\n"
"    require 'fiddle/import'\n"
"  rescue LoadError\n"
"    return\n"/* miniruby doesn't support MJIT */
"  end\n"
"\n"
"\n"/* forward declaration for ruby_vm/mjit/compiler */
"  RubyVM::MJIT::C = Object.new\n"/* :nodoc: */
"\n"
"  require 'ruby_vm/mjit/c_type'\n"
"  require 'ruby_vm/mjit/instruction'\n"
"  require 'ruby_vm/mjit/compiler'\n"
,
#line 32 "mjit.rb"
"  require 'ruby_vm/mjit/hooks'\n"
"\n"
"  module RubyVM::MJIT\n"
"    private_constant(*constants)\n"
"  end\n"
"end\n"
#line 1601 "miniprelude.c"
};

static const char prelude_name7[] = "<internal:mjit_c>";
static const struct {
    char L0[484]; /* 1..21 */
    char L21[495]; /* 22..34 */
    char L34[489]; /* 35..49 */
    char L49[503]; /* 50..67 */
    char L67[464]; /* 68..81 */
    char L81[465]; /* 82..87 */
    char L87[450]; /* 88..102 */
    char L102[501]; /* 103..108 */
    char L108[479]; /* 109..130 */
    char L130[466]; /* 131..152 */
    char L152[452]; /* 153..172 */
    char L172[501]; /* 173..195 */
    char L195[496]; /* 196..219 */
    char L219[474]; /* 220..244 */
    char L244[467]; /* 245..266 */
    char L266[502]; /* 267..275 */
    char L275[425]; /* 276..278 */
    char L278[438]; /* 279..281 */
    char L281[489]; /* 282..289 */
    char L289[503]; /* 290..293 */
    char L293[508]; /* 294..302 */
    char L302[456]; /* 303..309 */
    char L309[500]; /* 310..317 */
    char L317[457]; /* 318..325 */
    char L325[507]; /* 326..331 */
    char L331[444]; /* 332..341 */
    char L341[451]; /* 342..345 */
    char L345[498]; /* 346..349 */
    char L349[428]; /* 350..357 */
    char L357[392]; /* 358..360 */
    char L360[400]; /* 361..368 */
    char L368[461]; /* 369..376 */
    char L376[413]; /* 377..379 */
    char L379[459]; /* 380..388 */
    char L388[478]; /* 389..394 */
    char L394[450]; /* 395..405 */
    char L405[417]; /* 406..409 */
    char L409[401]; /* 410..417 */
    char L417[493]; /* 418..421 */
    char L421[489]; /* 422..428 */
    char L428[441]; /* 429..433 */
    char L433[462]; /* 434..441 */
    char L441[438]; /* 442..444 */
    char L444[410]; /* 445..447 */
    char L447[464]; /* 448..450 */
    char L450[455]; /* 451..453 */
    char L453[422]; /* 454..456 */
    char L456[418]; /* 457..459 */
    char L459[427]; /* 460..463 */
    char L463[467]; /* 464..466 */
    char L466[495]; /* 467..478 */
    char L478[442]; /* 479..483 */
    char L483[459]; /* 484..491 */
    char L491[413]; /* 492..496 */
    char L496[416]; /* 497..499 */
    char L499[424]; /* 500..502 */
    char L502[390]; /* 503..505 */
    char L505[391]; /* 506..508 */
    char L508[453]; /* 509..511 */
    char L511[431]; /* 512..515 */
    char L515[382]; /* 516..518 */
    char L518[382]; /* 519..521 */
    char L521[437]; /* 522..524 */
    char L524[427]; /* 525..527 */
    char L527[433]; /* 528..531 */
    char L531[430]; /* 532..536 */
    char L536[445]; /* 537..539 */
    char L539[444]; /* 540..547 */
    char L547[388]; /* 548..550 */
    char L550[424]; /* 551..558 */
    char L558[449]; /* 559..563 */
    char L563[476]; /* 564..570 */
    char L570[499]; /* 571..578 */
    char L578[457]; /* 579..589 */
    char L589[465]; /* 590..599 */
    char L599[454]; /* 600..607 */
    char L607[489]; /* 608..618 */
    char L618[404]; /* 619..622 */
    char L622[469]; /* 623..630 */
    char L630[397]; /* 631..634 */
    char L634[360]; /* 635..637 */
    char L637[450]; /* 638..640 */
    char L640[456]; /* 641..652 */
    char L652[455]; /* 653..656 */
    char L656[471]; /* 657..670 */
    char L670[507]; /* 671..695 */
    char L695[492]; /* 696..726 */
    char L726[476]; /* 727..754 */
    char L754[484]; /* 755..781 */
    char L781[449]; /* 782..806 */
    char L806[64]; /* 807..808 */
} prelude_code7 = {
#line 1 "mjit_c.rb"
""/* frozen_string_literal: true */
""/* Part of this file is generated by tool/mjit/bindgen.rb. */
""/* Run `make mjit-bindgen` to update code between "MJIT bindgen begin" and "MJIT bindgen end". */
"module RubyVM::MJIT\n"/* :nodoc: all */
"\n"/* This `class << C` section is for calling C functions. For importing variables */
"\n"/* or macros as is, please consider using tool/mjit/bindgen.rb instead. */
"  class << C\n"
"    def rb_hash_values(cdhash_addr)\n"
"      Primitive.cexpr! 'rb_hash_values((VALUE)NUM2PTR(cdhash_addr))'\n"
"    end\n"
"\n"
"    def builtin_compiler(buf, bf_ptr, index, stack_size, builtin_inline_p)\n"
"      _bf_addr = bf_ptr.to_i\n"
"\n"/* Call "mjit_compile_invokebuiltin_for_#{func}" in mk_builtin_loader.rb */
"      Primitive.cstmt! %{\n"
"        RB_BUILTIN bf = (RB_BUILTIN)NUM2PTR(_bf_addr);\n"
"        bf->compiler(buf, NIL_P(index) ? -1 : NUM2LONG(index), NUM2UINT(stack_size), RTEST(builtin_inline_p));\n"
"        return Qnil;\n"
"      }\n"
"    end\n"
"\n"
,
#line 22 "mjit_c.rb"
"    def has_cache_for_send(cc_ptr, insn)\n"
"      _cc_addr = cc_ptr.to_i\n"
"      Primitive.cstmt! %{\n"
"        extern bool rb_vm_opt_cfunc_p(CALL_CACHE cc, int insn);\n"
"        CALL_CACHE cc = (CALL_CACHE)NUM2PTR(_cc_addr);\n"
"        bool has_cache = vm_cc_cme(cc) != NULL &&\n"
"            !(vm_cc_cme(cc)->def->type == VM_METHOD_TYPE_CFUNC && rb_vm_opt_cfunc_p(cc, NUM2INT(insn)));\n"
"        return RBOOL(has_cache);\n"
"      }\n"
"    end\n"
"\n"
"    def rb_shape_get_shape_by_id(shape_id)\n"
"      _shape_id = shape_id.to_i\n"
,
#line 35 "mjit_c.rb"
"      shape_addr = Primitive.cexpr! 'PTR2NUM((VALUE)rb_shape_get_shape_by_id((shape_id_t)NUM2UINT(_shape_id)))'\n"
"      rb_shape_t.new(shape_addr)\n"
"    end\n"
"\n"
"    def rb_iseq_check(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      iseq_addr = Primitive.cexpr! 'PTR2NUM((VALUE)rb_iseq_check((rb_iseq_t *)NUM2PTR(_iseq_addr)))'\n"
"      rb_iseq_t.new(iseq_addr)\n"
"    end\n"
"\n"
"    def rb_iseq_path(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      Primitive.cexpr! 'rb_iseq_path((rb_iseq_t *)NUM2PTR(_iseq_addr))'\n"
"    end\n"
"\n"
,
#line 50 "mjit_c.rb"
"    def rb_iseq_first_lineno(iseq)\n"
"      _iseq_addr = iseq.to_i\n"
"      Primitive.cexpr! 'rb_iseq_first_lineno((rb_iseq_t *)NUM2PTR(_iseq_addr))'\n"
"    end\n"
"\n"
"    def vm_ci_argc(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(vm_ci_argc((CALL_INFO)NUM2PTR(_ci_addr)))'\n"
"    end\n"
"\n"
"    def vm_ci_flag(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cexpr! 'UINT2NUM(vm_ci_flag((CALL_INFO)NUM2PTR(_ci_addr)))'\n"
"    end\n"
"\n"
"    def rb_splat_or_kwargs_p(ci)\n"
"      _ci_addr = ci.to_i\n"
"      Primitive.cstmt! %{\n"
,
#line 68 "mjit_c.rb"
"        extern bool rb_splat_or_kwargs_p(const struct rb_callinfo *restrict ci);\n"
"        return RBOOL(rb_splat_or_kwargs_p((CALL_INFO)NUM2PTR(_ci_addr)));\n"
"      }\n"
"    end\n"
"\n"
"\n"/* Returns true if iseq can use fastpath for setup, otherwise NULL. This becomes true in the same condition */
"\n"/* as CC_SET_FASTPATH (in vm_callee_setup_arg) is called from vm_call_iseq_setup. */
"    def fastpath_applied_iseq_p(ci_ptr, cc_ptr, iseq_ptr)\n"
"      _ci_addr = ci_ptr.to_i\n"
"      _cc_addr = cc_ptr.to_i\n"
"      _iseq_addr = iseq_ptr.to_i\n"
"      Primitive.cstmt! %q{\n"
"        extern bool rb_simple_iseq_p(const rb_iseq_t *iseq);\n"
"        CALL_INFO ci = (CALL_INFO)NUM2PTR(_ci_addr);\n"
,
#line 82 "mjit_c.rb"
"        CALL_CACHE cc = (CALL_CACHE)NUM2PTR(_cc_addr);\n"
"        const rb_iseq_t *iseq = (rb_iseq_t *)NUM2PTR(_iseq_addr);\n"
"\n"
"        bool result = iseq != NULL\n"
"            && !(vm_ci_flag(ci) & VM_CALL_KW_SPLAT) && rb_simple_iseq_p(iseq) // Top of vm_callee_setup_arg. In this case, opt_pc is 0.\n"
"            && vm_ci_argc(ci) == (unsigned int)ISEQ_BODY(iseq)->param.lead_num // exclude argument_arity_error (assumption: `calling->argc == ci->orig_argc` in send insns)\n"
,
#line 88 "mjit_c.rb"
"            && vm_call_iseq_optimizable_p(ci, cc); // CC_SET_FASTPATH condition\n"
"        return RBOOL(result);\n"
"      }\n"
"    end\n"
"\n"
"    def mjit_opts\n"
"      addr = Primitive.cexpr! 'PTR2NUM((VALUE)&mjit_opts)'\n"
"      mjit_options.new(addr)\n"
"    end\n"
"\n"
"    def mjit_call_attribute_sp_inc(insn, operands)\n"
"      _operands_addr = operands.to_i\n"
"      Primitive.cexpr! 'LONG2NUM(mjit_call_attribute_sp_inc(NUM2INT(insn), (VALUE *)NUM2PTR(_operands_addr)))'\n"
"    end\n"
"\n"
,
#line 103 "mjit_c.rb"
"    def mjit_capture_cc_entries(compiled_body, captured_body)\n"
"      _compiled_body_addr = compiled_body.to_i\n"
"      _captured_body_addr = captured_body.to_i\n"
"      Primitive.cstmt! %{\n"
"        extern int mjit_capture_cc_entries(const struct rb_iseq_constant_body *compiled_iseq, const struct rb_iseq_constant_body *captured_iseq);\n"
"        return INT2NUM(mjit_capture_cc_entries((struct rb_iseq_constant_body *)NUM2PTR(_compiled_body_addr), (struct rb_iseq_constant_body *)NUM2PTR(_captured_body_addr)));\n"
,
#line 109 "mjit_c.rb"
"      }\n"
"    end\n"
"\n"
"    def mjit_cancel_all(reason)\n"
"      Primitive.cstmt! %{\n"
"        mjit_cancel_all(RSTRING_PTR(reason));\n"
"        return Qnil;\n"
"      }\n"
"    end\n"
"\n"
"\n"/* Convert encoded VM pointers to insn BINs. */
"    def rb_vm_insn_decode(encoded)\n"
"      Primitive.cexpr! 'INT2NUM(rb_vm_insn_decode(NUM2PTR(encoded)))'\n"
"    end\n"
"\n"
"\n"/* Convert insn BINs to encoded VM pointers. This one is not used by the compiler, but useful for debugging. */
"    def rb_vm_insn_encode(bin)\n"
"      Primitive.cexpr! 'PTR2NUM((VALUE)rb_vm_get_insns_address_table()[NUM2INT(bin)])'\n"
"    end\n"
"\n"
"    def insn_may_depend_on_sp_or_pc(insn, opes)\n"
"      _opes_addr = opes.to_i\n"
,
#line 131 "mjit_c.rb"
"      Primitive.cexpr! 'RBOOL(insn_may_depend_on_sp_or_pc(NUM2INT(insn), (VALUE *)NUM2PTR(_opes_addr)))'\n"
"    end\n"
"\n"
"\n"/* Convert Integer VALUE to an actual Ruby object */
"    def to_ruby(value)\n"
"      Primitive.cexpr! '(VALUE)NUM2PTR(value)'\n"
"    end\n"
"\n"
"\n"/* Convert RubyVM::InstructionSequence to C.rb_iseq_t. Not used by the compiler, but useful for debugging. */
"    def rb_iseqw_to_iseq(iseqw)\n"
"      iseq_addr = Primitive.cexpr! 'PTR2NUM((VALUE)rb_iseqw_to_iseq(iseqw))'\n"
"      rb_iseq_t.new(iseq_addr)\n"
"    end\n"
"  end\n"
"\n"
"\n"/* # MJIT bindgen begin ### */
"\n"
"  def C.USE_LAZY_LOAD\n"
"    Primitive.cexpr! %q{ RBOOL(USE_LAZY_LOAD != 0) }\n"
"  end\n"
"\n"
"  def C.NOT_COMPILED_STACK_SIZE\n"
,
#line 153 "mjit_c.rb"
"    Primitive.cexpr! %q{ INT2NUM(NOT_COMPILED_STACK_SIZE) }\n"
"  end\n"
"\n"
"  def C.VM_CALL_KW_SPLAT\n"
"    Primitive.cexpr! %q{ INT2NUM(VM_CALL_KW_SPLAT) }\n"
"  end\n"
"\n"
"  def C.VM_CALL_KW_SPLAT_bit\n"
"    Primitive.cexpr! %q{ INT2NUM(VM_CALL_KW_SPLAT_bit) }\n"
"  end\n"
"\n"
"  def C.VM_CALL_TAILCALL\n"
"    Primitive.cexpr! %q{ INT2NUM(VM_CALL_TAILCALL) }\n"
"  end\n"
"\n"
"  def C.VM_CALL_TAILCALL_bit\n"
"    Primitive.cexpr! %q{ INT2NUM(VM_CALL_TAILCALL_bit) }\n"
"  end\n"
"\n"
"  def C.VM_METHOD_TYPE_CFUNC\n"
,
#line 173 "mjit_c.rb"
"    Primitive.cexpr! %q{ INT2NUM(VM_METHOD_TYPE_CFUNC) }\n"
"  end\n"
"\n"
"  def C.VM_METHOD_TYPE_ISEQ\n"
"    Primitive.cexpr! %q{ INT2NUM(VM_METHOD_TYPE_ISEQ) }\n"
"  end\n"
"\n"
"  def C.RUBY_EVENT_CLASS\n"
"    Primitive.cexpr! %q{ UINT2NUM(RUBY_EVENT_CLASS) }\n"
"  end\n"
"\n"
"  def C.SHAPE_CAPACITY_CHANGE\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_CAPACITY_CHANGE) }\n"
"  end\n"
"\n"
"  def C.SHAPE_FLAG_SHIFT\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_FLAG_SHIFT) }\n"
"  end\n"
"\n"
"  def C.SHAPE_FROZEN\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_FROZEN) }\n"
"  end\n"
"\n"
,
#line 196 "mjit_c.rb"
"  def C.SHAPE_ID_NUM_BITS\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_ID_NUM_BITS) }\n"
"  end\n"
"\n"
"  def C.SHAPE_INITIAL_CAPACITY\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_INITIAL_CAPACITY) }\n"
"  end\n"
"\n"
"  def C.SHAPE_IVAR\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_IVAR) }\n"
"  end\n"
"\n"
"  def C.SHAPE_ROOT\n"
"    Primitive.cexpr! %q{ UINT2NUM(SHAPE_ROOT) }\n"
"  end\n"
"\n"
"  def C.INVALID_SHAPE_ID\n"
"    Primitive.cexpr! %q{ ULONG2NUM(INVALID_SHAPE_ID) }\n"
"  end\n"
"\n"
"  def C.SHAPE_MASK\n"
"    Primitive.cexpr! %q{ ULONG2NUM(SHAPE_MASK) }\n"
"  end\n"
"\n"
,
#line 220 "mjit_c.rb"
"  def C.rb_cFalseClass\n"
"    Primitive.cexpr! %q{ PTR2NUM(rb_cFalseClass) }\n"
"  end\n"
"\n"
"  def C.rb_cFloat\n"
"    Primitive.cexpr! %q{ PTR2NUM(rb_cFloat) }\n"
"  end\n"
"\n"
"  def C.rb_cInteger\n"
"    Primitive.cexpr! %q{ PTR2NUM(rb_cInteger) }\n"
"  end\n"
"\n"
"  def C.rb_cNilClass\n"
"    Primitive.cexpr! %q{ PTR2NUM(rb_cNilClass) }\n"
"  end\n"
"\n"
"  def C.rb_cSymbol\n"
"    Primitive.cexpr! %q{ PTR2NUM(rb_cSymbol) }\n"
"  end\n"
"\n"
"  def C.rb_cTrueClass\n"
"    Primitive.cexpr! %q{ PTR2NUM(rb_cTrueClass) }\n"
"  end\n"
"\n"
"  def C.CALL_DATA\n"
,
#line 245 "mjit_c.rb"
"    @CALL_DATA ||= self.rb_call_data\n"
"  end\n"
"\n"
"  def C.IC\n"
"    @IC ||= self.iseq_inline_constant_cache\n"
"  end\n"
"\n"
"  def C.IVC\n"
"    @IVC ||= self.iseq_inline_iv_cache_entry\n"
"  end\n"
"\n"
"  def C.RB_BUILTIN\n"
"    @RB_BUILTIN ||= self.rb_builtin_function\n"
"  end\n"
"\n"
"  def C.attr_index_t\n"
"    @attr_index_t ||= CType::Immediate.parse(\"uint32_t\")\n"
"  end\n"
"\n"
"  def C.compile_branch\n"
"    @compile_branch ||= CType::Struct.new(\n"
"      \"compile_branch\", Primitive.cexpr!(\"SIZEOF(struct compile_branch)\"),\n"
,
#line 267 "mjit_c.rb"
"      stack_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct compile_branch *)NULL)), stack_size)\")],\n"
"      finish_p: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct compile_branch *)NULL)), finish_p)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.compile_status\n"
"    @compile_status ||= CType::Struct.new(\n"
"      \"compile_status\", Primitive.cexpr!(\"SIZEOF(struct compile_status)\"),\n"
"      success: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), success)\")],\n"
,
#line 276 "mjit_c.rb"
"      stack_size_for_pos: [CType::Pointer.new { CType::Immediate.parse(\"int\") }, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), stack_size_for_pos)\")],\n"
"      local_stack_p: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), local_stack_p)\")],\n"
"      cc_entries_index: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), cc_entries_index)\")],\n"
,
#line 279 "mjit_c.rb"
"      compiled_iseq: [CType::Pointer.new { self.rb_iseq_constant_body }, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), compiled_iseq)\")],\n"
"      compiled_id: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), compiled_id)\")],\n"
"      compile_info: [CType::Pointer.new { self.rb_mjit_compile_info }, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), compile_info)\")],\n"
,
#line 282 "mjit_c.rb"
"      inlined_iseqs: [CType::Pointer.new { CType::Pointer.new { self.rb_iseq_constant_body } }, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), inlined_iseqs)\")],\n"
"      inline_context: [self.inlined_call_context, Primitive.cexpr!(\"OFFSETOF((*((struct compile_status *)NULL)), inline_context)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.inlined_call_context\n"
"    @inlined_call_context ||= CType::Struct.new(\n"
"      \"inlined_call_context\", Primitive.cexpr!(\"SIZEOF(struct inlined_call_context)\"),\n"
,
#line 290 "mjit_c.rb"
"      orig_argc: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct inlined_call_context *)NULL)), orig_argc)\")],\n"
"      me: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct inlined_call_context *)NULL)), me)\")],\n"
"      param_size: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct inlined_call_context *)NULL)), param_size)\")],\n"
"      local_size: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct inlined_call_context *)NULL)), local_size)\")],\n"
,
#line 294 "mjit_c.rb"
"    )\n"
"  end\n"
"\n"
"  def C.iseq_inline_constant_cache\n"
"    @iseq_inline_constant_cache ||= CType::Struct.new(\n"
"      \"iseq_inline_constant_cache\", Primitive.cexpr!(\"SIZEOF(struct iseq_inline_constant_cache)\"),\n"
"      entry: [CType::Pointer.new { self.iseq_inline_constant_cache_entry }, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache *)NULL)), entry)\")],\n"
"      segments: [CType::Pointer.new { self.ID }, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache *)NULL)), segments)\")],\n"
"    )\n"
,
#line 303 "mjit_c.rb"
"  end\n"
"\n"
"  def C.iseq_inline_constant_cache_entry\n"
"    @iseq_inline_constant_cache_entry ||= CType::Struct.new(\n"
"      \"iseq_inline_constant_cache_entry\", Primitive.cexpr!(\"SIZEOF(struct iseq_inline_constant_cache_entry)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), flags)\")],\n"
"      value: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), value)\")],\n"
,
#line 310 "mjit_c.rb"
"      _unused1: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), _unused1)\")],\n"
"      _unused2: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), _unused2)\")],\n"
"      ic_cref: [CType::Pointer.new { self.rb_cref_t }, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_constant_cache_entry *)NULL)), ic_cref)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.iseq_inline_iv_cache_entry\n"
"    @iseq_inline_iv_cache_entry ||= CType::Struct.new(\n"
,
#line 318 "mjit_c.rb"
"      \"iseq_inline_iv_cache_entry\", Primitive.cexpr!(\"SIZEOF(struct iseq_inline_iv_cache_entry)\"),\n"
"      value: [CType::Immediate.parse(\"uintptr_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_iv_cache_entry *)NULL)), value)\")],\n"
"      iv_set_name: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct iseq_inline_iv_cache_entry *)NULL)), iv_set_name)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.iseq_inline_storage_entry\n"
"    @iseq_inline_storage_entry ||= CType::Union.new(\n"
,
#line 326 "mjit_c.rb"
"      \"iseq_inline_storage_entry\", Primitive.cexpr!(\"SIZEOF(union iseq_inline_storage_entry)\"),\n"
"      once: CType::Struct.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((union iseq_inline_storage_entry *)NULL)->once)\"),\n"
"        running_thread: [CType::Pointer.new { self.rb_thread_struct }, Primitive.cexpr!(\"OFFSETOF(((union iseq_inline_storage_entry *)NULL)->once, running_thread)\")],\n"
"        value: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((union iseq_inline_storage_entry *)NULL)->once, value)\")],\n"
"      ),\n"
,
#line 332 "mjit_c.rb"
"      ic_cache: self.iseq_inline_constant_cache,\n"
"      iv_cache: self.iseq_inline_iv_cache_entry,\n"
"    )\n"
"  end\n"
"\n"
"  def C.mjit_options\n"
"    @mjit_options ||= CType::Struct.new(\n"
"      \"mjit_options\", Primitive.cexpr!(\"SIZEOF(struct mjit_options)\"),\n"
"      on: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), on)\")],\n"
"      save_temps: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), save_temps)\")],\n"
,
#line 342 "mjit_c.rb"
"      warnings: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), warnings)\")],\n"
"      debug: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), debug)\")],\n"
"      debug_flags: [CType::Pointer.new { CType::Immediate.parse(\"char\") }, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), debug_flags)\")],\n"
"      wait: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), wait)\")],\n"
,
#line 346 "mjit_c.rb"
"      call_threshold: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), call_threshold)\")],\n"
"      verbose: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), verbose)\")],\n"
"      max_cache_size: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), max_cache_size)\")],\n"
"      pause: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), pause)\")],\n"
,
#line 350 "mjit_c.rb"
"      custom: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct mjit_options *)NULL)), custom)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_builtin_function\n"
"    @rb_builtin_function ||= CType::Struct.new(\n"
"      \"rb_builtin_function\", Primitive.cexpr!(\"SIZEOF(struct rb_builtin_function)\"),\n"
"      func_ptr: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), func_ptr)\")],\n"
,
#line 358 "mjit_c.rb"
"      argc: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), argc)\")],\n"
"      index: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), index)\")],\n"
"      name: [CType::Pointer.new { CType::Immediate.parse(\"char\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), name)\")],\n"
,
#line 361 "mjit_c.rb"
"      compiler: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_builtin_function *)NULL)), compiler)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_call_data\n"
"    @rb_call_data ||= CType::Struct.new(\n"
"      \"rb_call_data\", Primitive.cexpr!(\"SIZEOF(struct rb_call_data)\"),\n"
"      ci: [CType::Pointer.new { self.rb_callinfo }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_call_data *)NULL)), ci)\")],\n"
,
#line 369 "mjit_c.rb"
"      cc: [CType::Pointer.new { self.rb_callcache }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_call_data *)NULL)), cc)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callable_method_entry_struct\n"
"    @rb_callable_method_entry_struct ||= CType::Struct.new(\n"
"      \"rb_callable_method_entry_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_callable_method_entry_struct)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), flags)\")],\n"
,
#line 377 "mjit_c.rb"
"      defined_class: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), defined_class)\")],\n"
"      def: [CType::Pointer.new { self.rb_method_definition_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), def)\")],\n"
"      called_id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), called_id)\")],\n"
,
#line 380 "mjit_c.rb"
"      owner: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callable_method_entry_struct *)NULL)), owner)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callcache\n"
"    @rb_callcache ||= CType::Struct.new(\n"
"      \"rb_callcache\", Primitive.cexpr!(\"SIZEOF(struct rb_callcache)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), flags)\")],\n"
"      klass: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), klass)\")],\n"
,
#line 389 "mjit_c.rb"
"      cme_: [CType::Pointer.new { self.rb_callable_method_entry_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), cme_)\")],\n"
"      call_: [self.vm_call_handler, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), call_)\")],\n"
"      aux_: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_callcache *)NULL)->aux_)\"),\n"
"        attr: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_callcache *)NULL)->aux_.attr)\"),\n"
,
#line 395 "mjit_c.rb"
"          value: [CType::Immediate.parse(\"uintptr_t\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_callcache *)NULL)->aux_.attr, value)\")],\n"
"        ),\n"
"        method_missing_reason: self.method_missing_reason,\n"
"        v: self.VALUE,\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_callcache *)NULL)), aux_)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_callinfo\n"
"    @rb_callinfo ||= CType::Struct.new(\n"
"      \"rb_callinfo\", Primitive.cexpr!(\"SIZEOF(struct rb_callinfo)\"),\n"
,
#line 406 "mjit_c.rb"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), flags)\")],\n"
"      kwarg: [CType::Pointer.new { self.rb_callinfo_kwarg }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), kwarg)\")],\n"
"      mid: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), mid)\")],\n"
"      flag: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), flag)\")],\n"
,
#line 410 "mjit_c.rb"
"      argc: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_callinfo *)NULL)), argc)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_control_frame_t\n"
"    @rb_control_frame_t ||= CType::Struct.new(\n"
"      \"rb_control_frame_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_control_frame_struct)\"),\n"
"      pc: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), pc)\")],\n"
,
#line 418 "mjit_c.rb"
"      sp: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), sp)\")],\n"
"      iseq: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), iseq)\")],\n"
"      self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), self)\")],\n"
"      ep: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), ep)\")],\n"
,
#line 422 "mjit_c.rb"
"      block_code: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), block_code)\")],\n"
"      __bp__: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), __bp__)\")],\n"
"      jit_return: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_control_frame_struct *)NULL)), jit_return)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_cref_t\n"
,
#line 429 "mjit_c.rb"
"    @rb_cref_t ||= CType::Struct.new(\n"
"      \"rb_cref_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_cref_struct)\"),\n"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), flags)\")],\n"
"      refinements: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), refinements)\")],\n"
"      klass_or_self: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), klass_or_self)\")],\n"
,
#line 434 "mjit_c.rb"
"      next: [CType::Pointer.new { self.rb_cref_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), next)\")],\n"
"      scope_visi: [self.rb_scope_visibility_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_cref_struct *)NULL)), scope_visi)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_execution_context_struct\n"
"    @rb_execution_context_struct ||= CType::Struct.new(\n"
"      \"rb_execution_context_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_execution_context_struct)\"),\n"
,
#line 442 "mjit_c.rb"
"      vm_stack: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), vm_stack)\")],\n"
"      vm_stack_size: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), vm_stack_size)\")],\n"
"      cfp: [CType::Pointer.new { self.rb_control_frame_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), cfp)\")],\n"
,
#line 445 "mjit_c.rb"
"      tag: [CType::Pointer.new { self.rb_vm_tag }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), tag)\")],\n"
"      interrupt_flag: [self.rb_atomic_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), interrupt_flag)\")],\n"
"      interrupt_mask: [self.rb_atomic_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), interrupt_mask)\")],\n"
,
#line 448 "mjit_c.rb"
"      fiber_ptr: [CType::Pointer.new { self.rb_fiber_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), fiber_ptr)\")],\n"
"      thread_ptr: [CType::Pointer.new { self.rb_thread_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), thread_ptr)\")],\n"
"      local_storage: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), local_storage)\")],\n"
,
#line 451 "mjit_c.rb"
"      local_storage_recursive_hash: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), local_storage_recursive_hash)\")],\n"
"      local_storage_recursive_hash_for_trace: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), local_storage_recursive_hash_for_trace)\")],\n"
"      storage: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), storage)\")],\n"
,
#line 454 "mjit_c.rb"
"      root_lep: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), root_lep)\")],\n"
"      root_svar: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), root_svar)\")],\n"
"      ensure_list: [CType::Pointer.new { self.rb_ensure_list_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), ensure_list)\")],\n"
,
#line 457 "mjit_c.rb"
"      trace_arg: [CType::Pointer.new { self.rb_trace_arg_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), trace_arg)\")],\n"
"      errinfo: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), errinfo)\")],\n"
"      passed_block_handler: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), passed_block_handler)\")],\n"
,
#line 460 "mjit_c.rb"
"      raised_flag: [CType::Immediate.parse(\"uint8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), raised_flag)\")],\n"
"      private_const_reference: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), private_const_reference)\")],\n"
"      machine: [CType::Struct.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_execution_context_struct *)NULL)->machine)\"),\n"
,
#line 464 "mjit_c.rb"
"        stack_start: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_execution_context_struct *)NULL)->machine, stack_start)\")],\n"
"        stack_end: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_execution_context_struct *)NULL)->machine, stack_end)\")],\n"
"        stack_maxsize: [CType::Immediate.parse(\"size_t\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_execution_context_struct *)NULL)->machine, stack_maxsize)\")],\n"
,
#line 467 "mjit_c.rb"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_execution_context_struct *)NULL)), machine)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_execution_context_t\n"
"    @rb_execution_context_t ||= self.rb_execution_context_struct\n"
"  end\n"
"\n"
"  def C.rb_iseq_constant_body\n"
"    @rb_iseq_constant_body ||= CType::Struct.new(\n"
"      \"rb_iseq_constant_body\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_constant_body)\"),\n"
"      type: [self.rb_iseq_type, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), type)\")],\n"
,
#line 479 "mjit_c.rb"
"      iseq_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), iseq_size)\")],\n"
"      iseq_encoded: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), iseq_encoded)\")],\n"
"      param: [CType::Struct.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->param)\"),\n"
"        flags: [CType::Struct.new(\n"
,
#line 484 "mjit_c.rb"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->param.flags)\"),\n"
"          has_lead: [CType::BitField.new(1, 0), 0],\n"
"          has_opt: [CType::BitField.new(1, 1), 1],\n"
"          has_rest: [CType::BitField.new(1, 2), 2],\n"
"          has_post: [CType::BitField.new(1, 3), 3],\n"
"          has_kw: [CType::BitField.new(1, 4), 4],\n"
"          has_kwrest: [CType::BitField.new(1, 5), 5],\n"
"          has_block: [CType::BitField.new(1, 6), 6],\n"
,
#line 492 "mjit_c.rb"
"          ambiguous_param0: [CType::BitField.new(1, 7), 7],\n"
"          accepts_no_kwarg: [CType::BitField.new(1, 0), 8],\n"
"          ruby2_keywords: [CType::BitField.new(1, 1), 9],\n"
"        ), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, flags)\")],\n"
"        size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, size)\")],\n"
,
#line 497 "mjit_c.rb"
"        lead_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, lead_num)\")],\n"
"        opt_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, opt_num)\")],\n"
"        rest_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, rest_start)\")],\n"
,
#line 500 "mjit_c.rb"
"        post_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, post_start)\")],\n"
"        post_num: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, post_num)\")],\n"
"        block_start: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, block_start)\")],\n"
,
#line 503 "mjit_c.rb"
"        opt_table: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, opt_table)\")],\n"
"        keyword: [CType::Pointer.new { self.rb_iseq_param_keyword }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->param, keyword)\")],\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), param)\")],\n"
,
#line 506 "mjit_c.rb"
"      location: [self.rb_iseq_location_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), location)\")],\n"
"      insns_info: [self.iseq_insn_info, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), insns_info)\")],\n"
"      local_table: [CType::Pointer.new { self.ID }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), local_table)\")],\n"
,
#line 509 "mjit_c.rb"
"      catch_table: [CType::Pointer.new { self.iseq_catch_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), catch_table)\")],\n"
"      parent_iseq: [CType::Pointer.new { self.rb_iseq_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), parent_iseq)\")],\n"
"      local_iseq: [CType::Pointer.new { self.rb_iseq_struct }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), local_iseq)\")],\n"
,
#line 512 "mjit_c.rb"
"      is_entries: [CType::Pointer.new { self.iseq_inline_storage_entry }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), is_entries)\")],\n"
"      call_data: [CType::Pointer.new { self.rb_call_data }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), call_data)\")],\n"
"      variable: [CType::Struct.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->variable)\"),\n"
,
#line 516 "mjit_c.rb"
"        flip_count: [self.rb_snum_t, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, flip_count)\")],\n"
"        script_lines: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, script_lines)\")],\n"
"        coverage: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, coverage)\")],\n"
,
#line 519 "mjit_c.rb"
"        pc2branchindex: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, pc2branchindex)\")],\n"
"        original_iseq: [CType::Pointer.new { self.VALUE }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_constant_body *)NULL)->variable, original_iseq)\")],\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), variable)\")],\n"
,
#line 522 "mjit_c.rb"
"      local_table_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), local_table_size)\")],\n"
"      ic_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ic_size)\")],\n"
"      ise_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ise_size)\")],\n"
,
#line 525 "mjit_c.rb"
"      ivc_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ivc_size)\")],\n"
"      icvarc_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), icvarc_size)\")],\n"
"      ci_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), ci_size)\")],\n"
,
#line 528 "mjit_c.rb"
"      stack_max: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), stack_max)\")],\n"
"      catch_except_p: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), catch_except_p)\")],\n"
"      builtin_inline_p: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), builtin_inline_p)\")],\n"
"      mark_bits: [CType::Union.new(\n"
,
#line 532 "mjit_c.rb"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_constant_body *)NULL)->mark_bits)\"),\n"
"        list: CType::Pointer.new { self.iseq_bits_t },\n"
"        single: self.iseq_bits_t,\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), mark_bits)\")],\n"
"      outer_variables: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), outer_variables)\")],\n"
,
#line 537 "mjit_c.rb"
"      mandatory_only_iseq: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), mandatory_only_iseq)\")],\n"
"      jit_func: [CType::Immediate.parse(\"void *\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), jit_func)\")],\n"
"      total_calls: [CType::Immediate.parse(\"unsigned long\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), total_calls)\")],\n"
,
#line 540 "mjit_c.rb"
"      mjit_unit: [CType::Pointer.new { self.rb_mjit_unit }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_constant_body *)NULL)), mjit_unit)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_iseq_location_t\n"
"    @rb_iseq_location_t ||= CType::Struct.new(\n"
"      \"rb_iseq_location_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_location_struct)\"),\n"
"      pathobj: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), pathobj)\"), true],\n"
,
#line 548 "mjit_c.rb"
"      base_label: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), base_label)\"), true],\n"
"      label: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), label)\"), true],\n"
"      first_lineno: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), first_lineno)\"), true],\n"
,
#line 551 "mjit_c.rb"
"      node_id: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), node_id)\")],\n"
"      code_location: [self.rb_code_location_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_location_struct *)NULL)), code_location)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_iseq_struct\n"
"    @rb_iseq_struct ||= CType::Struct.new(\n"
"      \"rb_iseq_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_iseq_struct)\"),\n"
,
#line 559 "mjit_c.rb"
"      flags: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), flags)\")],\n"
"      wrapper: [self.VALUE, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), wrapper)\")],\n"
"      body: [CType::Pointer.new { self.rb_iseq_constant_body }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), body)\")],\n"
"      aux: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_struct *)NULL)->aux)\"),\n"
,
#line 564 "mjit_c.rb"
"        compile_data: CType::Pointer.new { self.iseq_compile_data },\n"
"        loader: CType::Struct.new(\n"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_struct *)NULL)->aux.loader)\"),\n"
"          obj: [self.VALUE, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.loader, obj)\")],\n"
"          index: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.loader, index)\")],\n"
"        ),\n"
"        exec: CType::Struct.new(\n"
,
#line 571 "mjit_c.rb"
"          \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_iseq_struct *)NULL)->aux.exec)\"),\n"
"          local_hooks: [CType::Pointer.new { self.rb_hook_list_struct }, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.exec, local_hooks)\")],\n"
"          global_trace_events: [self.rb_event_flag_t, Primitive.cexpr!(\"OFFSETOF(((struct rb_iseq_struct *)NULL)->aux.exec, global_trace_events)\")],\n"
"        ),\n"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_iseq_struct *)NULL)), aux)\")],\n"
"    )\n"
"  end\n"
"\n"
,
#line 579 "mjit_c.rb"
"  def C.rb_iseq_t\n"
"    @rb_iseq_t ||= self.rb_iseq_struct\n"
"  end\n"
"\n"
"  def C.rb_method_definition_struct\n"
"    @rb_method_definition_struct ||= CType::Struct.new(\n"
"      \"rb_method_definition_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_definition_struct)\"),\n"
"      type: [CType::BitField.new(4, 0), 0],\n"
"      iseq_overload: [CType::BitField.new(1, 4), 4],\n"
"      no_redef_warning: [CType::BitField.new(1, 5), 5],\n"
"      aliased: [CType::BitField.new(1, 6), 6],\n"
,
#line 590 "mjit_c.rb"
"      reference_count: [CType::BitField.new(28, 0), 32],\n"
"      body: [CType::Union.new(\n"
"        \"\", Primitive.cexpr!(\"SIZEOF(((struct rb_method_definition_struct *)NULL)->body)\"),\n"
"        iseq: self.rb_method_iseq_t,\n"
"        cfunc: self.rb_method_cfunc_t,\n"
"        attr: self.rb_method_attr_t,\n"
"        alias: self.rb_method_alias_t,\n"
"        refined: self.rb_method_refined_t,\n"
"        bmethod: self.rb_method_bmethod_t,\n"
"        optimized: self.rb_method_optimized_t,\n"
,
#line 600 "mjit_c.rb"
"      ), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_definition_struct *)NULL)), body)\")],\n"
"      original_id: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_definition_struct *)NULL)), original_id)\")],\n"
"      method_serial: [CType::Immediate.parse(\"uintptr_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_definition_struct *)NULL)), method_serial)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_iseq_t\n"
"    @rb_method_iseq_t ||= CType::Struct.new(\n"
,
#line 608 "mjit_c.rb"
"      \"rb_method_iseq_struct\", Primitive.cexpr!(\"SIZEOF(struct rb_method_iseq_struct)\"),\n"
"      iseqptr: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_iseq_struct *)NULL)), iseqptr)\")],\n"
"      cref: [CType::Pointer.new { self.rb_cref_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_method_iseq_struct *)NULL)), cref)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_method_type_t\n"
"    @rb_method_type_t ||= CType::Immediate.parse(\"int\")\n"
"  end\n"
"\n"
"  def C.rb_mjit_compile_info\n"
,
#line 619 "mjit_c.rb"
"    @rb_mjit_compile_info ||= CType::Struct.new(\n"
"      \"rb_mjit_compile_info\", Primitive.cexpr!(\"SIZEOF(struct rb_mjit_compile_info)\"),\n"
"      disable_ivar_cache: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_compile_info *)NULL)), disable_ivar_cache)\")],\n"
"      disable_exivar_cache: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_compile_info *)NULL)), disable_exivar_cache)\")],\n"
,
#line 623 "mjit_c.rb"
"      disable_send_cache: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_compile_info *)NULL)), disable_send_cache)\")],\n"
"      disable_inlining: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_compile_info *)NULL)), disable_inlining)\")],\n"
"      disable_const_cache: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_compile_info *)NULL)), disable_const_cache)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_mjit_unit\n"
"    @rb_mjit_unit ||= CType::Struct.new(\n"
,
#line 631 "mjit_c.rb"
"      \"rb_mjit_unit\", Primitive.cexpr!(\"SIZEOF(struct rb_mjit_unit)\"),\n"
"      unode: [self.ccan_list_node, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), unode)\")],\n"
"      id: [CType::Immediate.parse(\"int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), id)\")],\n"
"      type: [self.rb_mjit_unit_type, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), type)\")],\n"
,
#line 635 "mjit_c.rb"
"      iseq: [CType::Pointer.new { self.rb_iseq_t }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), iseq)\")],\n"
"      used_code_p: [self._Bool, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), used_code_p)\")],\n"
"      compile_info: [self.rb_mjit_compile_info, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), compile_info)\")],\n"
,
#line 638 "mjit_c.rb"
"      cc_entries: [CType::Pointer.new { CType::Pointer.new { self.rb_callcache } }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), cc_entries)\")],\n"
"      cc_entries_size: [CType::Immediate.parse(\"unsigned int\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), cc_entries_size)\")],\n"
"      handle: [CType::Pointer.new { CType::Immediate.parse(\"void\") }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), handle)\")],\n"
,
#line 641 "mjit_c.rb"
"      units: [self.rb_mjit_unit_list, Primitive.cexpr!(\"OFFSETOF((*((struct rb_mjit_unit *)NULL)), units)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_serial_t\n"
"    @rb_serial_t ||= CType::Immediate.parse(\"unsigned long long\")\n"
"  end\n"
"\n"
"  def C.rb_shape\n"
"    @rb_shape ||= CType::Struct.new(\n"
"      \"rb_shape\", Primitive.cexpr!(\"SIZEOF(struct rb_shape)\"),\n"
"      edges: [CType::Pointer.new { self.rb_id_table }, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), edges)\")],\n"
,
#line 653 "mjit_c.rb"
"      edge_name: [self.ID, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), edge_name)\")],\n"
"      next_iv_index: [self.attr_index_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), next_iv_index)\")],\n"
"      capacity: [CType::Immediate.parse(\"uint32_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), capacity)\")],\n"
"      type: [CType::Immediate.parse(\"uint8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), type)\")],\n"
,
#line 657 "mjit_c.rb"
"      size_pool_index: [CType::Immediate.parse(\"uint8_t\"), Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), size_pool_index)\")],\n"
"      parent_id: [self.shape_id_t, Primitive.cexpr!(\"OFFSETOF((*((struct rb_shape *)NULL)), parent_id)\")],\n"
"    )\n"
"  end\n"
"\n"
"  def C.rb_shape_t\n"
"    @rb_shape_t ||= self.rb_shape\n"
"  end\n"
"\n"
"  def C.VALUE\n"
"    @VALUE ||= CType::Immediate.find(Primitive.cexpr!(\"SIZEOF(VALUE)\"), Primitive.cexpr!(\"SIGNED_TYPE_P(VALUE)\"))\n"
"  end\n"
"\n"
"  def C.shape_id_t\n"
,
#line 671 "mjit_c.rb"
"    @shape_id_t ||= CType::Immediate.find(Primitive.cexpr!(\"SIZEOF(shape_id_t)\"), Primitive.cexpr!(\"SIGNED_TYPE_P(shape_id_t)\"))\n"
"  end\n"
"\n"
"  def C._Bool\n"
"    CType::Bool.new\n"
"  end\n"
"\n"
"  def C.ID\n"
"    CType::Stub.new(:ID)\n"
"  end\n"
"\n"
"  def C.rb_thread_struct\n"
"    CType::Stub.new(:rb_thread_struct)\n"
"  end\n"
"\n"
"  def C.vm_call_handler\n"
"    CType::Stub.new(:vm_call_handler)\n"
"  end\n"
"\n"
"  def C.method_missing_reason\n"
"    CType::Stub.new(:method_missing_reason)\n"
"  end\n"
"\n"
"  def C.rb_callinfo_kwarg\n"
"    CType::Stub.new(:rb_callinfo_kwarg)\n"
,
#line 696 "mjit_c.rb"
"  end\n"
"\n"
"  def C.rb_cref_struct\n"
"    CType::Stub.new(:rb_cref_struct)\n"
"  end\n"
"\n"
"  def C.rb_scope_visibility_t\n"
"    CType::Stub.new(:rb_scope_visibility_t)\n"
"  end\n"
"\n"
"  def C.rb_vm_tag\n"
"    CType::Stub.new(:rb_vm_tag)\n"
"  end\n"
"\n"
"  def C.rb_atomic_t\n"
"    CType::Stub.new(:rb_atomic_t)\n"
"  end\n"
"\n"
"  def C.rb_fiber_t\n"
"    CType::Stub.new(:rb_fiber_t)\n"
"  end\n"
"\n"
"  def C.rb_id_table\n"
"    CType::Stub.new(:rb_id_table)\n"
"  end\n"
"\n"
"  def C.rb_ensure_list_t\n"
"    CType::Stub.new(:rb_ensure_list_t)\n"
"  end\n"
"\n"
"  def C.rb_trace_arg_struct\n"
,
#line 727 "mjit_c.rb"
"    CType::Stub.new(:rb_trace_arg_struct)\n"
"  end\n"
"\n"
"  def C.rb_iseq_type\n"
"    CType::Stub.new(:rb_iseq_type)\n"
"  end\n"
"\n"
"  def C.rb_iseq_param_keyword\n"
"    CType::Stub.new(:rb_iseq_param_keyword)\n"
"  end\n"
"\n"
"  def C.iseq_insn_info\n"
"    CType::Stub.new(:iseq_insn_info)\n"
"  end\n"
"\n"
"  def C.iseq_catch_table\n"
"    CType::Stub.new(:iseq_catch_table)\n"
"  end\n"
"\n"
"  def C.rb_snum_t\n"
"    CType::Stub.new(:rb_snum_t)\n"
"  end\n"
"\n"
"  def C.iseq_bits_t\n"
"    CType::Stub.new(:iseq_bits_t)\n"
"  end\n"
"\n"
"  def C.rb_code_location_t\n"
,
#line 755 "mjit_c.rb"
"    CType::Stub.new(:rb_code_location_t)\n"
"  end\n"
"\n"
"  def C.iseq_compile_data\n"
"    CType::Stub.new(:iseq_compile_data)\n"
"  end\n"
"\n"
"  def C.rb_hook_list_struct\n"
"    CType::Stub.new(:rb_hook_list_struct)\n"
"  end\n"
"\n"
"  def C.rb_event_flag_t\n"
"    CType::Stub.new(:rb_event_flag_t)\n"
"  end\n"
"\n"
"  def C.rb_method_cfunc_t\n"
"    CType::Stub.new(:rb_method_cfunc_t)\n"
"  end\n"
"\n"
"  def C.rb_method_attr_t\n"
"    CType::Stub.new(:rb_method_attr_t)\n"
"  end\n"
"\n"
"  def C.rb_method_alias_t\n"
"    CType::Stub.new(:rb_method_alias_t)\n"
"  end\n"
"\n"
,
#line 782 "mjit_c.rb"
"  def C.rb_method_refined_t\n"
"    CType::Stub.new(:rb_method_refined_t)\n"
"  end\n"
"\n"
"  def C.rb_method_bmethod_t\n"
"    CType::Stub.new(:rb_method_bmethod_t)\n"
"  end\n"
"\n"
"  def C.rb_method_optimized_t\n"
"    CType::Stub.new(:rb_method_optimized_t)\n"
"  end\n"
"\n"
"  def C.ccan_list_node\n"
"    CType::Stub.new(:ccan_list_node)\n"
"  end\n"
"\n"
"  def C.rb_mjit_unit_type\n"
"    CType::Stub.new(:rb_mjit_unit_type)\n"
"  end\n"
"\n"
"  def C.rb_mjit_unit_list\n"
"    CType::Stub.new(:rb_mjit_unit_list)\n"
"  end\n"
"\n"
"\n"/* # MJIT bindgen end ### */
,
#line 807 "mjit_c.rb"
"end if RubyVM::MJIT.enabled? && RubyVM::MJIT.const_defined?(:C)\n"/* not defined for miniruby */
#line 2686 "miniprelude.c"
};

static const char prelude_name8[] = "<internal:pack>";
static const struct {
    char L0[273]; /* 1..32 */
} prelude_code8 = {
#line 1 "pack.rb"
"class Array\n"
"\n"/*  call-seq: */
"\n"/*    pack(template, buffer: nil) -> string */
"\n"/*  */
"\n"/*  Formats each element in +self+ into a binary string; returns that string. */
"\n"/*  See {Packed Data}[rdoc-ref:packed_data.rdoc]. */
"  def pack(fmt, buffer: nil)\n"
"    Primitive.pack_pack(fmt, buffer)\n"
"  end\n"
"end\n"
"\n"
"class String\n"
"\n"/* call-seq: */
"\n"/*   unpack(template, offset: 0) -> array */
"\n"/*  */
"\n"/*  Extracts data from +self+, forming objects that become the elements of a new array; */
"\n"/*  returns that array. */
"\n"/*  See {Packed Data}[rdoc-ref:packed_data.rdoc]. */
"  def unpack(fmt, offset: 0)\n"
"    Primitive.pack_unpack(fmt, offset)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   unpack1(template, offset: 0) -> object */
"\n"/*  */
"\n"/*  Like String#unpack, but unpacks and returns only the first extracted object. */
"\n"/*  See {Packed Data}[rdoc-ref:packed_data.rdoc]. */
"  def unpack1(fmt, offset: 0)\n"
"    Primitive.pack_unpack1(fmt, offset)\n"
"  end\n"
"end\n"
#line 2725 "miniprelude.c"
};

static const char prelude_name9[] = "<internal:trace_point>";
static const struct {
    char L0[508]; /* 1..238 */
    char L238[506]; /* 239..328 */
    char L328[496]; /* 329..403 */
    char L403[215]; /* 404..421 */
} prelude_code9 = {
#line 1 "trace_point.rb"
""/* loaded from vm_trace.c */
""
""/* Document-class: TracePoint */
""/*  */
""/* A class that provides the functionality of Kernel#set_trace_func in a */
""/* nice Object-Oriented API. */
""/*  */
""/* == Example */
""/*  */
""/* We can use TracePoint to gather information specifically for exceptions: */
""/*  */
""/*     trace = TracePoint.new(:raise) do |tp| */
""/* 	p [tp.lineno, tp.event, tp.raised_exception] */
""/*     end */
""/*     #=> #<TracePoint:disabled> */
""/*  */
""/*     trace.enable */
""/*     #=> false */
""/*  */
""/*     0 / 0 */
""/*     #=> [5, :raise, #<ZeroDivisionError: divided by 0>] */
""/*  */
""/* == Events */
""/*  */
""/* If you don't specify the type of events you want to listen for, */
""/* TracePoint will include all available events. */
""/*  */
""/* *Note* do not depend on current event set, as this list is subject to */
""/* change. Instead, it is recommended you specify the type of events you */
""/* want to use. */
""/*  */
""/* To filter what is traced, you can pass any of the following as +events+: */
""/*  */
""/* +:line+:: execute an expression or statement on a new line */
""/* +:class+:: start a class or module definition */
""/* +:end+:: finish a class or module definition */
""/* +:call+:: call a Ruby method */
""/* +:return+:: return from a Ruby method */
""/* +:c_call+:: call a C-language routine */
""/* +:c_return+:: return from a C-language routine */
""/* +:raise+:: raise an exception */
""/* +:b_call+:: event hook at block entry */
""/* +:b_return+:: event hook at block ending */
""/* +:a_call+:: event hook at all calls (+call+, +b_call+, and +c_call+) */
""/* +:a_return+:: event hook at all returns (+return+, +b_return+, and +c_return+) */
""/* +:thread_begin+:: event hook at thread beginning */
""/* +:thread_end+:: event hook at thread ending */
""/* +:fiber_switch+:: event hook at fiber switch */
""/* +:script_compiled+:: new Ruby code compiled (with +eval+, +load+ or +require+) */
""/*  */
"class TracePoint\n"
"\n"/* call-seq: */
"\n"/* TracePoint.new(*events) { |obj| block }	    -> obj */
"\n"/*  */
"\n"/* Returns a new TracePoint object, not enabled by default. */
"\n"/*  */
"\n"/* Next, in order to activate the trace, you must use TracePoint#enable */
"\n"/*  */
"\n"/* trace = TracePoint.new(:call) do |tp| */
"\n"/*     p [tp.lineno, tp.defined_class, tp.method_id, tp.event] */
"\n"/* end */
"\n"/* #=> #<TracePoint:disabled> */
"\n"/*  */
"\n"/* trace.enable */
"\n"/* #=> false */
"\n"/*  */
"\n"/* puts "Hello, TracePoint!" */
"\n"/* # ... */
"\n"/* # [48, IRB::Notifier::AbstractNotifier, :printf, :call] */
"\n"/* # ... */
"\n"/*  */
"\n"/* When you want to deactivate the trace, you must use TracePoint#disable */
"\n"/*  */
"\n"/* trace.disable */
"\n"/*  */
"\n"/* See TracePoint@Events for possible events and more information. */
"\n"/*  */
"\n"/* A block must be given, otherwise an ArgumentError is raised. */
"\n"/*  */
"\n"/* If the trace method isn't included in the given events filter, a */
"\n"/* RuntimeError is raised. */
"\n"/*  */
"\n"/* TracePoint.trace(:line) do |tp| */
"\n"/*     p tp.raised_exception */
"\n"/* end */
"\n"/* #=> RuntimeError: 'raised_exception' not supported by this event */
"\n"/*  */
"\n"/* If the trace method is called outside block, a RuntimeError is raised. */
"\n"/*  */
"\n"/*      TracePoint.trace(:line) do |tp| */
"\n"/*        $tp = tp */
"\n"/*      end */
"\n"/*      $tp.lineno #=> access from outside (RuntimeError) */
"\n"/*  */
"\n"/* Access from other threads is also forbidden. */
"\n"/*  */
"  def self.new(*events)\n"
"    Primitive.tracepoint_new_s(events)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    trace.inspect  -> string */
"\n"/*  */
"\n"/*  Return a string containing a human-readable TracePoint */
"\n"/*  status. */
"  def inspect\n"
"    Primitive.tracepoint_inspect\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* TracePoint.stat -> obj */
"\n"/*  */
"\n"/*  Returns internal information of TracePoint. */
"\n"/*  */
"\n"/*  The contents of the returned value are implementation specific. */
"\n"/*  It may be changed in future. */
"\n"/*  */
"\n"/*  This method is only for debugging TracePoint itself. */
"  def self.stat\n"
"    Primitive.tracepoint_stat_s\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    TracePoint.trace(*events) { |obj| block }	-> obj */
"\n"/*  */
"\n"/* A convenience method for TracePoint.new, that activates the trace */
"\n"/* automatically. */
"\n"/*  */
"\n"/*     trace = TracePoint.trace(:call) { |tp| [tp.lineno, tp.event] } */
"\n"/*     #=> #<TracePoint:enabled> */
"\n"/*  */
"\n"/*     trace.enabled? #=> true */
"\n"/*  */
"  def self.trace(*events)\n"
"    Primitive.tracepoint_trace_s(events)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   TracePoint.allow_reentry { block } */
"\n"/*  */
"\n"/* In general, while a TracePoint callback is running, */
"\n"/* other registered callbacks are not called to avoid */
"\n"/* confusion by reentrance. */
"\n"/* This method allows the reentrance in a given block. */
"\n"/* This method should be used carefully, otherwise the callback */
"\n"/* can be easily called infinitely. */
"\n"/*  */
"\n"/* If this method is called when the reentrance is already allowed, */
"\n"/* it raises a RuntimeError. */
"\n"/*  */
"\n"/* <b>Example:</b> */
"\n"/*  */
"\n"/*   # Without reentry */
"\n"/*   # --------------- */
"\n"/*  */
"\n"/*   line_handler = TracePoint.new(:line) do |tp| */
"\n"/*     next if tp.path != __FILE__ # only work in this file */
"\n"/*     puts "Line handler" */
"\n"/*     binding.eval("class C; end") */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class_handler = TracePoint.new(:class) do |tp| */
"\n"/*     puts "Class handler" */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class B */
"\n"/*   end */
"\n"/*  */
"\n"/*   # This script will print "Class handler" only once: when inside :line */
"\n"/*   # handler, all other handlers are ignored */
"\n"/*  */
"\n"/*  */
"\n"/*   # With reentry */
"\n"/*   # ------------ */
"\n"/*  */
"\n"/*   line_handler = TracePoint.new(:line) do |tp| */
"\n"/*     next if tp.path != __FILE__ # only work in this file */
"\n"/*     next if (__LINE__..__LINE__+3).cover?(tp.lineno) # don't be invoked from itself */
"\n"/*     puts "Line handler" */
"\n"/*     TracePoint.allow_reentry { binding.eval("class C; end") } */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class_handler = TracePoint.new(:class) do |tp| */
"\n"/*     puts "Class handler" */
"\n"/*   end.enable */
"\n"/*  */
"\n"/*   class B */
"\n"/*   end */
"\n"/*  */
"\n"/*   # This wil print "Class handler" twice: inside allow_reentry block in :line */
"\n"/*   # handler, other handlers are enabled. */
"\n"/*  */
"\n"/* Note that the example shows the principal effect of the method, but its */
"\n"/* practical usage is for debugging libraries that sometimes require other libraries */
"\n"/* hooks to not be affected by debugger being inside trace point handling. Precautions */
"\n"/* should be taken against infinite recursion in this case (note that we needed to filter */
"\n"/* out calls by itself from :line handler, otherwise it will call itself infinitely). */
"\n"/*  */
"  def self.allow_reentry\n"
"    Primitive.tracepoint_allow_reentry\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: nil)    -> true or false */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: :default) { block }  -> obj */
"\n"/*  */
"\n"/* Activates the trace. */
"\n"/*  */
"\n"/* Returns +true+ if trace was enabled. */
"\n"/* Returns +false+ if trace was disabled. */
"\n"/*  */
"\n"/*   trace.enabled?  #=> false */
"\n"/*   trace.enable    #=> false (previous state) */
"\n"/*                   #   trace is enabled */
"\n"/*   trace.enabled?  #=> true */
"\n"/*   trace.enable    #=> true (previous state) */
"\n"/*                   #   trace is still enabled */
"\n"/*  */
"\n"/* If a block is given, the trace will only be enabled during the block call. */
"\n"/* If target and target_line are both nil, then target_thread will default */
"\n"/* to the current thread if a block is given. */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/*    trace.enable do */
"\n"/*      trace.enabled? */
"\n"/*      # only enabled for this block and thread */
"\n"/*    end */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/* +target+, +target_line+ and +target_thread+ parameters are used to */
"\n"/* limit tracing only to specified code objects. +target+ should be a */
"\n"/* code object for which RubyVM::InstructionSequence.of will return */
"\n"/* an instruction sequence. */
"\n"/*  */
,
#line 239 "trace_point.rb"
"\n"/*    t = TracePoint.new(:line) { |tp| p tp } */
"\n"/*  */
"\n"/*    def m1 */
"\n"/*      p 1 */
"\n"/*    end */
"\n"/*  */
"\n"/*    def m2 */
"\n"/*      p 2 */
"\n"/*    end */
"\n"/*  */
"\n"/*    t.enable(target: method(:m1)) */
"\n"/*  */
"\n"/*    m1 */
"\n"/*    # prints #<TracePoint:line test.rb:4 in `m1'> */
"\n"/*    m2 */
"\n"/*    # prints nothing */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the +enable+ block. */
"\n"/*  */
"\n"/*    trace.enable { p tp.lineno } */
"\n"/*    #=> RuntimeError: access from outside */
"\n"/*  */
"  def enable(target: nil, target_line: nil, target_thread: :default)\n"
"    Primitive.tracepoint_enable_m(target, target_line, target_thread)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.disable		-> true or false */
"\n"/* trace.disable { block } -> obj */
"\n"/*  */
"\n"/* Deactivates the trace */
"\n"/*  */
"\n"/* Return true if trace was enabled. */
"\n"/* Return false if trace was disabled. */
"\n"/*  */
"\n"/* trace.enabled?	#=> true */
"\n"/* trace.disable	#=> true (previous status) */
"\n"/* trace.enabled?	#=> false */
"\n"/* trace.disable	#=> false */
"\n"/*  */
"\n"/* If a block is given, the trace will only be disable within the scope of the */
"\n"/* block. */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* trace.disable do */
"\n"/*     trace.enabled? */
"\n"/*     # only disabled for this block */
"\n"/* end */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the block. */
"\n"/*  */
"\n"/* trace.disable { p tp.lineno } */
"\n"/* #=> RuntimeError: access from outside */
"  def disable\n"
"    Primitive.tracepoint_disable_m\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.enabled?	    -> true or false */
"\n"/*  */
"\n"/* The current status of the trace */
"  def enabled?\n"
"    Primitive.tracepoint_enabled_p\n"
"  end\n"
"\n"
"\n"/* Type of event */
"\n"/*  */
"\n"/* See TracePoint@Events for more information. */
"  def event\n"
"    Primitive.tracepoint_attr_event\n"
"  end\n"
"\n"
"\n"/* Line number of the event */
"  def lineno\n"
"    Primitive.tracepoint_attr_lineno\n"
"  end\n"
"\n"
"\n"/* Path of the file being run */
"  def path\n"
"    Primitive.tracepoint_attr_path\n"
"  end\n"
"\n"
"\n"/* Return the parameters definition of the method or block that the */
"\n"/* current hook belongs to. Format is the same as for Method#parameters */
"  def parameters\n"
,
#line 329 "trace_point.rb"
"    Primitive.tracepoint_attr_parameters\n"
"  end\n"
"\n"
"\n"/* Return the name at the definition of the method being called */
"  def method_id\n"
"    Primitive.tracepoint_attr_method_id\n"
"  end\n"
"\n"
"\n"/* Return the called name of the method being called */
"  def callee_id\n"
"    Primitive.tracepoint_attr_callee_id\n"
"  end\n"
"\n"
"\n"/* Return class or module of the method being called. */
"\n"/*  */
"\n"/* class C; def foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> C */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* If method is defined by a module, then that module is returned. */
"\n"/*  */
"\n"/* module M; def foo; end; end */
"\n"/* 	class C; include M; end; */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> M */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* <b>Note:</b> #defined_class returns singleton class. */
"\n"/*  */
"\n"/* 6th block parameter of Kernel#set_trace_func passes original class */
"\n"/* of attached by singleton class. */
"\n"/*  */
"\n"/* <b>This is a difference between Kernel#set_trace_func and TracePoint.</b> */
"\n"/*  */
"\n"/* class C; def self.foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> #<Class:C> */
"\n"/* 	end.enable do */
"\n"/* 	  C.foo */
"\n"/* 	end */
"  def defined_class\n"
"    Primitive.tracepoint_attr_defined_class\n"
"  end\n"
"\n"
"\n"/* Return the generated binding object from event. */
"\n"/*  */
"\n"/* Note that for +c_call+ and +c_return+ events, the binding returned is the */
"\n"/* binding of the nearest Ruby method calling the C method, since C methods */
"\n"/* themselves do not have bindings. */
"  def binding\n"
"    Primitive.tracepoint_attr_binding\n"
"  end\n"
"\n"
"\n"/* Return the trace object during event */
"\n"/*  */
"\n"/* Same as the following, except it returns the correct object (the method */
"\n"/* receiver) for +c_call+ and +c_return+ events: */
"\n"/*  */
"\n"/*   trace.binding.eval('self') */
"  def self\n"
"    Primitive.tracepoint_attr_self\n"
"  end\n"
"\n"
"\n"/*  Return value from +:return+, +c_return+, and +b_return+ event */
"  def return_value\n"
"    Primitive.tracepoint_attr_return_value\n"
"  end\n"
"\n"
"\n"/* Value from exception raised on the +:raise+ event */
"  def raised_exception\n"
,
#line 404 "trace_point.rb"
"    Primitive.tracepoint_attr_raised_exception\n"
"  end\n"
"\n"
"\n"/* Compiled source code (String) on *eval methods on the +:script_compiled+ event. */
"\n"/* If loaded from a file, it will return nil. */
"  def eval_script\n"
"    Primitive.tracepoint_attr_eval_script\n"
"  end\n"
"\n"
"\n"/* Compiled instruction sequence represented by a RubyVM::InstructionSequence instance */
"\n"/* on the +:script_compiled+ event. */
"\n"/*  */
"\n"/* Note that this method is MRI specific. */
"  def instruction_sequence\n"
"    Primitive.tracepoint_attr_instruction_sequence\n"
"  end\n"
"end\n"
#line 3162 "miniprelude.c"
};

static const char prelude_name10[] = "<internal:warning>";
static const struct {
    char L0[182]; /* 1..54 */
} prelude_code10 = {
#line 1 "warning.rb"
""/* encoding: utf-8 */
""/* frozen-string-literal: true */
""
"module Kernel\n"
"  module_function\n"
"\n"
"\n"/* call-seq: */
"\n"/*    warn(*msgs, uplevel: nil, category: nil)   -> nil */
"\n"/*  */
"\n"/* If warnings have been disabled (for example with the */
"\n"/* <code>-W0</code> flag), does nothing.  Otherwise, */
"\n"/* converts each of the messages to strings, appends a newline */
"\n"/* character to the string if the string does not end in a newline, */
"\n"/* and calls Warning.warn with the string. */
"\n"/*  */
"\n"/*    warn("warning 1", "warning 2") */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    warning 1 */
"\n"/*    warning 2 */
"\n"/*  */
"\n"/* If the <code>uplevel</code> keyword argument is given, the string will */
"\n"/* be prepended with information for the given caller frame in */
"\n"/* the same format used by the <code>rb_warn</code> C function. */
"\n"/*  */
"\n"/*    # In baz.rb */
"\n"/*    def foo */
"\n"/*      warn("invalid call to foo", uplevel: 1) */
"\n"/*    end */
"\n"/*  */
"\n"/*    def bar */
"\n"/*      foo */
"\n"/*    end */
"\n"/*  */
"\n"/*    bar */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    baz.rb:6: warning: invalid call to foo */
"\n"/*  */
"\n"/* If <code>category</code> keyword argument is given, passes the category */
"\n"/* to <code>Warning.warn</code>.  The category given must be be one of the */
"\n"/* following categories: */
"\n"/*  */
"\n"/* :deprecated :: Used for warning for deprecated functionality that may */
"\n"/*                be removed in the future. */
"\n"/* :experimental :: Used for experimental features that may change in */
"\n"/*                  future releases. */
"  def warn(*msgs, uplevel: nil, category: nil)\n"
"    Primitive.rb_warn_m(msgs, uplevel, category)\n"
"  end\n"
"end\n"
#line 3223 "miniprelude.c"
};

static const char prelude_name11[] = "<internal:array>";
static const struct {
    char L0[397]; /* 1..70 */
} prelude_code11 = {
#line 1 "array.rb"
"class Array\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle!(random: Random) -> array */
"\n"/*  */
"\n"/* Shuffles the elements of +self+ in place. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle!    #=> [2, 3, 1] */
"\n"/*    a             #=> [2, 3, 1] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle!(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle!(random: Random)\n"
"    Primitive.rb_ary_shuffle_bang(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle(random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns a new array with elements of +self+ shuffled. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle     #=> [2, 3, 1] */
"\n"/*    a             #=> [1, 2, 3] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle(random: Random)\n"
"    Primitive.rb_ary_shuffle(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.sample(random: Random) -> object */
"\n"/*    array.sample(n, random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns random elements from +self+. */
"\n"/*  */
"\n"/* When no arguments are given, returns a random element from +self+: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample # => 3 */
"\n"/*    a.sample # => 8 */
"\n"/* If +self+ is empty, returns +nil+. */
"\n"/*  */
"\n"/* When argument +n+ is given, returns a new \Array containing +n+ random */
"\n"/* elements from +self+: */
"\n"/*    a.sample(3) # => [8, 9, 2] */
"\n"/*    a.sample(6) # => [9, 6, 10, 3, 1, 4] */
"\n"/* Returns no more than <tt>a.size</tt> elements */
"\n"/* (because no new duplicates are introduced): */
"\n"/*    a.sample(a.size * 2) # => [6, 4, 1, 8, 5, 9, 10, 2, 3, 7] */
"\n"/* But +self+ may contain duplicates: */
"\n"/*    a = [1, 1, 1, 2, 2, 3] */
"\n"/*    a.sample(a.size * 2) # => [1, 1, 3, 2, 1, 2] */
"\n"/* The argument +n+ must be a non-negative numeric value. */
"\n"/* The order of the result array is unrelated to the order of +self+. */
"\n"/* Returns a new empty \Array if +self+ is empty. */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample(random: Random.new(1))     #=> 6 */
"\n"/*    a.sample(4, random: Random.new(1))  #=> [6, 10, 9, 2] */
"  def sample(n = (ary = false), random: Random)\n"
"    if Primitive.mandatory_only?\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, rb_cRandom, Qfalse, Qfalse) } */
"      Primitive.ary_sample0\n"
"    else\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, random, n, ary) } */
"      Primitive.ary_sample(random, n, ary)\n"
"    end\n"
"  end\n"
"end\n"
#line 3300 "miniprelude.c"
};

static const char prelude_name12[] = "<internal:kernel>";
static const struct {
    char L0[454]; /* 1..121 */
    char L121[486]; /* 122..179 */
} prelude_code12 = {
#line 1 "kernel.rb"
"module Kernel\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.class    -> class */
"\n"/*  */
"\n"/*  Returns the class of <i>obj</i>. This method must always be called */
"\n"/*  with an explicit receiver, as #class is also a reserved word in */
"\n"/*  Ruby. */
"\n"/*  */
"\n"/*     1.class      #=> Integer */
"\n"/*     self.class   #=> Object */
"\n"/* -- */
"\n"/* Equivalent to \c Object\#class in Ruby. */
"\n"/*  */
"\n"/* Returns the class of \c obj, skipping singleton classes or module inclusions. */
"\n"/* ++ */
"\n"/*  */
"  def class\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_class(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.clone(freeze: nil) -> an_object */
"\n"/*  */
"\n"/*  Produces a shallow copy of <i>obj</i>---the instance variables of */
"\n"/*  <i>obj</i> are copied, but not the objects they reference. */
"\n"/*  #clone copies the frozen value state of <i>obj</i>, unless the */
"\n"/*  +:freeze+ keyword argument is given with a false or true value. */
"\n"/*  See also the discussion under Object#dup. */
"\n"/*  */
"\n"/*     class Klass */
"\n"/*        attr_accessor :str */
"\n"/*     end */
"\n"/*     s1 = Klass.new      #=> #<Klass:0x401b3a38> */
"\n"/*     s1.str = "Hello"    #=> "Hello" */
"\n"/*     s2 = s1.clone       #=> #<Klass:0x401b3998 @str="Hello"> */
"\n"/*     s2.str[1,4] = "i"   #=> "i" */
"\n"/*     s1.inspect          #=> "#<Klass:0x401b3a38 @str=\"Hi\">" */
"\n"/*     s2.inspect          #=> "#<Klass:0x401b3998 @str=\"Hi\">" */
"\n"/*  */
"\n"/*  This method may have class-specific behavior.  If so, that */
"\n"/*  behavior will be documented under the #+initialize_copy+ method of */
"\n"/*  the class. */
"\n"/*  */
"  def clone(freeze: nil)\n"
"    Primitive.rb_obj_clone2(freeze)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.frozen?    -> true or false */
"\n"/*  */
"\n"/*  Returns the freeze status of <i>obj</i>. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     a.freeze    #=> ["a", "b", "c"] */
"\n"/*     a.frozen?   #=> true */
"\n"/* -- */
"\n"/* Determines if the object is frozen. Equivalent to \c Object\#frozen? in Ruby. */
"\n"/* \param[in] obj  the object to be determines */
"\n"/* \retval Qtrue if frozen */
"\n"/* \retval Qfalse if not frozen */
"\n"/* ++ */
"\n"/*  */
"  def frozen?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_frozen_p(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.tap {|x| block }    -> obj */
"\n"/*  */
"\n"/*  Yields self to the block, and then returns self. */
"\n"/*  The primary purpose of this method is to "tap into" a method chain, */
"\n"/*  in order to perform operations on intermediate results within the chain. */
"\n"/*  */
"\n"/*     (1..10)                  .tap {|x| puts "original: #{x}" } */
"\n"/*       .to_a                  .tap {|x| puts "array:    #{x}" } */
"\n"/*       .select {|x| x.even? } .tap {|x| puts "evens:    #{x}" } */
"\n"/*       .map {|x| x*x }        .tap {|x| puts "squares:  #{x}" } */
"\n"/*  */
"\n"/* -- */
"\n"/* \private */
"\n"/* ++ */
"\n"/*  */
"  def tap\n"
"    yield(self)\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.then {|x| block }          -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     3.next.then {|x| x**x }.to_s             #=> "256" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| URI(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"\n"/*  When called without block, the method returns +Enumerator+, */
"\n"/*  which can be used, for example, for conditional */
"\n"/*  circuit-breaking: */
"\n"/*  */
"\n"/*     # meets condition, no-op */
"\n"/*     1.then.detect(&:odd?)            # => 1 */
"\n"/*     # does not meet condition, drop value */
"\n"/*     2.then.detect(&:odd?)            # => nil */
"\n"/*  */
"  def then\n"
"    unless Primitive.block_given_p\n"
,
#line 122 "kernel.rb"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.yield_self {|x| block }    -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     "my string".yield_self {|s| s.upcase }   #=> "MY STRING" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| URI(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"  def yield_self\n"
"    unless Primitive.block_given_p\n"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"  module_function\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Float(arg, exception: true)    -> float or nil */
"\n"/*  */
"\n"/*  Returns <i>arg</i> converted to a float. Numeric types are */
"\n"/*  converted directly, and with exception to String and */
"\n"/*  <code>nil</code> the rest are converted using */
"\n"/*  <i>arg</i><code>.to_f</code>.  Converting a String with invalid */
"\n"/*  characters will result in a ArgumentError.  Converting */
"\n"/*  <code>nil</code> generates a TypeError.  Exceptions can be */
"\n"/*  suppressed by passing <code>exception: false</code>. */
"\n"/*  */
"\n"/*     Float(1)                 #=> 1.0 */
"\n"/*     Float("123.456")         #=> 123.456 */
"\n"/*     Float("123.0_badstring") #=> ArgumentError: invalid value for Float(): "123.0_badstring" */
"\n"/*     Float(nil)               #=> TypeError: can't convert nil into Float */
"\n"/*     Float("123.0_badstring", exception: false)  #=> nil */
"\n"/*  */
"  def Float(arg, exception: true)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.rb_f_float1(arg)\n"
"    else\n"
"      Primitive.rb_f_float(arg, exception)\n"
"    end\n"
"  end\n"
"end\n"
#line 3489 "miniprelude.c"
};

static const char prelude_name13[] = "<internal:ractor>";
static const struct {
    char L0[502]; /* 1..270 */
    char L270[502]; /* 271..348 */
    char L348[477]; /* 349..420 */
    char L420[508]; /* 421..582 */
    char L582[467]; /* 583..703 */
    char L703[487]; /* 704..720 */
    char L720[483]; /* 721..815 */
    char L815[422]; /* 816..843 */
} prelude_code13 = {
#line 1 "ractor.rb"
""/* Ractor is an Actor-model abstraction for Ruby that provides thread-safe parallel execution. */
""/*  */
""/* Ractor.new can make a new Ractor, and it will run in parallel. */
""/*  */
""/*     # The simplest ractor */
""/*     r = Ractor.new {puts "I am in Ractor!"} */
""/*     r.take # wait for it to finish */
""/*     # here "I am in Ractor!" would be printed */
""/*  */
""/* Ractors do not share usual objects, so the same kinds of thread-safety concerns such as data-race, */
""/* race-conditions are not available on multi-ractor programming. */
""/*  */
""/* To achieve this, ractors severely limit object sharing between different ractors. */
""/* For example, unlike threads, ractors can't access each other's objects, nor any objects through */
""/* variables of the outer scope. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new {puts "I am in Ractor! a=#{a}"} */
""/*     # fails immediately with */
""/*     # ArgumentError (can not isolate a Proc because it accesses outer variables (a).) */
""/*  */
""/* On CRuby (the default implementation), Global Virtual Machine Lock (GVL) is held per ractor, so */
""/* ractors are performed in parallel without locking each other. */
""/*  */
""/* Instead of accessing the shared state, the objects should be passed to and from ractors via */
""/* sending and receiving objects as messages. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new do */
""/*       a_in_ractor = receive # receive blocks till somebody will pass message */
""/*       puts "I am in Ractor! a=#{a_in_ractor}" */
""/*     end */
""/*     r.send(a)  # pass it */
""/*     r.take */
""/*     # here "I am in Ractor! a=1" would be printed */
""/*  */
""/* There are two pairs of methods for sending/receiving messages: */
""/*  */
""/* * Ractor#send and Ractor.receive for when the _sender_ knows the receiver (push); */
""/* * Ractor.yield and Ractor#take for when the _receiver_ knows the sender (pull); */
""/*  */
""/* In addition to that, an argument to Ractor.new would be passed to block and available there */
""/* as if received by Ractor.receive, and the last block value would be sent outside of the */
""/* ractor as if sent by Ractor.yield. */
""/*  */
""/* A little demonstration on a classic ping-pong: */
""/*  */
""/*     server = Ractor.new do */
""/*       puts "Server starts: #{self.inspect}" */
""/*       puts "Server sends: ping" */
""/*       Ractor.yield 'ping'                       # The server doesn't know the receiver and sends to whoever interested */
""/*       received = Ractor.receive                 # The server doesn't know the sender and receives from whoever sent */
""/*       puts "Server received: #{received}" */
""/*     end */
""/*  */
""/*     client = Ractor.new(server) do |srv|        # The server is sent inside client, and available as srv */
""/*       puts "Client starts: #{self.inspect}" */
""/*       received = srv.take                       # The Client takes a message specifically from the server */
""/*       puts "Client received from " \ */
""/*            "#{srv.inspect}: #{received}" */
""/*       puts "Client sends to " \ */
""/*            "#{srv.inspect}: pong" */
""/*       srv.send 'pong'                           # The client sends a message specifically to the server */
""/*     end */
""/*  */
""/*     [client, server].each(&:take)               # Wait till they both finish */
""/*  */
""/* This will output: */
""/*  */
""/*     Server starts: #<Ractor:#2 test.rb:1 running> */
""/*     Server sends: ping */
""/*     Client starts: #<Ractor:#3 test.rb:8 running> */
""/*     Client received from #<Ractor:#2 rac.rb:1 blocking>: ping */
""/*     Client sends to #<Ractor:#2 rac.rb:1 blocking>: pong */
""/*     Server received: pong */
""/*  */
""/* It is said that Ractor receives messages via the <em>incoming port</em>, and sends them */
""/* to the <em>outgoing port</em>. Either one can be disabled with Ractor#close_incoming and */
""/* Ractor#close_outgoing respectively. If a ractor terminated, its ports will be closed */
""/* automatically. */
""/*  */
""/* == Shareable and unshareable objects */
""/*  */
""/* When the object is sent to and from the ractor, it is important to understand whether the */
""/* object is shareable or unshareable. Most of objects are unshareable objects. */
""/*  */
""/* Shareable objects are basically those which can be used by several threads without compromising */
""/* thread-safety; e.g. immutable ones. Ractor.shareable? allows to check this, and Ractor.make_shareable */
""/* tries to make object shareable if it is not. */
""/*  */
""/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are */
""/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
""/*     Ractor.shareable?('foo'.freeze) #=> true */
""/*  */
""/*     ary = ['hello', 'world'] */
""/*     ary.frozen?                 #=> false */
""/*     ary[0].frozen?              #=> false */
""/*     Ractor.make_shareable(ary) */
""/*     ary.frozen?                 #=> true */
""/*     ary[0].frozen?              #=> true */
""/*     ary[1].frozen?              #=> true */
""/*  */
""/* When a shareable object is sent (via #send or Ractor.yield), no additional processing happens, */
""/* and it just becomes usable by both ractors. When an unshareable object is sent, it can be */
""/* either _copied_ or _moved_. The first is the default, and it makes the object's full copy by */
""/* deep cloning of non-shareable parts of its structure. */
""/*  */
""/*     data = ['foo', 'bar'.freeze] */
""/*     r = Ractor.new do */
""/*       data2 = Ractor.receive */
""/*       puts "In ractor: #{data2.object_id}, #{data2[0].object_id}, #{data2[1].object_id}" */
""/*     end */
""/*     r.send(data) */
""/*     r.take */
""/*     puts "Outside  : #{data.object_id}, #{data[0].object_id}, #{data[1].object_id}" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 340, 360, 320 */
""/*     Outside  : 380, 400, 320 */
""/*  */
""/* (Note that object id of both array and non-frozen string inside array have changed inside */
""/* the ractor, showing it is different objects. But the second array's element, which is a */
""/* shareable frozen string, has the same object_id.) */
""/*  */
""/* Deep cloning of the objects may be slow, and sometimes impossible. Alternatively, */
""/* <tt>move: true</tt> may be used on sending. This will <em>move</em> the object to the */
""/* receiving ractor, making it inaccessible for a sending ractor. */
""/*  */
""/*     data = ['foo', 'bar'] */
""/*     r = Ractor.new do */
""/*       data_in_ractor = Ractor.receive */
""/*       puts "In ractor: #{data_in_ractor.object_id}, #{data_in_ractor[0].object_id}" */
""/*     end */
""/*     r.send(data, move: true) */
""/*     r.take */
""/*     puts "Outside: moved? #{Ractor::MovedObject === data}" */
""/*     puts "Outside: #{data.inspect}" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 100, 120 */
""/*     Outside: moved? true */
""/*     test.rb:9:in `method_missing': can not send any methods to a moved object (Ractor::MovedError) */
""/*  */
""/* Notice that even +inspect+ (and more basic methods like <tt>__id__</tt>) is inaccessible */
""/* on a moved object. */
""/*  */
""/* Besides frozen objects, there are shareable objects. Class and Module objects are shareable so */
""/* the Class/Module definitions are shared between ractors. Ractor objects are also shareable objects. */
""/* All operations for the shareable mutable objects are thread-safe, so the thread-safety property */
""/* will be kept. We can not define mutable shareable objects in Ruby, but C extensions can introduce them. */
""/*  */
""/* It is prohibited to access instance variables of mutable shareable objects (especially Modules and classes) */
""/* from ractors other than main: */
""/*  */
""/*     class C */
""/*       class << self */
""/*         attr_accessor :tricky */
""/*       end */
""/*     end */
""/*  */
""/*     C.tricky = 'test' */
""/*  */
""/*     r = Ractor.new(C) do |cls| */
""/*       puts "I see #{cls}" */
""/*       puts "I can't see #{cls.tricky}" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* Ractors can access constants if they are shareable. The main Ractor is the only one that can */
""/* access non-shareable constants. */
""/*  */
""/*     GOOD = 'good'.freeze */
""/*     BAD = 'bad' */
""/*  */
""/*     r = Ractor.new do */
""/*       puts "GOOD=#{GOOD}" */
""/*       puts "BAD=#{BAD}" */
""/*     end */
""/*     r.take */
""/*     # GOOD=good */
""/*     # can not access non-shareable objects in constant Object::BAD by non-main Ractor. (NameError) */
""/*  */
""/*     # Consider the same C class from above */
""/*  */
""/*     r = Ractor.new do */
""/*       puts "I see #{C}" */
""/*       puts "I can't see #{C.tricky}" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* See also the description of <tt># shareable_constant_value</tt> pragma in */
""/* {Comments syntax}[rdoc-ref:syntax/comments.rdoc] explanation. */
""/*  */
""/* == Ractors vs threads */
""/*  */
""/* Each ractor creates its own thread. New threads can be created from inside ractor */
""/* (and, on CRuby, sharing GVL with other threads of this ractor). */
""/*  */
""/*     r = Ractor.new do */
""/*       a = 1 */
""/*       Thread.new {puts "Thread in ractor: a=#{a}"}.join */
""/*     end */
""/*     r.take */
""/*     # Here "Thread in ractor: a=1" will be printed */
""/*  */
""/* == Note on code examples */
""/*  */
""/* In examples below, sometimes we use the following method to wait till ractors that */
""/* are not currently blocked will finish (or process till next blocking) method. */
""/*  */
""/*     def wait */
""/*       sleep(0.1) */
""/*     end */
""/*  */
""/* It is **only for demonstration purposes** and shouldn't be used in a real code. */
""/* Most of the times, just #take is used to wait till ractor will finish. */
""/*  */
""/* == Reference */
""/*  */
""/* See {Ractor design doc}[rdoc-ref:ractor.md] for more details. */
""/*  */
"class Ractor\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.new(*args, name: nil) {|*args| block } -> ractor */
"\n"/*  */
"\n"/* Create a new Ractor with args and a block. */
"\n"/*  */
"\n"/* A block (Proc) will be isolated (can't access to outer variables). +self+ */
"\n"/* inside the block will refer to the current Ractor. */
"\n"/*  */
"\n"/*    r = Ractor.new { puts "Hi, I am #{self.inspect}" } */
"\n"/*    r.take */
"\n"/*    # Prints "Hi, I am #<Ractor:#2 test.rb:1 running>" */
"\n"/*  */
"\n"/* +args+ passed to the method would be propagated to block args by the same rules as */
"\n"/* objects passed through #send/Ractor.receive: if +args+ are not shareable, they */
"\n"/* will be copied (via deep cloning, which might be inefficient). */
"\n"/*  */
"\n"/*    arg = [1, 2, 3] */
"\n"/*    puts "Passing: #{arg} (##{arg.object_id})" */
"\n"/*    r = Ractor.new(arg) {|received_arg| */
"\n"/*      puts "Received: #{received_arg} (##{received_arg.object_id})" */
"\n"/*    } */
"\n"/*    r.take */
"\n"/*    # Prints: */
"\n"/*    #   Passing: [1, 2, 3] (#280) */
"\n"/*    #   Received: [1, 2, 3] (#300) */
"\n"/*  */
"\n"/* Ractor's +name+ can be set for debugging purposes: */
"\n"/*  */
"\n"/*    r = Ractor.new(name: 'my ractor') {} */
"\n"/*    p r */
"\n"/*    #=> #<Ractor:#3 my ractor test.rb:1 terminated> */
"\n"/*  */
"  def self.new(*args, name: nil, &block)\n"
"    b = block\n"/* TODO: builtin bug */
"    raise ArgumentError, \"must be called with a block\" unless block\n"
"    if __builtin_cexpr!(\"RBOOL(ruby_single_main_ractor)\")\n"
"      warn(\"Ractor is experimental, and the behavior may change in future versions of Ruby! \" \\\n"
"           \"Also there are many implementation issues.\", uplevel: 0, category: :experimental)\n"
"    end\n"
"    loc = caller_locations(1, 1).first\n"
"    loc = \"#{loc.path}:#{loc.lineno}\"\n"
,
#line 271 "ractor.rb"
"    __builtin_ractor_create(loc, name, args, b)\n"
"  end\n"
"\n"
"\n"/* Returns the currently executing Ractor. */
"\n"/*  */
"\n"/*   Ractor.current #=> #<Ractor:#1 running> */
"  def self.current\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(rb_ec_ractor_ptr(ec));\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Returns total count of Ractors currently running. */
"\n"/*  */
"\n"/*    Ractor.count                   #=> 1 */
"\n"/*    r = Ractor.new(name: 'example') { Ractor.yield(1) } */
"\n"/*    Ractor.count                   #=> 2 (main + example ractor) */
"\n"/*    r.take                         # wait for Ractor.yield(1) */
"\n"/*    r.take                         # wait till r will finish */
"\n"/*    Ractor.count                   #=> 1 */
"  def self.count\n"
"    __builtin_cexpr! %q{\n"
"      ULONG2NUM(GET_VM()->ractor.cnt);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.select(*ractors, [yield_value:, move: false]) -> [ractor or symbol, obj] */
"\n"/*  */
"\n"/* Waits for the first ractor to have something in its outgoing port, reads from this ractor, and */
"\n"/* returns that ractor and the object received. */
"\n"/*  */
"\n"/*    r1 = Ractor.new {Ractor.yield 'from 1'} */
"\n"/*    r2 = Ractor.new {Ractor.yield 'from 2'} */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2) */
"\n"/*  */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "from 1" from #<Ractor:#2 test.rb:1 running> */
"\n"/*  */
"\n"/* If one of the given ractors is the current ractor, and it would be selected, +r+ will contain */
"\n"/* +:receive+ symbol instead of the ractor object. */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      main.send 'to main' */
"\n"/*      Ractor.yield 'from 1' */
"\n"/*    end */
"\n"/*    r2 = Ractor.new do */
"\n"/*      Ractor.yield 'from 2' */
"\n"/*    end */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2, Ractor.current) */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "to main" from :receive */
"\n"/*  */
"\n"/* If +yield_value+ is provided, that value may be yielded if another Ractor is calling #take. */
"\n"/* In this case, the pair <tt>[:yield, nil]</tt> would be returned: */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      puts "Received from main: #{main.take}" */
"\n"/*    end */
"\n"/*  */
"\n"/*    puts "Trying to select" */
"\n"/*    r, obj = Ractor.select(r1, Ractor.current, yield_value: 123) */
"\n"/*    wait */
"\n"/*    puts "Received #{obj.inspect} from #{r.inspect}" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Trying to select */
"\n"/*    Received from main: 123 */
"\n"/*    Received nil from :yield */
"\n"/*  */
"\n"/* +move+ boolean flag defines whether yielded value should be copied (default) or moved. */
"  def self.select(*ractors, yield_value: yield_unspecified = true, move: false)\n"
"    raise ArgumentError, 'specify at least one ractor or `yield_value`' if yield_unspecified && ractors.empty?\n"
"\n"
,
#line 349 "ractor.rb"
"    __builtin_cstmt! %q{\n"
"      const VALUE *rs = RARRAY_CONST_PTR_TRANSIENT(ractors);\n"
"      VALUE rv;\n"
"      VALUE v = ractor_select(ec, rs, RARRAY_LENINT(ractors),\n"
"                              yield_unspecified == Qtrue ? Qundef : yield_value,\n"
"                              (bool)RTEST(move) ? true : false, &rv);\n"
"      return rb_ary_new_from_args(2, rv, v);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive -> msg */
"\n"/*  */
"\n"/* Receive an incoming message from the current Ractor's incoming port's queue, which was */
"\n"/* sent there by #send. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* Alternatively, private instance method +receive+ may be used: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* The method blocks if the queue is empty. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts "Before first receive" */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*       v2 = Ractor.receive */
"\n"/*       puts "Received: #{v2}" */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     puts "Still not received" */
"\n"/*     r.send('message1') */
"\n"/*     wait */
"\n"/*     puts "Still received only one" */
"\n"/*     r.send('message2') */
"\n"/*     r.take */
"\n"/*  */
"\n"/* Output: */
"\n"/*  */
"\n"/*     Before first receive */
"\n"/*     Still not received */
"\n"/*     Received: message1 */
"\n"/*     Still received only one */
"\n"/*     Received: message2 */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method raises Ractor::ClosedError */
"\n"/* if there are no more messages in incoming queue: */
"\n"/*  */
"\n"/*     Ractor.new do */
"\n"/*       close_incoming */
"\n"/*       receive */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     # in `receive': The incoming port is already closed => #<Ractor:#2 test.rb:1 running> (Ractor::ClosedError) */
"\n"/*  */
"  def self.receive\n"
"    __builtin_cexpr! %q{\n"
,
#line 421 "ractor.rb"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"\n"
"  class << self\n"
"    alias recv receive\n"
"  end\n"
"\n"
"\n"/* same as Ractor.receive */
"  private def receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"  alias recv receive\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive_if {|msg| block } -> msg */
"\n"/*  */
"\n"/* Receive only a specific message. */
"\n"/*  */
"\n"/* Instead of Ractor.receive, Ractor.receive_if can provide a pattern */
"\n"/* by a block and you can choose the receiving message. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/foo/)} #=> "foo3" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/bar/)} #=> "bar1" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/baz/)} #=> "baz2" */
"\n"/*     end */
"\n"/*     r << "bar1" */
"\n"/*     r << "baz2" */
"\n"/*     r << "foo3" */
"\n"/*     r.take */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     foo3 */
"\n"/*     bar1 */
"\n"/*     baz2 */
"\n"/*  */
"\n"/* If the block returns a truthy value, the message will be removed from the incoming queue */
"\n"/* and returned. */
"\n"/* Otherwise, the message remains in the incoming queue and the following received */
"\n"/* messages are checked by the given block. */
"\n"/*  */
"\n"/* If there are no messages left in the incoming queue, the method will */
"\n"/* block until new messages arrive. */
"\n"/*  */
"\n"/* If the block is escaped by break/return/exception/throw, the message is removed from */
"\n"/* the incoming queue as if a truthy value had been returned. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       val = Ractor.receive_if{|msg| msg.is_a?(Array)} */
"\n"/*       puts "Received successfully: #{val}" */
"\n"/*     end */
"\n"/*  */
"\n"/*     r.send(1) */
"\n"/*     r.send('test') */
"\n"/*     wait */
"\n"/*     puts "2 non-matching sent, nothing received" */
"\n"/*     r.send([1, 2, 3]) */
"\n"/*     wait */
"\n"/*  */
"\n"/* Prints: */
"\n"/*  */
"\n"/*     2 non-matching sent, nothing received */
"\n"/*     Received successfully: [1, 2, 3] */
"\n"/*  */
"\n"/* Note that you can not call receive/receive_if in the given block recursively. */
"\n"/* It means that you should not do any tasks in the block. */
"\n"/*  */
"\n"/*     Ractor.current << true */
"\n"/*     Ractor.receive_if{|msg| Ractor.receive} */
"\n"/*     #=> `receive': can not call receive/receive_if recursively (Ractor::Error) */
"\n"/*  */
"  def self.receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"  private def receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.send(msg, move: false) -> self */
"\n"/*  */
"\n"/* Send a message to a Ractor's incoming queue to be consumed by Ractor.receive. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     value = Ractor.receive */
"\n"/*     puts "Received #{value}" */
"\n"/*   end */
"\n"/*   r.send 'message' */
"\n"/*   # Prints: "Received: message" */
"\n"/*  */
"\n"/* The method is non-blocking (will return immediately even if the ractor is not ready */
"\n"/* to receive anything): */
"\n"/*  */
"\n"/*    r = Ractor.new {sleep(5)} */
"\n"/*    r.send('test') */
"\n"/*    puts "Sent successfully" */
"\n"/*    # Prints: "Sent successfully" immediately */
"\n"/*  */
"\n"/* Attempt to send to ractor which already finished its execution will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {} */
"\n"/*   r.take */
"\n"/*   p r */
"\n"/*   # "#<Ractor:#6 (irb):23 terminated>" */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method also raises Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r =  Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      receive */
"\n"/*    end */
"\n"/*    r.close_incoming */
"\n"/*    r.send('test') */
"\n"/*    # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If the +obj+ is unshareable, by default it would be copied into ractor by deep cloning. */
"\n"/* If the <tt>move: true</tt> is passed, object is _moved_ into ractor and becomes */
"\n"/* inaccessible to sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    msg = 'message' */
"\n"/*    r.send(msg, move: true) */
"\n"/*    r.take */
"\n"/*    p msg */
"\n"/*  */
"\n"/* This prints: */
"\n"/*  */
"\n"/*    Received: message */
"\n"/*    in `p': undefined method `inspect' for #<Ractor::MovedObject:0x000055c99b9b69b8> */
"\n"/*  */
"\n"/* All references to the object and its parts will become invalid in sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message' */
"\n"/*    ary = [s] */
"\n"/*    copy = ary.dup */
"\n"/*    r.send(ary, move: true) */
"\n"/*  */
"\n"/*    s.inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    ary.class */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    copy.class */
"\n"/*    # => Array, it is different object */
"\n"/*    copy[0].inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    # ...but its item was still a reference to `s`, which was moved */
"\n"/*  */
"\n"/* If the object was shareable, <tt>move: true</tt> has no effect on it: */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message'.freeze */
,
#line 583 "ractor.rb"
"\n"/*    r.send(s, move: true) */
"\n"/*    s.inspect #=> "message", still available */
"\n"/*  */
"  def send(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_send(ec, RACTOR_PTR(self), obj, move)\n"
"    }\n"
"  end\n"
"  alias << send\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.yield(msg, move: false) -> nil */
"\n"/*  */
"\n"/* Send a message to the current ractor's outgoing port to be consumed by #take. */
"\n"/*  */
"\n"/*    r = Ractor.new {Ractor.yield 'Hello from ractor'} */
"\n"/*    puts r.take */
"\n"/*    # Prints: "Hello from ractor" */
"\n"/*  */
"\n"/* The method is blocking, and will return only when somebody consumes the */
"\n"/* sent message. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*      puts "Ractor: after yield" */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    puts "Still not taken" */
"\n"/*    puts r.take */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Still not taken */
"\n"/*    Hello from ractor */
"\n"/*    Ractor: after yield */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise: */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      close_outgoing */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    # `yield': The outgoing-port is already closed (Ractor::ClosedError) */
"\n"/*  */
"\n"/* The meaning of +move+ argument is the same as for #send. */
"  def self.yield(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_yield(ec, rb_ec_ractor_ptr(ec), obj, move)\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.take -> msg */
"\n"/*  */
"\n"/* Take a message from ractor's outgoing port, which was put there by Ractor.yield or at ractor's */
"\n"/* finalization. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     Ractor.yield 'explicit yield' */
"\n"/*     'last value' */
"\n"/*   end */
"\n"/*   puts r.take #=> 'explicit yield' */
"\n"/*   puts r.take #=> 'last value' */
"\n"/*   puts r.take # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*  */
"\n"/* The fact that the last value is also put to outgoing port means that +take+ can be used */
"\n"/* as some analog of Thread#join ("just wait till ractor finishes"), but don't forget it */
"\n"/* will raise if somebody had already consumed everything ractor have produced. */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    r.close_outgoing */
"\n"/*    r.take */
"\n"/*    # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If an uncaught exception is raised in the Ractor, it is propagated on take as a */
"\n"/* Ractor::RemoteError. */
"\n"/*  */
"\n"/*   r = Ractor.new {raise "Something weird happened"} */
"\n"/*  */
"\n"/*   begin */
"\n"/*     r.take */
"\n"/*   rescue => e */
"\n"/*     p e              #  => #<Ractor::RemoteError: thrown by remote Ractor.> */
"\n"/*     p e.ractor == r  # => true */
"\n"/*     p e.cause        # => #<RuntimeError: Something weird happened> */
"\n"/*   end */
"\n"/*  */
"\n"/* Ractor::ClosedError is a descendant of StopIteration, so the closing of the ractor will break */
"\n"/* the loops without propagating the error: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       3.times {|i| Ractor.yield "message #{i}"} */
"\n"/*       "finishing" */
"\n"/*     end */
"\n"/*  */
"\n"/*     loop {puts "Received: " + r.take} */
"\n"/*     puts "Continue successfully" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*     Received: message 0 */
"\n"/*     Received: message 1 */
"\n"/*     Received: message 2 */
"\n"/*     Received: finishing */
"\n"/*     Continue successfully */
"  def take\n"
"    __builtin_cexpr! %q{\n"
"      ractor_take(ec, RACTOR_PTR(self))\n"
"    }\n"
"  end\n"
"\n"
"  def inspect\n"
,
#line 704 "ractor.rb"
"    loc  = __builtin_cexpr! %q{ RACTOR_PTR(self)->loc }\n"
"    name = __builtin_cexpr! %q{ RACTOR_PTR(self)->name }\n"
"    id   = __builtin_cexpr! %q{ UINT2NUM(rb_ractor_id(RACTOR_PTR(self))) }\n"
"    status = __builtin_cexpr! %q{\n"
"      rb_str_new2(ractor_status_str(RACTOR_PTR(self)->status_))\n"
"    }\n"
"    \"#<Ractor:##{id}#{name ? ' '+name : ''}#{loc ? \" \" + loc : ''} #{status}>\"\n"
"  end\n"
"\n"
"  alias to_s inspect\n"
"\n"
"\n"/* The name set in Ractor.new, or +nil+. */
"  def name\n"
"    __builtin_cexpr! %q{RACTOR_PTR(self)->name}\n"
"  end\n"
"\n"
"  class RemoteError\n"
,
#line 721 "ractor.rb"
"    attr_reader :ractor\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.close_incoming -> true | false */
"\n"/*  */
"\n"/* Closes the incoming port and returns its previous state. */
"\n"/* All further attempts to Ractor.receive in the ractor, and #send to the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_incoming  #=> false */
"\n"/*   r.close_incoming  #=> true */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"  def close_incoming\n"
"    __builtin_cexpr! %q{\n"
"      ractor_close_incoming(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.close_outgoing -> true | false */
"\n"/*  */
"\n"/* Closes the outgoing port and returns its previous state. */
"\n"/* All further attempts to Ractor.yield in the ractor, and #take from the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_outgoing  #=> false */
"\n"/*   r.close_outgoing  #=> true */
"\n"/*   r.take */
"\n"/*   # Ractor::ClosedError (The outgoing-port is already closed) */
"  def close_outgoing\n"
"    __builtin_cexpr! %q{\n"
"      ractor_close_outgoing(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.shareable?(obj) -> true | false */
"\n"/*  */
"\n"/* Checks if the object is shareable by ractors. */
"\n"/*  */
"\n"/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are frozen */
"\n"/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
"\n"/*     Ractor.shareable?('foo'.freeze) #=> true */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.shareable? obj\n"
"    __builtin_cexpr! %q{\n"
"      RBOOL(rb_ractor_shareable_p(obj));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.make_shareable(obj, copy: false) -> shareable_obj */
"\n"/*  */
"\n"/* Make +obj+ shareable between ractors. */
"\n"/*  */
"\n"/* +obj+ and all the objects it refers to will be frozen, unless they are */
"\n"/* already shareable. */
"\n"/*  */
"\n"/* If +copy+ keyword is +true+, the method will copy objects before freezing them */
"\n"/* This is safer option but it can take be slower. */
"\n"/*  */
"\n"/* Note that the specification and implementation of this method are not */
"\n"/* mature and may be changed in the future. */
"\n"/*  */
"\n"/*   obj = ['test'] */
"\n"/*   Ractor.shareable?(obj)     #=> false */
"\n"/*   Ractor.make_shareable(obj) #=> ["test"] */
"\n"/*   Ractor.shareable?(obj)     #=> true */
"\n"/*   obj.frozen?                #=> true */
"\n"/*   obj[0].frozen?             #=> true */
"\n"/*  */
"\n"/*   # Copy vs non-copy versions: */
"\n"/*   obj1 = ['test'] */
"\n"/*   obj1s = Ractor.make_shareable(obj1) */
"\n"/*   obj1.frozen?                        #=> true */
"\n"/*   obj1s.object_id == obj1.object_id   #=> true */
"\n"/*   obj2 = ['test'] */
"\n"/*   obj2s = Ractor.make_shareable(obj2, copy: true) */
"\n"/*   obj2.frozen?                        #=> false */
"\n"/*   obj2s.frozen?                       #=> true */
"\n"/*   obj2s.object_id == obj2.object_id   #=> false */
"\n"/*   obj2s[0].object_id == obj2[0].object_id #=> false */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.make_shareable obj, copy: false\n"
"    if copy\n"
,
#line 816 "ractor.rb"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable_copy(obj);\n"
"      }\n"
"    else\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable(obj);\n"
"      }\n"
"    end\n"
"  end\n"
"\n"
"\n"/* get a value from ractor-local storage */
"  def [](sym)\n"
"    Primitive.ractor_local_value(sym)\n"
"  end\n"
"\n"
"\n"/* set a value in ractor-local storage */
"  def []=(sym, val)\n"
"    Primitive.ractor_local_value_set(sym, val)\n"
"  end\n"
"\n"
"\n"/* returns main ractor */
"  def self.main\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(GET_VM()->ractor.main_ractor);\n"
"    }\n"
"  end\n"
"end\n"
#line 4360 "miniprelude.c"
};

static const char prelude_name14[] = "<internal:symbol>";
static const struct {
    char L0[76]; /* 1..16 */
} prelude_code14 = {
#line 1 "symbol.rb"
"class Symbol\n"
"\n"/* call-seq: */
"\n"/*   to_sym -> self */
"\n"/*  */
"\n"/* Returns +self+. */
"\n"/*  */
"\n"/* Symbol#intern is an alias for Symbol#to_sym. */
"\n"/*  */
"\n"/* Related: String#to_sym. */
"  def to_sym\n"
"    self\n"
"  end\n"
"\n"
"  alias intern to_sym\n"
"end\n"
#line 4383 "miniprelude.c"
};

static const char prelude_name15[] = "<internal:timev>";
static const struct {
    char L0[468]; /* 1..383 */
    char L383[507]; /* 384..401 */
    char L401[78]; /* 402..405 */
} prelude_code15 = {
#line 1 "timev.rb"
""/* A \Time object represents a date and time: */
""/*  */
""/*   Time.new(2000, 1, 1, 0, 0, 0) # => 2000-01-01 00:00:00 -0600 */
""/*  */
""/* Although its value can be expressed as a single numeric */
""/* (see {Epoch Seconds}[rdoc-ref:Time@Epoch+Seconds] below), */
""/* it can be convenient to deal with the value by parts: */
""/*  */
""/*   t = Time.new(-2000, 1, 1, 0, 0, 0.0) */
""/*   # => -2000-01-01 00:00:00 -0600 */
""/*   t.year # => -2000 */
""/*   t.month # => 1 */
""/*   t.mday # => 1 */
""/*   t.hour # => 0 */
""/*   t.min # => 0 */
""/*   t.sec # => 0 */
""/*   t.subsec # => 0 */
""/*  */
""/*   t = Time.new(2000, 12, 31, 23, 59, 59.5) */
""/*   # => 2000-12-31 23:59:59.5 -0600 */
""/*   t.year # => 2000 */
""/*   t.month # => 12 */
""/*   t.mday # => 31 */
""/*   t.hour # => 23 */
""/*   t.min # => 59 */
""/*   t.sec # => 59 */
""/*   t.subsec # => (1/2) */
""/*  */
""/* == Epoch Seconds */
""/*  */
""/* <i>Epoch seconds</i> is the exact number of seconds */
""/* (including fractional subseconds) since the Unix Epoch, January 1, 1970. */
""/*  */
""/* You can retrieve that value exactly using method Time.to_r: */
""/*  */
""/*   Time.at(0).to_r        # => (0/1) */
""/*   Time.at(0.999999).to_r # => (9007190247541737/9007199254740992) */
""/*  */
""/* Other retrieval methods such as Time#to_i and Time#to_f */
""/* may return a value that rounds or truncates subseconds. */
""/*  */
""/* == \Time Resolution */
""/*  */
""/* A \Time object derived from the system clock */
""/* (for example, by method Time.now) */
""/* has the resolution supported by the system. */
""/*  */
""/* == Examples */
""/*  */
""/* All of these examples were done using the EST timezone which is GMT-5. */
""/*  */
""/* === Creating a New \Time Instance */
""/*  */
""/* You can create a new instance of Time with Time.new. This will use the */
""/* current system time. Time.now is an alias for this. You can also */
""/* pass parts of the time to Time.new such as year, month, minute, etc. When */
""/* you want to construct a time this way you must pass at least a year. If you */
""/* pass the year with nothing else time will default to January 1 of that year */
""/* at 00:00:00 with the current system timezone. Here are some examples: */
""/*  */
""/*   Time.new(2002)         #=> 2002-01-01 00:00:00 -0500 */
""/*   Time.new(2002, 10)     #=> 2002-10-01 00:00:00 -0500 */
""/*   Time.new(2002, 10, 31) #=> 2002-10-31 00:00:00 -0500 */
""/*  */
""/* You can pass a UTC offset: */
""/*  */
""/*   Time.new(2002, 10, 31, 2, 2, 2, "+02:00") #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* Or a timezone object: */
""/*  */
""/*   zone = timezone("Europe/Athens")      # Eastern European Time, UTC+2 */
""/*   Time.new(2002, 10, 31, 2, 2, 2, zone) #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* You can also use Time.local and Time.utc to infer */
""/* local and UTC timezones instead of using the current system */
""/* setting. */
""/*  */
""/* You can also create a new time using Time.at which takes the number of */
""/* seconds (with subsecond) since the {Unix */
""/* Epoch}[https://en.wikipedia.org/wiki/Unix_time]. */
""/*  */
""/*   Time.at(628232400) #=> 1989-11-28 00:00:00 -0500 */
""/*  */
""/* === Working with an Instance of \Time */
""/*  */
""/* Once you have an instance of Time there is a multitude of things you can */
""/* do with it. Below are some examples. For all of the following examples, we */
""/* will work on the assumption that you have done the following: */
""/*  */
""/*   t = Time.new(1993, 02, 24, 12, 0, 0, "+09:00") */
""/*  */
""/* Was that a monday? */
""/*  */
""/*   t.monday? #=> false */
""/*  */
""/* What year was that again? */
""/*  */
""/*   t.year #=> 1993 */
""/*  */
""/* Was it daylight savings at the time? */
""/*  */
""/*   t.dst? #=> false */
""/*  */
""/* What's the day a year later? */
""/*  */
""/*   t + (60*60*24*365) #=> 1994-02-24 12:00:00 +0900 */
""/*  */
""/* How many seconds was that since the Unix Epoch? */
""/*  */
""/*   t.to_i #=> 730522800 */
""/*  */
""/* You can also do standard functions like compare two times. */
""/*  */
""/*   t1 = Time.new(2010) */
""/*   t2 = Time.new(2011) */
""/*  */
""/*   t1 == t2 #=> false */
""/*   t1 == t1 #=> true */
""/*   t1 <  t2 #=> true */
""/*   t1 >  t2 #=> false */
""/*  */
""/*   Time.new(2010,10,31).between?(t1, t2) #=> true */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \Class \Time: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Comparable}[rdoc-ref:Comparable@What-27s+Here]. */
""/*  */
""/* Here, class \Time provides methods that are useful for: */
""/*  */
""/* - {Creating \Time objects}[rdoc-ref:Time@Methods+for+Creating]. */
""/* - {Fetching \Time values}[rdoc-ref:Time@Methods+for+Fetching]. */
""/* - {Querying a \Time object}[rdoc-ref:Time@Methods+for+Querying]. */
""/* - {Comparing \Time objects}[rdoc-ref:Time@Methods+for+Comparing]. */
""/* - {Converting a \Time object}[rdoc-ref:Time@Methods+for+Converting]. */
""/* - {Rounding a \Time}[rdoc-ref:Time@Methods+for+Rounding]. */
""/*  */
""/* === Methods for Creating */
""/*  */
""/* - ::new: Returns a new time from specified arguments (year, month, etc.), */
""/*   including an optional timezone value. */
""/* - ::local (aliased as ::mktime): Same as ::new, except the */
""/*   timezone is the local timezone. */
""/* - ::utc (aliased as ::gm): Same as ::new, except the timezone is UTC. */
""/* - ::at: Returns a new time based on seconds since epoch. */
""/* - ::now: Returns a new time based on the current system time. */
""/* - #+ (plus): Returns a new time increased by the given number of seconds. */
""/* - #- (minus): Returns a new time decreased by the given number of seconds. */
""/*  */
""/* === Methods for Fetching */
""/*  */
""/* - #year: Returns the year of the time. */
""/* - #month (aliased as #mon): Returns the month of the time. */
""/* - #mday (aliased as #day): Returns the day of the month. */
""/* - #hour: Returns the hours value for the time. */
""/* - #min: Returns the minutes value for the time. */
""/* - #sec: Returns the seconds value for the time. */
""/* - #usec (aliased as #tv_usec): Returns the number of microseconds */
""/*   in the subseconds value of the time. */
""/* - #nsec (aliased as #tv_nsec: Returns the number of nanoseconds */
""/*   in the subsecond part of the time. */
""/* - #subsec: Returns the subseconds value for the time. */
""/* - #wday: Returns the integer weekday value of the time (0 == Sunday). */
""/* - #yday: Returns the integer yearday value of the time (1 == January 1). */
""/* - #hash: Returns the integer hash value for the time. */
""/* - #utc_offset (aliased as #gmt_offset and #gmtoff): Returns the offset */
""/*   in seconds between time and UTC. */
""/* - #to_f: Returns the float number of seconds since epoch for the time. */
""/* - #to_i (aliased as #tv_sec): Returns the integer number of seconds since epoch */
""/*   for the time. */
""/* - #to_r: Returns the Rational number of seconds since epoch for the time. */
""/* - #zone: Returns a string representation of the timezone of the time. */
""/*  */
""/* === Methods for Querying */
""/*  */
""/* - #utc? (aliased as #gmt?): Returns whether the time is UTC. */
""/* - #dst? (aliased as #isdst): Returns whether the time is DST (daylight saving time). */
""/* - #sunday?: Returns whether the time is a Sunday. */
""/* - #monday?: Returns whether the time is a Monday. */
""/* - #tuesday?: Returns whether the time is a Tuesday. */
""/* - #wednesday?: Returns whether the time is a Wednesday. */
""/* - #thursday?: Returns whether the time is a Thursday. */
""/* - #friday?: Returns whether time is a Friday. */
""/* - #saturday?: Returns whether the time is a Saturday. */
""/*  */
""/* === Methods for Comparing */
""/*  */
""/* - #<=>: Compares +self+ to another time. */
""/* - #eql?: Returns whether the time is equal to another time. */
""/*  */
""/* === Methods for Converting */
""/*  */
""/* - #asctime (aliased as #ctime): Returns the time as a string. */
""/* - #inspect: Returns the time in detail as a string. */
""/* - #strftime: Returns the time as a string, according to a given format. */
""/* - #to_a: Returns a 10-element array of values from the time. */
""/* - #to_s: Returns a string representation of the time. */
""/* - #getutc (aliased as #getgm): Returns a new time converted to UTC. */
""/* - #getlocal: Returns a new time converted to local time. */
""/* - #utc (aliased as #gmtime): Converts time to UTC in place. */
""/* - #localtime: Converts time to local time in place. */
""/* - #deconstruct_keys: Returns a hash of time components used in pattern-matching. */
""/*  */
""/* === Methods for Rounding */
""/*  */
""/* - #round:Returns a new time with subseconds rounded. */
""/* - #ceil: Returns a new time with subseconds raised to a ceiling. */
""/* - #floor: Returns a new time with subseconds lowered to a floor. */
""/*  */
""/* For the forms of argument +zone+, see */
""/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]. */
"class Time\n"
"\n"/* Creates a new \Time object from the current system time. */
"\n"/* This is the same as Time.new without arguments. */
"\n"/*  */
"\n"/*    Time.now               # => 2009-06-24 12:39:54 +0900 */
"\n"/*    Time.now(in: '+04:00') # => 2009-06-24 07:39:54 +0400 */
"\n"/*  */
"\n"/* For forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]. */
"  def self.now(in: nil)\n"
"    Primitive.time_s_now(Primitive.arg!(:in))\n"
"  end\n"
"\n"
"\n"/* Returns a new \Time object based on the given arguments. */
"\n"/*  */
"\n"/* Required argument +time+ may be either of: */
"\n"/*  */
"\n"/* - A \Time object, whose value is the basis for the returned time; */
"\n"/*   also influenced by optional keyword argument +in:+ (see below). */
"\n"/* - A numeric number of */
"\n"/*   {Epoch seconds}[rdoc-ref:Time@Epoch+Seconds] */
"\n"/*   for the returned time. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*   t = Time.new(2000, 12, 31, 23, 59, 59) # => 2000-12-31 23:59:59 -0600 */
"\n"/*   secs = t.to_i                          # => 978328799 */
"\n"/*   Time.at(secs)                          # => 2000-12-31 23:59:59 -0600 */
"\n"/*   Time.at(secs + 0.5)                    # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.at(1000000000)                    # => 2001-09-08 20:46:40 -0500 */
"\n"/*   Time.at(0)                             # => 1969-12-31 18:00:00 -0600 */
"\n"/*   Time.at(-1000000000)                   # => 1938-04-24 17:13:20 -0500 */
"\n"/*  */
"\n"/* Optional numeric argument +subsec+ and optional symbol argument +units+ */
"\n"/* work together to specify subseconds for the returned time; */
"\n"/* argument +units+ specifies the units for +subsec+: */
"\n"/*  */
"\n"/* - +:millisecond+: +subsec+ in milliseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :millisecond)     # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500, :millisecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000, :millisecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000, :millisecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/* - +:microsecond+ or +:usec+: +subsec+ in microseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :microsecond)        # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500000, :microsecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000000, :microsecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000000, :microsecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/* - +:nanosecond+ or +:nsec+: +subsec+ in nanoseconds: */
"\n"/*  */
"\n"/*     Time.at(secs, 0, :nanosecond)           # => 2000-12-31 23:59:59 -0600 */
"\n"/*     Time.at(secs, 500000000, :nanosecond)   # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*     Time.at(secs, 1000000000, :nanosecond)  # => 2001-01-01 00:00:00 -0600 */
"\n"/*     Time.at(secs, -1000000000, :nanosecond) # => 2000-12-31 23:59:58 -0600 */
"\n"/*  */
"\n"/*  */
"\n"/* Optional keyword argument <tt>+in: zone</tt> specifies the timezone */
"\n"/* for the returned time: */
"\n"/*  */
"\n"/*   Time.at(secs, in: '+12:00') # => 2001-01-01 17:59:59 +1200 */
"\n"/*   Time.at(secs, in: '-12:00') # => 2000-12-31 17:59:59 -1200 */
"\n"/*  */
"\n"/* For the forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]. */
"\n"/*  */
"  def self.at(time, subsec = false, unit = :microsecond, in: nil)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.time_s_at1(time)\n"
"    else\n"
"      Primitive.time_s_at(time, subsec, unit, Primitive.arg!(:in))\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Returns a new \Time object based on the given arguments, */
"\n"/* by default in the local timezone. */
"\n"/*  */
"\n"/* With no positional arguments, returns the value of Time.now: */
"\n"/*  */
"\n"/*   Time.new # => 2021-04-24 17:27:46.0512465 -0500 */
"\n"/*  */
"\n"/* With one string argument that represents a time, returns a new */
"\n"/* \Time object based on the given argument, in the local timezone. */
"\n"/*  */
"\n"/*   Time.new('2000-12-31 23:59:59.5')              # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.new('2000-12-31 23:59:59.5 +0900')        # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*   Time.new('2000-12-31 23:59:59.5', in: '+0900') # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*   Time.new('2000-12-31 23:59:59.5')              # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.new('2000-12-31 23:59:59.56789', precision: 3) # => 2000-12-31 23:59:59.567 -0600 */
"\n"/*  */
"\n"/* With one to six arguments, returns a new \Time object */
"\n"/* based on the given arguments, in the local timezone. */
"\n"/*  */
"\n"/*   Time.new(2000, 1, 2, 3, 4, 5) # => 2000-01-02 03:04:05 -0600 */
"\n"/*  */
"\n"/* For the positional arguments (other than +zone+): */
"\n"/*  */
"\n"/* - +year+: Year, with no range limits: */
"\n"/*  */
"\n"/*     Time.new(999999999)  # => 999999999-01-01 00:00:00 -0600 */
"\n"/*     Time.new(-999999999) # => -999999999-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +month+: Month in range (1..12), or case-insensitive */
"\n"/*   3-letter month name: */
"\n"/*  */
"\n"/*     Time.new(2000, 1)     # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 12)    # => 2000-12-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 'jan') # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 'JAN') # => 2000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +mday+: Month day in range(1..31): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 31) # => 2000-01-31 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +hour+: Hour in range (0..23), or 24 if +min+, +sec+, and +usec+ */
"\n"/*   are zero: */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 23) # => 2000-01-01 23:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 24) # => 2000-01-02 00:00:00 -0600 */
"\n"/*  */
"\n"/* - +min+: Minute in range (0..59): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 59) # => 2000-01-01 00:59:00 -0600 */
"\n"/*  */
"\n"/* - +sec+: Second in range (0...61): */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 0)  # => 2000-01-01 00:00:00 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59) # => 2000-01-01 00:00:59 -0600 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 60) # => 2000-01-01 00:01:00 -0600 */
"\n"/*  */
"\n"/*   +sec+ may be Float or Rational. */
"\n"/*  */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59.5)  # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*     Time.new(2000, 1, 1, 0, 0, 59.7r) # => 2000-12-31 23:59:59.7 +0900 */
"\n"/*  */
"\n"/* These values may be: */
"\n"/*  */
"\n"/* - Integers, as above. */
"\n"/* - Numerics convertible to integers: */
"\n"/*  */
"\n"/*     Time.new(Float(0.0), Rational(1, 1), 1.0, 0.0, 0.0, 0.0) */
"\n"/*     # => 0000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* - \String integers: */
"\n"/*  */
"\n"/*     a = %w[0 1 1 0 0 0] */
"\n"/*     # => ["0", "1", "1", "0", "0", "0"] */
"\n"/*     Time.new(*a) # => 0000-01-01 00:00:00 -0600 */
"\n"/*  */
"\n"/* When positional argument +zone+ or keyword argument +in:+ is given, */
"\n"/* the new \Time object is in the specified timezone. */
"\n"/* For the forms of argument +zone+, see */
"\n"/* {Timezone Specifiers}[rdoc-ref:timezones.rdoc]: */
"\n"/*  */
"\n"/*   Time.new(2000, 1, 1, 0, 0, 0, '+12:00') */
"\n"/*   # => 2000-01-01 00:00:00 +1200 */
"\n"/*   Time.new(2000, 1, 1, 0, 0, 0, in: '-12:00') */
"\n"/*   # => 2000-01-01 00:00:00 -1200 */
"\n"/*   Time.new(in: '-12:00') */
"\n"/*   # => 2022-08-23 08:49:26.1941467 -1200 */
"\n"/*  */
"\n"/* - +precision+: maximum effective digits in sub-second part, default is 9. */
"\n"/*   More digits will be truncated, as other operations of \Time. */
"\n"/*   Ignored unless the first argument is a string. */
"\n"/*  */
,
#line 384 "timev.rb"
"  def initialize(year = (now = true), mon = (str = year; nil), mday = nil, hour = nil, min = nil, sec = nil, zone = nil,\n"
"                 in: nil, precision: 9)\n"
"    if zone\n"
"      if Primitive.arg!(:in)\n"
"        raise ArgumentError, \"timezone argument given as positional and keyword arguments\"\n"
"      end\n"
"    else\n"
"      zone = Primitive.arg!(:in)\n"
"    end\n"
"\n"
"    if now\n"
"      return Primitive.time_init_now(zone)\n"
"    end\n"
"\n"
"    if str and Primitive.time_init_parse(str, zone, precision)\n"
"      return self\n"
"    end\n"
"\n"
,
#line 402 "timev.rb"
"    Primitive.time_init_args(year, mon, mday, hour, min, sec, zone)\n"
"  end\n"
"end\n"
#line 4801 "miniprelude.c"
};

static const char prelude_name16[] = "<internal:thread_sync>";
static const struct {
    char L0[500]; /* 1..38 */
    char L38[446]; /* 39..69 */
} prelude_code16 = {
#line 1 "thread_sync.rb"
"class Thread\n"
"  class Queue\n"
"\n"/* call-seq: */
"\n"/*   pop(non_block=false, timeout: nil) */
"\n"/*  */
"\n"/* Retrieves data from the queue. */
"\n"/*  */
"\n"/* If the queue is empty, the calling thread is suspended until data is pushed */
"\n"/* onto the queue. If +non_block+ is true, the thread isn't suspended, and */
"\n"/* +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no data is available +nil+ is */
"\n"/* returned. If +timeout+ is +0+ it returns immediately. */
"    def pop(non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
"      end\n"
"      Primitive.rb_queue_pop(non_block, timeout)\n"
"    end\n"
"    alias_method :deq, :pop\n"
"    alias_method :shift, :pop\n"
"  end\n"
"\n"
"  class SizedQueue\n"
"\n"/* call-seq: */
"\n"/*   pop(non_block=false, timeout: nil) */
"\n"/*  */
"\n"/* Retrieves data from the queue. */
"\n"/*  */
"\n"/* If the queue is empty, the calling thread is suspended until data is */
"\n"/* pushed onto the queue. If +non_block+ is true, the thread isn't */
"\n"/* suspended, and +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no data is available +nil+ is */
"\n"/* returned. If +timeout+ is +0+ it returns immediately. */
"    def pop(non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
,
#line 39 "thread_sync.rb"
"      end\n"
"      Primitive.rb_szqueue_pop(non_block, timeout)\n"
"    end\n"
"    alias_method :deq, :pop\n"
"    alias_method :shift, :pop\n"
"\n"
"\n"/* call-seq: */
"\n"/*   push(object, non_block=false, timeout: nil) */
"\n"/*   enq(object, non_block=false, timeout: nil) */
"\n"/*   <<(object) */
"\n"/*  */
"\n"/* Pushes +object+ to the queue. */
"\n"/*  */
"\n"/* If there is no space left in the queue, waits until space becomes */
"\n"/* available, unless +non_block+ is true.  If +non_block+ is true, the */
"\n"/* thread isn't suspended, and +ThreadError+ is raised. */
"\n"/*  */
"\n"/* If +timeout+ seconds have passed and no space is available +nil+ is */
"\n"/* returned. If +timeout+ is +0+ it returns immediately. */
"\n"/* Otherwise it returns +self+. */
"    def push(object, non_block = false, timeout: nil)\n"
"      if non_block && timeout\n"
"        raise ArgumentError, \"can't set a timeout if non_block is enabled\"\n"
"      end\n"
"      Primitive.rb_szqueue_push(object, non_block, timeout)\n"
"    end\n"
"    alias_method :enq, :push\n"
"    alias_method :<<, :push\n"
"  end\n"
"end\n"
#line 4880 "miniprelude.c"
};

static const char prelude_name17[] = "<internal:nilclass>";
static const struct {
    char L0[98]; /* 1..26 */
} prelude_code17 = {
#line 1 "nilclass.rb"
"class NilClass\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_i -> 0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_i   #=> 0 */
"\n"/*  */
"  def to_i\n"
"    return 0\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_f    -> 0.0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_f   #=> 0.0 */
"\n"/*  */
"  def to_f\n"
"    return 0.0\n"
"  end\n"
"end\n"
#line 4913 "miniprelude.c"
};

static const char prelude_name18[] = "<internal:prelude>";
static const struct {
    char L0[310]; /* 1..32 */
} prelude_code18 = {
#line 1 "prelude.rb"
"class Binding\n"
"\n"/* :nodoc: */
"  def irb\n"
"    require 'irb'\n"
"    irb\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias irb irb\n"/* :nodoc: */
"end\n"
"\n"
"module Kernel\n"
"  def pp(*objs)\n"
"    require 'pp'\n"
"    pp(*objs)\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias pp pp\n"/* :nodoc: */
"\n"
"  private :pp\n"
"end\n"
"\n"
"autoload :Set, 'set'\n"
"\n"
"module Enumerable\n"
"\n"/* Makes a set from the enumerable object with given arguments. */
"  def to_set(klass = Set, *args, &block)\n"
"    klass.new(self, *args, &block)\n"
"  end\n"
"end\n"
#line 4952 "miniprelude.c"
};

static const char prelude_name19[] = "<internal:gem_prelude>";
static const struct {
    char L0[490]; /* 1..24 */
    char L24[32]; /* 25..27 */
} prelude_code19 = {
#line 1 "gem_prelude.rb"
"begin\n"
"  require 'rubygems'\n"
"rescue LoadError => e\n"
"  raise unless e.path == 'rubygems'\n"
"\n"
"  warn \"`RubyGems' were not loaded.\"\n"
"end if defined?(Gem)\n"
"\n"
"begin\n"
"  require 'error_highlight'\n"
"rescue LoadError\n"
"  warn \"`error_highlight' was not loaded.\"\n"
"end if defined?(ErrorHighlight)\n"
"\n"
"begin\n"
"  require 'did_you_mean'\n"
"rescue LoadError\n"
"  warn \"`did_you_mean' was not loaded.\"\n"
"end if defined?(DidYouMean)\n"
"\n"
"begin\n"
"  require 'syntax_suggest/core_ext'\n"
"rescue LoadError\n"
"  warn \"`syntax_suggest' was not loaded.\"\n"
,
#line 25 "gem_prelude.rb"
"end if defined?(SyntaxSuggest)\n"
"\n"
#line 4989 "miniprelude.c"
};

static const char prelude_name20[] = "<internal:yjit>";
static const struct {
    char L0[473]; /* 1..39 */
    char L39[506]; /* 40..65 */
    char L65[491]; /* 66..84 */
    char L84[493]; /* 85..106 */
    char L106[467]; /* 107..151 */
    char L151[448]; /* 152..168 */
    char L168[499]; /* 169..191 */
    char L191[486]; /* 192..227 */
    char L227[460]; /* 228..244 */
    char L244[441]; /* 245..249 */
    char L249[455]; /* 250..256 */
    char L256[500]; /* 257..263 */
    char L263[504]; /* 264..269 */
    char L269[447]; /* 270..274 */
    char L274[494]; /* 275..280 */
    char L280[450]; /* 281..287 */
    char L287[479]; /* 288..302 */
    char L302[473]; /* 303..312 */
    char L312[467]; /* 313..325 */
    char L325[461]; /* 326..340 */
    char L340[425]; /* 341..351 */
    char L351[126]; /* 352..357 */
} prelude_code20 = {
#line 1 "yjit.rb"
""/* frozen_string_literal: true */
""
""/* This module allows for introspection of YJIT, CRuby's in-process */
""/* just-in-time compiler. This module exists only to help develop YJIT, as such, */
""/* everything in the module is highly implementation specific and comes with no */
""/* API stability guarantee whatsoever. */
""/*  */
""/* This module may not exist if YJIT does not support the particular platform */
""/* for which CRuby is built. There is also no API stability guarantee as to in */
""/* what situations this module is defined. */
"module RubyVM::YJIT\n"
"\n"/* Check if YJIT is enabled */
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(rb_yjit_enabled_p())'\n"
"  end\n"
"\n"
"\n"/* Check if --yjit-stats is used. */
"  def self.stats_enabled?\n"
"    Primitive.rb_yjit_stats_enabled_p\n"
"  end\n"
"\n"
"\n"/* Check if rb_yjit_trace_exit_locations_enabled_p is enabled. */
"  def self.trace_exit_locations_enabled?\n"
"    Primitive.rb_yjit_trace_exit_locations_enabled_p\n"
"  end\n"
"\n"
"\n"/* Discard statistics collected for --yjit-stats. */
"  def self.reset_stats!\n"
"    Primitive.rb_yjit_reset_stats_bang\n"
"  end\n"
"\n"
"\n"/* If --yjit-trace-exits is enabled parse the hashes from */
"\n"/* Primitive.rb_yjit_get_exit_locations into a format readable */
"\n"/* by Stackprof. This will allow us to find the exact location of a */
"\n"/* side exit in YJIT based on the instruction that is exiting. */
"  def self.exit_locations\n"
"    return unless trace_exit_locations_enabled?\n"
"\n"
"    results = Primitive.rb_yjit_get_exit_locations\n"
,
#line 40 "yjit.rb"
"    raw_samples = results[:raw].dup\n"
"    line_samples = results[:lines].dup\n"
"    frames = results[:frames].dup\n"
"    samples_count = 0\n"
"\n"
"\n"/* Loop through the instructions and set the frame hash with the data. */
"\n"/* We use nonexistent.def for the file name, otherwise insns.def will be displayed */
"\n"/* and that information isn't useful in this context. */
"    RubyVM::INSTRUCTION_NAMES.each_with_index do |name, frame_id|\n"
"      frame_hash = { samples: 0, total_samples: 0, edges: {}, name: name, file: \"nonexistent.def\", line: nil, lines: {} }\n"
"      results[:frames][frame_id] = frame_hash\n"
"      frames[frame_id] = frame_hash\n"
"    end\n"
"\n"
"\n"/* Loop through the raw_samples and build the hashes for StackProf. */
"\n"/* The loop is based off an example in the StackProf documentation and therefore */
"\n"/* this functionality can only work with that library. */
"\n"/*  */
"\n"/* Raw Samples: */
"\n"/* [ length, frame1, frame2, frameN, ..., instruction, count */
"\n"/*  */
"\n"/* Line Samples */
"\n"/* [ length, line_1, line_2, line_n, ..., dummy value, count */
"    i = 0\n"
"    while i < raw_samples.length\n"
"      stack_length = raw_samples[i] + 1\n"
,
#line 66 "yjit.rb"
"      i += 1\n"/* consume the stack length */
"\n"
"      prev_frame_id = nil\n"
"      stack_length.times do |idx|\n"
"        idx += i\n"
"        frame_id = raw_samples[idx]\n"
"\n"
"        if prev_frame_id\n"
"          prev_frame = frames[prev_frame_id]\n"
"          prev_frame[:edges][frame_id] ||= 0\n"
"          prev_frame[:edges][frame_id] += 1\n"
"        end\n"
"\n"
"        frame_info = frames[frame_id]\n"
"        frame_info[:total_samples] += 1\n"
"\n"
"        frame_info[:lines][line_samples[idx]] ||= [0, 0]\n"
"        frame_info[:lines][line_samples[idx]][0] += 1\n"
"\n"
,
#line 85 "yjit.rb"
"        prev_frame_id = frame_id\n"
"      end\n"
"\n"
"      i += stack_length\n"/* consume the stack */
"\n"
"      top_frame_id = prev_frame_id\n"
"      top_frame_line = 1\n"
"\n"
"      sample_count = raw_samples[i]\n"
"\n"
"      frames[top_frame_id][:samples] += sample_count\n"
"      frames[top_frame_id][:lines] ||= {}\n"
"      frames[top_frame_id][:lines][top_frame_line] ||= [0, 0]\n"
"      frames[top_frame_id][:lines][top_frame_line][1] += sample_count\n"
"\n"
"      samples_count += sample_count\n"
"      i += 1\n"
"    end\n"
"\n"
"    results[:samples] = samples_count\n"
"\n"/* Set missed_samples and gc_samples to 0 as their values */
"\n"/* don't matter to us in this context. */
,
#line 107 "yjit.rb"
"    results[:missed_samples] = 0\n"
"    results[:gc_samples] = 0\n"
"    results\n"
"  end\n"
"\n"
"\n"/* Marshal dumps exit locations to the given filename. */
"\n"/*  */
"\n"/* Usage: */
"\n"/*  */
"\n"/* If `--yjit-exit-locations` is passed, a file named */
"\n"/* "yjit_exit_locations.dump" will automatically be generated. */
"\n"/*  */
"\n"/* If you want to collect traces manually, call `dump_exit_locations` */
"\n"/* directly. */
"\n"/*  */
"\n"/* Note that calling this in a script will generate stats after the */
"\n"/* dump is created, so the stats data may include exits from the */
"\n"/* dump itself. */
"\n"/*  */
"\n"/* In a script call: */
"\n"/*  */
"\n"/*   at_exit do */
"\n"/*     RubyVM::YJIT.dump_exit_locations("my_file.dump") */
"\n"/*   end */
"\n"/*  */
"\n"/* Then run the file with the following options: */
"\n"/*  */
"\n"/*   ruby --yjit --yjit-trace-exits test.rb */
"\n"/*  */
"\n"/* Once the code is done running, use Stackprof to read the dump file. */
"\n"/* See Stackprof documentation for options. */
"  def self.dump_exit_locations(filename)\n"
"    unless trace_exit_locations_enabled?\n"
"      raise ArgumentError, \"--yjit-trace-exits must be enabled to use dump_exit_locations.\"\n"
"    end\n"
"\n"
"    File.binwrite(filename, Marshal.dump(RubyVM::YJIT.exit_locations))\n"
"  end\n"
"\n"
"\n"/* Return a hash for statistics generated for the --yjit-stats command line option. */
"\n"/* Return nil when option is not passed or unavailable. */
"  def self.runtime_stats\n"
"    stats = Primitive.rb_yjit_get_stats\n"
"    return stats if stats.nil?\n"
"\n"
,
#line 152 "yjit.rb"
"    stats[:object_shape_count] = Primitive.object_shape_count\n"
"    return stats unless Primitive.rb_yjit_stats_enabled_p\n"
"\n"
"    side_exits = total_exit_count(stats)\n"
"    total_exits = side_exits + stats[:leave_interp_return]\n"
"\n"
"\n"/* Number of instructions that finish executing in YJIT. */
"\n"/* See :count-placement: about the subtraction. */
"    retired_in_yjit = stats[:exec_instruction] - side_exits\n"
"\n"
"\n"/* Average length of instruction sequences executed by YJIT */
"    avg_len_in_yjit = retired_in_yjit.to_f / total_exits\n"
"\n"
"\n"/* This only available on yjit stats builds */
"    if stats.key?(:vm_insns_count)\n"
"\n"/* Proportion of instructions that retire in YJIT */
"      total_insns_count = retired_in_yjit + stats[:vm_insns_count]\n"
,
#line 169 "yjit.rb"
"      yjit_ratio_pct = 100.0 * retired_in_yjit.to_f / total_insns_count\n"
"      stats[:total_insns_count] = total_insns_count\n"
"      stats[:ratio_in_yjit] = yjit_ratio_pct\n"
"    end\n"
"\n"
"\n"/* Make those stats available in RubyVM::YJIT.runtime_stats as well */
"    stats[:side_exit_count]  = side_exits\n"
"    stats[:total_exit_count] = total_exits\n"
"    stats[:avg_len_in_yjit]  = avg_len_in_yjit\n"
"\n"
"    stats\n"
"  end\n"
"\n"
"\n"/* Produce disassembly for an iseq */
"  def self.disasm(iseq)\n"
"\n"/* If a method or proc is passed in, get its iseq */
"    iseq = RubyVM::InstructionSequence.of(iseq)\n"
"\n"
"    if self.enabled?\n"
"\n"/* Produce the disassembly string */
"\n"/* Include the YARV iseq disasm in the string for additional context */
"      iseq.disasm + \"\\n\" + Primitive.rb_yjit_disasm_iseq(iseq)\n"
"    else\n"
,
#line 192 "yjit.rb"
"      iseq.disasm\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Produce a list of instructions compiled by YJIT for an iseq */
"  def self.insns_compiled(iseq)\n"
"\n"/* If a method or proc is passed in, get its iseq */
"    iseq = RubyVM::InstructionSequence.of(iseq)\n"
"\n"
"    if self.enabled?\n"
"      Primitive.rb_yjit_insns_compiled(iseq)\n"
"    else\n"
"      Qnil\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Free and recompile all existing JIT code */
"  def self.code_gc\n"
"    Primitive.rb_yjit_code_gc\n"
"  end\n"
"\n"
"  def self.simulate_oom!\n"/* :nodoc: */
"    Primitive.rb_yjit_simulate_oom_bang\n"
"  end\n"
"\n"
"\n"/* Avoid calling a method here to not interfere with compilation tests */
"  if Primitive.rb_yjit_stats_enabled_p\n"
"    at_exit do\n"
"      _print_stats\n"
"      _dump_locations\n"
"    end\n"
"  end\n"
"\n"
"  class << self\n"
"    private\n"
"\n"
,
#line 228 "yjit.rb"
"    def _dump_locations\n"/* :nodoc: */
"      return unless trace_exit_locations_enabled?\n"
"\n"
"      filename = \"yjit_exit_locations.dump\"\n"
"      dump_exit_locations(filename)\n"
"\n"
"      $stderr.puts(\"YJIT exit locations dumped to `#{filename}`.\")\n"
"    end\n"
"\n"
"\n"/* Format and print out counters */
"    def _print_stats\n"/* :nodoc: */
"      stats = runtime_stats\n"
"      return unless stats\n"
"\n"
"      $stderr.puts(\"***YJIT: Printing YJIT statistics on exit***\")\n"
"\n"
"      print_counters(stats, prefix: 'send_', prompt: 'method call exit reasons: ')\n"
,
#line 245 "yjit.rb"
"      print_counters(stats, prefix: 'invokeblock_', prompt: 'invokeblock exit reasons: ')\n"
"      print_counters(stats, prefix: 'invokesuper_', prompt: 'invokesuper exit reasons: ')\n"
"      print_counters(stats, prefix: 'leave_', prompt: 'leave exit reasons: ')\n"
"      print_counters(stats, prefix: 'gbpp_', prompt: 'getblockparamproxy exit reasons: ')\n"
"      print_counters(stats, prefix: 'getivar_', prompt: 'getinstancevariable exit reasons:')\n"
,
#line 250 "yjit.rb"
"      print_counters(stats, prefix: 'setivar_', prompt: 'setinstancevariable exit reasons:')\n"
"      print_counters(stats, prefix: 'oaref_', prompt: 'opt_aref exit reasons: ')\n"
"      print_counters(stats, prefix: 'expandarray_', prompt: 'expandarray exit reasons: ')\n"
"      print_counters(stats, prefix: 'opt_getinlinecache_', prompt: 'opt_getinlinecache exit reasons: ')\n"
"      print_counters(stats, prefix: 'invalidate_', prompt: 'invalidation reasons: ')\n"
"\n"
"\n"/* Number of failed compiler invocations */
,
#line 257 "yjit.rb"
"      compilation_failure = stats[:compilation_failure]\n"
"\n"
"      $stderr.puts \"bindings_allocations:  \" + (\"%10d\" % stats[:binding_allocations])\n"
"      $stderr.puts \"bindings_set:          \" + (\"%10d\" % stats[:binding_set])\n"
"      $stderr.puts \"compilation_failure:   \" + (\"%10d\" % compilation_failure) if compilation_failure != 0\n"
"      $stderr.puts \"compiled_iseq_count:   \" + (\"%10d\" % stats[:compiled_iseq_count])\n"
"      $stderr.puts \"compiled_block_count:  \" + (\"%10d\" % stats[:compiled_block_count])\n"
,
#line 264 "yjit.rb"
"      $stderr.puts \"compiled_branch_count: \" + (\"%10d\" % stats[:compiled_branch_count])\n"
"      $stderr.puts \"block_next_count:      \" + (\"%10d\" % stats[:block_next_count])\n"
"      $stderr.puts \"defer_count:           \" + (\"%10d\" % stats[:defer_count])\n"
"      $stderr.puts \"freed_iseq_count:      \" + (\"%10d\" % stats[:freed_iseq_count])\n"
"      $stderr.puts \"invalidation_count:    \" + (\"%10d\" % stats[:invalidation_count])\n"
"      $stderr.puts \"constant_state_bumps:  \" + (\"%10d\" % stats[:constant_state_bumps])\n"
,
#line 270 "yjit.rb"
"      $stderr.puts \"inline_code_size:      \" + (\"%10d\" % stats[:inline_code_size])\n"
"      $stderr.puts \"outlined_code_size:    \" + (\"%10d\" % stats[:outlined_code_size])\n"
"      $stderr.puts \"freed_code_size:       \" + (\"%10d\" % stats[:freed_code_size])\n"
"      $stderr.puts \"code_region_size:      \" + (\"%10d\" % stats[:code_region_size])\n"
"      $stderr.puts \"yjit_alloc_size:       \" + (\"%10d\" % stats[:yjit_alloc_size]) if stats.key?(:yjit_alloc_size)\n"
,
#line 275 "yjit.rb"
"      $stderr.puts \"live_page_count:       \" + (\"%10d\" % stats[:live_page_count])\n"
"      $stderr.puts \"freed_page_count:      \" + (\"%10d\" % stats[:freed_page_count])\n"
"      $stderr.puts \"code_gc_count:         \" + (\"%10d\" % stats[:code_gc_count])\n"
"      $stderr.puts \"num_gc_obj_refs:       \" + (\"%10d\" % stats[:num_gc_obj_refs])\n"
"      $stderr.puts \"object_shape_count:    \" + (\"%10d\" % stats[:object_shape_count])\n"
"      $stderr.puts \"side_exit_count:       \" + (\"%10d\" % stats[:side_exit_count])\n"
,
#line 281 "yjit.rb"
"      $stderr.puts \"total_exit_count:      \" + (\"%10d\" % stats[:total_exit_count])\n"
"      $stderr.puts \"total_insns_count:     \" + (\"%10d\" % stats[:total_insns_count]) if stats.key?(:total_insns_count)\n"
"      if stats.key?(:vm_insns_count)\n"
"        $stderr.puts \"vm_insns_count:        \" + (\"%10d\" % stats[:vm_insns_count])\n"
"      end\n"
"      $stderr.puts \"yjit_insns_count:      \" + (\"%10d\" % stats[:exec_instruction])\n"
"      if stats.key?(:ratio_in_yjit)\n"
,
#line 288 "yjit.rb"
"        $stderr.puts \"ratio_in_yjit:         \" + (\"%9.1f\" % stats[:ratio_in_yjit]) + \"%\"\n"
"      end\n"
"      $stderr.puts \"avg_len_in_yjit:       \" + (\"%10.1f\" % stats[:avg_len_in_yjit])\n"
"\n"
"      print_sorted_exit_counts(stats, prefix: \"exit_\")\n"
"    end\n"
"\n"
"    def print_sorted_exit_counts(stats, prefix:, how_many: 20, left_pad: 4)\n"/* :nodoc: */
"      exits = []\n"
"      stats.each do |k, v|\n"
"        if k.start_with?(prefix)\n"
"          exits.push [k.to_s.delete_prefix(prefix), v]\n"
"        end\n"
"      end\n"
"\n"
,
#line 303 "yjit.rb"
"      exits = exits.select { |_name, count| count > 0 }.sort_by { |_name, count| -count }.first(how_many)\n"
"      total_exits = total_exit_count(stats)\n"
"\n"
"      if total_exits > 0\n"
"        top_n_total = exits.sum { |name, count| count }\n"
"        top_n_exit_pct = 100.0 * top_n_total / total_exits\n"
"\n"
"        $stderr.puts \"Top-#{exits.size} most frequent exit ops (#{\"%.1f\" % top_n_exit_pct}% of exits):\"\n"
"\n"
"        longest_insn_name_len = exits.map { |name, count| name.length }.max\n"
,
#line 313 "yjit.rb"
"        exits.each do |name, count|\n"
"          padding = longest_insn_name_len + left_pad\n"
"          padded_name = \"%#{padding}s\" % name\n"
"          padded_count = \"%10d\" % count\n"
"          percent = 100.0 * count / total_exits\n"
"          formatted_percent = \"%.1f\" % percent\n"
"          $stderr.puts(\"#{padded_name}: #{padded_count} (#{formatted_percent}%)\" )\n"
"        end\n"
"      else\n"
"        $stderr.puts \"total_exits:           \" + (\"%10d\" % total_exits)\n"
"      end\n"
"    end\n"
"\n"
,
#line 326 "yjit.rb"
"    def total_exit_count(stats, prefix: \"exit_\")\n"/* :nodoc: */
"      total = 0\n"
"      stats.each do |k,v|\n"
"        total += v if k.start_with?(prefix)\n"
"      end\n"
"      total\n"
"    end\n"
"\n"
"    def print_counters(counters, prefix:, prompt:)\n"/* :nodoc: */
"      $stderr.puts(prompt)\n"
"      counters = counters.filter { |key, _| key.start_with?(prefix) }\n"
"      counters.filter! { |_, value| value != 0 }\n"
"      counters.transform_keys! { |key| key.to_s.delete_prefix(prefix) }\n"
"\n"
"      if counters.empty?\n"
,
#line 341 "yjit.rb"
"        $stderr.puts(\"    (all relevant counters are zero)\")\n"
"        return\n"
"      end\n"
"\n"
"      counters = counters.to_a\n"
"      counters.sort_by! { |(_, counter_value)| counter_value }\n"
"      longest_name_length = counters.max_by { |(name, _)| name.length }.first.length\n"
"      total = counters.sum { |(_, counter_value)| counter_value }\n"
"\n"
"      counters.reverse_each do |(name, value)|\n"
"        percentage = value.fdiv(total) * 100\n"
,
#line 352 "yjit.rb"
"        $stderr.printf(\"    %*s %10d (%4.1f%%)\\n\", longest_name_length, name, value, percentage);\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 5416 "miniprelude.c"
};

COMPILER_WARNING_POP

#define PRELUDE_NAME(n) rb_usascii_str_new_static(prelude_name##n, sizeof(prelude_name##n)-1)
#define PRELUDE_CODE(n) rb_utf8_str_new_static(prelude_code##n.L0, sizeof(prelude_code##n))

static rb_ast_t *
prelude_ast(VALUE name, VALUE code, int line)
{
    rb_ast_t *ast = rb_parser_compile_string_path(rb_parser_new(), name, code, line);
    if (!ast->body.root) {
        rb_ast_dispose(ast);
        rb_exc_raise(rb_errinfo());
    }
    return ast;
}

#define PRELUDE_AST(n, name_str, start_line) \
    (((sizeof(prelude_name##n) - prefix_len - 2) == namelen) && \
     (strncmp(prelude_name##n + prefix_len, feature_name, namelen) == 0) ? \
     prelude_ast((name_str) = PRELUDE_NAME(n), PRELUDE_CODE(n), start_line) : 0)

rb_ast_t *
rb_builtin_ast(const char *feature_name, VALUE *name_str)
{
    const size_t prefix_len = rb_strlen_lit("<internal:");
    size_t namelen = strlen(feature_name);
    rb_ast_t *ast = 0;

    if ((ast = PRELUDE_AST(0, *name_str, 20)) != 0) return ast;
    if ((ast = PRELUDE_AST(1, *name_str, 83)) != 0) return ast;
    if ((ast = PRELUDE_AST(2, *name_str, 11)) != 0) return ast;
    if ((ast = PRELUDE_AST(3, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(4, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(5, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(6, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(7, *name_str, 4)) != 0) return ast;
    if ((ast = PRELUDE_AST(8, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(9, *name_str, 51)) != 0) return ast;
    if ((ast = PRELUDE_AST(10, *name_str, 4)) != 0) return ast;
    if ((ast = PRELUDE_AST(11, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(12, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(13, *name_str, 228)) != 0) return ast;
    if ((ast = PRELUDE_AST(14, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(15, *name_str, 214)) != 0) return ast;
    if ((ast = PRELUDE_AST(16, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(17, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(18, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(19, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(20, *name_str, 11)) != 0) return ast;
    return ast;
}

void
Init_prelude(void)
{
}
