/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseObject;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseDirectory
extends AltibaseObject<GenericStructContainer>
implements DBPScriptObject,
DBPRefreshableObject {
    private String ddl;
    private String dirPath;
    private Timestamp created;
    private Timestamp lastDdlTime;

    protected AltibaseDirectory(GenericStructContainer parent, JDBCResultSet resultSet) {
        super(parent, JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DIRECTORY_NAME"), JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"DIRECTORY_ID"), true);
        this.dirPath = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DIRECTORY_PATH");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        this.lastDdlTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_DDL_TIME");
    }

    @Property(viewable=true, order=2)
    public long getDirId() {
        return this.getObjectId();
    }

    @Property(viewable=true, order=4)
    @Nullable
    public String getDirName() {
        return this.dirPath;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public Timestamp getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=11)
    @NotNull
    public Timestamp getLastDdlTime() {
        return this.lastDdlTime;
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = this.getDataSource().getMetaModel().getDirectoryDDL(monitor, this, options) + ";";
        }
        return this.ddl;
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        AltibaseSchema schema = (AltibaseSchema)((Object)this.getParentObject());
        return schema.getDirectoryCache().refreshObject(monitor, (DBSObject)schema, this);
    }
}

