/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.google.common.base.CharMatcher;
import java.util.ArrayDeque;
import java.util.Deque;
import org.gradle.internal.file.FilePathUtil;

public class RelativePathParser {
    private static final CharMatcher IS_SLASH = CharMatcher.is((char)'/');
    private final Deque<String> directoryPaths = new ArrayDeque<String>();
    private final Deque<String> directoryNames = new ArrayDeque<String>();
    private final int rootLength;
    private String currentPath;
    private int sizeOfCommonPrefix;

    public RelativePathParser(String rootPath) {
        this.directoryPaths.addLast(rootPath.substring(0, rootPath.length() - 1));
        this.rootLength = rootPath.length();
        this.currentPath = rootPath;
    }

    public String getRelativePath() {
        return this.currentPath.substring(this.rootLength);
    }

    public String getName() {
        return this.currentPath.substring(this.sizeOfCommonPrefix + 1);
    }

    public boolean nextPath(String nextPath, boolean directory, Runnable exitDirectoryHandler) {
        this.currentPath = directory ? nextPath.substring(0, nextPath.length() - 1) : nextPath;
        String lastDirPath = this.directoryPaths.peekLast();
        this.sizeOfCommonPrefix = FilePathUtil.sizeOfCommonPrefix((String)lastDirPath, (String)this.currentPath, (int)0, (char)'/');
        int directoriesExited = RelativePathParser.determineDirectoriesExited(lastDirPath, this.sizeOfCommonPrefix);
        for (int i = 0; i < directoriesExited; ++i) {
            if (!this.exitDirectory(exitDirectoryHandler)) continue;
            return true;
        }
        String currentName = this.currentPath.substring(this.sizeOfCommonPrefix + 1);
        if (directory) {
            this.directoryPaths.addLast(this.currentPath);
            this.directoryNames.addLast(currentName);
        }
        return this.isRoot();
    }

    private boolean exitDirectory(Runnable exitDirectoryHandler) {
        if (this.directoryPaths.pollLast() == null) {
            return true;
        }
        if (this.directoryNames.pollLast() == null) {
            return true;
        }
        exitDirectoryHandler.run();
        return false;
    }

    private static int determineDirectoriesExited(String lastDirPath, int sizeOfCommonPrefix) {
        if (sizeOfCommonPrefix == lastDirPath.length()) {
            return 0;
        }
        int rootDirAdjustment = sizeOfCommonPrefix == 0 ? 1 : 0;
        return rootDirAdjustment + IS_SLASH.countIn((CharSequence)lastDirPath.substring(sizeOfCommonPrefix));
    }

    public boolean isRoot() {
        return this.directoryNames.isEmpty() && this.currentPath.length() == this.rootLength;
    }

    public void exitToRoot(Runnable exitDirectoryHandler) {
        while (!this.exitDirectory(exitDirectoryHandler)) {
        }
    }
}

