/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalProviderGroup {
    /// Unique identifier of the rental provider group
    #[serde(rename = "id")]
    pub id: String,
    /// Name of the provider group to be displayed to customers
    #[serde(rename = "name")]
    pub name: String,
    /// Color associated with this provider group, in hexadecimal RGB format (e.g. \"#FF0000\" for red). Can be empty. 
    #[serde(rename = "color", skip_serializing_if = "Option::is_none")]
    pub color: Option<String>,
    /// List of rental provider IDs that belong to this group
    #[serde(rename = "providers")]
    pub providers: Vec<String>,
    /// List of form factors offered by this provider group
    #[serde(rename = "formFactors")]
    pub form_factors: Vec<models::RentalFormFactor>,
}

impl RentalProviderGroup {
    pub fn new(id: String, name: String, providers: Vec<String>, form_factors: Vec<models::RentalFormFactor>) -> RentalProviderGroup {
        RentalProviderGroup {
            id,
            name,
            color: None,
            providers,
            form_factors,
        }
    }
}

