// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_create_bucket_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::create_bucket::CreateBucketOutput, crate::operation::create_bucket::CreateBucketError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::create_bucket::CreateBucketError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::create_bucket::CreateBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BucketAlreadyExists" => crate::operation::create_bucket::CreateBucketError::BucketAlreadyExists({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::BucketAlreadyExistsBuilder::default();
                output = crate::protocol_serde::shape_bucket_already_exists::de_bucket_already_exists_xml_err(_response_body, output)
                    .map_err(crate::operation::create_bucket::CreateBucketError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "BucketAlreadyOwnedByYou" => crate::operation::create_bucket::CreateBucketError::BucketAlreadyOwnedByYou({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::BucketAlreadyOwnedByYouBuilder::default();
                output = crate::protocol_serde::shape_bucket_already_owned_by_you::de_bucket_already_owned_by_you_xml_err(_response_body, output)
                    .map_err(crate::operation::create_bucket::CreateBucketError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::create_bucket::CreateBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_create_bucket_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::create_bucket::CreateBucketOutput, crate::operation::create_bucket::CreateBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::create_bucket::builders::CreateBucketOutputBuilder::default();
        output = output.set_bucket_arn(
            crate::protocol_serde::shape_create_bucket_output::de_bucket_arn_header(_response_headers).map_err(|_| {
                crate::operation::create_bucket::CreateBucketError::unhandled("Failed to parse BucketArn from header `x-amz-bucket-arn")
            })?,
        );
        output = output.set_location(
            crate::protocol_serde::shape_create_bucket_output::de_location_header(_response_headers)
                .map_err(|_| crate::operation::create_bucket::CreateBucketError::unhandled("Failed to parse Location from header `Location"))?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_create_bucket_headers(
    input: &crate::operation::create_bucket::CreateBucketInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.acl {
        let formatted_2 = inner_1.as_str();
        let header_value = formatted_2;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "acl",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-acl", header_value);
    }
    if let ::std::option::Option::Some(inner_3) = &input.grant_full_control {
        let formatted_4 = inner_3.as_str();
        let header_value = formatted_4;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_full_control",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-full-control", header_value);
    }
    if let ::std::option::Option::Some(inner_5) = &input.grant_read {
        let formatted_6 = inner_5.as_str();
        let header_value = formatted_6;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_read",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-read", header_value);
    }
    if let ::std::option::Option::Some(inner_7) = &input.grant_read_acp {
        let formatted_8 = inner_7.as_str();
        let header_value = formatted_8;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_read_acp",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-read-acp", header_value);
    }
    if let ::std::option::Option::Some(inner_9) = &input.grant_write {
        let formatted_10 = inner_9.as_str();
        let header_value = formatted_10;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_write",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-write", header_value);
    }
    if let ::std::option::Option::Some(inner_11) = &input.grant_write_acp {
        let formatted_12 = inner_11.as_str();
        let header_value = formatted_12;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "grant_write_acp",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-grant-write-acp", header_value);
    }
    if let ::std::option::Option::Some(inner_13) = &input.object_lock_enabled_for_bucket {
        let mut encoder = ::aws_smithy_types::primitive::Encoder::from(*inner_13);
        let formatted_14 = encoder.encode();
        let header_value = formatted_14;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "object_lock_enabled_for_bucket",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-bucket-object-lock-enabled", header_value);
    }
    if let ::std::option::Option::Some(inner_15) = &input.object_ownership {
        let formatted_16 = inner_15.as_str();
        let header_value = formatted_16;
        let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
            ::aws_smithy_types::error::operation::BuildError::invalid_field(
                "object_ownership",
                format!("`{}` cannot be used as a header value: {}", &header_value, err),
            )
        })?;
        builder = builder.header("x-amz-object-ownership", header_value);
    }
    Ok(builder)
}
