/*
	Adds a file handle abstraction on top of LUFS
*/

#ifndef _HANDLEFS_H_
#define _HANDLEFS_H_

using namespace std;

struct directory;
struct dir_cache;

#ifdef DEBUGGING
#define HANDLES_TTL	30
#else
#define HANDLES_TTL	300
#endif


class HandleFS
{
public:
    HandleFS(struct list_head*, struct dir_cache*, struct credentials*);
    ~HandleFS();

    int do_mount();
    void do_umount();
	
    int do_readdir(const char*, struct directory*);
    int do_stat(const char*, struct lufs_fattr*);
    int do_readlink(char*, char*, int);
    int do_open(const char*);
    int do_release(const char*);
    int do_read(const char*, long long, unsigned long, char*);

protected:
	// returns a handle to an already opened file or opens the file. Returns NULL if error.
	FileHandle	*Open( const char* path );

    struct dir_cache *cache;
    struct list_head *cfg;
	struct credentials *cred;
		
    FileHandleArray handles;
	FSModule::Array modules;	
};

#endif
