/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;
import org.logstash.Event;
import org.logstash.FieldReference;
import org.logstash.RubyUtil;
import org.logstash.Rubyfier;
import org.logstash.Valuefier;
import org.logstash.config.ir.expression.BinaryBooleanExpression;
import org.logstash.config.ir.expression.BooleanExpression;
import org.logstash.config.ir.expression.EventValueExpression;
import org.logstash.config.ir.expression.Expression;
import org.logstash.config.ir.expression.RegexValueExpression;
import org.logstash.config.ir.expression.ValueExpression;
import org.logstash.config.ir.expression.binary.And;
import org.logstash.config.ir.expression.binary.Eq;
import org.logstash.config.ir.expression.binary.Gt;
import org.logstash.config.ir.expression.binary.Gte;
import org.logstash.config.ir.expression.binary.In;
import org.logstash.config.ir.expression.binary.Lt;
import org.logstash.config.ir.expression.binary.Lte;
import org.logstash.config.ir.expression.binary.Neq;
import org.logstash.config.ir.expression.binary.Or;
import org.logstash.config.ir.expression.binary.RegexEq;
import org.logstash.config.ir.expression.unary.Not;
import org.logstash.config.ir.expression.unary.Truthy;
import org.logstash.ext.JrubyEventExtLibrary;

public interface EventCondition {
    public boolean fulfilled(JrubyEventExtLibrary.RubyEvent var1);

    public static final class Compiler {
        private static final Predicate<Integer> LESS_THAN = i -> i < 0;
        private static final Predicate<Integer> LESS_OR_EQUAL_THAN = i -> i <= 0;
        private static final Predicate<Integer> GREATER_THAN = i -> i > 0;
        private static final Predicate<Integer> GREATER_OR_EQUAL_THAN = i -> i >= 0;
        private final Map<String, EventCondition> cache = new HashMap<String, EventCondition>(10);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EventCondition buildCondition(BooleanExpression expression) {
            Map<String, EventCondition> map = this.cache;
            synchronized (map) {
                EventCondition condition;
                String cachekey = expression.toRubyString();
                EventCondition cached = this.cache.get(cachekey);
                if (cached != null) {
                    return cached;
                }
                if (expression instanceof Eq) {
                    condition = Compiler.eq((Eq)expression);
                } else if (expression instanceof RegexEq) {
                    condition = Compiler.regex((RegexEq)expression);
                } else if (expression instanceof In) {
                    condition = Compiler.in((In)expression);
                } else if (expression instanceof Or || expression instanceof And) {
                    condition = this.booleanCondition((BinaryBooleanExpression)expression);
                } else if (expression instanceof Truthy) {
                    condition = Compiler.truthy((Truthy)expression);
                } else if (expression instanceof Not) {
                    condition = this.not((Not)expression);
                } else if (expression instanceof Gt || expression instanceof Gte || expression instanceof Lt || expression instanceof Lte) {
                    condition = Compiler.comparison((BinaryBooleanExpression)expression);
                } else if (expression instanceof Neq) {
                    condition = Compiler.not(Compiler.eq((BinaryBooleanExpression)expression));
                } else {
                    throw new UnexpectedTypeException(expression);
                }
                this.cache.put(cachekey, condition);
                return condition;
            }
        }

        private EventCondition booleanCondition(BinaryBooleanExpression expression) {
            EventCondition second;
            EventCondition first;
            Expression left = expression.getLeft();
            Expression right = expression.getRight();
            if (left instanceof BooleanExpression && right instanceof BooleanExpression) {
                first = this.buildCondition((BooleanExpression)left);
                second = this.buildCondition((BooleanExpression)right);
            } else if (Compiler.eAndE(expression)) {
                first = Compiler.truthy((EventValueExpression)left);
                second = Compiler.truthy((EventValueExpression)right);
            } else if (left instanceof BooleanExpression && right instanceof EventValueExpression) {
                first = this.buildCondition((BooleanExpression)left);
                second = Compiler.truthy((EventValueExpression)right);
            } else if (right instanceof BooleanExpression && left instanceof EventValueExpression) {
                first = Compiler.truthy((EventValueExpression)left);
                second = this.buildCondition((BooleanExpression)right);
            } else {
                throw new UnexpectedTypeException(left, right);
            }
            if (expression instanceof And) {
                return event -> first.fulfilled(event) && second.fulfilled(event);
            }
            if (expression instanceof Or) {
                return event -> first.fulfilled(event) || second.fulfilled(event);
            }
            throw new UnexpectedTypeException(expression);
        }

        private EventCondition not(Not not) {
            EventCondition condition;
            Expression inner = not.getExpression();
            if (inner instanceof BooleanExpression) {
                condition = Compiler.not(this.buildCondition((BooleanExpression)inner));
            } else if (inner instanceof EventValueExpression) {
                condition = Compiler.not(Compiler.truthy((EventValueExpression)inner));
            } else {
                throw new UnexpectedTypeException(inner);
            }
            return condition;
        }

        private static boolean vAndE(BinaryBooleanExpression expression) {
            return expression.getLeft() instanceof ValueExpression && expression.getRight() instanceof EventValueExpression;
        }

        private static boolean vAndV(BinaryBooleanExpression expression) {
            return expression.getLeft() instanceof ValueExpression && expression.getRight() instanceof ValueExpression;
        }

        private static boolean eAndV(BinaryBooleanExpression expression) {
            return expression.getLeft() instanceof EventValueExpression && expression.getRight() instanceof ValueExpression;
        }

        private static boolean eAndE(BinaryBooleanExpression expression) {
            return expression.getLeft() instanceof EventValueExpression && expression.getRight() instanceof EventValueExpression;
        }

        private static boolean vAndR(BinaryBooleanExpression expression) {
            return expression.getLeft() instanceof ValueExpression && expression.getRight() instanceof RegexValueExpression;
        }

        private static EventCondition truthy(Truthy truthy) {
            EventCondition condition;
            Expression inner = truthy.getExpression();
            if (inner instanceof EventValueExpression) {
                condition = Compiler.truthy((EventValueExpression)inner);
            } else if (inner instanceof ValueExpression) {
                condition = Compiler.constant(Compiler.valueIsTruthy(((ValueExpression)inner).get()));
            } else {
                throw new UnexpectedTypeException(inner);
            }
            return condition;
        }

        private static EventCondition regex(RegexEq regex) {
            EventCondition condition;
            Expression uleft = regex.getLeft();
            Expression uright = regex.getRight();
            if (Compiler.eAndV(regex)) {
                condition = new FieldMatches(((EventValueExpression)uleft).getFieldName(), ((ValueExpression)uright).get().toString());
            } else if (Compiler.vAndR(regex)) {
                condition = new ConstantMatches(((ValueExpression)uleft).get(), ((RegexValueExpression)uright).get().toString());
            } else {
                throw new UnexpectedTypeException(uleft, uright);
            }
            return condition;
        }

        private static EventCondition comparison(BinaryBooleanExpression expression) {
            EventCondition condition;
            Predicate<Integer> converse;
            Predicate<Integer> conditional;
            if (expression instanceof Gte) {
                conditional = GREATER_OR_EQUAL_THAN;
                converse = LESS_OR_EQUAL_THAN;
            } else if (expression instanceof Lte) {
                conditional = LESS_OR_EQUAL_THAN;
                converse = GREATER_OR_EQUAL_THAN;
            } else if (expression instanceof Lt) {
                conditional = LESS_THAN;
                converse = GREATER_THAN;
            } else if (expression instanceof Gt) {
                conditional = GREATER_THAN;
                converse = LESS_THAN;
            } else {
                throw new UnexpectedTypeException(expression);
            }
            Expression uleft = expression.getLeft();
            Expression uright = expression.getRight();
            if (Compiler.eAndV(expression)) {
                condition = Compiler.compareFieldToConstant((EventValueExpression)uleft, (ValueExpression)uright, conditional);
            } else if (Compiler.vAndE(expression)) {
                condition = Compiler.compareFieldToConstant((EventValueExpression)uright, (ValueExpression)uleft, converse);
            } else {
                if (Compiler.vAndV(expression)) {
                    return Compiler.compareConstants((ValueExpression)uleft, (ValueExpression)uright, conditional);
                }
                return Compiler.compareFields((EventValueExpression)uleft, (EventValueExpression)uright, conditional);
            }
            return condition;
        }

        private static EventCondition in(In in) {
            EventCondition condition;
            Expression left = in.getLeft();
            Expression right = in.getRight();
            if (Compiler.eAndV(in) && Compiler.isScalar((ValueExpression)in.getRight())) {
                condition = new FieldInConstantScalar(FieldReference.from(((EventValueExpression)left).getFieldName()), ((ValueExpression)right).get().toString());
            } else if (Compiler.vAndE(in) && Compiler.isScalar((ValueExpression)in.getLeft())) {
                Object leftv = ((ValueExpression)left).get();
                FieldReference rfield = FieldReference.from(((EventValueExpression)right).getFieldName());
                condition = leftv instanceof String ? new ConstantStringInField(rfield, (String)leftv) : new ConstantScalarInField(rfield, leftv);
            } else if (Compiler.eAndV(in) && Compiler.listValueRight(in)) {
                condition = Compiler.in((EventValueExpression)left, (List)((ValueExpression)right).get());
            } else if (Compiler.eAndE(in)) {
                condition = Compiler.in((EventValueExpression)left, (EventValueExpression)right);
            } else if (Compiler.vAndV(in)) {
                condition = Compiler.in((ValueExpression)left, (ValueExpression)right);
            } else {
                throw new UnexpectedTypeException(left, right);
            }
            return condition;
        }

        private static EventCondition in(EventValueExpression left, List<?> right) {
            return new FieldInConstantList(FieldReference.from(left.getFieldName()), right);
        }

        private static EventCondition in(ValueExpression left, ValueExpression right) {
            Object found = right.get();
            Object other = left.get();
            boolean res = found instanceof ConvertedList && other instanceof RubyString ? ((ConvertedList)found).stream().anyMatch(item -> item.toString().equals(other.toString())) : (found instanceof RubyString && other instanceof RubyString ? found.toString().contains(other.toString()) : (found instanceof RubyString && other instanceof ConvertedList ? ((ConvertedList)other).stream().anyMatch(item -> item.toString().equals(found.toString())) : found != null && found.equals(other)));
            return Compiler.constant(res);
        }

        private static boolean listValueRight(In in) {
            return ((ValueExpression)in.getRight()).get() instanceof List;
        }

        private static boolean isScalar(ValueExpression expression) {
            Object value = expression.get();
            return value instanceof String || value instanceof Number;
        }

        private static EventCondition in(EventValueExpression left, EventValueExpression right) {
            return new FieldInField(FieldReference.from(left.getFieldName()), FieldReference.from(right.getFieldName()));
        }

        private static EventCondition eq(EventValueExpression evalE, ValueExpression valE) {
            return Compiler.rubyFieldEquals((Comparable)Rubyfier.deep(RubyUtil.RUBY, valE.get()), evalE.getFieldName());
        }

        private static EventCondition eq(BinaryBooleanExpression equals) {
            Expression left = equals.getLeft();
            Expression right = equals.getRight();
            EventCondition condition = Compiler.eAndV(equals) ? Compiler.eq((EventValueExpression)left, (ValueExpression)right) : (Compiler.vAndE(equals) ? Compiler.eq((EventValueExpression)right, (ValueExpression)left) : (Compiler.eAndE(equals) ? Compiler.eq((EventValueExpression)left, (EventValueExpression)right) : Compiler.constant(((ValueExpression)left).get().equals(((ValueExpression)right).get()))));
            return condition;
        }

        private static EventCondition eq(EventValueExpression first, EventValueExpression second) {
            FieldReference field1 = FieldReference.from(first.getFieldName());
            FieldReference field2 = FieldReference.from(second.getFieldName());
            return event -> {
                Event java = event.getEvent();
                return Objects.equals(java.getUnconvertedField(field1), java.getUnconvertedField(field2));
            };
        }

        private static EventCondition truthy(EventValueExpression evalE) {
            return new FieldTruthy(FieldReference.from(evalE.getFieldName()));
        }

        private static EventCondition not(EventCondition condition) {
            return event -> !condition.fulfilled(event);
        }

        private static EventCondition compareConstants(ValueExpression left, ValueExpression right, Predicate<Integer> operator) {
            return Compiler.constant(operator.test(Compiler.compare(left.get(), right.get())));
        }

        private static EventCondition compareFields(EventValueExpression left, EventValueExpression right, Predicate<Integer> operator) {
            FieldReference one = FieldReference.from(left.getFieldName());
            FieldReference other = FieldReference.from(right.getFieldName());
            return event -> {
                Event javaEvent = event.getEvent();
                return operator.test(Compiler.compare(javaEvent.getUnconvertedField(one), javaEvent.getUnconvertedField(other)));
            };
        }

        private static EventCondition compareFieldToConstant(EventValueExpression left, ValueExpression right, Predicate<Integer> operator) {
            FieldReference one = FieldReference.from(left.getFieldName());
            Comparable other = (Comparable)Rubyfier.deep(RubyUtil.RUBY, right.get());
            return event -> {
                Event javaEvent = event.getEvent();
                return operator.test(Compiler.compare(javaEvent.getUnconvertedField(one), other));
            };
        }

        private static int compare(Object left, Object right) {
            if (left instanceof Comparable) {
                return ((Comparable)left).compareTo(right);
            }
            throw new UnexpectedTypeException(left, right);
        }

        private static boolean contains(ConvertedList list, Object value) {
            for (Object element : list) {
                if (!value.equals(element)) continue;
                return true;
            }
            return false;
        }

        private static EventCondition rubyFieldEquals(Comparable<IRubyObject> left, String field) {
            FieldReference reference = FieldReference.from(field);
            return event -> left.equals(Rubyfier.deep(RubyUtil.RUBY, event.getEvent().getUnconvertedField(reference)));
        }

        private static EventCondition constant(boolean value) {
            return value ? event -> true : event -> false;
        }

        private static boolean valueIsTruthy(Object object) {
            if (object == null) {
                return false;
            }
            String other = object.toString();
            return other != null && !other.isEmpty() && !Boolean.toString(false).equals(other);
        }

        private static RubyRegexp newRegexp(String pattern) {
            Ruby runtime = RubyUtil.RUBY;
            return RubyRegexp.newRegexpFromStr((Ruby)runtime, (RubyString)runtime.newString(pattern), (int)0);
        }

        private static boolean matches(RubyString str, RubyRegexp regexp) {
            return regexp.match_p(RubyUtil.RUBY.getCurrentContext(), (IRubyObject)str).isTrue();
        }

        private static final class UnexpectedTypeException
        extends IllegalArgumentException {
            private static final long serialVersionUID = 1L;

            UnexpectedTypeException(Expression left, Expression right) {
                super(String.format("Unexpected input types left: %s, right: %s", UnexpectedTypeException.getUnexpectedTypeDetails(left), UnexpectedTypeException.getUnexpectedTypeDetails(right)));
            }

            UnexpectedTypeException(Object inner) {
                super(String.format("Unexpected input type %s", UnexpectedTypeException.getUnexpectedTypeDetails(inner)));
            }

            UnexpectedTypeException(Object left, Object right) {
                super(String.format("Unexpected input type combination left %s, right %s", UnexpectedTypeException.getUnexpectedTypeDetails(left), UnexpectedTypeException.getUnexpectedTypeDetails(right)));
            }

            private static String getUnexpectedTypeDetails(Object unexpected) {
                Expression expression;
                String details = unexpected instanceof Expression ? ((expression = (Expression)unexpected).getSourceWithMetadata() != null ? expression.getSourceWithMetadata().toString() : expression.toString()) : unexpected.toString();
                return String.format("%s:%s", unexpected.getClass(), details);
            }
        }

        private static final class FieldMatches
        implements EventCondition {
            private final FieldReference field;
            private final RubyRegexp regexp;

            private FieldMatches(String field, String pattern) {
                this.field = FieldReference.from(field);
                this.regexp = Compiler.newRegexp(pattern);
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object toMatch = event.getEvent().getUnconvertedField(this.field);
                return toMatch instanceof RubyString && Compiler.matches((RubyString)toMatch, this.regexp);
            }
        }

        private static final class ConstantMatches
        implements EventCondition {
            private final boolean matches;

            private ConstantMatches(Object constant, String pattern) {
                this.matches = constant instanceof String && Compiler.matches(RubyUtil.RUBY.newString((String)constant), Compiler.newRegexp(pattern));
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                return this.matches;
            }
        }

        private static final class FieldInConstantScalar
        implements EventCondition {
            private final FieldReference field;
            private final ByteList value;

            private FieldInConstantScalar(FieldReference field, String value) {
                this.field = field;
                this.value = RubyUtil.RUBY.newString(value).getByteList();
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object found = event.getEvent().getUnconvertedField(this.field);
                return found instanceof RubyString && this.value.indexOf(((RubyString)found).getByteList()) > -1;
            }
        }

        private static final class ConstantStringInField
        implements EventCondition {
            private final FieldReference field;
            private final ByteList bytes;
            private final RubyString string;

            private ConstantStringInField(FieldReference field, String value) {
                this.field = field;
                this.string = RubyUtil.RUBY.newString(value);
                this.bytes = this.string.getByteList();
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object found = event.getEvent().getUnconvertedField(this.field);
                return found instanceof RubyString && ((RubyString)found).getByteList().indexOf(this.bytes) > -1 || found instanceof ConvertedList && Compiler.contains((ConvertedList)found, this.string);
            }
        }

        private static final class ConstantScalarInField
        implements EventCondition {
            private final FieldReference field;
            private final Object value;

            private ConstantScalarInField(FieldReference field, Object value) {
                this.field = field;
                this.value = Valuefier.convert(value);
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object found = event.getEvent().getUnconvertedField(this.field);
                return found instanceof ConvertedList && Compiler.contains((ConvertedList)found, this.value) || Objects.equals(found, this.field);
            }
        }

        private static final class FieldInConstantList
        implements EventCondition {
            private final FieldReference field;
            private final List<?> value;

            private FieldInConstantList(FieldReference field, List<?> value) {
                this.field = field;
                this.value = value;
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object found = event.getEvent().getUnconvertedField(this.field);
                return found != null && this.value.stream().anyMatch(val -> val.toString().equals(found.toString()));
            }
        }

        private static final class FieldInField
        implements EventCondition {
            private final FieldReference left;
            private final FieldReference right;

            private FieldInField(FieldReference left, FieldReference right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object lfound = event.getEvent().getUnconvertedField(this.left);
                Object rfound = event.getEvent().getUnconvertedField(this.right);
                if (lfound instanceof ConvertedList || lfound instanceof ConvertedMap) {
                    return false;
                }
                if (lfound instanceof RubyString && rfound instanceof RubyString) {
                    return ((RubyString)rfound).getByteList().indexOf(((RubyString)lfound).getByteList()) > -1;
                }
                if (rfound instanceof ConvertedList) {
                    return Compiler.contains((ConvertedList)rfound, lfound);
                }
                return lfound != null && lfound.equals(rfound);
            }
        }

        private static final class FieldTruthy
        implements EventCondition {
            private final FieldReference field;

            private FieldTruthy(FieldReference field) {
                this.field = field;
            }

            @Override
            public boolean fulfilled(JrubyEventExtLibrary.RubyEvent event) {
                Object object = event.getEvent().getUnconvertedField(this.field);
                return Compiler.valueIsTruthy(object);
            }
        }
    }
}

