-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Term_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY TrmA IS

TrmA_cached	SG_TERM_ASSOC.OID%TYPE DEFAULT NULL;
cache_key		VARCHAR2(1024) DEFAULT NULL;

CURSOR TrmA_c (
		TrmA_SUBJ_TRM_OID	IN SG_TERM_ASSOC.SUBJ_TRM_OID%TYPE,
		TrmA_PRED_TRM_OID	IN SG_TERM_ASSOC.PRED_TRM_OID%TYPE,
		TrmA_OBJ_TRM_OID	IN SG_TERM_ASSOC.OBJ_TRM_OID%TYPE,
		TrmA_ONT_OID	IN SG_TERM_ASSOC.ONT_OID%TYPE)
RETURN SG_TERM_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_TERM_ASSOC t
	WHERE
		t.SUBJ_TRM_OID = TrmA_SUBJ_TRM_OID
	AND	t.PRED_TRM_OID = TrmA_PRED_TRM_OID
	AND	t.OBJ_TRM_OID = TrmA_OBJ_TRM_OID
	AND	t.ONT_OID = TrmA_ONT_OID
	;

FUNCTION get_oid(
		TrmA_OID	IN SG_TERM_ASSOC.OID%TYPE DEFAULT NULL,
		SUBJ_TRM_OID	IN SG_TERM_ASSOC.SUBJ_TRM_OID%TYPE,
		PRED_TRM_OID	IN SG_TERM_ASSOC.PRED_TRM_OID%TYPE,
		OBJ_TRM_OID	IN SG_TERM_ASSOC.OBJ_TRM_OID%TYPE,
		ONT_OID	IN SG_TERM_ASSOC.ONT_OID%TYPE,
		Ont_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Subj_Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		Subj_ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		Subj_ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Subj_Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		Pred_Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		Pred_ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		Pred_ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Pred_Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		Obj_Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		Obj_ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		Obj_ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Obj_Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN SG_TERM_ASSOC.OID%TYPE
IS
	pk	SG_TERM_ASSOC.OID%TYPE DEFAULT NULL;
	TrmA_row TrmA_c%ROWTYPE;
	SUBJ_TRM_OID_	SG_TERM.OID%TYPE DEFAULT SUBJ_TRM_OID;
	OBJ_TRM_OID_	SG_TERM.OID%TYPE DEFAULT OBJ_TRM_OID;
	PRED_TRM_OID_	SG_TERM.OID%TYPE DEFAULT PRED_TRM_OID;
	ONT_OID_	SG_ONTOLOGY.OID%TYPE DEFAULT ONT_OID;
	key_str	VARCHAR2(1024) DEFAULT Subj_Trm_NAME || '|' || Subj_ONT_OID || '|' || Subj_Ont_Name || '|' || Subj_Trm_IDENTIFIER || '|' || Obj_Trm_NAME || '|' || Obj_ONT_OID || '|' || Obj_Ont_Name || '|' || Obj_Trm_IDENTIFIER || '|' || Pred_Trm_NAME || '|' || Pred_ONT_OID || '|' || Pred_Ont_Name || '|' || Pred_Trm_IDENTIFIER || '|' || Ont_NAME;
BEGIN
	-- initialize
	IF (do_DML > BSStd.DML_NO) THEN
		pk := TrmA_OID;
	END IF;
	-- look up
	IF pk IS NULL THEN
		IF (key_str = cache_key) THEN
			pk := TrmA_cached;
		ELSE
			-- reset cache
			cache_key := NULL;
			TrmA_cached := NULL;
                	-- look up SG_TERM subject
                	IF (SUBJ_TRM_OID_ IS NULL) THEN
                		SUBJ_TRM_OID_ := Trm.get_oid(
                			Trm_NAME => Subj_Trm_NAME,
                			ONT_OID => Subj_ONT_OID,
                			ONT_Name => Subj_ONT_NAME,
                			Trm_IDENTIFIER => Subj_Trm_IDENTIFIER,
                			do_DML => do_DML);
                	END IF;
                	-- look up SG_TERM object
                	IF (OBJ_TRM_OID_ IS NULL) THEN
                		OBJ_TRM_OID_ := Trm.get_oid(
                			Trm_NAME => Obj_Trm_NAME,
                			ONT_OID => Obj_ONT_OID,
                			ONT_Name => Obj_ONT_NAME,
                			Trm_IDENTIFIER => Obj_Trm_IDENTIFIER,
                			do_DML => do_DML);
                	END IF;
                	-- look up SG_TERM predicate
                	IF (PRED_TRM_OID_ IS NULL) THEN
                		PRED_TRM_OID_ := Trm.get_oid(
                			Trm_NAME => Pred_Trm_NAME,
                			ONT_OID => Pred_ONT_OID,
                			ONT_Name => Pred_ONT_NAME,
                			Trm_IDENTIFIER => Pred_Trm_IDENTIFIER,
                			do_DML => do_DML);
                	END IF;
                	-- look up SG_ONTOLOGY
                	IF (ONT_OID_ IS NULL) THEN
                		ONT_OID_ := Ont.get_oid(
                			Ont_NAME => Ont_NAME);
                	END IF;
			-- do the look up
			FOR TrmA_row IN TrmA_c(SUBJ_TRM_OID_, PRED_TRM_OID_, OBJ_TRM_OID_, ONT_OID_) LOOP
		        	pk := TrmA_row.OID;
				-- cache result
			    	cache_key := key_str;
			    	TrmA_cached := pk;
			END LOOP;
		END IF;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_TERM subject successful?
		IF (SUBJ_TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Subj_Trm_NAME || '|' || Subj_ONT_OID || '|' || Subj_Ont_Name || '|' || Subj_Trm_IDENTIFIER || '>');
		END IF;
		-- look up SG_TERM object successful?
		IF (OBJ_TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Obj_Trm_NAME || '|' || Obj_ONT_OID || '|' || Obj_Ont_Name || '|' || Obj_Trm_IDENTIFIER || '>');
		END IF;
		-- look up SG_TERM predicate successful?
		IF (PRED_TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Pred_Trm_NAME || '|' || Pred_ONT_OID || '|' || Pred_Ont_Name || '|' || Pred_Trm_IDENTIFIER || '>');
		END IF;
		-- look up SG_ONTOLOGY successful?
		IF (ONT_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Ont <' || Ont_NAME || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        SUBJ_TRM_OID => SUBJ_TRM_OID_,
			PRED_TRM_OID => PRED_TRM_OID_,
			OBJ_TRM_OID => OBJ_TRM_OID_,
			ONT_OID => ONT_OID_);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			TrmA_OID	=> pk,
		        TrmA_SUBJ_TRM_OID => SUBJ_TRM_OID_,
			TrmA_PRED_TRM_OID => PRED_TRM_OID_,
			TrmA_OBJ_TRM_OID => OBJ_TRM_OID_,
			TrmA_ONT_OID => ONT_OID_);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		SUBJ_TRM_OID	IN SG_TERM_ASSOC.SUBJ_TRM_OID%TYPE,
		PRED_TRM_OID	IN SG_TERM_ASSOC.PRED_TRM_OID%TYPE,
		OBJ_TRM_OID	IN SG_TERM_ASSOC.OBJ_TRM_OID%TYPE,
		ONT_OID	IN SG_TERM_ASSOC.ONT_OID%TYPE)
RETURN SG_TERM_ASSOC.OID%TYPE 
IS
	pk	SG_TERM_ASSOC.OID%TYPE;
BEGIN
	-- pre-generate the primary key value
	SELECT SG_Sequence_TrmA.nextval INTO pk FROM DUAL;
	-- insert the record
	INSERT INTO SG_TERM_ASSOC (
		OID,
		SUBJ_TRM_OID,
		PRED_TRM_OID,
		OBJ_TRM_OID,
		ONT_OID)
	VALUES (pk,
		SUBJ_TRM_OID,
		PRED_TRM_OID,
		OBJ_TRM_OID,
		ONT_OID)
	;
	-- return the new pk value
	RETURN pk;
END;

PROCEDURE do_update(
		TrmA_OID	IN SG_TERM_ASSOC.OID%TYPE,
		TrmA_SUBJ_TRM_OID	IN SG_TERM_ASSOC.SUBJ_TRM_OID%TYPE,
		TrmA_PRED_TRM_OID	IN SG_TERM_ASSOC.PRED_TRM_OID%TYPE,
		TrmA_OBJ_TRM_OID	IN SG_TERM_ASSOC.OBJ_TRM_OID%TYPE,
		TrmA_ONT_OID	IN SG_TERM_ASSOC.ONT_OID%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_TERM_ASSOC
	SET
		SUBJ_TRM_OID = NVL(TrmA_SUBJ_TRM_OID, SUBJ_TRM_OID),
		PRED_TRM_OID = NVL(TrmA_PRED_TRM_OID, PRED_TRM_OID),
		OBJ_TRM_OID = NVL(TrmA_OBJ_TRM_OID, OBJ_TRM_OID),
		ONT_OID = NVL(TrmA_ONT_OID, ONT_OID)
	WHERE OID = TrmA_OID
	;
END;

END TrmA;
/

