/* arch-tag: 6750c768-cd2d-4659-bf04-8ba8ab506b64 */

/*  eXperience GTK engine: render.c
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "group.h"
#include "render.h"

gboolean
experience_render_group (eXperienceGroup *group, GdkWindow *window, GdkRectangle * object_area, GdkRectangle *area, GtkStyle * style, GdkRegion *subtract_region)
{
	GdkRectangle dest_area;
	eXperienceRenderContext render_context;
	gboolean result;
	
	g_return_val_if_fail (group != NULL, FALSE);
	
	if ((object_area->width == -1) && (object_area->height == -1)) {
		gdk_window_get_size (window, &object_area->width, &object_area->height);
	} else if (object_area->width == -1)
		gdk_window_get_size (window, &object_area->width, NULL);
	else if (object_area->height == -1)
		gdk_window_get_size (window, NULL, &object_area->height);
	
	if (area == NULL) {
		dest_area = *object_area;
	} else {
		dest_area = *area;
	}

	if (!group->dont_clip)
		gdk_rectangle_intersect(&dest_area, object_area, &dest_area);

	if (dest_area.width <= 0 || dest_area.height <= 0)
		return TRUE;
		
	if (group->filter.opacity < 1.0) {
		GdkGC *gc;
		/* render into pixbuf */
		render_context.type = TYPE_PIXBUF;
		render_context.pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, dest_area.width, dest_area.height);
		gdk_pixbuf_fill (render_context.pixbuf, 0x00000000);
		
		render_context.clip_area.x = 0;
		render_context.clip_area.y = 0;
		render_context.clip_area.width = dest_area.width;
		render_context.clip_area.height = dest_area.height;
		render_context.dirty_region = gdk_region_new ();
		
		object_area->x -= dest_area.x;
		object_area->y -= dest_area.y;

		result = experience_group_draw (group, &render_context, object_area, style);
		experience_change_pixbuf_opacity (render_context.pixbuf, group->filter.opacity);
		
		gdk_region_offset (render_context.dirty_region, dest_area.x, dest_area.y);
		if (subtract_region)
			gdk_region_subtract (render_context.dirty_region, subtract_region);
		
		gc = gdk_gc_new (window);
		
		gdk_gc_set_clip_region (gc, render_context.dirty_region);
		
		gdk_draw_pixbuf (window, gc, render_context.pixbuf,
		                 0, 0,
		                 dest_area.x, dest_area.y,
		                 dest_area.width, dest_area.height,
		                 GDK_RGB_DITHER_NORMAL, 0 ,0);
	
		gdk_gc_unref (gc);
		
		g_object_unref (render_context.pixbuf);
		gdk_region_destroy (render_context.dirty_region);
	} else {
		GdkRegion *clip_region;
		render_context.type = TYPE_DRAWABLE;
		render_context.drawable = (GdkDrawable*) window; /* should be casted earlier */
		render_context.clip_gc = NULL;
		
		render_context.clip_area = dest_area;
		
		if (subtract_region) {
			render_context.clip_gc = gdk_gc_new (render_context.drawable);
			
			clip_region = gdk_region_rectangle (&dest_area);
			gdk_region_subtract (clip_region, subtract_region);
			gdk_gc_set_clip_region (render_context.clip_gc, clip_region);
			
			gdk_region_destroy (clip_region);
		}
		result = experience_group_draw (group, &render_context, object_area, style);
		
		if (render_context.clip_gc)
			gdk_gc_unref (render_context.clip_gc);
	}
	return result;
}

void
experience_render_cleanup (void)
{
	/* ok, this is now empty, I'll just leave it in here for now. */
}
