# Unresolved Imports

## Unresolved import statement

```py
import bar  # error: "Cannot resolve imported module `bar`"

reveal_type(bar)  # revealed: Unknown
```

## Unresolved import from statement

```py
from bar import baz  # error: "Cannot resolve imported module `bar`"

reveal_type(baz)  # revealed: Unknown
```

## Unresolved import from resolved module

`a.py`:

```py
```

```py
from a import thing  # error: "Module `a` has no member `thing`"

reveal_type(thing)  # revealed: Unknown
```

## Resolved import of symbol from unresolved import

`a.py`:

```py
import foo as foo  # error: "Cannot resolve imported module `foo`"

reveal_type(foo)  # revealed: Unknown
```

Importing the unresolved import into a second file should not trigger an additional "unresolved
import" violation:

```py
from a import foo

reveal_type(foo)  # revealed: Unknown
```

## No implicit shadowing

`b.py`:

```py
x: int
```

```py
from b import x

x = "foo"  # error: [invalid-assignment] "Object of type `Literal["foo"]"
```

## Import cycle

`a.py`:

```py
from ty_extensions import reveal_mro

class A: ...

reveal_mro(A)  # revealed: (<class 'A'>, <class 'object'>)
import b

class C(b.B): ...

reveal_mro(C)  # revealed: (<class 'C'>, <class 'B'>, <class 'A'>, <class 'object'>)
```

`b.py`:

```py
from ty_extensions import reveal_mro
from a import A

class B(A): ...

reveal_mro(B)  # revealed: (<class 'B'>, <class 'A'>, <class 'object'>)
```
