def func():
    # SIM113
    idx = 0
    for x in range(5):
        g(x, idx)
        idx += 1
        h(x)


def func():
    # SIM113
    sum = 0
    idx = 0
    for x in range(5):
        if g(x):
            break
        idx += 1
        sum += h(x, idx)


def func():
    # SIM113
    idx = 0
    for x, y in zip(range(5), range(5)):
        g(x)
        h(x, y)
        idx += 1


def func():
    # SIM113
    idx = 0
    sum = 0
    for x in range(5):
        sum += h(x, idx)
        idx += 1


def func():
    # SIM113
    sum, idx = 0, 0
    for x in range(5):
        g(x, idx)
        idx += 1
        h(x)


def func():
    # SIM113
    # https://github.com/astral-sh/ruff/pull/21395
    idx = 10
    for x in range(5):
        g(x, idx)
        idx += 1
        h(x)


def func():
    # OK (incremented by more than 1)
    idx = 0
    for x in range(5):
        g(x, idx)
        idx += 2
        h(x)


def func():
    # OK (incremented in `if`)
    idx = 0
    for x in range(5):
        if g(x):
            idx += 1
        h(x)


def func():
    # OK (`continue` in match-case)
    idx = 0
    for x in range(5):
        match g(x):
            case 1:
                h(x)
            case 2:
                continue
            case _:
                h(idx)
        idx += 1


def func():
    # OK (`continue` inside `with` clause)
    idx = 0
    for x in range(5):
        with context as c:
            if g(x):
                continue
            h(x, idx, c)
        idx += 1


def func():
    # OK (incremented in `try` block)
    idx = 0
    for x in range(5):
        try:
            g(x, idx)
        except:
            h(x)
            continue
        idx += 1


def func(idx: 0):
    # OK (index is an argument)
    for x in range(5):
        g(x, idx)
        idx += 1


def func(x: int):
    # OK (index _may_ be non-zero)
    if x > 0:
        idx = 1
    else:
        idx = 0
    for x in range(5):
        g(x, idx)
        idx += 1
        h(x)


def func():
    # OK
    idx = 0
    for x in range(5):
        g(x, idx)
        idx += 1
        idx += 1
        h(x)


def func():
    # OK
    idx = 0
    for x in range(5):
        g(x, idx)
        idx += 1
        if idx > 10:
            idx *= 2
        h(x)


def func():
    # OK (index used after loop)
    idx = 0
    for x in range(5):
        g(x, idx)
        idx += 1
        h(x)
    print(idx)


def func():
    # OK (index within nested loop)
    idx = 0
    for x in range(5):
        for y in range(5):
            g(x, idx)
            idx += 1


def func():
    # OK (index used within inner)
    idx = 0

    def inner():
        print(idx)

    for x in range(5):
        for y in range(5):
            g(x, idx)
            idx += 1


def func():
    # OK (index used as nonlocal inner)
    idx = 0

    def inner():
        nonlocal idx
        idx = 3

    for x in range(5):
        for y in range(5):
            g(x, idx)
            idx += 1

async def func():
    # OK (for loop is async)
    idx = 0

    async for x in async_gen():
        g(x, idx)
        idx += 1
