/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.interpreter.OopMapCacheEntry;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.BreakpointInfo;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CheckedExceptionElement;
import sun.jvm.hotspot.oops.ConstMethod;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ExceptionTableElement;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.LineNumberTableElement;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.MethodCounters;
import sun.jvm.hotspot.oops.MethodData;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.SignatureConverter;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class Method
extends Metadata {
    private static AddressField constMethod;
    private static AddressField methodData;
    private static AddressField methodCounters;
    private static CIntField methodSize;
    private static CIntField accessFlags;
    private static CIntField vtableIndex;
    private static long bytecodeOffset;
    private static AddressField code;
    private static Symbol objectInitializerName;
    private static Symbol classInitializerName;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Method");
        constMethod = type.getAddressField("_constMethod");
        methodData = type.getAddressField("_method_data");
        methodCounters = type.getAddressField("_method_counters");
        methodSize = new CIntField(type.getCIntegerField("_method_size"), 0L);
        accessFlags = new CIntField(type.getCIntegerField("_access_flags"), 0L);
        code = type.getAddressField("_code");
        vtableIndex = new CIntField(type.getCIntegerField("_vtable_index"), 0L);
        bytecodeOffset = type.getSize();
        objectInitializerName = null;
        classInitializerName = null;
    }

    public Method(Address addr) {
        super(addr);
    }

    public boolean isMethod() {
        return true;
    }

    private static Symbol objectInitializerName() {
        if (objectInitializerName == null) {
            objectInitializerName = VM.getVM().getSymbolTable().probe("<init>");
        }
        return objectInitializerName;
    }

    private static Symbol classInitializerName() {
        if (classInitializerName == null) {
            classInitializerName = VM.getVM().getSymbolTable().probe("<clinit>");
        }
        return classInitializerName;
    }

    public ConstMethod getConstMethod() {
        Address addr = constMethod.getValue(this.getAddress());
        return (ConstMethod)VMObjectFactory.newObject(ConstMethod.class, addr);
    }

    public ConstantPool getConstants() {
        return this.getConstMethod().getConstants();
    }

    public MethodData getMethodData() {
        Address addr = methodData.getValue(this.getAddress());
        return (MethodData)VMObjectFactory.newObject(MethodData.class, addr);
    }

    public MethodCounters getMethodCounters() {
        Address addr = methodCounters.getValue(this.getAddress());
        return (MethodCounters)VMObjectFactory.newObject(MethodCounters.class, addr);
    }

    public long getMethodSize() {
        return methodSize.getValue(this);
    }

    public long getMaxStack() {
        return this.getConstMethod().getMaxStack();
    }

    public long getMaxLocals() {
        return this.getConstMethod().getMaxLocals();
    }

    public long getSizeOfParameters() {
        return this.getConstMethod().getSizeOfParameters();
    }

    public long getNameIndex() {
        return this.getConstMethod().getNameIndex();
    }

    public long getSignatureIndex() {
        return this.getConstMethod().getSignatureIndex();
    }

    public long getGenericSignatureIndex() {
        return this.getConstMethod().getGenericSignatureIndex();
    }

    public long getAccessFlags() {
        return accessFlags.getValue(this);
    }

    public long getCodeSize() {
        return this.getConstMethod().getCodeSize();
    }

    public long getVtableIndex() {
        return vtableIndex.getValue(this);
    }

    public long getInvocationCount() {
        MethodCounters mc = this.getMethodCounters();
        return mc == null ? 0L : mc.getInvocationCounter();
    }

    public long getBackedgeCount() {
        MethodCounters mc = this.getMethodCounters();
        return mc == null ? 0L : mc.getBackedgeCounter();
    }

    public NMethod getNativeMethod() {
        Address addr = code.getValue(this.getAddress());
        return (NMethod)VMObjectFactory.newObject(NMethod.class, addr);
    }

    public AccessFlags getAccessFlagsObj() {
        return new AccessFlags(this.getAccessFlags());
    }

    public int getBytecodeOrBPAt(int bci) {
        return this.getConstMethod().getBytecodeOrBPAt(bci);
    }

    public int getOrigBytecodeAt(int bci) {
        BreakpointInfo bp;
        for (bp = this.getMethodHolder().getBreakpoints(); bp != null; bp = bp.getNext()) {
            if (!bp.match(this, bci)) continue;
            return bp.getOrigBytecode();
        }
        System.err.println("Requested bci " + bci);
        while (bp != null) {
            System.err.println("Breakpoint at bci " + bp.getBCI() + ", bytecode " + bp.getOrigBytecode());
            bp = bp.getNext();
        }
        Assert.that(false, "Should not reach here");
        return -1;
    }

    public byte getBytecodeByteArg(int bci) {
        return this.getConstMethod().getBytecodeByteArg(bci);
    }

    public short getBytecodeShortArg(int bci) {
        return this.getConstMethod().getBytecodeShortArg(bci);
    }

    public short getNativeShortArg(int bci) {
        return this.getConstMethod().getNativeShortArg(bci);
    }

    public int getBytecodeIntArg(int bci) {
        return this.getConstMethod().getBytecodeIntArg(bci);
    }

    public int getNativeIntArg(int bci) {
        return this.getConstMethod().getNativeIntArg(bci);
    }

    public byte[] getByteCode() {
        return this.getConstMethod().getByteCode();
    }

    public Symbol getName() {
        return this.getConstants().getSymbolAt(this.getNameIndex());
    }

    public Symbol getSignature() {
        return this.getConstants().getSymbolAt(this.getSignatureIndex());
    }

    public Symbol getGenericSignature() {
        long index = this.getGenericSignatureIndex();
        return index != 0L ? this.getConstants().getSymbolAt(index) : null;
    }

    public InstanceKlass getMethodHolder() {
        return this.getConstants().getPoolHolder();
    }

    public boolean isPublic() {
        return this.getAccessFlagsObj().isPublic();
    }

    public boolean isPrivate() {
        return this.getAccessFlagsObj().isPrivate();
    }

    public boolean isProtected() {
        return this.getAccessFlagsObj().isProtected();
    }

    public boolean isPackagePrivate() {
        AccessFlags af = this.getAccessFlagsObj();
        return !af.isPublic() && !af.isPrivate() && !af.isProtected();
    }

    public boolean isStatic() {
        return this.getAccessFlagsObj().isStatic();
    }

    public boolean isFinal() {
        return this.getAccessFlagsObj().isFinal();
    }

    public boolean isSynchronized() {
        return this.getAccessFlagsObj().isSynchronized();
    }

    public boolean isBridge() {
        return this.getAccessFlagsObj().isBridge();
    }

    public boolean isVarArgs() {
        return this.getAccessFlagsObj().isVarArgs();
    }

    public boolean isNative() {
        return this.getAccessFlagsObj().isNative();
    }

    public boolean isAbstract() {
        return this.getAccessFlagsObj().isAbstract();
    }

    public boolean isStrict() {
        return this.getAccessFlagsObj().isStrict();
    }

    public boolean isSynthetic() {
        return this.getAccessFlagsObj().isSynthetic();
    }

    public boolean isConstructor() {
        return !this.isStatic() && this.getName().equals(Method.objectInitializerName());
    }

    public boolean isStaticInitializer() {
        return this.isStatic() && this.getName().equals(Method.classInitializerName());
    }

    public boolean isObsolete() {
        return this.getAccessFlagsObj().isObsolete();
    }

    public OopMapCacheEntry getMaskFor(int bci) {
        OopMapCacheEntry entry = new OopMapCacheEntry();
        entry.fill(this, bci);
        return entry;
    }

    public long getSize() {
        return this.getMethodSize();
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("Method " + this.getName().asString() + this.getSignature().asString() + "@" + this.getAddress());
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        visitor.doCInt(methodSize, true);
        visitor.doCInt(accessFlags, true);
    }

    public boolean hasLineNumberTable() {
        return this.getConstMethod().hasLineNumberTable();
    }

    public int getLineNumberFromBCI(int bci) {
        return this.getConstMethod().getLineNumberFromBCI(bci);
    }

    public LineNumberTableElement[] getLineNumberTable() {
        return this.getConstMethod().getLineNumberTable();
    }

    public boolean hasLocalVariableTable() {
        return this.getConstMethod().hasLocalVariableTable();
    }

    public LocalVariableTableElement[] getLocalVariableTable() {
        return this.getConstMethod().getLocalVariableTable();
    }

    public Symbol getLocalVariableName(int bci, int slot) {
        if (!this.hasLocalVariableTable()) {
            return null;
        }
        LocalVariableTableElement[] locals = this.getLocalVariableTable();
        for (int l = 0; l < locals.length; ++l) {
            LocalVariableTableElement local = locals[l];
            if (bci < local.getStartBCI() || bci >= local.getStartBCI() + local.getLength() || slot != local.getSlot()) continue;
            return this.getConstants().getSymbolAt(local.getNameCPIndex());
        }
        return null;
    }

    public boolean hasExceptionTable() {
        return this.getConstMethod().hasExceptionTable();
    }

    public ExceptionTableElement[] getExceptionTable() {
        return this.getConstMethod().getExceptionTable();
    }

    public boolean hasCheckedExceptions() {
        return this.getConstMethod().hasCheckedExceptions();
    }

    public CheckedExceptionElement[] getCheckedExceptions() {
        return this.getConstMethod().getCheckedExceptions();
    }

    public String externalNameAndSignature() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getMethodHolder().getName().asString());
        buf.append(".");
        buf.append(this.getName().asString());
        buf.append("(");
        new SignatureConverter(this.getSignature(), buf).iterateParameters();
        buf.append(")");
        return buf.toString().replace('/', '.');
    }

    @Override
    public void dumpReplayData(PrintStream out) {
        NMethod nm = this.getNativeMethod();
        int code_size = 0;
        if (nm != null) {
            code_size = (int)nm.codeEnd().minus(nm.getVerifiedEntryPoint());
        }
        InstanceKlass holder = this.getMethodHolder();
        out.println("ciMethod " + holder.getName().asString() + " " + OopUtilities.escapeString(this.getName().asString()) + " " + this.getSignature().asString() + " " + this.getInvocationCount() + " " + this.getBackedgeCount() + " " + this.interpreterInvocationCount() + " " + this.interpreterThrowoutCount() + " " + code_size);
    }

    public int interpreterThrowoutCount() {
        return this.getMethodCounters().interpreterThrowoutCount();
    }

    public int interpreterInvocationCount() {
        return this.getMethodCounters().interpreterInvocationCount();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Method.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

