/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CustomResourceSubresourceScaleApplyConfiguration represents a declarative configuration of the CustomResourceSubresourceScale type for use
// with apply.
//
// CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
type CustomResourceSubresourceScaleApplyConfiguration struct {
	// specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`.
	// Only JSON paths without the array notation are allowed.
	// Must be a JSON Path under `.spec`.
	// If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
	SpecReplicasPath *string `json:"specReplicasPath,omitempty"`
	// statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`.
	// Only JSON paths without the array notation are allowed.
	// Must be a JSON Path under `.status`.
	// If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource
	// will default to 0.
	StatusReplicasPath *string `json:"statusReplicasPath,omitempty"`
	// labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`.
	// Only JSON paths without the array notation are allowed.
	// Must be a JSON Path under `.status` or `.spec`.
	// Must be set to work with HorizontalPodAutoscaler.
	// The field pointed by this JSON path must be a string field (not a complex selector struct)
	// which contains a serialized label selector in string form.
	// More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource
	// If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale`
	// subresource will default to the empty string.
	LabelSelectorPath *string `json:"labelSelectorPath,omitempty"`
}

// CustomResourceSubresourceScaleApplyConfiguration constructs a declarative configuration of the CustomResourceSubresourceScale type for use with
// apply.
func CustomResourceSubresourceScale() *CustomResourceSubresourceScaleApplyConfiguration {
	return &CustomResourceSubresourceScaleApplyConfiguration{}
}

// WithSpecReplicasPath sets the SpecReplicasPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SpecReplicasPath field is set to the value of the last call.
func (b *CustomResourceSubresourceScaleApplyConfiguration) WithSpecReplicasPath(value string) *CustomResourceSubresourceScaleApplyConfiguration {
	b.SpecReplicasPath = &value
	return b
}

// WithStatusReplicasPath sets the StatusReplicasPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StatusReplicasPath field is set to the value of the last call.
func (b *CustomResourceSubresourceScaleApplyConfiguration) WithStatusReplicasPath(value string) *CustomResourceSubresourceScaleApplyConfiguration {
	b.StatusReplicasPath = &value
	return b
}

// WithLabelSelectorPath sets the LabelSelectorPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LabelSelectorPath field is set to the value of the last call.
func (b *CustomResourceSubresourceScaleApplyConfiguration) WithLabelSelectorPath(value string) *CustomResourceSubresourceScaleApplyConfiguration {
	b.LabelSelectorPath = &value
	return b
}
