#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include "../wmgeneral/wmgeneral.h"
#include "../wmgeneral/misc.h"
#include "master.xpm"

#define WMMON_VERSION "1.0smp"

char	*ProgName;
FILE	*fp_stat;
FILE	*fp_loadavg;
char	wmmon_mask_bits[64*64];
int	wmmon_mask_width = 64;
int	wmmon_mask_height = 64;

void usage(void);
void drawstat(int *, int, int, int, int);
void wmmon_routine(int, char **);

int main(int argc, char *argv[]) {
 int i;
 
 ProgName = argv[0];
 if (strlen(ProgName) >= 5)
 ProgName += (strlen(ProgName) - 5);
	
 for (i=1; i<argc; i++) {
  char *arg = argv[i];
  if (*arg=='-') {
   switch (arg[1]) {
    case 'd' :
     if (strcmp(arg+1, "display")) {
      usage();
      exit(1);
     }
     break;
    default:
     usage();
     exit(0);
    break;
   }
  }
 }
 wmmon_routine(argc, argv);
 return(0);
}

void wmmon_routine(int argc, char **argv) {
 unsigned long	j;
 long k=0;
 XEvent Event;
 int	i;
 char	temp[128];
 char	*p;
 char	*tokens = " \t\n";
 float	f;
 long loadavg = 0;
 long use[2];
 long idle[2];
 int his[55];
 int hisaddcnt;
 long uselast[2];
 long idlelast[2];

 fp_loadavg = fopen("/proc/loadavg", "r");
 fp_stat = fopen("/proc/stat", "r");

 for (j=0; j<55; j++) his[j] = 0;
 hisaddcnt = 0;

 createXBMfromXPM(wmmon_mask_bits, master_xpm, wmmon_mask_width, wmmon_mask_height);
 openXwindow(argc, argv, master_xpm, wmmon_mask_bits, wmmon_mask_width, wmmon_mask_height);
 drawstat(his, 54, 40, 5, 58);

 // main loop
 while (1) {
  uselast[0] = use[0];
  uselast[1] = use[1];
  idlelast[0] = idle[0];
  idlelast[1] = idle[1];
  fseek(fp_stat, 0, SEEK_SET); // goto beginning of file
  use[0]=0; use[1]=0; // clear used cpu
  idle[0]=0; idle[1]=0; // and idle
  while (fgets(temp, 128, fp_stat)) { // getting cpu usage
   if (strstr(temp, "cpu0")) {
    p = strtok(temp, tokens);
    for (i=0; i<3; i++) {
     p = strtok(NULL, tokens);
     use[0] += atol(p);
    }
    p = strtok(NULL, tokens);
    idle[0] = atol(p);
   }
   if (strstr(temp, "cpu1")) {
    p = strtok(temp, tokens);
    for (i=0; i<3; i++) {
     p = strtok(NULL, tokens);
     use[1] += atol(p);
    }
    p = strtok(NULL, tokens);
    idle[1] = atol(p);
   }
  } // end while, getting cpu usage

  copyXPMArea(0, 64, 32, 12, 28, 4);
  copyXPMArea(32, 64, use[0]-uselast[0], 6, 28, 4);
  copyXPMArea(32, 64, use[1]-uselast[1], 6, 28, 10);
  k++;

  if (k>20) {
   fp_loadavg = freopen("/proc/loadavg", "r", fp_loadavg);
   fscanf(fp_loadavg, "%f", &f);
   loadavg = (long) (100 * f); // loadavg
   his[54] += loadavg;
   hisaddcnt += 1;
   if (his[54]) his[54] /= hisaddcnt;
    for (j=1; j<55; j++) {
    his[j-1] = his[j];
   }
   drawstat(his, 54, 40, 5, 58);
   his[54] = 0;
   hisaddcnt = 0;
   k=0;
  }
  RedrawWindow();
  while (XPending(display)) {
   XNextEvent(display, &Event);
   switch (Event.type) {
   case Expose:
    RedrawWindow();
    break;
   case DestroyNotify:
    XCloseDisplay(display);
    exit(0);
    break;
   }
  }
  usleep(250000L);
 }
}

void drawstat(int *his, int num, int size, int x_left, int y_bottom) {
 int     pixels_per_byte;
 int     j,k;
 int     *p;
 int		d;
 
 pixels_per_byte = 100;
 p = his;
 for (j=0; j<num; j++) {
  if (p[0] > pixels_per_byte)
   pixels_per_byte += 100;
   p += 1;
  }
  p = his;
  
  for (k=0; k<num; k++) {
   d = (1.0 * p[0] / pixels_per_byte) * size;
   for (j=0; j<size; j++) {
    if (j < d - 3)
     copyXPMArea(2, 88, 1, 1, k+x_left, y_bottom-j);
    else if (j < d)
     copyXPMArea(2, 89, 1, 1, k+x_left, y_bottom-j);
    else
     copyXPMArea(2, 90, 1, 1, k+x_left, y_bottom-j);
    }
    p += 1;
   }
   for (j = pixels_per_byte-100; j > 0; j-=100) {
    for (k=0; k<num; k++) {
     d = (40.0 / pixels_per_byte) * j;
     copyXPMArea(2, 91, 1, 1, k+x_left, y_bottom-d);
    }
   }
}

void usage(void) {
 fprintf(stderr, "\nwmmon+smp - version 1.0, by timecop@linuxwarez.com\n\n");
 fprintf(stderr, "usage:\n");
 fprintf(stderr, "\t-display <display name>\n");
 fprintf(stderr, "\t-h\tthis screen\n");
 fprintf(stderr, "\n");
}
