// Copyright 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for RSA SSA (Signature Schemes with Appendix) using PKCS1-v1_5
// encoding (https://tools.ietf.org/html/rfc8017#section-8.2).

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.12.4
// source: third_party/tink/proto/rsa_ssa_pkcs1.proto

package rsa_ssa_pkcs1_go_proto

import (
	common_go_proto "github.com/google/tink/go/proto/common_go_proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RsaSsaPkcs1Params struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hash function used in computing hash of the signing message
	// (see https://tools.ietf.org/html/rfc8017#section-9.2).
	// Required.
	HashType common_go_proto.HashType `protobuf:"varint,1,opt,name=hash_type,json=hashType,proto3,enum=google.crypto.tink.HashType" json:"hash_type,omitempty"`
}

func (x *RsaSsaPkcs1Params) Reset() {
	*x = RsaSsaPkcs1Params{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPkcs1Params) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1Params) ProtoMessage() {}

func (x *RsaSsaPkcs1Params) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1Params.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1Params) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{0}
}

func (x *RsaSsaPkcs1Params) GetHashType() common_go_proto.HashType {
	if x != nil {
		return x.HashType
	}
	return common_go_proto.HashType(0)
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PublicKey
type RsaSsaPkcs1PublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params *RsaSsaPkcs1Params `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	// Modulus.
	// Unsigned big integer in bigendian representation.
	N []byte `protobuf:"bytes,3,opt,name=n,proto3" json:"n,omitempty"`
	// Public exponent.
	// Unsigned big integer in bigendian representation.
	E []byte `protobuf:"bytes,4,opt,name=e,proto3" json:"e,omitempty"`
}

func (x *RsaSsaPkcs1PublicKey) Reset() {
	*x = RsaSsaPkcs1PublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPkcs1PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1PublicKey) ProtoMessage() {}

func (x *RsaSsaPkcs1PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1PublicKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1PublicKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{1}
}

func (x *RsaSsaPkcs1PublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPkcs1PublicKey) GetParams() *RsaSsaPkcs1Params {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPkcs1PublicKey) GetN() []byte {
	if x != nil {
		return x.N
	}
	return nil
}

func (x *RsaSsaPkcs1PublicKey) GetE() []byte {
	if x != nil {
		return x.E
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.RsaSsaPkcs1PrivateKey
type RsaSsaPkcs1PrivateKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	PublicKey *RsaSsaPkcs1PublicKey `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Private exponent.
	// Unsigned big integer in bigendian representation.
	// Required.
	D []byte `protobuf:"bytes,3,opt,name=d,proto3" json:"d,omitempty"`
	// The following parameters are used to optimize RSA signature computation.
	// The prime factor p of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	P []byte `protobuf:"bytes,4,opt,name=p,proto3" json:"p,omitempty"`
	// The prime factor q of n.
	// Unsigned big integer in bigendian representation.
	// Required.
	Q []byte `protobuf:"bytes,5,opt,name=q,proto3" json:"q,omitempty"`
	// d mod (p - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dp []byte `protobuf:"bytes,6,opt,name=dp,proto3" json:"dp,omitempty"`
	// d mod (q - 1).
	// Unsigned big integer in bigendian representation.
	// Required.
	Dq []byte `protobuf:"bytes,7,opt,name=dq,proto3" json:"dq,omitempty"`
	// Chinese Remainder Theorem coefficient q^(-1) mod p.
	// Unsigned big integer in bigendian representation.
	// Required.
	Crt []byte `protobuf:"bytes,8,opt,name=crt,proto3" json:"crt,omitempty"`
}

func (x *RsaSsaPkcs1PrivateKey) Reset() {
	*x = RsaSsaPkcs1PrivateKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPkcs1PrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1PrivateKey) ProtoMessage() {}

func (x *RsaSsaPkcs1PrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1PrivateKey.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1PrivateKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{2}
}

func (x *RsaSsaPkcs1PrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *RsaSsaPkcs1PrivateKey) GetPublicKey() *RsaSsaPkcs1PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetD() []byte {
	if x != nil {
		return x.D
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetP() []byte {
	if x != nil {
		return x.P
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetQ() []byte {
	if x != nil {
		return x.Q
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetDp() []byte {
	if x != nil {
		return x.Dp
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetDq() []byte {
	if x != nil {
		return x.Dq
	}
	return nil
}

func (x *RsaSsaPkcs1PrivateKey) GetCrt() []byte {
	if x != nil {
		return x.Crt
	}
	return nil
}

type RsaSsaPkcs1KeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	Params *RsaSsaPkcs1Params `protobuf:"bytes,1,opt,name=params,proto3" json:"params,omitempty"`
	// Required.
	ModulusSizeInBits uint32 `protobuf:"varint,2,opt,name=modulus_size_in_bits,json=modulusSizeInBits,proto3" json:"modulus_size_in_bits,omitempty"`
	// Required.
	PublicExponent []byte `protobuf:"bytes,3,opt,name=public_exponent,json=publicExponent,proto3" json:"public_exponent,omitempty"`
}

func (x *RsaSsaPkcs1KeyFormat) Reset() {
	*x = RsaSsaPkcs1KeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RsaSsaPkcs1KeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RsaSsaPkcs1KeyFormat) ProtoMessage() {}

func (x *RsaSsaPkcs1KeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RsaSsaPkcs1KeyFormat.ProtoReflect.Descriptor instead.
func (*RsaSsaPkcs1KeyFormat) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescGZIP(), []int{3}
}

func (x *RsaSsaPkcs1KeyFormat) GetParams() *RsaSsaPkcs1Params {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *RsaSsaPkcs1KeyFormat) GetModulusSizeInBits() uint32 {
	if x != nil {
		return x.ModulusSizeInBits
	}
	return 0
}

func (x *RsaSsaPkcs1KeyFormat) GetPublicExponent() []byte {
	if x != nil {
		return x.PublicExponent
	}
	return nil
}

var File_third_party_tink_proto_rsa_ssa_pkcs1_proto protoreflect.FileDescriptor

var file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x73, 0x61, 0x5f, 0x73, 0x73, 0x61,
	0x5f, 0x70, 0x6b, 0x63, 0x73, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b,
	0x1a, 0x23, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4e, 0x0a, 0x11, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50,
	0x6b, 0x63, 0x73, 0x31, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x39, 0x0a, 0x09, 0x68, 0x61,
	0x73, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69,
	0x6e, 0x6b, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x68, 0x61, 0x73,
	0x68, 0x54, 0x79, 0x70, 0x65, 0x22, 0x8b, 0x01, 0x0a, 0x14, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61,
	0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x52, 0x73,
	0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x0c, 0x0a, 0x01, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x01, 0x6e, 0x12, 0x0c, 0x0a, 0x01, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x01, 0x65, 0x22, 0xd6, 0x01, 0x0a, 0x15, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x6b,
	0x63, 0x73, 0x31, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b,
	0x2e, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x12, 0x0c, 0x0a, 0x01, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x64, 0x12, 0x0c,
	0x0a, 0x01, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x70, 0x12, 0x0c, 0x0a, 0x01,
	0x71, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x01, 0x71, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x70,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x64, 0x70, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x71,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x02, 0x64, 0x71, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x72,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x63, 0x72, 0x74, 0x22, 0xaf, 0x01, 0x0a,
	0x14, 0x52, 0x73, 0x61, 0x53, 0x73, 0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x4b, 0x65, 0x79, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x52, 0x73, 0x61, 0x53, 0x73,
	0x61, 0x50, 0x6b, 0x63, 0x73, 0x31, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x75, 0x73, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x75, 0x73, 0x53, 0x69, 0x7a, 0x65, 0x49,
	0x6e, 0x42, 0x69, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x55,
	0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x69, 0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72,
	0x73, 0x61, 0x5f, 0x73, 0x73, 0x61, 0x5f, 0x70, 0x6b, 0x63, 0x73, 0x31, 0x5f, 0x67, 0x6f, 0x5f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescOnce sync.Once
	file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescData = file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDesc
)

func file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescGZIP() []byte {
	file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescOnce.Do(func() {
		file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescData = protoimpl.X.CompressGZIP(file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescData)
	})
	return file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDescData
}

var file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_third_party_tink_proto_rsa_ssa_pkcs1_proto_goTypes = []interface{}{
	(*RsaSsaPkcs1Params)(nil),     // 0: google.crypto.tink.RsaSsaPkcs1Params
	(*RsaSsaPkcs1PublicKey)(nil),  // 1: google.crypto.tink.RsaSsaPkcs1PublicKey
	(*RsaSsaPkcs1PrivateKey)(nil), // 2: google.crypto.tink.RsaSsaPkcs1PrivateKey
	(*RsaSsaPkcs1KeyFormat)(nil),  // 3: google.crypto.tink.RsaSsaPkcs1KeyFormat
	(common_go_proto.HashType)(0), // 4: google.crypto.tink.HashType
}
var file_third_party_tink_proto_rsa_ssa_pkcs1_proto_depIdxs = []int32{
	4, // 0: google.crypto.tink.RsaSsaPkcs1Params.hash_type:type_name -> google.crypto.tink.HashType
	0, // 1: google.crypto.tink.RsaSsaPkcs1PublicKey.params:type_name -> google.crypto.tink.RsaSsaPkcs1Params
	1, // 2: google.crypto.tink.RsaSsaPkcs1PrivateKey.public_key:type_name -> google.crypto.tink.RsaSsaPkcs1PublicKey
	0, // 3: google.crypto.tink.RsaSsaPkcs1KeyFormat.params:type_name -> google.crypto.tink.RsaSsaPkcs1Params
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_third_party_tink_proto_rsa_ssa_pkcs1_proto_init() }
func file_third_party_tink_proto_rsa_ssa_pkcs1_proto_init() {
	if File_third_party_tink_proto_rsa_ssa_pkcs1_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPkcs1Params); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPkcs1PublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPkcs1PrivateKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RsaSsaPkcs1KeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_third_party_tink_proto_rsa_ssa_pkcs1_proto_goTypes,
		DependencyIndexes: file_third_party_tink_proto_rsa_ssa_pkcs1_proto_depIdxs,
		MessageInfos:      file_third_party_tink_proto_rsa_ssa_pkcs1_proto_msgTypes,
	}.Build()
	File_third_party_tink_proto_rsa_ssa_pkcs1_proto = out.File
	file_third_party_tink_proto_rsa_ssa_pkcs1_proto_rawDesc = nil
	file_third_party_tink_proto_rsa_ssa_pkcs1_proto_goTypes = nil
	file_third_party_tink_proto_rsa_ssa_pkcs1_proto_depIdxs = nil
}
