package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodStreamURL invokes the vs.DescribeVodStreamURL API synchronously
func (client *Client) DescribeVodStreamURL(request *DescribeVodStreamURLRequest) (response *DescribeVodStreamURLResponse, err error) {
	response = CreateDescribeVodStreamURLResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodStreamURLWithChan invokes the vs.DescribeVodStreamURL API asynchronously
func (client *Client) DescribeVodStreamURLWithChan(request *DescribeVodStreamURLRequest) (<-chan *DescribeVodStreamURLResponse, <-chan error) {
	responseChan := make(chan *DescribeVodStreamURLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodStreamURL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodStreamURLWithCallback invokes the vs.DescribeVodStreamURL API asynchronously
func (client *Client) DescribeVodStreamURLWithCallback(request *DescribeVodStreamURLRequest, callback func(response *DescribeVodStreamURLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodStreamURLResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodStreamURL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodStreamURLRequest is the request struct for api DescribeVodStreamURL
type DescribeVodStreamURLRequest struct {
	*requests.RpcRequest
	ShowLog string           `position:"Query" name:"ShowLog"`
	TxId    string           `position:"Query" name:"TxId"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Url     string           `position:"Query" name:"Url"`
}

// DescribeVodStreamURLResponse is the response struct for api DescribeVodStreamURL
type DescribeVodStreamURLResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Url         string `json:"Url" xml:"Url"`
	OutProtocol string `json:"OutProtocol" xml:"OutProtocol"`
	Port        int64  `json:"Port" xml:"Port"`
	TxId        string `json:"TxId" xml:"TxId"`
}

// CreateDescribeVodStreamURLRequest creates a request to invoke DescribeVodStreamURL API
func CreateDescribeVodStreamURLRequest() (request *DescribeVodStreamURLRequest) {
	request = &DescribeVodStreamURLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVodStreamURL", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVodStreamURLResponse creates a response to parse from DescribeVodStreamURL response
func CreateDescribeVodStreamURLResponse() (response *DescribeVodStreamURLResponse) {
	response = &DescribeVodStreamURLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
