package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReduceApplicationCapacityByInstanceIds invokes the sae.ReduceApplicationCapacityByInstanceIds API synchronously
func (client *Client) ReduceApplicationCapacityByInstanceIds(request *ReduceApplicationCapacityByInstanceIdsRequest) (response *ReduceApplicationCapacityByInstanceIdsResponse, err error) {
	response = CreateReduceApplicationCapacityByInstanceIdsResponse()
	err = client.DoAction(request, response)
	return
}

// ReduceApplicationCapacityByInstanceIdsWithChan invokes the sae.ReduceApplicationCapacityByInstanceIds API asynchronously
func (client *Client) ReduceApplicationCapacityByInstanceIdsWithChan(request *ReduceApplicationCapacityByInstanceIdsRequest) (<-chan *ReduceApplicationCapacityByInstanceIdsResponse, <-chan error) {
	responseChan := make(chan *ReduceApplicationCapacityByInstanceIdsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReduceApplicationCapacityByInstanceIds(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReduceApplicationCapacityByInstanceIdsWithCallback invokes the sae.ReduceApplicationCapacityByInstanceIds API asynchronously
func (client *Client) ReduceApplicationCapacityByInstanceIdsWithCallback(request *ReduceApplicationCapacityByInstanceIdsRequest, callback func(response *ReduceApplicationCapacityByInstanceIdsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReduceApplicationCapacityByInstanceIdsResponse
		var err error
		defer close(result)
		response, err = client.ReduceApplicationCapacityByInstanceIds(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReduceApplicationCapacityByInstanceIdsRequest is the request struct for api ReduceApplicationCapacityByInstanceIds
type ReduceApplicationCapacityByInstanceIdsRequest struct {
	*requests.RoaRequest
	InstanceIds string `position:"Query" name:"InstanceIds"`
	AppId       string `position:"Query" name:"AppId"`
}

// ReduceApplicationCapacityByInstanceIdsResponse is the response struct for api ReduceApplicationCapacityByInstanceIds
type ReduceApplicationCapacityByInstanceIdsResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateReduceApplicationCapacityByInstanceIdsRequest creates a request to invoke ReduceApplicationCapacityByInstanceIds API
func CreateReduceApplicationCapacityByInstanceIdsRequest() (request *ReduceApplicationCapacityByInstanceIdsRequest) {
	request = &ReduceApplicationCapacityByInstanceIdsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "ReduceApplicationCapacityByInstanceIds", "/pop/v1/sam/app/ScaleInApplicationWithInstanceIds", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateReduceApplicationCapacityByInstanceIdsResponse creates a response to parse from ReduceApplicationCapacityByInstanceIds response
func CreateReduceApplicationCapacityByInstanceIdsResponse() (response *ReduceApplicationCapacityByInstanceIdsResponse) {
	response = &ReduceApplicationCapacityByInstanceIdsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
