package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPolicyVersion invokes the ram.GetPolicyVersion API synchronously
// api document: https://help.aliyun.com/api/ram/getpolicyversion.html
func (client *Client) GetPolicyVersion(request *GetPolicyVersionRequest) (response *GetPolicyVersionResponse, err error) {
	response = CreateGetPolicyVersionResponse()
	err = client.DoAction(request, response)
	return
}

// GetPolicyVersionWithChan invokes the ram.GetPolicyVersion API asynchronously
// api document: https://help.aliyun.com/api/ram/getpolicyversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPolicyVersionWithChan(request *GetPolicyVersionRequest) (<-chan *GetPolicyVersionResponse, <-chan error) {
	responseChan := make(chan *GetPolicyVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPolicyVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPolicyVersionWithCallback invokes the ram.GetPolicyVersion API asynchronously
// api document: https://help.aliyun.com/api/ram/getpolicyversion.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPolicyVersionWithCallback(request *GetPolicyVersionRequest, callback func(response *GetPolicyVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPolicyVersionResponse
		var err error
		defer close(result)
		response, err = client.GetPolicyVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPolicyVersionRequest is the request struct for api GetPolicyVersion
type GetPolicyVersionRequest struct {
	*requests.RpcRequest
	PolicyType string `position:"Query" name:"PolicyType"`
	VersionId  string `position:"Query" name:"VersionId"`
	PolicyName string `position:"Query" name:"PolicyName"`
}

// GetPolicyVersionResponse is the response struct for api GetPolicyVersion
type GetPolicyVersionResponse struct {
	*responses.BaseResponse
	RequestId     string                          `json:"RequestId" xml:"RequestId"`
	PolicyVersion PolicyVersionInGetPolicyVersion `json:"PolicyVersion" xml:"PolicyVersion"`
}

// CreateGetPolicyVersionRequest creates a request to invoke GetPolicyVersion API
func CreateGetPolicyVersionRequest() (request *GetPolicyVersionRequest) {
	request = &GetPolicyVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "GetPolicyVersion", "Ram", "openAPI")
	return
}

// CreateGetPolicyVersionResponse creates a response to parse from GetPolicyVersion response
func CreateGetPolicyVersionResponse() (response *GetPolicyVersionResponse) {
	response = &GetPolicyVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
