package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryThingModelPublished invokes the iot.QueryThingModelPublished API synchronously
func (client *Client) QueryThingModelPublished(request *QueryThingModelPublishedRequest) (response *QueryThingModelPublishedResponse, err error) {
	response = CreateQueryThingModelPublishedResponse()
	err = client.DoAction(request, response)
	return
}

// QueryThingModelPublishedWithChan invokes the iot.QueryThingModelPublished API asynchronously
func (client *Client) QueryThingModelPublishedWithChan(request *QueryThingModelPublishedRequest) (<-chan *QueryThingModelPublishedResponse, <-chan error) {
	responseChan := make(chan *QueryThingModelPublishedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryThingModelPublished(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryThingModelPublishedWithCallback invokes the iot.QueryThingModelPublished API asynchronously
func (client *Client) QueryThingModelPublishedWithCallback(request *QueryThingModelPublishedRequest, callback func(response *QueryThingModelPublishedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryThingModelPublishedResponse
		var err error
		defer close(result)
		response, err = client.QueryThingModelPublished(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryThingModelPublishedRequest is the request struct for api QueryThingModelPublished
type QueryThingModelPublishedRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	ResourceGroupId   string `position:"Query" name:"ResourceGroupId"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	ModelVersion      string `position:"Query" name:"ModelVersion"`
	FunctionBlockId   string `position:"Query" name:"FunctionBlockId"`
}

// QueryThingModelPublishedResponse is the response struct for api QueryThingModelPublished
type QueryThingModelPublishedResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ProductKey   string `json:"ProductKey" xml:"ProductKey"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryThingModelPublishedRequest creates a request to invoke QueryThingModelPublished API
func CreateQueryThingModelPublishedRequest() (request *QueryThingModelPublishedRequest) {
	request = &QueryThingModelPublishedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryThingModelPublished", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryThingModelPublishedResponse creates a response to parse from QueryThingModelPublished response
func CreateQueryThingModelPublishedResponse() (response *QueryThingModelPublishedResponse) {
	response = &QueryThingModelPublishedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
