package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceFile invokes the iot.QueryDeviceFile API synchronously
func (client *Client) QueryDeviceFile(request *QueryDeviceFileRequest) (response *QueryDeviceFileResponse, err error) {
	response = CreateQueryDeviceFileResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceFileWithChan invokes the iot.QueryDeviceFile API asynchronously
func (client *Client) QueryDeviceFileWithChan(request *QueryDeviceFileRequest) (<-chan *QueryDeviceFileResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceFileWithCallback invokes the iot.QueryDeviceFile API asynchronously
func (client *Client) QueryDeviceFileWithCallback(request *QueryDeviceFileRequest, callback func(response *QueryDeviceFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceFileResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceFileRequest is the request struct for api QueryDeviceFile
type QueryDeviceFileRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	FileId        string `position:"Query" name:"FileId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// QueryDeviceFileResponse is the response struct for api QueryDeviceFile
type QueryDeviceFileResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryDeviceFileRequest creates a request to invoke QueryDeviceFile API
func CreateQueryDeviceFileRequest() (request *QueryDeviceFileRequest) {
	request = &QueryDeviceFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceFile", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceFileResponse creates a response to parse from QueryDeviceFile response
func CreateQueryDeviceFileResponse() (response *QueryDeviceFileResponse) {
	response = &QueryDeviceFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
