package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserPermissions invokes the dms_enterprise.ListUserPermissions API synchronously
func (client *Client) ListUserPermissions(request *ListUserPermissionsRequest) (response *ListUserPermissionsResponse, err error) {
	response = CreateListUserPermissionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserPermissionsWithChan invokes the dms_enterprise.ListUserPermissions API asynchronously
func (client *Client) ListUserPermissionsWithChan(request *ListUserPermissionsRequest) (<-chan *ListUserPermissionsResponse, <-chan error) {
	responseChan := make(chan *ListUserPermissionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserPermissions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserPermissionsWithCallback invokes the dms_enterprise.ListUserPermissions API asynchronously
func (client *Client) ListUserPermissionsWithCallback(request *ListUserPermissionsRequest, callback func(response *ListUserPermissionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserPermissionsResponse
		var err error
		defer close(result)
		response, err = client.ListUserPermissions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserPermissionsRequest is the request struct for api ListUserPermissions
type ListUserPermissionsRequest struct {
	*requests.RpcRequest
	SearchKey    string           `position:"Query" name:"SearchKey"`
	UserId       string           `position:"Query" name:"UserId"`
	Tid          requests.Integer `position:"Query" name:"Tid"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PermType     string           `position:"Query" name:"PermType"`
	DatabaseName string           `position:"Query" name:"DatabaseName"`
	EnvType      string           `position:"Query" name:"EnvType"`
	DbType       string           `position:"Query" name:"DbType"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Logic        requests.Boolean `position:"Query" name:"Logic"`
}

// ListUserPermissionsResponse is the response struct for api ListUserPermissions
type ListUserPermissionsResponse struct {
	*responses.BaseResponse
	TotalCount      int64                                `json:"TotalCount" xml:"TotalCount"`
	RequestId       string                               `json:"RequestId" xml:"RequestId"`
	ErrorCode       string                               `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage    string                               `json:"ErrorMessage" xml:"ErrorMessage"`
	Success         bool                                 `json:"Success" xml:"Success"`
	UserPermissions UserPermissionsInListUserPermissions `json:"UserPermissions" xml:"UserPermissions"`
}

// CreateListUserPermissionsRequest creates a request to invoke ListUserPermissions API
func CreateListUserPermissionsRequest() (request *ListUserPermissionsRequest) {
	request = &ListUserPermissionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListUserPermissions", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListUserPermissionsResponse creates a response to parse from ListUserPermissions response
func CreateListUserPermissionsResponse() (response *ListUserPermissionsResponse) {
	response = &ListUserPermissionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
