package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetCdnDomainStagingConfig invokes the cdn.SetCdnDomainStagingConfig API synchronously
func (client *Client) SetCdnDomainStagingConfig(request *SetCdnDomainStagingConfigRequest) (response *SetCdnDomainStagingConfigResponse, err error) {
	response = CreateSetCdnDomainStagingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetCdnDomainStagingConfigWithChan invokes the cdn.SetCdnDomainStagingConfig API asynchronously
func (client *Client) SetCdnDomainStagingConfigWithChan(request *SetCdnDomainStagingConfigRequest) (<-chan *SetCdnDomainStagingConfigResponse, <-chan error) {
	responseChan := make(chan *SetCdnDomainStagingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetCdnDomainStagingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetCdnDomainStagingConfigWithCallback invokes the cdn.SetCdnDomainStagingConfig API asynchronously
func (client *Client) SetCdnDomainStagingConfigWithCallback(request *SetCdnDomainStagingConfigRequest, callback func(response *SetCdnDomainStagingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetCdnDomainStagingConfigResponse
		var err error
		defer close(result)
		response, err = client.SetCdnDomainStagingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetCdnDomainStagingConfigRequest is the request struct for api SetCdnDomainStagingConfig
type SetCdnDomainStagingConfigRequest struct {
	*requests.RpcRequest
	Functions  string           `position:"Query" name:"Functions"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// SetCdnDomainStagingConfigResponse is the response struct for api SetCdnDomainStagingConfig
type SetCdnDomainStagingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetCdnDomainStagingConfigRequest creates a request to invoke SetCdnDomainStagingConfig API
func CreateSetCdnDomainStagingConfigRequest() (request *SetCdnDomainStagingConfigRequest) {
	request = &SetCdnDomainStagingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "SetCdnDomainStagingConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateSetCdnDomainStagingConfigResponse creates a response to parse from SetCdnDomainStagingConfig response
func CreateSetCdnDomainStagingConfigResponse() (response *SetCdnDomainStagingConfigResponse) {
	response = &SetCdnDomainStagingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
