package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTransitRouter invokes the cbn.CreateTransitRouter API synchronously
func (client *Client) CreateTransitRouter(request *CreateTransitRouterRequest) (response *CreateTransitRouterResponse, err error) {
	response = CreateCreateTransitRouterResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTransitRouterWithChan invokes the cbn.CreateTransitRouter API asynchronously
func (client *Client) CreateTransitRouterWithChan(request *CreateTransitRouterRequest) (<-chan *CreateTransitRouterResponse, <-chan error) {
	responseChan := make(chan *CreateTransitRouterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTransitRouter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTransitRouterWithCallback invokes the cbn.CreateTransitRouter API asynchronously
func (client *Client) CreateTransitRouterWithCallback(request *CreateTransitRouterRequest, callback func(response *CreateTransitRouterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTransitRouterResponse
		var err error
		defer close(result)
		response, err = client.CreateTransitRouter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTransitRouterRequest is the request struct for api CreateTransitRouter
type CreateTransitRouterRequest struct {
	*requests.RpcRequest
	TransitRouterName        string           `position:"Query" name:"TransitRouterName"`
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceMode              string           `position:"Query" name:"ServiceMode"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	CenId                    string           `position:"Query" name:"CenId"`
	Type                     string           `position:"Query" name:"Type"`
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount     string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount             string           `position:"Query" name:"OwnerAccount"`
	OwnerId                  requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterDescription string           `position:"Query" name:"TransitRouterDescription"`
}

// CreateTransitRouterResponse is the response struct for api CreateTransitRouter
type CreateTransitRouterResponse struct {
	*responses.BaseResponse
	TransitRouterId string `json:"TransitRouterId" xml:"TransitRouterId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTransitRouterRequest creates a request to invoke CreateTransitRouter API
func CreateCreateTransitRouterRequest() (request *CreateTransitRouterRequest) {
	request = &CreateTransitRouterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "CreateTransitRouter", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTransitRouterResponse creates a response to parse from CreateTransitRouter response
func CreateCreateTransitRouterResponse() (response *CreateTransitRouterResponse) {
	response = &CreateTransitRouterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
