package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateConfigName invokes the afs.UpdateConfigName API synchronously
// api document: https://help.aliyun.com/api/afs/updateconfigname.html
func (client *Client) UpdateConfigName(request *UpdateConfigNameRequest) (response *UpdateConfigNameResponse, err error) {
	response = CreateUpdateConfigNameResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateConfigNameWithChan invokes the afs.UpdateConfigName API asynchronously
// api document: https://help.aliyun.com/api/afs/updateconfigname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateConfigNameWithChan(request *UpdateConfigNameRequest) (<-chan *UpdateConfigNameResponse, <-chan error) {
	responseChan := make(chan *UpdateConfigNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateConfigName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateConfigNameWithCallback invokes the afs.UpdateConfigName API asynchronously
// api document: https://help.aliyun.com/api/afs/updateconfigname.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateConfigNameWithCallback(request *UpdateConfigNameRequest, callback func(response *UpdateConfigNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateConfigNameResponse
		var err error
		defer close(result)
		response, err = client.UpdateConfigName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateConfigNameRequest is the request struct for api UpdateConfigName
type UpdateConfigNameRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	ConfigName string `position:"Query" name:"ConfigName"`
	RefExtId   string `position:"Query" name:"RefExtId"`
	Lang       string `position:"Query" name:"Lang"`
}

// UpdateConfigNameResponse is the response struct for api UpdateConfigName
type UpdateConfigNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	BizCode   string `json:"BizCode" xml:"BizCode"`
}

// CreateUpdateConfigNameRequest creates a request to invoke UpdateConfigName API
func CreateUpdateConfigNameRequest() (request *UpdateConfigNameRequest) {
	request = &UpdateConfigNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "UpdateConfigName", "afs", "openAPI")
	return
}

// CreateUpdateConfigNameResponse creates a response to parse from UpdateConfigName response
func CreateUpdateConfigNameResponse() (response *UpdateConfigNameResponse) {
	response = &UpdateConfigNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
