package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExtractName invokes the address_purification.ExtractName API synchronously
func (client *Client) ExtractName(request *ExtractNameRequest) (response *ExtractNameResponse, err error) {
	response = CreateExtractNameResponse()
	err = client.DoAction(request, response)
	return
}

// ExtractNameWithChan invokes the address_purification.ExtractName API asynchronously
func (client *Client) ExtractNameWithChan(request *ExtractNameRequest) (<-chan *ExtractNameResponse, <-chan error) {
	responseChan := make(chan *ExtractNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExtractName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExtractNameWithCallback invokes the address_purification.ExtractName API asynchronously
func (client *Client) ExtractNameWithCallback(request *ExtractNameRequest, callback func(response *ExtractNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExtractNameResponse
		var err error
		defer close(result)
		response, err = client.ExtractName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExtractNameRequest is the request struct for api ExtractName
type ExtractNameRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// ExtractNameResponse is the response struct for api ExtractName
type ExtractNameResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateExtractNameRequest creates a request to invoke ExtractName API
func CreateExtractNameRequest() (request *ExtractNameRequest) {
	request = &ExtractNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "ExtractName", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExtractNameResponse creates a response to parse from ExtractName response
func CreateExtractNameResponse() (response *ExtractNameResponse) {
	response = &ExtractNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
