"""
This file adds a new Build->Compile current with -gnatR menu.

Selecting an opened source editor, and then clicking on this menu, will
output the layout of all the records in the current file, by recompiling
the file with -gnatR.
"""



import GPS

XML = r"""<?xml version="1.0" ?>
<gnatr>
   <action name="View types layout in file" output="none" category="Builder" >
      <external>gnatmake -f -gnatc -P%pp -gnatR -u %F</external>
      <shell>base_name "%F"</shell>
      <shell>dump_file "%2" "type_layout_%1"</shell>
      <shell>Editor.edit "%1"</shell>
      <shell>Editor.set_title "%2" "Type layout in %3"</shell>
      <shell>Editor.set_writable "%3" FALSE</shell>
      <shell>delete "%4"</shell>
      <filter id="Source editor" />
   </action>

   <Submenu>
      <Title>Build</Title>
      <menu action="View types layout in file">
         <Title>View types layout in file</Title>
      </menu>
   </Submenu>
</gnatr>
"""

GPS.parse_xml(XML)
