/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicate;

public class CodepointsToString
extends SystemFunctionCall
implements Callable {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        XPathContext context = visitor.getStaticContext().makeEarlyEvaluationContext();
        return new StringLiteral(CodepointsToString.unicodeToString(((Literal)this.argument[0]).iterate(), context.getConfiguration().getValidCharacterChecker()), this.getContainer());
    }

    public StringValue evaluateItem(XPathContext c) throws XPathException {
        return StringValue.makeStringValue(CodepointsToString.unicodeToString(this.argument[0].iterate(c), c.getConfiguration().getValidCharacterChecker()));
    }

    public static CharSequence unicodeToString(SequenceIterator chars, IntPredicate checker) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(64);
        NumericValue nextInt;
        while ((nextInt = (NumericValue)chars.next()) != null) {
            long next = nextInt.longValue();
            if (next < 0L || next > Integer.MAX_VALUE || !checker.matches((int)next)) {
                throw new XPathException("Invalid XML character [x " + Integer.toHexString((int)next) + ']', "FOCH0001");
            }
            sb.appendWideChar((int)next);
        }
        return sb.condense();
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator chars = arguments[0].iterate();
        return new StringValue(CodepointsToString.unicodeToString(chars, context.getConfiguration().getValidCharacterChecker()));
    }
}

