package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncDeviceChannels invokes the vs.SyncDeviceChannels API synchronously
func (client *Client) SyncDeviceChannels(request *SyncDeviceChannelsRequest) (response *SyncDeviceChannelsResponse, err error) {
	response = CreateSyncDeviceChannelsResponse()
	err = client.DoAction(request, response)
	return
}

// SyncDeviceChannelsWithChan invokes the vs.SyncDeviceChannels API asynchronously
func (client *Client) SyncDeviceChannelsWithChan(request *SyncDeviceChannelsRequest) (<-chan *SyncDeviceChannelsResponse, <-chan error) {
	responseChan := make(chan *SyncDeviceChannelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncDeviceChannels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncDeviceChannelsWithCallback invokes the vs.SyncDeviceChannels API asynchronously
func (client *Client) SyncDeviceChannelsWithCallback(request *SyncDeviceChannelsRequest, callback func(response *SyncDeviceChannelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncDeviceChannelsResponse
		var err error
		defer close(result)
		response, err = client.SyncDeviceChannels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncDeviceChannelsRequest is the request struct for api SyncDeviceChannels
type SyncDeviceChannelsRequest struct {
	*requests.RpcRequest
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId string           `position:"Query" name:"DeviceId"`
}

// SyncDeviceChannelsResponse is the response struct for api SyncDeviceChannels
type SyncDeviceChannelsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateSyncDeviceChannelsRequest creates a request to invoke SyncDeviceChannels API
func CreateSyncDeviceChannelsRequest() (request *SyncDeviceChannelsRequest) {
	request = &SyncDeviceChannelsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "SyncDeviceChannels", "", "")
	request.Method = requests.POST
	return
}

// CreateSyncDeviceChannelsResponse creates a response to parse from SyncDeviceChannels response
func CreateSyncDeviceChannelsResponse() (response *SyncDeviceChannelsResponse) {
	response = &SyncDeviceChannelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
