package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSkillGroup invokes the scsp.UpdateSkillGroup API synchronously
func (client *Client) UpdateSkillGroup(request *UpdateSkillGroupRequest) (response *UpdateSkillGroupResponse, err error) {
	response = CreateUpdateSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSkillGroupWithChan invokes the scsp.UpdateSkillGroup API asynchronously
func (client *Client) UpdateSkillGroupWithChan(request *UpdateSkillGroupRequest) (<-chan *UpdateSkillGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSkillGroupWithCallback invokes the scsp.UpdateSkillGroup API asynchronously
func (client *Client) UpdateSkillGroupWithCallback(request *UpdateSkillGroupRequest, callback func(response *UpdateSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSkillGroupRequest is the request struct for api UpdateSkillGroup
type UpdateSkillGroupRequest struct {
	*requests.RpcRequest
	InstanceId     string           `position:"Query"`
	ClientToken    string           `position:"Query"`
	SkillGroupId   requests.Integer `position:"Query"`
	DisplayName    string           `position:"Query"`
	ChannelType    requests.Integer `position:"Query"`
	SkillGroupName string           `position:"Query"`
	Description    string           `position:"Query"`
}

// UpdateSkillGroupResponse is the response struct for api UpdateSkillGroup
type UpdateSkillGroupResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUpdateSkillGroupRequest creates a request to invoke UpdateSkillGroup API
func CreateUpdateSkillGroupRequest() (request *UpdateSkillGroupRequest) {
	request = &UpdateSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "UpdateSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSkillGroupResponse creates a response to parse from UpdateSkillGroup response
func CreateUpdateSkillGroupResponse() (response *UpdateSkillGroupResponse) {
	response = &UpdateSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
