package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNodeGroupTransferPackets invokes the linkwan.ListNodeGroupTransferPackets API synchronously
func (client *Client) ListNodeGroupTransferPackets(request *ListNodeGroupTransferPacketsRequest) (response *ListNodeGroupTransferPacketsResponse, err error) {
	response = CreateListNodeGroupTransferPacketsResponse()
	err = client.DoAction(request, response)
	return
}

// ListNodeGroupTransferPacketsWithChan invokes the linkwan.ListNodeGroupTransferPackets API asynchronously
func (client *Client) ListNodeGroupTransferPacketsWithChan(request *ListNodeGroupTransferPacketsRequest) (<-chan *ListNodeGroupTransferPacketsResponse, <-chan error) {
	responseChan := make(chan *ListNodeGroupTransferPacketsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNodeGroupTransferPackets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNodeGroupTransferPacketsWithCallback invokes the linkwan.ListNodeGroupTransferPackets API asynchronously
func (client *Client) ListNodeGroupTransferPacketsWithCallback(request *ListNodeGroupTransferPacketsRequest, callback func(response *ListNodeGroupTransferPacketsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNodeGroupTransferPacketsResponse
		var err error
		defer close(result)
		response, err = client.ListNodeGroupTransferPackets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNodeGroupTransferPacketsRequest is the request struct for api ListNodeGroupTransferPackets
type ListNodeGroupTransferPacketsRequest struct {
	*requests.RpcRequest
	EndMillis     requests.Integer `position:"Query" name:"EndMillis"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Ascending     requests.Boolean `position:"Query" name:"Ascending"`
	DevEui        string           `position:"Query" name:"DevEui"`
	NodeGroupId   string           `position:"Query" name:"NodeGroupId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	Category      string           `position:"Query" name:"Category"`
	BeginMillis   requests.Integer `position:"Query" name:"BeginMillis"`
	SortingField  string           `position:"Query" name:"SortingField"`
}

// ListNodeGroupTransferPacketsResponse is the response struct for api ListNodeGroupTransferPackets
type ListNodeGroupTransferPacketsResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	Success   bool                               `json:"Success" xml:"Success"`
	Data      DataInListNodeGroupTransferPackets `json:"Data" xml:"Data"`
}

// CreateListNodeGroupTransferPacketsRequest creates a request to invoke ListNodeGroupTransferPackets API
func CreateListNodeGroupTransferPacketsRequest() (request *ListNodeGroupTransferPacketsRequest) {
	request = &ListNodeGroupTransferPacketsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListNodeGroupTransferPackets", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListNodeGroupTransferPacketsResponse creates a response to parse from ListNodeGroupTransferPackets response
func CreateListNodeGroupTransferPacketsResponse() (response *ListNodeGroupTransferPacketsResponse) {
	response = &ListNodeGroupTransferPacketsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
