package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePickUpWaybill invokes the dyplsapi.CreatePickUpWaybill API synchronously
func (client *Client) CreatePickUpWaybill(request *CreatePickUpWaybillRequest) (response *CreatePickUpWaybillResponse, err error) {
	response = CreateCreatePickUpWaybillResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePickUpWaybillWithChan invokes the dyplsapi.CreatePickUpWaybill API asynchronously
func (client *Client) CreatePickUpWaybillWithChan(request *CreatePickUpWaybillRequest) (<-chan *CreatePickUpWaybillResponse, <-chan error) {
	responseChan := make(chan *CreatePickUpWaybillResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePickUpWaybill(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePickUpWaybillWithCallback invokes the dyplsapi.CreatePickUpWaybill API asynchronously
func (client *Client) CreatePickUpWaybillWithCallback(request *CreatePickUpWaybillRequest, callback func(response *CreatePickUpWaybillResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePickUpWaybillResponse
		var err error
		defer close(result)
		response, err = client.CreatePickUpWaybill(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePickUpWaybillRequest is the request struct for api CreatePickUpWaybill
type CreatePickUpWaybillRequest struct {
	*requests.RpcRequest
	ConsigneeName    string                              `position:"Query" name:"ConsigneeName"`
	OrderChannels    string                              `position:"Query" name:"OrderChannels"`
	SendAddress      CreatePickUpWaybillSendAddress      `position:"Query" name:"SendAddress"  type:"Struct"`
	OuterOrderCode   string                              `position:"Query" name:"OuterOrderCode"`
	Remark           string                              `position:"Query" name:"Remark"`
	CpCode           string                              `position:"Query" name:"CpCode"`
	SendMobile       string                              `position:"Query" name:"SendMobile"`
	ConsigneeMobile  string                              `position:"Query" name:"ConsigneeMobile"`
	ContentType      string                              `position:"Header" name:"Content-Type"`
	ConsigneeAddress CreatePickUpWaybillConsigneeAddress `position:"Query" name:"ConsigneeAddress"  type:"Struct"`
	SendPhone        string                              `position:"Query" name:"SendPhone"`
	GoodsInfos       *[]CreatePickUpWaybillGoodsInfos    `position:"Query" name:"GoodsInfos"  type:"Json"`
	SendName         string                              `position:"Query" name:"SendName"`
	ConsigneePhone   string                              `position:"Query" name:"ConsigneePhone"`
}

// CreatePickUpWaybillGoodsInfos is a repeated param struct in CreatePickUpWaybillRequest
type CreatePickUpWaybillGoodsInfos struct {
	Name     string `name:"Name"`
	Weight   string `name:"Weight"`
	Quantity string `name:"Quantity"`
}

// CreatePickUpWaybillSendAddress is a repeated param struct in CreatePickUpWaybillRequest
type CreatePickUpWaybillSendAddress struct {
	ProvinceName  string `name:"ProvinceName"`
	CityName      string `name:"CityName"`
	AreaName      string `name:"AreaName"`
	TownName      string `name:"TownName"`
	AddressDetail string `name:"AddressDetail"`
}

// CreatePickUpWaybillConsigneeAddress is a repeated param struct in CreatePickUpWaybillRequest
type CreatePickUpWaybillConsigneeAddress struct {
	ProvinceName  string `name:"ProvinceName"`
	CityName      string `name:"CityName"`
	AreaName      string `name:"AreaName"`
	TownName      string `name:"TownName"`
	AddressDetail string `name:"AddressDetail"`
}

// CreatePickUpWaybillResponse is the response struct for api CreatePickUpWaybill
type CreatePickUpWaybillResponse struct {
	*responses.BaseResponse
	RequestId      string                    `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int                       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                    `json:"Message" xml:"Message"`
	Data           DataInCreatePickUpWaybill `json:"Data" xml:"Data"`
}

// CreateCreatePickUpWaybillRequest creates a request to invoke CreatePickUpWaybill API
func CreateCreatePickUpWaybillRequest() (request *CreatePickUpWaybillRequest) {
	request = &CreatePickUpWaybillRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "CreatePickUpWaybill", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePickUpWaybillResponse creates a response to parse from CreatePickUpWaybill response
func CreateCreatePickUpWaybillResponse() (response *CreatePickUpWaybillResponse) {
	response = &CreatePickUpWaybillResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
