package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DatabaseColumnsClient is the the Azure SQL Database management API provides a RESTful set of web services that
// interact with Azure SQL Database services to manage your databases. The API enables you to create, retrieve, update,
// and delete databases.
type DatabaseColumnsClient struct {
	BaseClient
}

// NewDatabaseColumnsClient creates an instance of the DatabaseColumnsClient client.
func NewDatabaseColumnsClient(subscriptionID string) DatabaseColumnsClient {
	return NewDatabaseColumnsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDatabaseColumnsClientWithBaseURI creates an instance of the DatabaseColumnsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDatabaseColumnsClientWithBaseURI(baseURI string, subscriptionID string) DatabaseColumnsClient {
	return DatabaseColumnsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get database column
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// schemaName - the name of the schema.
// tableName - the name of the table.
// columnName - the name of the column.
func (client DatabaseColumnsClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result DatabaseColumn, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, databaseName, schemaName, tableName, columnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DatabaseColumnsClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"columnName":        autorest.Encode("path", columnName),
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"schemaName":        autorest.Encode("path", schemaName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseColumnsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DatabaseColumnsClient) GetResponder(resp *http.Response) (result DatabaseColumn, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByDatabase list database columns
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// skiptoken - an opaque token that identifies a starting point in the collection.
func (client DatabaseColumnsClient) ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (result DatabaseColumnListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnsClient.ListByDatabase")
		defer func() {
			sc := -1
			if result.dclr.Response.Response != nil {
				sc = result.dclr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByDatabaseNextResults
	req, err := client.ListByDatabasePreparer(ctx, resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "ListByDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDatabaseSender(req)
	if err != nil {
		result.dclr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "ListByDatabase", resp, "Failure sending request")
		return
	}

	result.dclr, err = client.ListByDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "ListByDatabase", resp, "Failure responding to request")
		return
	}
	if result.dclr.hasNextLink() && result.dclr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByDatabasePreparer prepares the ListByDatabase request.
func (client DatabaseColumnsClient) ListByDatabasePreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if schema != nil && len(schema) > 0 {
		queryParameters["schema"] = schema
	}
	if table != nil && len(table) > 0 {
		queryParameters["table"] = table
	}
	if column != nil && len(column) > 0 {
		queryParameters["column"] = column
	}
	if orderBy != nil && len(orderBy) > 0 {
		queryParameters["orderBy"] = orderBy
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/columns", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDatabaseSender sends the ListByDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseColumnsClient) ListByDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByDatabaseResponder handles the response to the ListByDatabase request. The method always
// closes the http.Response Body.
func (client DatabaseColumnsClient) ListByDatabaseResponder(resp *http.Response) (result DatabaseColumnListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByDatabaseNextResults retrieves the next set of results, if any.
func (client DatabaseColumnsClient) listByDatabaseNextResults(ctx context.Context, lastResults DatabaseColumnListResult) (result DatabaseColumnListResult, err error) {
	req, err := lastResults.databaseColumnListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "listByDatabaseNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "listByDatabaseNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "listByDatabaseNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByDatabaseComplete enumerates all values, automatically crossing page boundaries as required.
func (client DatabaseColumnsClient) ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schema []string, table []string, column []string, orderBy []string, skiptoken string) (result DatabaseColumnListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnsClient.ListByDatabase")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByDatabase(ctx, resourceGroupName, serverName, databaseName, schema, table, column, orderBy, skiptoken)
	return
}

// ListByTable list database columns
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// databaseName - the name of the database.
// schemaName - the name of the schema.
// tableName - the name of the table.
// filter - an OData filter expression that filters elements in the collection.
func (client DatabaseColumnsClient) ListByTable(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, filter string) (result DatabaseColumnListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnsClient.ListByTable")
		defer func() {
			sc := -1
			if result.dclr.Response.Response != nil {
				sc = result.dclr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByTableNextResults
	req, err := client.ListByTablePreparer(ctx, resourceGroupName, serverName, databaseName, schemaName, tableName, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "ListByTable", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByTableSender(req)
	if err != nil {
		result.dclr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "ListByTable", resp, "Failure sending request")
		return
	}

	result.dclr, err = client.ListByTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "ListByTable", resp, "Failure responding to request")
		return
	}
	if result.dclr.hasNextLink() && result.dclr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByTablePreparer prepares the ListByTable request.
func (client DatabaseColumnsClient) ListByTablePreparer(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"databaseName":      autorest.Encode("path", databaseName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"schemaName":        autorest.Encode("path", schemaName),
		"serverName":        autorest.Encode("path", serverName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"tableName":         autorest.Encode("path", tableName),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByTableSender sends the ListByTable request. The method will close the
// http.Response Body if it receives an error.
func (client DatabaseColumnsClient) ListByTableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByTableResponder handles the response to the ListByTable request. The method always
// closes the http.Response Body.
func (client DatabaseColumnsClient) ListByTableResponder(resp *http.Response) (result DatabaseColumnListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByTableNextResults retrieves the next set of results, if any.
func (client DatabaseColumnsClient) listByTableNextResults(ctx context.Context, lastResults DatabaseColumnListResult) (result DatabaseColumnListResult, err error) {
	req, err := lastResults.databaseColumnListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "listByTableNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByTableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "listByTableNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByTableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabaseColumnsClient", "listByTableNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByTableComplete enumerates all values, automatically crossing page boundaries as required.
func (client DatabaseColumnsClient) ListByTableComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, filter string) (result DatabaseColumnListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseColumnsClient.ListByTable")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByTable(ctx, resourceGroupName, serverName, databaseName, schemaName, tableName, filter)
	return
}
