// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --check-globals --prefix-filecheck-ir-name _ --global-value-regex ".offload_maptypes.*" ".offload_sizes.*" --global-hex-value-regex ".offload_maptypes.*" --no-generate-body-for-unused-prefixes
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

// powerpc64le-ibm-linux-gnu

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-PPC64LE
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t \
// RUN:     -verify %s -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-PPC64LE

// i386-pc-linux-gnu

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-I386
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple i386-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -std=c++11 -include-pch %t -verify %s \
// RUN:     -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-I386

struct S1 {
  int i;
};
struct S2 {
  S1 s;
  struct S2 *ps;
};

// Map flags used in @.offload_maptypes* below:
//
//   TO          = 0x1
//   FROM        = 0x2
//   ALWAYS      = 0x4
//   PTR_AND_OBJ = 0x10
//   CLOSE       = 0x400
//   OMPX_HOLD   = 0x2000
//   MEMBER_OF_1 = 0x1000000000000
//   MEMBER_OF_7 = 0x7000000000000

//.
// CHECK-PPC64LE: @[[GLOB0:[0-9]+]] = private unnamed_addr constant [23 x i8] c"
// CHECK-PPC64LE: @[[GLOB1:[0-9]+]] = private unnamed_addr constant %struct.ident_t { i32 0, i32 2, i32 0, i32 22, ptr @[[GLOB0]] }, align 8
//.
// CHECK-I386: @[[GLOB0:[0-9]+]] = private unnamed_addr constant [23 x i8] c"
// CHECK-I386: @[[GLOB1:[0-9]+]] = private unnamed_addr constant %struct.ident_t { i32 0, i32 2, i32 0, i32 22, ptr @[[GLOB0]] }, align 8
//.
// CHECK-PPC64LE: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-PPC64LE: @.offload_maptypes = private unnamed_addr constant [1 x i64] [i64 8193]
// CHECK-PPC64LE: @.offload_sizes.1 = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-PPC64LE: @.offload_maptypes.2 = private unnamed_addr constant [1 x i64] [i64 9221]
// CHECK-PPC64LE: @.offload_sizes.3 = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-PPC64LE: @.offload_maptypes.4 = private unnamed_addr constant [1 x i64] [i64 8195]
// CHECK-PPC64LE: @.offload_sizes.5 = private unnamed_addr constant [11 x i64] [i64 0, i64 4, i64 8, i64 8, i64 4, i64 4, i64 0, i64 4, i64 8, i64 8, i64 4]
// CHECK-PPC64LE: @.offload_maptypes.6 = private unnamed_addr constant [11 x i64] [i64 8192, i64 281474976718851, i64 281474976718864, i64 8208, i64 8211, i64 3, i64 8192, i64 1970324836982787, i64 1970324836982800, i64 8208, i64 8211]
//.
// CHECK-I386: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-I386: @.offload_maptypes = private unnamed_addr constant [1 x i64] [i64 8193]
// CHECK-I386: @.offload_sizes.1 = private unnamed_addr constant [1 x i64] [i64 20]
// CHECK-I386: @.offload_maptypes.2 = private unnamed_addr constant [1 x i64] [i64 9221]
// CHECK-I386: @.offload_sizes.3 = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-I386: @.offload_maptypes.4 = private unnamed_addr constant [1 x i64] [i64 8195]
// CHECK-I386: @.offload_sizes.5 = private unnamed_addr constant [11 x i64] [i64 0, i64 4, i64 4, i64 4, i64 4, i64 4, i64 0, i64 4, i64 4, i64 4, i64 4]
// CHECK-I386: @.offload_maptypes.6 = private unnamed_addr constant [11 x i64] [i64 8192, i64 281474976718851, i64 281474976718864, i64 8208, i64 8211, i64 3, i64 8192, i64 1970324836982787, i64 1970324836982800, i64 8208, i64 8211]
//.
// CHECK-PPC64LE-LABEL: @_Z3fooi(
// CHECK-PPC64LE-NEXT:  entry:
// CHECK-PPC64LE-NEXT:    [[ARG_ADDR:%.*]] = alloca i32, align 4
// CHECK-PPC64LE-NEXT:    [[LB:%.*]] = alloca [5 x float], align 4
// CHECK-PPC64LE-NEXT:    [[PS1:%.*]] = alloca ptr, align 8
// CHECK-PPC64LE-NEXT:    [[PS2:%.*]] = alloca ptr, align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS1:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS2:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS3:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [1 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS29:%.*]] = alloca [11 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS30:%.*]] = alloca [11 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS31:%.*]] = alloca [11 x ptr], align 8
// CHECK-PPC64LE-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [11 x i64], align 8
// CHECK-PPC64LE-NEXT:    store i32 [[ARG:%.*]], ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[LB]], ptr [[TMP0]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[LB]], ptr [[TMP1]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP2]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP3]], ptr [[TMP4]], ptr @.offload_sizes, ptr @.offload_maptypes, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP5:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC]], ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP6]], ptr [[TMP7]], ptr @.offload_sizes, ptr @.offload_maptypes, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[LB]], ptr [[TMP8]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[LB]], ptr [[TMP9]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS3]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP10]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP11]], ptr [[TMP12]], ptr @.offload_sizes.1, ptr @.offload_maptypes.2, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC4:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC4]], ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP14]], ptr [[TMP15]], ptr @.offload_sizes.1, ptr @.offload_maptypes.2, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP16]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP17]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP18]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP19]], ptr [[TMP20]], ptr @.offload_sizes.3, ptr @.offload_maptypes.4, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC8:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC8]], ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP22]], ptr [[TMP23]], ptr @.offload_sizes.3, ptr @.offload_maptypes.4, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[S:%.*]] = getelementptr inbounds [[STRUCT_S2:%.*]], ptr [[TMP25]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP27]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS9:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP28]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[PS9]], align 8
// CHECK-PPC64LE-NEXT:    [[PS10:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP29]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS11:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP30]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[PS11]], align 8
// CHECK-PPC64LE-NEXT:    [[PS12:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP31]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[PS12]], align 8
// CHECK-PPC64LE-NEXT:    [[PS13:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP32]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[PS1]], align 8
// CHECK-PPC64LE-NEXT:    [[PS14:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP33]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[PS14]], align 8
// CHECK-PPC64LE-NEXT:    [[PS15:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP34]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[PS15]], align 8
// CHECK-PPC64LE-NEXT:    [[PS16:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP35]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[PS16]], align 8
// CHECK-PPC64LE-NEXT:    [[S17:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP36]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP37:%.*]] = getelementptr ptr, ptr [[PS]], i32 1
// CHECK-PPC64LE-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP37]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP39:%.*]] = ptrtoint ptr [[S]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP40:%.*]] = sub i64 [[TMP38]], [[TMP39]]
// CHECK-PPC64LE-NEXT:    [[TMP41:%.*]] = sdiv exact i64 [[TMP40]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// CHECK-PPC64LE-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP43:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[S18:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP43]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS19:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP45]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP46:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS20:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP46]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP47:%.*]] = load ptr, ptr [[PS20]], align 8
// CHECK-PPC64LE-NEXT:    [[PS21:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP47]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP48:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS22:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP48]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP49:%.*]] = load ptr, ptr [[PS22]], align 8
// CHECK-PPC64LE-NEXT:    [[PS23:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP49]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[PS23]], align 8
// CHECK-PPC64LE-NEXT:    [[PS24:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP50]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP51:%.*]] = load ptr, ptr [[PS2]], align 8
// CHECK-PPC64LE-NEXT:    [[PS25:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP51]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[PS25]], align 8
// CHECK-PPC64LE-NEXT:    [[PS26:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP52]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[PS26]], align 8
// CHECK-PPC64LE-NEXT:    [[PS27:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP53]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[PS27]], align 8
// CHECK-PPC64LE-NEXT:    [[S28:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP54]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP55:%.*]] = getelementptr ptr, ptr [[PS19]], i32 1
// CHECK-PPC64LE-NEXT:    [[TMP56:%.*]] = ptrtoint ptr [[TMP55]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP57:%.*]] = ptrtoint ptr [[S18]] to i64
// CHECK-PPC64LE-NEXT:    [[TMP58:%.*]] = sub i64 [[TMP56]], [[TMP57]]
// CHECK-PPC64LE-NEXT:    [[TMP59:%.*]] = sdiv exact i64 [[TMP58]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// CHECK-PPC64LE-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[DOTOFFLOAD_SIZES]], ptr align 8 @.offload_sizes.5, i64 88, i1 false)
// CHECK-PPC64LE-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[TMP24]], ptr [[TMP60]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store ptr [[S]], ptr [[TMP61]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    store i64 [[TMP41]], ptr [[TMP62]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 0
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP63]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    store ptr [[TMP24]], ptr [[TMP64]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 1
// CHECK-PPC64LE-NEXT:    store ptr [[S]], ptr [[TMP65]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 1
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP66]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 2
// CHECK-PPC64LE-NEXT:    store ptr [[PS]], ptr [[TMP67]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 2
// CHECK-PPC64LE-NEXT:    store ptr [[PS10]], ptr [[TMP68]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 2
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP69]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 3
// CHECK-PPC64LE-NEXT:    store ptr [[PS10]], ptr [[TMP70]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 3
// CHECK-PPC64LE-NEXT:    store ptr [[PS13]], ptr [[TMP71]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 3
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP72]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 4
// CHECK-PPC64LE-NEXT:    store ptr [[PS13]], ptr [[TMP73]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP74:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 4
// CHECK-PPC64LE-NEXT:    store ptr [[S17]], ptr [[TMP74]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 4
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP75]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 5
// CHECK-PPC64LE-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP76]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 5
// CHECK-PPC64LE-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP77]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 5
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP78]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP79:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 6
// CHECK-PPC64LE-NEXT:    store ptr [[TMP42]], ptr [[TMP79]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 6
// CHECK-PPC64LE-NEXT:    store ptr [[S18]], ptr [[TMP80]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP81:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-PPC64LE-NEXT:    store i64 [[TMP59]], ptr [[TMP81]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 6
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP82]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 7
// CHECK-PPC64LE-NEXT:    store ptr [[TMP42]], ptr [[TMP83]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 7
// CHECK-PPC64LE-NEXT:    store ptr [[S18]], ptr [[TMP84]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 7
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP85]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 8
// CHECK-PPC64LE-NEXT:    store ptr [[PS19]], ptr [[TMP86]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 8
// CHECK-PPC64LE-NEXT:    store ptr [[PS21]], ptr [[TMP87]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 8
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP88]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP89:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 9
// CHECK-PPC64LE-NEXT:    store ptr [[PS21]], ptr [[TMP89]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 9
// CHECK-PPC64LE-NEXT:    store ptr [[PS24]], ptr [[TMP90]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP91:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 9
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP91]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 10
// CHECK-PPC64LE-NEXT:    store ptr [[PS24]], ptr [[TMP92]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 10
// CHECK-PPC64LE-NEXT:    store ptr [[S28]], ptr [[TMP93]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i64 0, i64 10
// CHECK-PPC64LE-NEXT:    store ptr null, ptr [[TMP94]], align 8
// CHECK-PPC64LE-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 11, ptr [[TMP95]], ptr [[TMP96]], ptr [[TMP97]], ptr @.offload_maptypes.6, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    [[TMP98:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[INC32:%.*]] = add nsw i32 [[TMP98]], 1
// CHECK-PPC64LE-NEXT:    store i32 [[INC32]], ptr [[ARG_ADDR]], align 4
// CHECK-PPC64LE-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-PPC64LE-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 11, ptr [[TMP99]], ptr [[TMP100]], ptr [[TMP101]], ptr @.offload_maptypes.6, ptr null, ptr null)
// CHECK-PPC64LE-NEXT:    ret void
//
// CHECK-I386-LABEL: @_Z3fooi(
// CHECK-I386-NEXT:  entry:
// CHECK-I386-NEXT:    [[ARG_ADDR:%.*]] = alloca i32, align 4
// CHECK-I386-NEXT:    [[LB:%.*]] = alloca [5 x float], align 4
// CHECK-I386-NEXT:    [[PS1:%.*]] = alloca ptr, align 4
// CHECK-I386-NEXT:    [[PS2:%.*]] = alloca ptr, align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS1:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS2:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS3:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [1 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS29:%.*]] = alloca [11 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_PTRS30:%.*]] = alloca [11 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_MAPPERS31:%.*]] = alloca [11 x ptr], align 4
// CHECK-I386-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [11 x i64], align 4
// CHECK-I386-NEXT:    store i32 [[ARG:%.*]], ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[LB]], ptr [[TMP0]], align 4
// CHECK-I386-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[LB]], ptr [[TMP1]], align 4
// CHECK-I386-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP2]], align 4
// CHECK-I386-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP3]], ptr [[TMP4]], ptr @.offload_sizes, ptr @.offload_maptypes, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP5:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK-I386-NEXT:    store i32 [[INC]], ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP6]], ptr [[TMP7]], ptr @.offload_sizes, ptr @.offload_maptypes, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[LB]], ptr [[TMP8]], align 4
// CHECK-I386-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[LB]], ptr [[TMP9]], align 4
// CHECK-I386-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS3]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP10]], align 4
// CHECK-I386-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP11]], ptr [[TMP12]], ptr @.offload_sizes.1, ptr @.offload_maptypes.2, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC4:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK-I386-NEXT:    store i32 [[INC4]], ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS1]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS2]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP14]], ptr [[TMP15]], ptr @.offload_sizes.1, ptr @.offload_maptypes.2, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP16]], align 4
// CHECK-I386-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP17]], align 4
// CHECK-I386-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP18]], align 4
// CHECK-I386-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP19]], ptr [[TMP20]], ptr @.offload_sizes.3, ptr @.offload_maptypes.4, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC8:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK-I386-NEXT:    store i32 [[INC8]], ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 1, ptr [[TMP22]], ptr [[TMP23]], ptr @.offload_sizes.3, ptr @.offload_maptypes.4, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[S:%.*]] = getelementptr inbounds [[STRUCT_S2:%.*]], ptr [[TMP25]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[TMP27:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP27]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS9:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP28]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[PS9]], align 4
// CHECK-I386-NEXT:    [[PS10:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP29]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS11:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP30]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[PS11]], align 4
// CHECK-I386-NEXT:    [[PS12:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP31]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[PS12]], align 4
// CHECK-I386-NEXT:    [[PS13:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP32]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[PS1]], align 4
// CHECK-I386-NEXT:    [[PS14:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP33]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[PS14]], align 4
// CHECK-I386-NEXT:    [[PS15:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP34]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[PS15]], align 4
// CHECK-I386-NEXT:    [[PS16:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP35]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[PS16]], align 4
// CHECK-I386-NEXT:    [[S17:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP36]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP37:%.*]] = getelementptr ptr, ptr [[PS]], i32 1
// CHECK-I386-NEXT:    [[TMP38:%.*]] = ptrtoint ptr [[TMP37]] to i64
// CHECK-I386-NEXT:    [[TMP39:%.*]] = ptrtoint ptr [[S]] to i64
// CHECK-I386-NEXT:    [[TMP40:%.*]] = sub i64 [[TMP38]], [[TMP39]]
// CHECK-I386-NEXT:    [[TMP41:%.*]] = sdiv exact i64 [[TMP40]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// CHECK-I386-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[TMP43:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[S18:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP43]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS19:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP45]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP46:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS20:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP46]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP47:%.*]] = load ptr, ptr [[PS20]], align 4
// CHECK-I386-NEXT:    [[PS21:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP47]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP48:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS22:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP48]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP49:%.*]] = load ptr, ptr [[PS22]], align 4
// CHECK-I386-NEXT:    [[PS23:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP49]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[PS23]], align 4
// CHECK-I386-NEXT:    [[PS24:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP50]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP51:%.*]] = load ptr, ptr [[PS2]], align 4
// CHECK-I386-NEXT:    [[PS25:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP51]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[PS25]], align 4
// CHECK-I386-NEXT:    [[PS26:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP52]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[PS26]], align 4
// CHECK-I386-NEXT:    [[PS27:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP53]], i32 0, i32 1
// CHECK-I386-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[PS27]], align 4
// CHECK-I386-NEXT:    [[S28:%.*]] = getelementptr inbounds [[STRUCT_S2]], ptr [[TMP54]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP55:%.*]] = getelementptr ptr, ptr [[PS19]], i32 1
// CHECK-I386-NEXT:    [[TMP56:%.*]] = ptrtoint ptr [[TMP55]] to i64
// CHECK-I386-NEXT:    [[TMP57:%.*]] = ptrtoint ptr [[S18]] to i64
// CHECK-I386-NEXT:    [[TMP58:%.*]] = sub i64 [[TMP56]], [[TMP57]]
// CHECK-I386-NEXT:    [[TMP59:%.*]] = sdiv exact i64 [[TMP58]], ptrtoint (ptr getelementptr (i8, ptr null, i32 1) to i64)
// CHECK-I386-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[DOTOFFLOAD_SIZES]], ptr align 4 @.offload_sizes.5, i32 88, i1 false)
// CHECK-I386-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[TMP24]], ptr [[TMP60]], align 4
// CHECK-I386-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr [[S]], ptr [[TMP61]], align 4
// CHECK-I386-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-I386-NEXT:    store i64 [[TMP41]], ptr [[TMP62]], align 4
// CHECK-I386-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 0
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP63]], align 4
// CHECK-I386-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 1
// CHECK-I386-NEXT:    store ptr [[TMP24]], ptr [[TMP64]], align 4
// CHECK-I386-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 1
// CHECK-I386-NEXT:    store ptr [[S]], ptr [[TMP65]], align 4
// CHECK-I386-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 1
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP66]], align 4
// CHECK-I386-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 2
// CHECK-I386-NEXT:    store ptr [[PS]], ptr [[TMP67]], align 4
// CHECK-I386-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 2
// CHECK-I386-NEXT:    store ptr [[PS10]], ptr [[TMP68]], align 4
// CHECK-I386-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 2
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP69]], align 4
// CHECK-I386-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 3
// CHECK-I386-NEXT:    store ptr [[PS10]], ptr [[TMP70]], align 4
// CHECK-I386-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 3
// CHECK-I386-NEXT:    store ptr [[PS13]], ptr [[TMP71]], align 4
// CHECK-I386-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 3
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP72]], align 4
// CHECK-I386-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 4
// CHECK-I386-NEXT:    store ptr [[PS13]], ptr [[TMP73]], align 4
// CHECK-I386-NEXT:    [[TMP74:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 4
// CHECK-I386-NEXT:    store ptr [[S17]], ptr [[TMP74]], align 4
// CHECK-I386-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 4
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP75]], align 4
// CHECK-I386-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 5
// CHECK-I386-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP76]], align 4
// CHECK-I386-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 5
// CHECK-I386-NEXT:    store ptr [[ARG_ADDR]], ptr [[TMP77]], align 4
// CHECK-I386-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 5
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP78]], align 4
// CHECK-I386-NEXT:    [[TMP79:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 6
// CHECK-I386-NEXT:    store ptr [[TMP42]], ptr [[TMP79]], align 4
// CHECK-I386-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 6
// CHECK-I386-NEXT:    store ptr [[S18]], ptr [[TMP80]], align 4
// CHECK-I386-NEXT:    [[TMP81:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-I386-NEXT:    store i64 [[TMP59]], ptr [[TMP81]], align 4
// CHECK-I386-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 6
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP82]], align 4
// CHECK-I386-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 7
// CHECK-I386-NEXT:    store ptr [[TMP42]], ptr [[TMP83]], align 4
// CHECK-I386-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 7
// CHECK-I386-NEXT:    store ptr [[S18]], ptr [[TMP84]], align 4
// CHECK-I386-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 7
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP85]], align 4
// CHECK-I386-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 8
// CHECK-I386-NEXT:    store ptr [[PS19]], ptr [[TMP86]], align 4
// CHECK-I386-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 8
// CHECK-I386-NEXT:    store ptr [[PS21]], ptr [[TMP87]], align 4
// CHECK-I386-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 8
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP88]], align 4
// CHECK-I386-NEXT:    [[TMP89:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 9
// CHECK-I386-NEXT:    store ptr [[PS21]], ptr [[TMP89]], align 4
// CHECK-I386-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 9
// CHECK-I386-NEXT:    store ptr [[PS24]], ptr [[TMP90]], align 4
// CHECK-I386-NEXT:    [[TMP91:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 9
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP91]], align 4
// CHECK-I386-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 10
// CHECK-I386-NEXT:    store ptr [[PS24]], ptr [[TMP92]], align 4
// CHECK-I386-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 10
// CHECK-I386-NEXT:    store ptr [[S28]], ptr [[TMP93]], align 4
// CHECK-I386-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_MAPPERS31]], i32 0, i32 10
// CHECK-I386-NEXT:    store ptr null, ptr [[TMP94]], align 4
// CHECK-I386-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_begin_mapper(ptr @[[GLOB1]], i64 -1, i32 11, ptr [[TMP95]], ptr [[TMP96]], ptr [[TMP97]], ptr @.offload_maptypes.6, ptr null, ptr null)
// CHECK-I386-NEXT:    [[TMP98:%.*]] = load i32, ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[INC32:%.*]] = add nsw i32 [[TMP98]], 1
// CHECK-I386-NEXT:    store i32 [[INC32]], ptr [[ARG_ADDR]], align 4
// CHECK-I386-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_BASEPTRS29]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [11 x ptr], ptr [[DOTOFFLOAD_PTRS30]], i32 0, i32 0
// CHECK-I386-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [11 x i64], ptr [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-I386-NEXT:    call void @__tgt_target_data_end_mapper(ptr @[[GLOB1]], i64 -1, i32 11, ptr [[TMP99]], ptr [[TMP100]], ptr [[TMP101]], ptr @.offload_maptypes.6, ptr null, ptr null)
// CHECK-I386-NEXT:    ret void
//
void foo(int arg) {
  float lb[5];
  S2 *ps1;
  S2 *ps2;

  #pragma omp target data map(ompx_hold, to: lb)
  {++arg;}

  #pragma omp target data map(always close ompx_hold, to: lb)
  {++arg;}

  #pragma omp target data map(ompx_hold, tofrom : arg)
  {++arg;}

  // Make sure the struct picks up ompx_hold even if another element of the
  // struct doesn't have ompx_hold.
  #pragma omp target data map(tofrom : ps1->s, arg)                           \
                          map(ompx_hold, tofrom : ps1->ps->ps->ps->s, ps2->s) \
                          map(tofrom : ps2->ps->ps->ps->s)
  {
    ++(arg);
  }
}

#endif
//.
// CHECK-PPC64LE: attributes #[[ATTR0:[0-9]+]] = { mustprogress noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="-altivec,-bpermd,-crbits,-crypto,-direct-move,-extdiv,-htm,-isa-v206-instructions,-isa-v207-instructions,-isa-v30-instructions,-power8-vector,-power9-vector,-privileged,-quadword-atomics,-rop-protect,-spe,-vsx" }
// CHECK-PPC64LE: attributes #[[ATTR1:[0-9]+]] = { nounwind }
// CHECK-PPC64LE: attributes #[[ATTR2:[0-9]+]] = { nocallback nofree nounwind willreturn memory(argmem: readwrite) }
//.
// CHECK-I386: attributes #[[ATTR0:[0-9]+]] = { mustprogress noinline nounwind optnone "min-legal-vector-width"="0" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+cx8,+x87" }
// CHECK-I386: attributes #[[ATTR1:[0-9]+]] = { nounwind }
// CHECK-I386: attributes #[[ATTR2:[0-9]+]] = { nocallback nofree nounwind willreturn memory(argmem: readwrite) }
//.
// CHECK-PPC64LE: [[META0:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
// CHECK-PPC64LE: [[META1:![0-9]+]] = !{i32 7, !"openmp", i32 51}
// CHECK-PPC64LE: [[META2:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
//.
// CHECK-I386: [[META0:![0-9]+]] = !{i32 1, !"NumRegisterParameters", i32 0}
// CHECK-I386: [[META1:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
// CHECK-I386: [[META2:![0-9]+]] = !{i32 7, !"openmp", i32 51}
// CHECK-I386: [[META3:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
//.
