/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "sova_key_relations.h"
#include <gaminggear/hid_uid.h>

SovaKeyRelation const sova_key_relations[SOVA_KEYS_NUM] = {
		{HID_UID_KB_ESCAPE,       SOVA_KEY_RELATION_INVALID,                   SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_NOTHING},
		{HID_UID_KB_F1,           SOVA_KEY_TYPE_MULTIMEDIA_MUTE_MASTER_VOLUME, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  0, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F2,           SOVA_KEY_TYPE_MULTIMEDIA_VOLUME_DOWN,        SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  1, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F3,           SOVA_KEY_TYPE_MULTIMEDIA_VOLUME_UP,          SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  2, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F4,           SOVA_KEY_TYPE_APP_CALCULATOR,                SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  3, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F5,           SOVA_KEY_TYPE_MULTIMEDIA_PLAY_PAUSE,         SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  4, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F6,           SOVA_KEY_TYPE_MULTIMEDIA_STOP,               SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  5, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F7,           SOVA_KEY_TYPE_MULTIMEDIA_PREVIOUS_TRACK,     SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  6, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F8,           SOVA_KEY_TYPE_MULTIMEDIA_NEXT_TRACK,         SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  7, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F9,           SOVA_KEY_TYPE_APP_MY_COMPUTER,               SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  8, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F10,          SOVA_KEY_TYPE_APP_BROWSER,                   SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID,  9, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F11,          SOVA_KEY_TYPE_LIGHT,                         SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, 10, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_F12,          SOVA_KEY_TYPE_RECORD,                        SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, 11, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_PRINT_SCREEN, HID_UID_KB_PAUSE,                            SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, 12, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_INSERT,       HID_UID_KP_NUM_LOCK,                         SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, 13, SOVA_KEY_RELATION_TYPE_FUNCTION},
		{HID_UID_KB_DELETE,       HID_UID_KB_SCROLL_LOCK,                      SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, 14, SOVA_KEY_RELATION_TYPE_FUNCTION},

		{0x35,                 SOVA_KEY_RELATION_INVALID, 0x79, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_1,         SOVA_KEY_RELATION_INVALID, 0x4f, 0, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_2,         SOVA_KEY_RELATION_INVALID, 0x47, 1, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_3,         SOVA_KEY_RELATION_INVALID, 0x3f, 2, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_4,         SOVA_KEY_RELATION_INVALID, 0x37, 3, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_5,         SOVA_KEY_RELATION_INVALID, 0x2f, 4, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_6,         SOVA_KEY_RELATION_INVALID, 0x22, 5, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_7,         SOVA_KEY_RELATION_INVALID, 0x1a, 6, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_8,         SOVA_KEY_RELATION_INVALID, 0x12, 7, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_9,         SOVA_KEY_RELATION_INVALID, 0x4a, 8, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_0,         SOVA_KEY_RELATION_INVALID, 0x2a, 9, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x2D,                 SOVA_KEY_RELATION_INVALID, 0x42, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{0x2E,                 SOVA_KEY_RELATION_INVALID, 0x41, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_BACKSPACE, SOVA_KEY_RELATION_INVALID, 0x62, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_HOME,      SOVA_KEY_RELATION_INVALID, 0x52, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},

		{HID_UID_KB_TAB,     SOVA_KEY_RELATION_INVALID, 0x7e, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_Q,       SOVA_KEY_RELATION_INVALID, 0x00, 10, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_W,       SOVA_KEY_RELATION_INVALID, 0x77, 11, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_E,       SOVA_KEY_RELATION_INVALID, 0x01, 12, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_R,       SOVA_KEY_RELATION_INVALID, 0x02, 13, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_T,       SOVA_KEY_RELATION_INVALID, 0x03, 14, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_Z,       SOVA_KEY_RELATION_INVALID, 0x06, 15, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_U,       SOVA_KEY_RELATION_INVALID, 0x1a, 16, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_I,       SOVA_KEY_RELATION_INVALID, 0x13, 17, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_O,       SOVA_KEY_RELATION_INVALID, 0x4b, 18, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_P,       SOVA_KEY_RELATION_INVALID, 0x53, 19, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x2F,               SOVA_KEY_RELATION_INVALID, 0x5b, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{0x30,               SOVA_KEY_RELATION_INVALID, 0x63, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_ENTER,   SOVA_KEY_RELATION_INVALID, 0x65, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_PAGE_UP, SOVA_KEY_RELATION_INVALID, 0x5a, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},

		{HID_UID_KB_CAPS_LOCK, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_CAPSLOCK},
		{HID_UID_KB_A,         SOVA_KEY_RELATION_INVALID, 0x7f, 20, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_S,         SOVA_KEY_RELATION_INVALID, 0x87, 21, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_D,         SOVA_KEY_RELATION_INVALID, 0x8f, 22, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_F,         SOVA_KEY_RELATION_INVALID, 0x04, 23, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_G,         SOVA_KEY_RELATION_INVALID, 0x05, 24, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_H,         SOVA_KEY_RELATION_INVALID, 0x25, 25, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_J,         SOVA_KEY_RELATION_INVALID, 0x1d, 26, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_K,         SOVA_KEY_RELATION_INVALID, 0x15, 27, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_L,         SOVA_KEY_RELATION_INVALID, 0x4d, 28, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x33,                 SOVA_KEY_RELATION_INVALID, 0x55, 29, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x34,                 SOVA_KEY_RELATION_INVALID, 0x5d, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{0x32,                 SOVA_KEY_RELATION_INVALID, 0x6d, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_PAGE_DOWN, SOVA_KEY_RELATION_INVALID, 0x6a, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},

		{HID_UID_KB_LEFT_SHIFT,  SOVA_KEY_RELATION_INVALID, 0x80, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{0x64,                   SOVA_KEY_RELATION_INVALID, 0x0e, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_Y,           SOVA_KEY_RELATION_INVALID, 0x23, 30, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_X,           SOVA_KEY_RELATION_INVALID, 0x0f, 31, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_C,           SOVA_KEY_RELATION_INVALID, 0x17, 32, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_V,           SOVA_KEY_RELATION_INVALID, 0x1f, 33, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_B,           SOVA_KEY_RELATION_INVALID, 0x27, 34, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_N,           SOVA_KEY_RELATION_INVALID, 0x26, 35, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_M,           SOVA_KEY_RELATION_INVALID, 0x1e, 36, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x36,                   SOVA_KEY_RELATION_INVALID, 0x16, 37, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x37,                   SOVA_KEY_RELATION_INVALID, 0x56, 38, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{0x38,                   SOVA_KEY_RELATION_INVALID, 0x5e, 39, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_EASYZONE},
		{HID_UID_KB_RIGHT_SHIFT, SOVA_KEY_RELATION_INVALID, 0x88, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_UP_ARROW,    SOVA_KEY_RELATION_INVALID, 0x57, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_END,         SOVA_KEY_RELATION_INVALID, 0x6e, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},

		{HID_UID_KB_LEFT_CONTROL,  SOVA_KEY_RELATION_INVALID, 0x82, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_LEFT_GUI,      SOVA_KEY_RELATION_INVALID, 0x81, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_LEFT_ALT,      SOVA_KEY_RELATION_INVALID, 0x83, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_SPACE,         SOVA_KEY_RELATION_INVALID, 0x84, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_RIGHT_ALT,     SOVA_KEY_RELATION_INVALID, 0x8b, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_RIGHT_GUI,     SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_NOTHING},
		{HID_UID_KB_RIGHT_CONTROL, SOVA_KEY_RELATION_INVALID, 0x8a, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_LEFT_ARROW,    SOVA_KEY_RELATION_INVALID, 0x67, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_DOWN_ARROW,    SOVA_KEY_RELATION_INVALID, 0x5f, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
		{HID_UID_KB_RIGHT_ARROW,   SOVA_KEY_RELATION_INVALID, 0x6f, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_INVALID, SOVA_KEY_RELATION_TYPE_PRIMARY},
};

guint sova_key_relation_find_by_easyzone_index(guint easyzone_index) {
	guint i;

	for (i = 0; i < SOVA_KEYS_NUM; ++i)
		if (easyzone_index == sova_key_relations[i].easyzone_index)
			return i;
	return SOVA_KEY_RELATION_INVALID;
}
