# Stefan Achatz 2012
#
# Tries to find libdbus-1 and sets following variables according to found capabilities:
#
# DBUS_FOUND
# DBUS_INCLUDE_DIRS
# DBUS_LIBRARIES

FIND_PACKAGE(PkgConfig REQUIRED)
PKG_CHECK_MODULES(PKG_DBUS dbus-1)

FIND_PATH(DBUS_INCLUDE_DIR dbus/dbus.h
  HINTS
    ${PKG_DBUS_INCLUDE_DIRS}
    ${PKB_DBUS_INCLUDEDIR}
  PATH_SUFFIXES dbus-1.0
)

FIND_PATH(DBUS_ARCH_DIR dbus/dbus-arch-deps.h
  HINTS
    ${PKG_DBUS_INCLUDE_DIRS}
    ${PKB_DBUS_INCLUDEDIR}
  PATH_SUFFIXES dbus-1.0
)

FIND_LIBRARY(DBUS_LIBRARIES dbus-1
  PATHS ${PKG_DBUS_LIBRARY_DIRS}
)

IF(DBUS_LIBRARIES AND DBUS_INCLUDE_DIR AND DBUS_ARCH_DIR)
  SET(DBUS_FOUND true)
ENDIF()

SET(DBUS_INCLUDE_DIRS ${DBUS_INCLUDE_DIR} ${DBUS_ARCH_DIR})

IF(DBUS_FIND_REQUIRED AND NOT DBUS_FOUND)
  MESSAGE(FATAL_ERROR "Could not find DBUS")
ENDIF()
