import org.aspectj.testing.Tester;

// PR#275 & 276 cast error generated by ajc when type not in signature

public class Driver {
    public static void main(String[] args) { test(); }

    public static void test() {
        Tester.checkEqual(new SourcePane().go(), -10);
    }
}

class SourcePane {
    public int go() {
        Location location = new Location();
        return location.lineNumber();
    }
}

class Location {
    public int lineNumber() {
        return 10;
    }
}

aspect DriverAspect {

    pointcut locationLineNumber(Location loc):
        //XXX Fails with a star
        //calls(int *.lineNumber()) && within(SourcePane);
        //calls(int loc.lineNumber()) && within(SourcePane);
        target(loc) && call(int Location.lineNumber()) && within(SourcePane);
    int around(Location loc): locationLineNumber(loc) {
        int result = proceed(loc);
        return result * -1;
    }
// The following code won't report the cast error and will work:
/*
    pointcut locationLineNumber(SourcePane s, Location loc):
        calls(loc, int lineNumber()) & within(s);
    static around(SourcePane s, Location loc) returns int: locationLineNumber(s, loc) {
        int result = proceed(s, loc);
        return result * -1;
    }
*/
}
