/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeNode;

class ElementSubtree {
    protected String elementName;
    protected Object elementData;
    protected ElementSubtree[] children;
    static final ElementSubtree[] EMPTY_ARRAY = new ElementSubtree[0];

    public ElementSubtree(String elementName, Object elementData, ElementSubtree[] children) {
        if (children == null || children.length == 0) {
            children = EMPTY_ARRAY;
        }
        this.elementName = elementName;
        this.elementData = elementData;
        this.children = children;
    }

    ElementSubtree(DataTreeNode childNode) {
        AbstractDataTreeNode[] childNodes = childNode.getChildren();
        if (childNodes.length == 0) {
            this.children = EMPTY_ARRAY;
        } else {
            ElementSubtree[] types = new ElementSubtree[childNodes.length];
            int i = childNodes.length;
            while (--i >= 0) {
                types[i] = new ElementSubtree((DataTreeNode)childNodes[i]);
            }
            this.children = types;
        }
        this.elementName = childNode.getName();
        this.elementData = childNode.getData();
    }

    public ElementSubtree[] getChildren() {
        return this.children;
    }

    public Object getElementData() {
        return this.elementData;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String toString() {
        return "ElementSubtree(" + this.elementName + ", " + this.elementData + ")";
    }
}

