/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    protected char[] qualification;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char typeSuffix, int matchRule) {
        this(matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = this.isCaseSensitive() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.typeSuffix = typeSuffix;
        this.mustResolve = this.qualification != null;
    }

    QualifiedTypeDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('/', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        int secondSlash = CharOperation.indexOf('/', key, (slash = CharOperation.indexOf('/', key, start)) + 1);
        if (start + 1 == secondSlash) {
            this.qualification = CharOperation.NO_CHAR;
        } else if (slash + 1 == secondSlash) {
            this.qualification = CharOperation.subarray(key, start, slash);
        } else {
            this.qualification = CharOperation.subarray(key, start, secondSlash);
            this.qualification[slash - start] = 46;
        }
        this.typeSuffix = key[key.length - 1];
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        switch (this.typeSuffix) {
            case 'A': 
            case 'C': 
            case 'E': 
            case 'I': {
                if (this.typeSuffix == pattern.typeSuffix) break;
                return false;
            }
        }
        return this.matchesName(this.simpleName, pattern.simpleName) && this.matchesName(this.qualification, pattern.qualification);
    }

    protected StringBuffer print(StringBuffer output) {
        switch (this.typeSuffix) {
            case 'C': {
                output.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'I': {
                output.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            case 'E': {
                output.append("EnumDeclarationPattern: qualification<");
                break;
            }
            case 'A': {
                output.append("AnnotationTypeDeclarationPattern: qualification<");
                break;
            }
            default: {
                output.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        return super.print(output);
    }
}

