/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding
implements BaseTypes,
TagBits,
TypeConstants,
TypeIds {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;

    public static final TypeBinding wellKnownType(Scope scope, int id) {
        switch (id) {
            case 5: {
                return BaseTypes.BooleanBinding;
            }
            case 3: {
                return BaseTypes.ByteBinding;
            }
            case 2: {
                return BaseTypes.CharBinding;
            }
            case 4: {
                return BaseTypes.ShortBinding;
            }
            case 8: {
                return BaseTypes.DoubleBinding;
            }
            case 9: {
                return BaseTypes.FloatBinding;
            }
            case 10: {
                return BaseTypes.IntBinding;
            }
            case 7: {
                return BaseTypes.LongBinding;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public int kind() {
        return 4;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public void collectSubstitutes(TypeBinding otherType, Map substitutes) {
    }

    public char[] computeUniqueKey() {
        return this.genericTypeSignature();
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    public TypeBinding genericCast(TypeBinding otherType) {
        if (this == otherType) {
            return null;
        }
        if (otherType.isWildcard() && ((WildcardBinding)otherType).kind != 1) {
            return null;
        }
        TypeBinding otherErasure = otherType.erasure();
        if (otherErasure == this.erasure()) {
            return null;
        }
        return otherErasure;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public abstract PackageBinding getPackage();

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        if (otherType.isWildcard()) {
            return ((WildcardBinding)otherType).boundCheck(this);
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x8000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isPartOfRawType() {
        TypeBinding current = this;
        do {
            if (!current.isRawType()) continue;
            return true;
        } while ((current = current.enclosingType()) != null);
        return false;
    }

    public boolean isProvablyDistinctFrom(TypeBinding otherType, int depth) {
        if (this == otherType) {
            return false;
        }
        if (depth > 1) {
            return true;
        }
        switch (otherType.kind()) {
            case 260: 
            case 2052: {
                return false;
            }
        }
        switch (this.kind()) {
            case 260: 
            case 2052: {
                return false;
            }
            case 132: {
                ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)this;
                if (parameterizedType.type.isProvablyDistinctFrom(otherType.erasure(), depth)) {
                    return true;
                }
                switch (otherType.kind()) {
                    case 516: 
                    case 1028: {
                        return false;
                    }
                    case 132: {
                        TypeBinding[] arguments = parameterizedType.arguments;
                        if (arguments == null) {
                            return false;
                        }
                        ParameterizedTypeBinding otherParameterizedType = (ParameterizedTypeBinding)otherType;
                        TypeBinding[] otherArguments = otherParameterizedType.arguments;
                        if (otherArguments == null) {
                            return false;
                        }
                        int i = 0;
                        int length = arguments.length;
                        while (i < length) {
                            if (arguments[i].isProvablyDistinctFrom(otherArguments[i], depth + 1)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                }
                break;
            }
            case 516: {
                return this.erasure().isProvablyDistinctFrom(otherType.erasure(), 0);
            }
            case 1028: {
                return this != otherType.erasure();
            }
        }
        return this != otherType;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isReifiable() {
        TypeBinding leafType = this.leafComponentType();
        if (!(leafType instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding current = (ReferenceBinding)leafType;
        do {
            switch (current.kind()) {
                case 260: 
                case 1028: 
                case 2052: {
                    return false;
                }
                case 132: {
                    if (!this.isBoundParameterizedType()) break;
                    return false;
                }
                case 516: {
                    return true;
                }
            }
            if (!current.isStatic()) continue;
            return true;
        } while ((current = current.enclosingType()) != null);
        return true;
    }

    public boolean isTypeArgumentContainedBy(TypeBinding otherArgument) {
        if (this == otherArgument) {
            return true;
        }
        TypeBinding lowerBound = this;
        TypeBinding upperBound = this;
        if (this.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)this;
            switch (wildcard.kind) {
                case 1: {
                    upperBound = wildcard.bound;
                    lowerBound = null;
                    break;
                }
                case 2: {
                    upperBound = wildcard.typeVariable();
                    lowerBound = wildcard.bound;
                    break;
                }
                case 0: {
                    upperBound = wildcard.typeVariable();
                    lowerBound = null;
                }
            }
        }
        if (otherArgument.isWildcard()) {
            WildcardBinding otherWildcard = (WildcardBinding)otherArgument;
            switch (otherWildcard.kind) {
                case 1: {
                    return upperBound != null && upperBound.isCompatibleWith(otherWildcard.bound);
                }
                case 2: {
                    return lowerBound != null && otherWildcard.bound.isCompatibleWith(lowerBound);
                }
                case 0: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean needsUncheckedConversion(TypeBinding targetType) {
        return false;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment environment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return TypeConstants.NoTypeVariables;
    }
}

