---
slug: /
---

# Introduction

Thrift is a serialization and [RPC](https://en.wikipedia.org/wiki/Remote_procedure_call)
(Remote Procedure Call) framework for service communication. Thrift enables
these features in all major languages, with strong support for C++, Python, Hack,
 and Java. Most services at Meta use Thrift for RPC, and some
storage systems use Thrift to serialize records on disk.
The Meta version, [FBThrift](https://github.com/facebook/fbthrift), is based on
[Apache Thrift](https://thrift.apache.org/), and is open sourced. At a high level, Thrift has three major components:

## A Code Generator

Thrift has a code generator, which generates client and server stubs for RPC in different languages and data structures that it can serialize.

<!--
  Diagram source: assets/codegen.vsdx (Visio file format, created and exported from LucidChart).
  To edit, import assets/codegen.vsdx into LucidChart and ensure you update source control
  with the export of the updated version.
  -->
![The Thrift compiler generates code in different languages from `.thrift` files](codegen.svg)

## A Serialization Framework

Thrift has a set of protocols for serialization that may be used in different
languages to serialize the structures generated by the code generator.

## A RPC Framework

Thrift has an RPC framework that frames the messages it sends between clients and servers, and calls application-defined functions in various languages when it receives messages.

<!--
  Diagram source: assets/rpc.vsdx (Visio file format, created and exported from LucidChart).
  To edit, import assets/rpc.vsdx into LucidChart and ensure you update source control
  with the export of the updated version.
  -->
![A high-level view of the Thrift RPC framework](rpc.svg)

There are several key goals for these components:

* **Ease of use**: Thrift handles the boilerplate for serialization and
  RPC, which enables the developer to focus on the schema of the system's
  serializable types and on the interfaces of system's RPC services.
* **Cross-language support**: Thrift enables inter-language communication. For example, a Python client that communicates with a C++
  server.
* **Performance**: Thrift structures and services enable fast serialization and
  deserialization, and its RPC protocol and frameworks are designed with
  performance as a feature.
* **Evolvability**: Thrift allows fields to be added to and removed
  from serializable types in a manner that preserves backward and forward
  compatibility.
